# Tmp workaround for Empty %files file debugsourcefiles.list problem
%global debug_package %{nil}

%?python_enable_dependency_generator
%define srcname nmstate
%define libname libnmstate

Name:           nmstate
Version:        2.2.7
Release:        1%{?dist}
Summary:        Declarative network manager API
License:        LGPLv2+
URL:            https://github.com/%{srcname}/%{srcname}
Source0:        https://github.com/%{srcname}/%{srcname}/releases/download/v%{version}/%{srcname}-%{version}.tar.gz
BuildRequires:  python3-setuptools
BuildRequires:  python3-devel
BuildRequires:  systemd
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}
%if 0%{?rhel}
BuildRequires:  rust-toolset
%else
BuildRequires:  rust cargo
%endif

%description
Nmstate is a library with an accompanying command line tool that manages host
networking settings in a declarative manner and aimed to satisfy enterprise
needs to manage host networking through a northbound declarative API and multi
provider support on the southbound.

%package libs
Summary:        C binding of nmstate
# Use Recommends for NetworkManager because only access to NM DBus is required,
# but NM could be running on a different host
Recommends:     NetworkManager
# Avoid automatically generated profiles
Recommends:     NetworkManager-config-server

%description libs
C binding of nmstate.

%package devel
Summary:        Development files for nmstate
Group:          Development/Libraries
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}

%description devel
Development files of nmstate C binding.

%package static
Summary:        Static development files for nmstate
Group:          Development/Libraries
Requires:       %{name}-devel%{?_isa} = %{version}-%{release}

%description static
Static C library bindings for nmstate.

%package -n python3-%{libname}
Summary:        nmstate Python 3 API library
# Use Recommends for NetworkManager because only access to NM DBus is required,
# but NM could be running on a different host
Recommends:     NetworkManager
# Avoid automatically generated profiles
Recommends:     NetworkManager-config-server
Recommends:     (nmstate-plugin-ovsdb if openvswitch)
# Use Suggests for NetworkManager-ovs and NetworkManager-team since it is only
# required for OVS and team support
Suggests:       NetworkManager-ovs
Suggests:       NetworkManager-team
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}
Provides:       nmstate-plugin-ovsdb = %{version}-%{release}
Obsoletes:      nmstate-plugin-ovsdb < 2.0-1

%description -n python3-%{libname}
This package contains the Python 3 library for Nmstate.

%prep
%setup -q

%build
pushd rust/src/python
%py3_build
popd

%install
pushd rust/src/python
%py3_install
popd

env SKIP_PYTHON_INSTALL=1 \
    PREFIX=%{_prefix} \
    LIBDIR=%{_libdir} \
    SYSCONFDIR=%{_sysconfdir} \
    %make_install

%files
%doc README.md
%doc examples/
%{_mandir}/man8/nmstate.service.8*
%{_mandir}/man8/nmstatectl.8*
%{_mandir}/man8/nmstate-autoconf.8*
%{_bindir}/nmstatectl
%{_bindir}/nmstate-autoconf
%{_unitdir}/nmstate.service
%dir %{_sysconfdir}/%{name}
%{_sysconfdir}/%{name}/README

%files libs
%{_libdir}/libnmstate.so.*

%files devel
%{_libdir}/libnmstate.so
%{_includedir}/nmstate.h
%{_libdir}/pkgconfig/nmstate.pc

%files static
%{_libdir}/libnmstate.a

%files -n python3-%{libname}
%license LICENSE
%{python3_sitelib}/%{srcname}-*.egg-info/
%{python3_sitelib}/%{libname}

%post libs
/sbin/ldconfig

%postun libs
/sbin/ldconfig

%changelog
* Thu Feb 16 2023 N. N. - 2.2.7-1
- snapshot build
