﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/forecast/model/ForecastSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ForecastService
{
namespace Model
{

ForecastSummary::ForecastSummary() : 
    m_forecastArnHasBeenSet(false),
    m_forecastNameHasBeenSet(false),
    m_predictorArnHasBeenSet(false),
    m_createdUsingAutoPredictor(false),
    m_createdUsingAutoPredictorHasBeenSet(false),
    m_datasetGroupArnHasBeenSet(false),
    m_statusHasBeenSet(false),
    m_messageHasBeenSet(false),
    m_creationTimeHasBeenSet(false),
    m_lastModificationTimeHasBeenSet(false)
{
}

ForecastSummary::ForecastSummary(JsonView jsonValue) : 
    m_forecastArnHasBeenSet(false),
    m_forecastNameHasBeenSet(false),
    m_predictorArnHasBeenSet(false),
    m_createdUsingAutoPredictor(false),
    m_createdUsingAutoPredictorHasBeenSet(false),
    m_datasetGroupArnHasBeenSet(false),
    m_statusHasBeenSet(false),
    m_messageHasBeenSet(false),
    m_creationTimeHasBeenSet(false),
    m_lastModificationTimeHasBeenSet(false)
{
  *this = jsonValue;
}

ForecastSummary& ForecastSummary::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("ForecastArn"))
  {
    m_forecastArn = jsonValue.GetString("ForecastArn");

    m_forecastArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("ForecastName"))
  {
    m_forecastName = jsonValue.GetString("ForecastName");

    m_forecastNameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("PredictorArn"))
  {
    m_predictorArn = jsonValue.GetString("PredictorArn");

    m_predictorArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("CreatedUsingAutoPredictor"))
  {
    m_createdUsingAutoPredictor = jsonValue.GetBool("CreatedUsingAutoPredictor");

    m_createdUsingAutoPredictorHasBeenSet = true;
  }

  if(jsonValue.ValueExists("DatasetGroupArn"))
  {
    m_datasetGroupArn = jsonValue.GetString("DatasetGroupArn");

    m_datasetGroupArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Status"))
  {
    m_status = jsonValue.GetString("Status");

    m_statusHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Message"))
  {
    m_message = jsonValue.GetString("Message");

    m_messageHasBeenSet = true;
  }

  if(jsonValue.ValueExists("CreationTime"))
  {
    m_creationTime = jsonValue.GetDouble("CreationTime");

    m_creationTimeHasBeenSet = true;
  }

  if(jsonValue.ValueExists("LastModificationTime"))
  {
    m_lastModificationTime = jsonValue.GetDouble("LastModificationTime");

    m_lastModificationTimeHasBeenSet = true;
  }

  return *this;
}

JsonValue ForecastSummary::Jsonize() const
{
  JsonValue payload;

  if(m_forecastArnHasBeenSet)
  {
   payload.WithString("ForecastArn", m_forecastArn);

  }

  if(m_forecastNameHasBeenSet)
  {
   payload.WithString("ForecastName", m_forecastName);

  }

  if(m_predictorArnHasBeenSet)
  {
   payload.WithString("PredictorArn", m_predictorArn);

  }

  if(m_createdUsingAutoPredictorHasBeenSet)
  {
   payload.WithBool("CreatedUsingAutoPredictor", m_createdUsingAutoPredictor);

  }

  if(m_datasetGroupArnHasBeenSet)
  {
   payload.WithString("DatasetGroupArn", m_datasetGroupArn);

  }

  if(m_statusHasBeenSet)
  {
   payload.WithString("Status", m_status);

  }

  if(m_messageHasBeenSet)
  {
   payload.WithString("Message", m_message);

  }

  if(m_creationTimeHasBeenSet)
  {
   payload.WithDouble("CreationTime", m_creationTime.SecondsWithMSPrecision());
  }

  if(m_lastModificationTimeHasBeenSet)
  {
   payload.WithDouble("LastModificationTime", m_lastModificationTime.SecondsWithMSPrecision());
  }

  return payload;
}

} // namespace Model
} // namespace ForecastService
} // namespace Aws
