; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define void @bitcast_v4i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [x0]
; CHECK-NEXT:    st1b { z0.h }, p0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <4 x i8>, ptr %a
  %cast = bitcast <4 x i8> %load to <4 x i8>
  store volatile <4 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v8i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <8 x i8>, ptr %a
  %cast = bitcast <8 x i8> %load to <8 x i8>
  store volatile <8 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v16i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <16 x i8>, ptr %a
  %cast = bitcast <16 x i8> %load to <16 x i8>
  store volatile <16 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <32 x i8>, ptr %a
  %cast = bitcast <32 x i8> %load to <32 x i8>
  store volatile <32 x i8> %cast, ptr %b
  ret void
}

define void @bitcast_v2i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldrh w8, [x0, #2]
; CHECK-NEXT:    str w8, [sp, #4]
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    ldr d0, [sp]
; CHECK-NEXT:    mov z1.s, z0.s[1]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    fmov w9, s1
; CHECK-NEXT:    strh w8, [sp, #8]
; CHECK-NEXT:    strh w9, [sp, #10]
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    str w8, [x1]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %load = load volatile <2 x i16>, ptr %a
  %cast = bitcast <2 x i16> %load to <2 x half>
  store volatile <2 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v4i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <4 x i16>, ptr %a
  %cast = bitcast <4 x i16> %load to <4 x half>
  store volatile <4 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v8i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <8 x i16>, ptr %a
  %cast = bitcast <8 x i16> %load to <8 x half>
  store volatile <8 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <16 x i16>, ptr %a
  %cast = bitcast <16 x i16> %load to <16 x half>
  store volatile <16 x half> %cast, ptr %b
  ret void
}

define void @bitcast_v2i32(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <2 x i32>, ptr %a
  %cast = bitcast <2 x i32> %load to <2 x float>
  store volatile <2 x float> %cast, ptr %b
  ret void
}

define void @bitcast_v4i32(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <4 x i32>, ptr %a
  %cast = bitcast <4 x i32> %load to <4 x float>
  store volatile <4 x float> %cast, ptr %b
  ret void
}

define void @bitcast_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <8 x i32>, ptr %a
  %cast = bitcast <8 x i32> %load to <8 x float>
  store volatile <8 x float> %cast, ptr %b
  ret void
}

define void @bitcast_v1i64(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    str d0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <1 x i64>, ptr %a
  %cast = bitcast <1 x i64> %load to <1 x double>
  store volatile <1 x double> %cast, ptr %b
  ret void
}

define void @bitcast_v2i64(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <2 x i64>, ptr %a
  %cast = bitcast <2 x i64> %load to <2 x double>
  store volatile <2 x double> %cast, ptr %b
  ret void
}

define void @bitcast_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: bitcast_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    str q1, [x1, #16]
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %load = load volatile <4 x i64>, ptr %a
  %cast = bitcast <4 x i64> %load to <4 x double>
  store volatile <4 x double> %cast, ptr %b
  ret void
}

