// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_add3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0x05,0x0e,0x00]

v_add3_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xff,0x05,0xa4,0x01]

v_add3_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x01,0xfe,0xff,0x01]

v_add3_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x69,0xd2,0xf8,0x01]

v_add3_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x6a,0xf6,0x0c,0x04]

v_add3_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_add3_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7b,0xfa,0xed,0x01]

v_add3_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7d,0xe0,0xf5,0x01]

v_add3_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7e,0x82,0xad,0x01]

v_add3_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7f,0xf8,0xa8,0x01]

v_add3_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_add3_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xc1,0xfe,0xf4,0x03]

v_add3_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xf0,0xfa,0xc0,0x03]

v_add3_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x55,0xd6,0xfd,0xd4,0x04,0x03]

v_add3_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x55,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_add_co_u32 v5, s6, v1, v2
// W32: encoding: [0x05,0x06,0x00,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, v255, v255
// W32: encoding: [0x05,0x06,0x00,0xd7,0xff,0xff,0x03,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, s1, s2
// W32: encoding: [0x05,0x06,0x00,0xd7,0x01,0x04,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, s105, s105
// W32: encoding: [0x05,0x06,0x00,0xd7,0x69,0xd2,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, vcc_lo, ttmp15
// W32: encoding: [0x05,0x06,0x00,0xd7,0x6a,0xf6,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, vcc_hi, 0xaf123456
// W32: encoding: [0x05,0x06,0x00,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, ttmp15, src_scc
// W32: encoding: [0x05,0x06,0x00,0xd7,0x7b,0xfa,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, m0, 0.5
// W32: encoding: [0x05,0x06,0x00,0xd7,0x7d,0xe0,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, exec_lo, -1
// W32: encoding: [0x05,0x06,0x00,0xd7,0x7e,0x82,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s6, exec_hi, null
// W32: encoding: [0x05,0x06,0x00,0xd7,0x7f,0xf8,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s105, null, exec_lo
// W32: encoding: [0x05,0x69,0x00,0xd7,0x7c,0xfc,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, vcc_lo, -1, exec_hi
// W32: encoding: [0x05,0x6a,0x00,0xd7,0xc1,0xfe,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, vcc_hi, 0.5, m0
// W32: encoding: [0x05,0x6b,0x00,0xd7,0xf0,0xfa,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, ttmp15, src_scc, vcc_lo
// W32: encoding: [0x05,0x7b,0x00,0xd7,0xfd,0xd4,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], v1, v2
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], v255, v255
// W64: encoding: [0x05,0x0c,0x00,0xd7,0xff,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], s1, s2
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x01,0x04,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], s105, s105
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x69,0xd2,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], vcc_lo, ttmp15
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x6a,0xf6,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], vcc_hi, 0xaf123456
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], ttmp15, src_scc
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x7b,0xfa,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], m0, 0.5
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x7d,0xe0,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], exec_lo, -1
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x7e,0x82,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], exec_hi, null
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x7f,0xf8,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[12:13], null, exec_lo
// W64: encoding: [0x05,0x0c,0x00,0xd7,0x7c,0xfc,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, s[104:105], -1, exec_hi
// W64: encoding: [0x05,0x68,0x00,0xd7,0xc1,0xfe,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v5, vcc, 0.5, m0
// W64: encoding: [0x05,0x6a,0x00,0xd7,0xf0,0xfa,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_add_co_u32 v5, ttmp[14:15], src_scc, vcc_lo
// W64: encoding: [0x05,0x7a,0x00,0xd7,0xfd,0xd4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32 v255, null, 0xaf123456, vcc_hi clamp
// GFX11: encoding: [0xff,0xfc,0x00,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_add_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[254:255], v[254:255]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xfe,0xfd,0x03,0x00]

v_add_f64 v[5:6], s[2:3], s[4:5]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x02,0x08,0x00,0x00]

v_add_f64 v[5:6], s[104:105], s[104:105]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x68,0xd0,0x00,0x00]

v_add_f64 v[5:6], vcc, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x6a,0xf4,0x00,0x00]

v_add_f64 v[5:6], ttmp[14:15], 0xaf123456
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_add_f64 v[5:6], -|exec|, src_scc
// GFX11: encoding: [0x05,0x01,0x27,0xd7,0x7e,0xfa,0x01,0x20]

v_add_f64 v[5:6], null, 0.5
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0x7c,0xe0,0x01,0x00]

v_add_f64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xc1,0x82,0x01,0x00]

v_add_f64 v[5:6], 0.5, null mul:2
// GFX11: encoding: [0x05,0x00,0x27,0xd7,0xf0,0xf8,0x00,0x08]

v_add_f64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX11: encoding: [0x05,0x03,0x27,0xd7,0xfd,0xfc,0x00,0x70]

v_add_f64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX11: encoding: [0xfe,0x82,0x27,0xd7,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_add_lshl_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0x05,0x0e,0x00]

v_add_lshl_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xff,0x05,0xa4,0x01]

v_add_lshl_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x01,0xfe,0xff,0x01]

v_add_lshl_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x69,0xd2,0xf8,0x01]

v_add_lshl_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x6a,0xf6,0x0c,0x04]

v_add_lshl_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_add_lshl_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7b,0xfa,0xed,0x01]

v_add_lshl_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7d,0xe0,0xf5,0x01]

v_add_lshl_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7e,0x82,0xad,0x01]

v_add_lshl_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7f,0xf8,0xa8,0x01]

v_add_lshl_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_add_lshl_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xc1,0xfe,0xf4,0x03]

v_add_lshl_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xf0,0xfa,0xc0,0x03]

v_add_lshl_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x47,0xd6,0xfd,0xd4,0x04,0x03]

v_add_lshl_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x47,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_add_nc_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0xff,0xff,0x03,0x00]

v_add_nc_i16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x01,0x04,0x00,0x00]

v_add_nc_i16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x69,0xd2,0x00,0x00]

v_add_nc_i16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x6a,0xf6,0x00,0x00]

v_add_nc_i16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_add_nc_i16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7b,0xfa,0x01,0x00]

v_add_nc_i16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_add_nc_i16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7e,0x82,0x01,0x00]

v_add_nc_i16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0x7f,0xf8,0x00,0x00]

v_add_nc_i16 v5, null, exec_lo op_sel:[1,1,1]
// GFX11: encoding: [0x05,0x58,0x0d,0xd7,0x7c,0xfc,0x00,0x00]

v_add_nc_i16 v5, -1, exec_hi op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x0d,0xd7,0xc1,0xfe,0x00,0x00]

v_add_nc_i16 v5, 0.5, m0 op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x08,0x0d,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_add_nc_i16 v5, src_scc, vcc_lo op_sel:[0,1,0]
// GFX11: encoding: [0x05,0x10,0x0d,0xd7,0xfd,0xd4,0x00,0x00]

v_add_nc_i16 v255, 0xfe0b, vcc_hi op_sel:[0,0,1] clamp
// GFX11: encoding: [0xff,0xc0,0x0d,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_add_nc_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_i32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xff,0xff,0x03,0x00]

v_add_nc_i32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x01,0x04,0x00,0x00]

v_add_nc_i32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x69,0xd2,0x00,0x00]

v_add_nc_i32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x6a,0xf6,0x00,0x00]

v_add_nc_i32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_add_nc_i32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7b,0xfa,0x01,0x00]

v_add_nc_i32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7d,0xe0,0x01,0x00]

v_add_nc_i32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7e,0x82,0x01,0x00]

v_add_nc_i32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7f,0xf8,0x00,0x00]

v_add_nc_i32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0x7c,0xfc,0x00,0x00]

v_add_nc_i32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xc1,0xfe,0x00,0x00]

v_add_nc_i32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xf0,0xfa,0x00,0x00]

v_add_nc_i32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd7,0xfd,0xd4,0x00,0x00]

v_add_nc_i32 v255, 0xaf123456, vcc_hi clamp
// GFX11: encoding: [0xff,0x80,0x26,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_add_nc_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x05,0x02,0x00]

v_add_nc_u16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0xff,0xff,0x03,0x00]

v_add_nc_u16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x01,0x04,0x00,0x00]

v_add_nc_u16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x69,0xd2,0x00,0x00]

v_add_nc_u16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x6a,0xf6,0x00,0x00]

v_add_nc_u16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_add_nc_u16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7b,0xfa,0x01,0x00]

v_add_nc_u16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_add_nc_u16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7e,0x82,0x01,0x00]

v_add_nc_u16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0x7f,0xf8,0x00,0x00]

v_add_nc_u16 v5, null, exec_lo op_sel:[1,1,1]
// GFX11: encoding: [0x05,0x58,0x03,0xd7,0x7c,0xfc,0x00,0x00]

v_add_nc_u16 v5, -1, exec_hi op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x03,0xd7,0xc1,0xfe,0x00,0x00]

v_add_nc_u16 v5, 0.5, m0 op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x08,0x03,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_add_nc_u16 v5, src_scc, vcc_lo op_sel:[0,1,0]
// GFX11: encoding: [0x05,0x10,0x03,0xd7,0xfd,0xd4,0x00,0x00]

v_add_nc_u16 v255, 0xfe0b, vcc_hi op_sel:[0,0,1] clamp
// GFX11: encoding: [0xff,0xc0,0x03,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_alignbit_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0x05,0x0e,0x00]

v_alignbit_b32 v5, v255, s2, s3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0xff,0x05,0x0c,0x00]

v_alignbit_b32 v5, s1, v255, s3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x01,0xfe,0x0f,0x00]

v_alignbit_b32 v5, s105, s105, s105
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x69,0xd2,0xa4,0x01]

v_alignbit_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x6a,0xf6,0x0c,0x04]

v_alignbit_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_alignbit_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7b,0xfa,0xed,0x01]

v_alignbit_b32 v5, m0, 0.5, exec_lo
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7d,0xe0,0xf9,0x01]

v_alignbit_b32 v5, exec_lo, -1, m0
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7e,0x82,0xf5,0x01]

v_alignbit_b32 v5, exec_hi, null, vcc_hi
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7f,0xf8,0xac,0x01]

v_alignbit_b32 v5, null, exec_lo, vcc_lo
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0x7c,0xfc,0xa8,0x01]

v_alignbit_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0xc1,0xfe,0xf4,0x03]

v_alignbit_b32 v5, 0.5, m0, exec_hi
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0xf0,0xfa,0xfc,0x01]

v_alignbit_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x16,0xd6,0xfd,0xd4,0x04,0x03]

v_alignbit_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x16,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_alignbyte_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0x05,0x0e,0x00]

v_alignbyte_b32 v5, v255, s2, s3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0xff,0x05,0x0c,0x00]

v_alignbyte_b32 v5, s1, v255, s3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x01,0xfe,0x0f,0x00]

v_alignbyte_b32 v5, s105, s105, s105
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x69,0xd2,0xa4,0x01]

v_alignbyte_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x6a,0xf6,0x0c,0x04]

v_alignbyte_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_alignbyte_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7b,0xfa,0xed,0x01]

v_alignbyte_b32 v5, m0, 0.5, exec_lo
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7d,0xe0,0xf9,0x01]

v_alignbyte_b32 v5, exec_lo, -1, m0
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7e,0x82,0xf5,0x01]

v_alignbyte_b32 v5, exec_hi, null, vcc_hi
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7f,0xf8,0xac,0x01]

v_alignbyte_b32 v5, null, exec_lo, vcc_lo
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0x7c,0xfc,0xa8,0x01]

v_alignbyte_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0xc1,0xfe,0xf4,0x03]

v_alignbyte_b32 v5, 0.5, m0, exec_hi
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0xf0,0xfa,0xfc,0x01]

v_alignbyte_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x17,0xd6,0xfd,0xd4,0x04,0x03]

v_alignbyte_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x17,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_and_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x05,0x02,0x00]

v_and_b16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0xff,0x03,0x00]

v_and_b16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x01,0x04,0x00,0x00]

v_and_b16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x69,0xd2,0x00,0x00]

v_and_b16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x6a,0xf6,0x00,0x00]

v_and_b16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_and_b16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7b,0xfa,0x01,0x00]

v_and_b16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_and_b16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7e,0x82,0x01,0x00]

v_and_b16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7f,0xf8,0x00,0x00]

v_and_b16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0x7c,0xfc,0x00,0x00]

v_and_b16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xc1,0xfe,0x00,0x00]

v_and_b16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_and_b16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x62,0xd7,0xfd,0xd4,0x00,0x00]

v_and_b16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x62,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_and_or_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0x05,0x0e,0x00]

v_and_or_b32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xff,0x05,0xa4,0x01]

v_and_or_b32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x01,0xfe,0xff,0x01]

v_and_or_b32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x69,0xd2,0xf8,0x01]

v_and_or_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x6a,0xf6,0x0c,0x04]

v_and_or_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_and_or_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7b,0xfa,0xed,0x01]

v_and_or_b32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7d,0xe0,0xf5,0x01]

v_and_or_b32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7e,0x82,0xad,0x01]

v_and_or_b32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7f,0xf8,0xa8,0x01]

v_and_or_b32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_and_or_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xc1,0xfe,0xf4,0x03]

v_and_or_b32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xf0,0xfa,0xc0,0x03]

v_and_or_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x57,0xd6,0xfd,0xd4,0x04,0x03]

v_and_or_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x57,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_ashrrev_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x05,0x02,0x00]

v_ashrrev_i16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xff,0xff,0x03,0x00]

v_ashrrev_i16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x01,0x04,0x00,0x00]

v_ashrrev_i16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x69,0xd2,0x00,0x00]

v_ashrrev_i16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x6a,0xf6,0x00,0x00]

v_ashrrev_i16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_ashrrev_i16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7b,0xfa,0x01,0x00]

v_ashrrev_i16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7e,0x82,0x01,0x00]

v_ashrrev_i16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7f,0xf8,0x00,0x00]

v_ashrrev_i16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0x7c,0xfc,0x00,0x00]

v_ashrrev_i16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xc1,0xfe,0x00,0x00]

v_ashrrev_i16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x3a,0xd7,0xfd,0xd4,0x00,0x00]

v_ashrrev_i16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x3a,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, vcc
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x01,0xd5,0x00,0x00]

v_ashrrev_i64 v[5:6], v255, exec
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xff,0xfd,0x00,0x00]

v_ashrrev_i64 v[5:6], exec_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x7e,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_hi, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x7f,0xfc,0x03,0x00]

v_ashrrev_i64 v[5:6], null, null
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0x7c,0xf8,0x00,0x00]

v_ashrrev_i64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xc1,0x82,0x01,0x00]

v_ashrrev_i64 v[5:6], 0.5, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xf0,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_ashrrev_i64 v[5:6], src_scc, src_scc
// GFX11: encoding: [0x05,0x00,0x3e,0xd7,0xfd,0xfa,0x01,0x00]

v_ashrrev_i64 v[254:255], 0xaf123456, 0.5
// GFX11: encoding: [0xfe,0x00,0x3e,0xd7,0xff,0xe0,0x01,0x00,0x56,0x34,0x12,0xaf]

v_bcnt_u32_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xff,0xff,0x03,0x00]

v_bcnt_u32_b32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x01,0x04,0x00,0x00]

v_bcnt_u32_b32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x69,0xd2,0x00,0x00]

v_bcnt_u32_b32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x6a,0xf6,0x00,0x00]

v_bcnt_u32_b32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_bcnt_u32_b32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7b,0xfa,0x01,0x00]

v_bcnt_u32_b32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7d,0xe0,0x01,0x00]

v_bcnt_u32_b32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7e,0x82,0x01,0x00]

v_bcnt_u32_b32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7f,0xf8,0x00,0x00]

v_bcnt_u32_b32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0x7c,0xfc,0x00,0x00]

v_bcnt_u32_b32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xc1,0xfe,0x00,0x00]

v_bcnt_u32_b32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xf0,0xfa,0x00,0x00]

v_bcnt_u32_b32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd7,0xfd,0xd4,0x00,0x00]

v_bcnt_u32_b32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x1e,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_bfe_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0x05,0x0e,0x00]

v_bfe_i32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xff,0x05,0xa4,0x01]

v_bfe_i32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x01,0xfe,0xff,0x01]

v_bfe_i32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x69,0xd2,0xf8,0x01]

v_bfe_i32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x6a,0xf6,0x0c,0x04]

v_bfe_i32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_bfe_i32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7b,0xfa,0xed,0x01]

v_bfe_i32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7d,0xe0,0xf5,0x01]

v_bfe_i32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7e,0x82,0xad,0x01]

v_bfe_i32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7f,0xf8,0xa8,0x01]

v_bfe_i32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_bfe_i32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xc1,0xfe,0xf4,0x03]

v_bfe_i32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xf0,0xfa,0xc0,0x03]

v_bfe_i32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x11,0xd6,0xfd,0xd4,0x04,0x03]

v_bfe_i32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x11,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_bfe_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0x05,0x0e,0x00]

v_bfe_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xff,0x05,0xa4,0x01]

v_bfe_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x01,0xfe,0xff,0x01]

v_bfe_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x69,0xd2,0xf8,0x01]

v_bfe_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x6a,0xf6,0x0c,0x04]

v_bfe_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_bfe_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7b,0xfa,0xed,0x01]

v_bfe_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7d,0xe0,0xf5,0x01]

v_bfe_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7e,0x82,0xad,0x01]

v_bfe_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7f,0xf8,0xa8,0x01]

v_bfe_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_bfe_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xc1,0xfe,0xf4,0x03]

v_bfe_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xf0,0xfa,0xc0,0x03]

v_bfe_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x10,0xd6,0xfd,0xd4,0x04,0x03]

v_bfe_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x10,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_bfi_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0x05,0x0e,0x00]

v_bfi_b32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xff,0x05,0xa4,0x01]

v_bfi_b32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x01,0xfe,0xff,0x01]

v_bfi_b32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x69,0xd2,0xf8,0x01]

v_bfi_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x6a,0xf6,0x0c,0x04]

v_bfi_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_bfi_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7b,0xfa,0xed,0x01]

v_bfi_b32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7d,0xe0,0xf5,0x01]

v_bfi_b32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7e,0x82,0xad,0x01]

v_bfi_b32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7f,0xf8,0xa8,0x01]

v_bfi_b32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_bfi_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xc1,0xfe,0xf4,0x03]

v_bfi_b32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xf0,0xfa,0xc0,0x03]

v_bfi_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x12,0xd6,0xfd,0xd4,0x04,0x03]

v_bfi_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x12,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_bfm_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x05,0x02,0x00]

v_bfm_b32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xff,0xff,0x03,0x00]

v_bfm_b32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x01,0x04,0x00,0x00]

v_bfm_b32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x69,0xd2,0x00,0x00]

v_bfm_b32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x6a,0xf6,0x00,0x00]

v_bfm_b32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_bfm_b32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7b,0xfa,0x01,0x00]

v_bfm_b32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7d,0xe0,0x01,0x00]

v_bfm_b32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7e,0x82,0x01,0x00]

v_bfm_b32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7f,0xf8,0x00,0x00]

v_bfm_b32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0x7c,0xfc,0x00,0x00]

v_bfm_b32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xc1,0xfe,0x00,0x00]

v_bfm_b32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xf0,0xfa,0x00,0x00]

v_bfm_b32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd7,0xfd,0xd4,0x00,0x00]

v_bfm_b32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x1d,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cndmask_b16 v5, v1, src_scc, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x01,0xfb,0x0d,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, v255, 0.5, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0xff,0xff,0x0d,0x00,0x00,0x38,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, s105, s105, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x69,0xd2,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, vcc_hi, v2, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x6b,0x04,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, ttmp15, ttmp15, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x7b,0xf6,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, m0, v255, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x7d,0xfe,0x0f,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, exec_lo, exec_lo, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x7e,0xfc,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, exec_hi, exec_hi, s3
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x7f,0xfe,0x0c,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, null, m0, s105
// W32: encoding: [0x05,0x00,0x5d,0xd6,0x7c,0xfa,0xa4,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, -1, -|vcc_lo|, vcc_lo
// W32: encoding: [0x05,0x02,0x5d,0xd6,0xc1,0xd4,0xa8,0x41]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, 0.5, -1, vcc_hi
// W32: encoding: [0x05,0x00,0x5d,0xd6,0xff,0x82,0xad,0x01,0x00,0x38,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, -|src_scc|, null, ttmp15
// W32: encoding: [0x05,0x01,0x5d,0xd6,0xfd,0xf8,0xec,0x21]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, v1, src_scc, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x01,0xfb,0x19,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, v255, 0.5, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0xff,0xff,0x19,0x00,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, s105, s105, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, vcc_hi, v2, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x6b,0x04,0x1a,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, ttmp15, ttmp15, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x7b,0xf6,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, m0, v255, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x7d,0xfe,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, exec_lo, exec_lo, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x7e,0xfc,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, exec_hi, exec_hi, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x7f,0xfe,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, null, m0, s[6:7]
// W64: encoding: [0x05,0x00,0x5d,0xd6,0x7c,0xfa,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, -1, -|vcc_lo|, s[104:105]
// W64: encoding: [0x05,0x02,0x5d,0xd6,0xc1,0xd4,0xa0,0x41]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, 0.5, -1, vcc
// W64: encoding: [0x05,0x00,0x5d,0xd6,0xff,0x82,0xa9,0x01,0x00,0x38,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v5, -|src_scc|, null, ttmp[14:15]
// W64: encoding: [0x05,0x01,0x5d,0xd6,0xfd,0xf8,0xe8,0x21]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16 v255, -|0xfe0b|, -|vcc_hi|, null
// GFX11: encoding: [0xff,0x03,0x5d,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_cubeid_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0x05,0x0e,0x00]

v_cubeid_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0xff,0x05,0xa4,0x01]

v_cubeid_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x01,0xfe,0xff,0x01]

v_cubeid_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x69,0xd2,0xf8,0x01]

v_cubeid_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x6a,0xf6,0x0c,0x04]

v_cubeid_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_cubeid_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x0c,0xd6,0x7b,0xfa,0xed,0xe1]

v_cubeid_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0x7d,0xe0,0xf5,0x01]

v_cubeid_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x0c,0xd6,0x7e,0x82,0xad,0x01]

v_cubeid_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x0c,0xd6,0x7f,0xf8,0xa8,0xa1]

v_cubeid_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x0c,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_cubeid_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x0c,0xd6,0xc1,0xfe,0xf4,0xc3]

v_cubeid_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x0c,0xd6,0xf0,0xfa,0xc0,0x4b]

v_cubeid_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x0c,0xd6,0xfd,0xd4,0x04,0x33]

v_cubeid_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x0c,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_cubema_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0x05,0x0e,0x00]

v_cubema_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0xff,0x05,0xa4,0x01]

v_cubema_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x01,0xfe,0xff,0x01]

v_cubema_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x69,0xd2,0xf8,0x01]

v_cubema_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x6a,0xf6,0x0c,0x04]

v_cubema_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_cubema_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x0f,0xd6,0x7b,0xfa,0xed,0xe1]

v_cubema_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0x7d,0xe0,0xf5,0x01]

v_cubema_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x0f,0xd6,0x7e,0x82,0xad,0x01]

v_cubema_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x0f,0xd6,0x7f,0xf8,0xa8,0xa1]

v_cubema_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x0f,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_cubema_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x0f,0xd6,0xc1,0xfe,0xf4,0xc3]

v_cubema_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x0f,0xd6,0xf0,0xfa,0xc0,0x4b]

v_cubema_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x0f,0xd6,0xfd,0xd4,0x04,0x33]

v_cubema_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x0f,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_cubesc_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0x05,0x0e,0x00]

v_cubesc_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0xff,0x05,0xa4,0x01]

v_cubesc_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x01,0xfe,0xff,0x01]

v_cubesc_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x69,0xd2,0xf8,0x01]

v_cubesc_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x6a,0xf6,0x0c,0x04]

v_cubesc_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_cubesc_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x0d,0xd6,0x7b,0xfa,0xed,0xe1]

v_cubesc_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0x7d,0xe0,0xf5,0x01]

v_cubesc_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x0d,0xd6,0x7e,0x82,0xad,0x01]

v_cubesc_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x0d,0xd6,0x7f,0xf8,0xa8,0xa1]

v_cubesc_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x0d,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_cubesc_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x0d,0xd6,0xc1,0xfe,0xf4,0xc3]

v_cubesc_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x0d,0xd6,0xf0,0xfa,0xc0,0x4b]

v_cubesc_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x0d,0xd6,0xfd,0xd4,0x04,0x33]

v_cubesc_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x0d,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_cubetc_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0x05,0x0e,0x00]

v_cubetc_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0xff,0x05,0xa4,0x01]

v_cubetc_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x01,0xfe,0xff,0x01]

v_cubetc_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x69,0xd2,0xf8,0x01]

v_cubetc_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x6a,0xf6,0x0c,0x04]

v_cubetc_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_cubetc_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x0e,0xd6,0x7b,0xfa,0xed,0xe1]

v_cubetc_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0x7d,0xe0,0xf5,0x01]

v_cubetc_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x0e,0xd6,0x7e,0x82,0xad,0x01]

v_cubetc_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x0e,0xd6,0x7f,0xf8,0xa8,0xa1]

v_cubetc_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x0e,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_cubetc_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x0e,0xd6,0xc1,0xfe,0xf4,0xc3]

v_cubetc_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x0e,0xd6,0xf0,0xfa,0xc0,0x4b]

v_cubetc_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x0e,0xd6,0xfd,0xd4,0x04,0x33]

v_cubetc_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x0e,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_cvt_pk_i16_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_f32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pk_i16_f32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pk_i16_f32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pk_i16_f32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pk_i16_f32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_i16_f32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pk_i16_f32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pk_i16_f32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pk_i16_f32 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x06,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pk_i16_f32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pk_i16_f32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pk_i16_f32 v5, 0.5, -m0
// GFX11: encoding: [0x05,0x00,0x06,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pk_i16_f32 v5, -src_scc, |vcc_lo|
// GFX11: encoding: [0x05,0x02,0x06,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pk_i16_f32 v255, -|0xaf123456|, -|vcc_hi|
// GFX11: encoding: [0xff,0x03,0x06,0xd7,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cvt_pk_i16_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pk_i16_i32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pk_i16_i32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pk_i16_i32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pk_i16_i32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_i16_i32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pk_i16_i32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pk_i16_i32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pk_i16_i32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pk_i16_i32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pk_i16_i32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pk_i16_i32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xf0,0xfa,0x00,0x00]

v_cvt_pk_i16_i32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd7,0xfd,0xd4,0x00,0x00]

v_cvt_pk_i16_i32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x24,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_norm_i16_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_norm_i16_f16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pk_norm_i16_f16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pk_norm_i16_f16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pk_norm_i16_f16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pk_norm_i16_f16 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x12,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pk_norm_i16_f16 v5, 0.5, -m0 op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pk_norm_i16_f16 v5, -src_scc, |vcc_lo| op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x0a,0x12,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pk_norm_i16_f16 v255, -|0xfe0b|, -|vcc_hi| op_sel:[0,1,0]
// GFX11: encoding: [0xff,0x13,0x12,0xd7,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_norm_u16_f16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pk_norm_u16_f16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pk_norm_u16_f16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pk_norm_u16_f16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pk_norm_u16_f16 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x13,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pk_norm_u16_f16 v5, 0.5, -m0 op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pk_norm_u16_f16 v5, -src_scc, |vcc_lo| op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x0a,0x13,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pk_norm_u16_f16 v255, -|0xfe0b|, -|vcc_hi| op_sel:[0,1,0]
// GFX11: encoding: [0xff,0x13,0x13,0xd7,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cvt_pk_u16_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_f32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pk_u16_f32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pk_u16_f32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pk_u16_f32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pk_u16_f32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_u16_f32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pk_u16_f32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pk_u16_f32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pk_u16_f32 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x07,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pk_u16_f32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pk_u16_f32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pk_u16_f32 v5, 0.5, -m0
// GFX11: encoding: [0x05,0x00,0x07,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pk_u16_f32 v5, -src_scc, |vcc_lo|
// GFX11: encoding: [0x05,0x02,0x07,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pk_u16_f32 v255, -|0xaf123456|, -|vcc_hi|
// GFX11: encoding: [0xff,0x03,0x07,0xd7,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cvt_pk_u16_u32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pk_u16_u32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pk_u16_u32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pk_u16_u32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pk_u16_u32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_u16_u32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pk_u16_u32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pk_u16_u32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pk_u16_u32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pk_u16_u32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pk_u16_u32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pk_u16_u32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xf0,0xfa,0x00,0x00]

v_cvt_pk_u16_u32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd7,0xfd,0xd4,0x00,0x00]

v_cvt_pk_u16_u32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x23,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pk_u8_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0x05,0x0e,0x00]

v_cvt_pk_u8_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xff,0x05,0xa4,0x01]

v_cvt_pk_u8_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x01,0xfe,0xff,0x01]

v_cvt_pk_u8_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x69,0xd2,0xf8,0x01]

v_cvt_pk_u8_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x6a,0xf6,0x0c,0x04]

v_cvt_pk_u8_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_cvt_pk_u8_f32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7b,0xfa,0xed,0x01]

v_cvt_pk_u8_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7d,0xe0,0xf5,0x01]

v_cvt_pk_u8_f32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7e,0x82,0xad,0x01]

v_cvt_pk_u8_f32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7f,0xf8,0xa8,0x01]

v_cvt_pk_u8_f32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_cvt_pk_u8_f32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xc1,0xfe,0xf4,0x03]

v_cvt_pk_u8_f32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xf0,0xfa,0xc0,0x03]

v_cvt_pk_u8_f32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x26,0xd6,0xfd,0xd4,0x04,0x03]

v_cvt_pk_u8_f32 v255, -|0xaf123456|, vcc_hi, null
// GFX11: encoding: [0xff,0x01,0x26,0xd6,0xff,0xd6,0xf0,0x21,0x56,0x34,0x12,0xaf]

v_cvt_pknorm_i16_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pknorm_i16_f16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pknorm_i16_f16 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x12,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pknorm_i16_f16 v5, 0.5, -m0 op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x12,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pknorm_i16_f16 v5, -src_scc, |vcc_lo| op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x0a,0x12,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pknorm_i16_f16 v255, -|0xfe0b|, -|vcc_hi| op_sel:[0,1,0]
// GFX11: encoding: [0xff,0x13,0x12,0xd7,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pknorm_i16_f32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pknorm_i16_f32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x21,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, 0.5, -m0
// GFX11: encoding: [0x05,0x00,0x21,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pknorm_i16_f32 v5, -src_scc, |vcc_lo|
// GFX11: encoding: [0x05,0x02,0x21,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pknorm_i16_f32 v255, -|0xaf123456|, -|vcc_hi|
// GFX11: encoding: [0xff,0x03,0x21,0xd7,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cvt_pknorm_u16_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pknorm_u16_f16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pknorm_u16_f16 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x13,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pknorm_u16_f16 v5, 0.5, -m0 op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x13,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pknorm_u16_f16 v5, -src_scc, |vcc_lo| op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x0a,0x13,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pknorm_u16_f16 v255, -|0xfe0b|, -|vcc_hi| op_sel:[0,1,0]
// GFX11: encoding: [0xff,0x13,0x13,0xd7,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xff,0xff,0x03,0x00]

v_cvt_pknorm_u16_f32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x01,0x04,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x69,0xd2,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x6a,0xf6,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cvt_pknorm_u16_f32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7b,0xfa,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7d,0xe0,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7e,0x82,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x22,0xd7,0x7f,0xf8,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0x7c,0xfc,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xc1,0xfe,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, 0.5, -m0
// GFX11: encoding: [0x05,0x00,0x22,0xd7,0xf0,0xfa,0x00,0x40]

v_cvt_pknorm_u16_f32 v5, -src_scc, |vcc_lo|
// GFX11: encoding: [0x05,0x02,0x22,0xd7,0xfd,0xd4,0x00,0x20]

v_cvt_pknorm_u16_f32 v255, -|0xaf123456|, -|vcc_hi|
// GFX11: encoding: [0xff,0x03,0x22,0xd7,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_div_fixup_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x01,0x05,0x0e,0x00]

v_div_fixup_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0xff,0x05,0xa4,0x01]

v_div_fixup_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x01,0xfe,0xff,0x01]

v_div_fixup_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x69,0xd2,0xf8,0x01]

v_div_fixup_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x6a,0xf6,0x0c,0x04]

v_div_fixup_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_div_fixup_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x54,0xd6,0x7b,0xfa,0xed,0xe1]

v_div_fixup_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x54,0xd6,0x7d,0xe0,0xf5,0x01]

v_div_fixup_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x54,0xd6,0x7e,0x82,0xad,0x01]

v_div_fixup_f16 v5, -|exec_hi|, null, -|vcc_lo| op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x7d,0x54,0xd6,0x7f,0xf8,0xa8,0xa1]

v_div_fixup_f16 v5, null, exec_lo, -|0xfe0b| op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x04,0x54,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_div_fixup_f16 v5, -1, -|exec_hi|, -|src_scc| op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x0e,0x54,0xd6,0xc1,0xfe,0xf4,0xc3]

v_div_fixup_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x54,0xd6,0xf0,0xfa,0xc0,0x43]

v_div_fixup_f16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x54,0xd6,0xfd,0xd4,0x04,0x23]

v_div_fixup_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc3,0x54,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_div_fixup_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0] mul:2
// GFX11: encoding: [0x05,0x10,0x54,0xd6,0xf0,0xfa,0xc0,0x4b]

v_div_fixup_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0x05,0x0e,0x00]

v_div_fixup_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0xff,0x05,0xa4,0x01]

v_div_fixup_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x01,0xfe,0xff,0x01]

v_div_fixup_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x69,0xd2,0xf8,0x01]

v_div_fixup_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x6a,0xf6,0x0c,0x04]

v_div_fixup_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_div_fixup_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x27,0xd6,0x7b,0xfa,0xed,0xe1]

v_div_fixup_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0x7d,0xe0,0xf5,0x01]

v_div_fixup_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x27,0xd6,0x7e,0x82,0xad,0x01]

v_div_fixup_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x27,0xd6,0x7f,0xf8,0xa8,0xa1]

v_div_fixup_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x27,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_div_fixup_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x27,0xd6,0xc1,0xfe,0xf4,0xc3]

v_div_fixup_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x27,0xd6,0xf0,0xfa,0xc0,0x4b]

v_div_fixup_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x27,0xd6,0xfd,0xd4,0x04,0x33]

v_div_fixup_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x27,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[254:255], v[254:255], s[6:7]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0xfe,0xfd,0x1b,0x00]

v_div_fixup_f64 v[5:6], s[2:3], s[4:5], v[254:255]
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x02,0x08,0xf8,0x07]

v_div_fixup_f64 v[5:6], -|s[104:105]|, s[104:105], -|s[104:105]|
// GFX11: encoding: [0x05,0x05,0x28,0xd6,0x68,0xd0,0xa0,0xa1]

v_div_fixup_f64 v[5:6], vcc, -|ttmp[14:15]|, -|ttmp[14:15]|
// GFX11: encoding: [0x05,0x06,0x28,0xd6,0x6a,0xf4,0xe8,0xc1]

v_div_fixup_f64 v[5:6], -|ttmp[14:15]|, 0xaf123456, null
// GFX11: encoding: [0x05,0x01,0x28,0xd6,0x7a,0xfe,0xf1,0x21,0x56,0x34,0x12,0xaf]

v_div_fixup_f64 v[5:6], -|exec|, -|src_scc|, -|exec|
// GFX11: encoding: [0x05,0x07,0x28,0xd6,0x7e,0xfa,0xf9,0xe1]

v_div_fixup_f64 v[5:6], null, 0.5, vcc
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0x7c,0xe0,0xa9,0x01]

v_div_fixup_f64 v[5:6], -1, -1, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x28,0xd6,0xc1,0x82,0xfd,0x03,0x56,0x34,0x12,0xaf]

v_div_fixup_f64 v[5:6], 0.5, null, -|src_scc| mul:2
// GFX11: encoding: [0x05,0x04,0x28,0xd6,0xf0,0xf8,0xf4,0x8b]

v_div_fixup_f64 v[5:6], -|src_scc|, -|exec|, 0.5 mul:4
// GFX11: encoding: [0x05,0x03,0x28,0xd6,0xfd,0xfc,0xc0,0x73]

v_div_fixup_f64 v[254:255], 0xaf123456, -|vcc|, -1 clamp div:2
// GFX11: encoding: [0xfe,0x82,0x28,0xd6,0xff,0xd4,0x04,0x5b,0x56,0x34,0x12,0xaf]

v_div_fmas_f32 v5, vcc_lo, v2, vcc_lo
// W32: encoding: [0x05,0x00,0x37,0xd6,0x6a,0x04,0xaa,0x01]

v_div_fmas_f32 v5, ttmp15, ttmp15, ttmp15
// W32: encoding: [0x05,0x00,0x37,0xd6,0x7b,0xf6,0xec,0x01]

v_div_fmas_f32 v5, -|m0|, -|v255|, v3
// W32: encoding: [0x05,0x03,0x37,0xd6,0x7d,0xfe,0x0f,0x64]

v_div_fmas_f32 v5, -|exec_lo|, -|exec_lo|, -|exec_lo|
// W32: encoding: [0x05,0x07,0x37,0xd6,0x7e,0xfc,0xf8,0xe1]

v_div_fmas_f32 v5, -|exec_hi|, 0.5, -|v255|
// W32: encoding: [0x05,0x05,0x37,0xd6,0x7f,0xe0,0xfd,0xa7]

v_div_fmas_f32 v5, null, exec_hi, -|exec_hi|
// W32: encoding: [0x05,0x04,0x37,0xd6,0x7c,0xfe,0xfc,0x81]

v_div_fmas_f32 v5, -1, -|m0|, -|m0|
// W32: encoding: [0x05,0x06,0x37,0xd6,0xc1,0xfa,0xf4,0xc1]

v_div_fmas_f32 v5, 0.5, -|vcc_lo|, 0.5 mul:2
// W32: encoding: [0x05,0x02,0x37,0xd6,0xf0,0xd4,0xc0,0x4b]

v_div_fmas_f32 v5, vcc_lo, v2, v3
// W64: encoding: [0x05,0x00,0x37,0xd6,0x6a,0x04,0x0e,0x04]

v_div_fmas_f32 v5, vcc_hi, v255, vcc_hi
// W64: encoding: [0x05,0x00,0x37,0xd6,0x6b,0xfe,0xaf,0x01]

v_div_fmas_f32 v5, -|ttmp15|, -|ttmp15|, ttmp15
// W64: encoding: [0x05,0x03,0x37,0xd6,0x7b,0xf6,0xec,0x61]

v_div_fmas_f32 v5, m0, 0.5, v255
// W64: encoding: [0x05,0x00,0x37,0xd6,0x7d,0xe0,0xfd,0x07]

v_div_fmas_f32 v5, -|exec_lo|, exec_lo, -|exec_lo|
// W64: encoding: [0x05,0x05,0x37,0xd6,0x7e,0xfc,0xf8,0xa1]

v_div_fmas_f32 v5, -|exec_hi|, -|exec_hi|, -|exec_hi|
// W64: encoding: [0x05,0x07,0x37,0xd6,0x7f,0xfe,0xfc,0xe1]

v_div_fmas_f32 v5, null, m0, -|m0|
// W64: encoding: [0x05,0x04,0x37,0xd6,0x7c,0xfa,0xf4,0x81]

v_div_fmas_f32 v5, -1, -|vcc_lo|, -|vcc_lo|
// W64: encoding: [0x05,0x06,0x37,0xd6,0xc1,0xd4,0xa8,0xc1]

v_div_fmas_f32 v5, 0.5, -|vcc_hi|, 0.5 mul:2
// W64: encoding: [0x05,0x02,0x37,0xd6,0xf0,0xd6,0xc0,0x4b]

v_div_fmas_f32 v5, v1, 0xaf123456, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x01,0xff,0xfd,0x03,0x56,0x34,0x12,0xaf]

v_div_fmas_f32 v5, v255, src_scc, src_scc
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0xff,0xfb,0xf5,0x03]

v_div_fmas_f32 v5, s105, s105, s105
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0x69,0xd2,0xa4,0x01]

v_div_fmas_f32 v5, src_scc, -1, -1 mul:4
// GFX11: encoding: [0x05,0x00,0x37,0xd6,0xfd,0x82,0x05,0x13]

v_div_fmas_f32 v255, -|0xaf123456|, null, null clamp div:2
// GFX11: encoding: [0xff,0x81,0x37,0xd6,0xff,0xf8,0xf0,0x39,0x56,0x34,0x12,0xaf]

v_div_fmas_f64 v[5:6], v[1:2], 0xaf123456, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x01,0xff,0xfd,0x03,0x56,0x34,0x12,0xaf]

v_div_fmas_f64 v[5:6], v[254:255], src_scc, v[3:4]
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0xfe,0xfb,0x0d,0x04]

v_div_fmas_f64 v[5:6], s[104:105], |s[104:105]|, s[104:105]
// GFX11: encoding: [0x05,0x02,0x38,0xd6,0x68,0xd0,0xa0,0x01]

v_div_fmas_f64 v[5:6], -|vcc|, v[2:3], -|v[254:255]|
// GFX11: encoding: [0x05,0x05,0x38,0xd6,0x6a,0x04,0xfa,0xa7]

v_div_fmas_f64 v[5:6], -|ttmp[14:15]|, -|ttmp[14:15]|, -|ttmp[14:15]|
// GFX11: encoding: [0x05,0x07,0x38,0xd6,0x7a,0xf4,0xe8,0xe1]

v_div_fmas_f64 v[5:6], -|exec|, -|v[254:255]|, null
// GFX11: encoding: [0x05,0x03,0x38,0xd6,0x7e,0xfc,0xf3,0x61]

v_div_fmas_f64 v[5:6], null, 0.5, -src_scc
// GFX11: encoding: [0x05,0x00,0x38,0xd6,0x7c,0xe0,0xf5,0x83]

v_div_fmas_f64 v[5:6], -1, -exec, |exec|
// GFX11: encoding: [0x05,0x04,0x38,0xd6,0xc1,0xfc,0xf8,0x41]

v_div_fmas_f64 v[5:6], 0.5, -|vcc|, -|vcc| mul:2
// GFX11: encoding: [0x05,0x06,0x38,0xd6,0xf0,0xd4,0xa8,0xc9]

v_div_fmas_f64 v[5:6], -|src_scc|, -1, 0.5 mul:4
// GFX11: encoding: [0x05,0x01,0x38,0xd6,0xfd,0x82,0xc1,0x33]

v_div_fmas_f64 v[254:255], 0xaf123456, null, -1 clamp div:2
// GFX11: encoding: [0xfe,0x80,0x38,0xd6,0xff,0xf8,0x04,0x1b,0x56,0x34,0x12,0xaf]

v_div_scale_f32 v5, vcc_lo, v1, v2, s3
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x01,0x05,0x0e,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, v255, s2, s105
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0xff,0x05,0xa4,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, s1, v255, exec_hi
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x01,0xfe,0xff,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, s105, s105, exec_lo
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x69,0xd2,0xf8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, vcc_lo, ttmp15, v3
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x6a,0xf6,0x0c,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, vcc_hi, 0xaf123456, v255
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, -ttmp15, -src_scc, -ttmp15
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x7b,0xfa,0xed,0xe1]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, m0, 0.5, m0
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x7d,0xe0,0xf5,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, exec_lo, -1, vcc_hi
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x7e,0x82,0xad,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, -exec_hi, null, -vcc_lo
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x7f,0xf8,0xa8,0xa1]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, null, exec_lo, neg(0xaf123456)
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, -1, -exec_hi, -src_scc
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0xc1,0xfe,0xf4,0xc3]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, 0.5, -m0, 0.5 mul:2
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0xf0,0xfa,0xc0,0x4b]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc_lo, -src_scc, vcc_lo, -1 mul:4
// W32: encoding: [0x05,0x6a,0xfc,0xd6,0xfd,0xd4,0x04,0x33]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v255, vcc_lo, neg(0xaf123456), -vcc_hi, null clamp div:2
// W32: encoding: [0xff,0xea,0xfc,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, v1, v2, s3
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x01,0x05,0x0e,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, v255, s2, s105
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0xff,0x05,0xa4,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, s1, v255, exec_hi
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x01,0xfe,0xff,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, s105, s105, exec_lo
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x69,0xd2,0xf8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, vcc_lo, ttmp15, v3
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x6a,0xf6,0x0c,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, vcc_hi, 0xaf123456, v255
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, -ttmp15, -src_scc, -ttmp15
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x7b,0xfa,0xed,0xe1]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, m0, 0.5, m0
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x7d,0xe0,0xf5,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, exec_lo, -1, vcc_hi
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x7e,0x82,0xad,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, -exec_hi, null, -vcc_lo
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x7f,0xf8,0xa8,0xa1]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, null, exec_lo, neg(0xaf123456)
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, -1, -exec_hi, -src_scc
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0xc1,0xfe,0xf4,0xc3]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, 0.5, -m0, 0.5 mul:2
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0xf0,0xfa,0xc0,0x4b]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v5, vcc, -src_scc, vcc_lo, -1 mul:4
// W64: encoding: [0x05,0x6a,0xfc,0xd6,0xfd,0xd4,0x04,0x33]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f32 v255, vcc, neg(0xaf123456), -vcc_hi, null clamp div:2
// W64: encoding: [0xff,0xea,0xfc,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, v[1:2], v[2:3], v[3:4]
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x01,0x05,0x0e,0x04]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, v[254:255], v[254:255], s[6:7]
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0xfe,0xfd,0x1b,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, s[2:3], s[4:5], v[254:255]
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x02,0x08,0xf8,0x07]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, -s[104:105], s[104:105], -s[104:105]
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x68,0xd0,0xa0,0xa1]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, vcc, -ttmp[14:15], -ttmp[14:15]
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x6a,0xf4,0xe8,0xc1]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, -ttmp[14:15], 0xaf123456, null
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x7a,0xfe,0xf1,0x21,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, -exec, -src_scc, -exec
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x7e,0xfa,0xf9,0xe1]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, null, 0.5, vcc
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0x7c,0xe0,0xa9,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, -1, -1, 0xaf123456
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0xc1,0x82,0xfd,0x03,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, 0.5, null, -src_scc mul:2
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0xf0,0xf8,0xf4,0x8b]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc_lo, -src_scc, -exec, 0.5 mul:4
// W32: encoding: [0x05,0x6a,0xfd,0xd6,0xfd,0xfc,0xc0,0x73]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[254:255], vcc_lo, 0xaf123456, -vcc, -1 clamp div:2
// W32: encoding: [0xfe,0xea,0xfd,0xd6,0xff,0xd4,0x04,0x5b,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], v[3:4]
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x01,0x05,0x0e,0x04]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, v[254:255], v[254:255], s[6:7]
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0xfe,0xfd,0x1b,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, s[2:3], s[4:5], v[254:255]
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x02,0x08,0xf8,0x07]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, -s[104:105], s[104:105], -s[104:105]
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x68,0xd0,0xa0,0xa1]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, vcc, -ttmp[14:15], -ttmp[14:15]
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x6a,0xf4,0xe8,0xc1]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, -ttmp[14:15], 0xaf123456, null
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x7a,0xfe,0xf1,0x21,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, -exec, -src_scc, -exec
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x7e,0xfa,0xf9,0xe1]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, null, 0.5, vcc
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0x7c,0xe0,0xa9,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, -1, -1, 0xaf123456
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0xc1,0x82,0xfd,0x03,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, 0.5, null, -src_scc mul:2
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0xf0,0xf8,0xf4,0x8b]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[5:6], vcc, -src_scc, -exec, 0.5 mul:4
// W64: encoding: [0x05,0x6a,0xfd,0xd6,0xfd,0xfc,0xc0,0x73]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_div_scale_f64 v[254:255], vcc, 0xaf123456, -vcc, -1 clamp div:2
// W64: encoding: [0xfe,0xea,0xfd,0xd6,0xff,0xd4,0x04,0x5b,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_dot2_bf16_bf16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0x01,0x05,0x0e,0x00]

v_dot2_bf16_bf16 v5, v255, v255, s105
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0xff,0xff,0xa7,0x01]

v_dot2_bf16_bf16 v5, s1, s2, v3
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0x01,0x04,0x0c,0x04]

v_dot2_bf16_bf16 v5, s105, s105, m0
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0x69,0xd2,0xf4,0x01]

v_dot2_bf16_bf16 v5, vcc_lo, ttmp15, v255
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0x6a,0xf6,0xfc,0x07]

v_dot2_bf16_bf16 v5, vcc_hi, 0xfe0b, vcc_hi
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0x6b,0xfe,0xad,0x01,0x0b,0xfe,0x00,0x00]

v_dot2_bf16_bf16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x67,0xd6,0x7b,0xfa,0xed,0x01]

v_dot2_bf16_bf16 v5, |m0|, -1, -vcc_lo
// GFX11: encoding: [0x05,0x01,0x67,0xd6,0x7d,0x82,0xa9,0x81]

v_dot2_bf16_bf16 v5, -|exec_lo|, null, -|0xfe0b|
// GFX11: encoding: [0x05,0x05,0x67,0xd6,0x7e,0xf8,0xfc,0xa3,0x0b,0xfe,0x00,0x00]

v_dot2_bf16_bf16 v5, -|exec_hi|, -|exec_lo|, -|exec_lo|
// GFX11: encoding: [0x05,0x07,0x67,0xd6,0x7f,0xfc,0xf8,0xe1]

v_dot2_bf16_bf16 v5, null, -exec_hi, |src_scc|
// GFX11: encoding: [0x05,0x04,0x67,0xd6,0x7c,0xfe,0xf4,0x43]

v_dot2_bf16_bf16 v5, -1, -|m0|, -|exec_hi| op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x06,0x67,0xd6,0xc1,0xfa,0xfc,0xc1]

v_dot2_bf16_bf16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x67,0xd6,0xfd,0xd4,0x04,0x23]

v_dot2_bf16_bf16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x43,0x67,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_dot2_f16_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0x01,0x05,0x0e,0x00]

v_dot2_f16_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0xff,0x05,0xa4,0x01]

v_dot2_f16_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0x01,0xfe,0xff,0x01]

v_dot2_f16_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0x69,0xd2,0xf8,0x01]

v_dot2_f16_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0x6a,0xf6,0x0c,0x04]

v_dot2_f16_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_dot2_f16_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x66,0xd6,0x7b,0xfa,0xed,0xe1]

v_dot2_f16_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0x7d,0xe0,0xf5,0x01]

v_dot2_f16_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x66,0xd6,0x7e,0x82,0xad,0x01]

v_dot2_f16_f16 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x66,0xd6,0x7f,0xf8,0xa8,0xa1]

v_dot2_f16_f16 v5, null, exec_lo, -|0xfe0b|
// GFX11: encoding: [0x05,0x04,0x66,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_dot2_f16_f16 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x66,0xd6,0xc1,0xfe,0xf4,0xc3]

v_dot2_f16_f16 v5, 0.5, -m0, 0.5 op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x66,0xd6,0xf0,0xfa,0xc0,0x43]

v_dot2_f16_f16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x66,0xd6,0xfd,0xd4,0x04,0x23]

v_dot2_f16_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x43,0x66,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_fma_dx9_zero_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x00]

v_fma_dx9_zero_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xff,0x05,0xa4,0x01]

v_fma_dx9_zero_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xfe,0xff,0x01]

v_fma_dx9_zero_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x69,0xd2,0xf8,0x01]

v_fma_dx9_zero_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x6a,0xf6,0x0c,0x04]

v_fma_dx9_zero_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_fma_dx9_zero_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x09,0xd6,0x7b,0xfa,0xed,0xe1]

v_fma_dx9_zero_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x7d,0xe0,0xf5,0x01]

v_fma_dx9_zero_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x09,0xd6,0x7e,0x82,0xad,0x01]

v_fma_dx9_zero_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x09,0xd6,0x7f,0xf8,0xa8,0xa1]

v_fma_dx9_zero_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x09,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_fma_dx9_zero_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x09,0xd6,0xc1,0xfe,0xf4,0xc3]

v_fma_dx9_zero_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xf0,0xfa,0xc0,0x4b]

v_fma_dx9_zero_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x09,0xd6,0xfd,0xd4,0x04,0x33]

v_fma_dx9_zero_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x09,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_fma_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x01,0x05,0x0e,0x00]

v_fma_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0xff,0x05,0xa4,0x01]

v_fma_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x01,0xfe,0xff,0x01]

v_fma_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x69,0xd2,0xf8,0x01]

v_fma_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x6a,0xf6,0x0c,0x04]

v_fma_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_fma_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x48,0xd6,0x7b,0xfa,0xed,0xe1]

v_fma_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x48,0xd6,0x7d,0xe0,0xf5,0x01]

v_fma_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x48,0xd6,0x7e,0x82,0xad,0x01]

v_fma_f16 v5, -|exec_hi|, null, -|vcc_lo| op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x7d,0x48,0xd6,0x7f,0xf8,0xa8,0xa1]

v_fma_f16 v5, null, exec_lo, -|0xfe0b| op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x04,0x48,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_fma_f16 v5, -1, -|exec_hi|, -|src_scc| op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x0e,0x48,0xd6,0xc1,0xfe,0xf4,0xc3]

v_fma_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x48,0xd6,0xf0,0xfa,0xc0,0x43]

v_fma_f16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x48,0xd6,0xfd,0xd4,0x04,0x23]

v_fma_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc3,0x48,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_fma_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1] clamp div:2
// GFX11: encoding: [0xff,0xc3,0x48,0xd6,0xff,0xd6,0xf0,0x79,0x0b,0xfe,0x00,0x00]

v_fma_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0x05,0x0e,0x00]

v_fma_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0xff,0x05,0xa4,0x01]

v_fma_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x01,0xfe,0xff,0x01]

v_fma_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x69,0xd2,0xf8,0x01]

v_fma_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x6a,0xf6,0x0c,0x04]

v_fma_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_fma_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x13,0xd6,0x7b,0xfa,0xed,0xe1]

v_fma_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0x7d,0xe0,0xf5,0x01]

v_fma_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x13,0xd6,0x7e,0x82,0xad,0x01]

v_fma_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x13,0xd6,0x7f,0xf8,0xa8,0xa1]

v_fma_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x13,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_fma_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x13,0xd6,0xc1,0xfe,0xf4,0xc3]

v_fma_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x13,0xd6,0xf0,0xfa,0xc0,0x4b]

v_fma_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x13,0xd6,0xfd,0xd4,0x04,0x33]

v_fma_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x13,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[254:255], v[254:255], s[6:7]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0xfe,0xfd,0x1b,0x00]

v_fma_f64 v[5:6], s[2:3], s[4:5], v[254:255]
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x02,0x08,0xf8,0x07]

v_fma_f64 v[5:6], -|s[104:105]|, s[104:105], -|s[104:105]|
// GFX11: encoding: [0x05,0x05,0x14,0xd6,0x68,0xd0,0xa0,0xa1]

v_fma_f64 v[5:6], vcc, -|ttmp[14:15]|, -|ttmp[14:15]|
// GFX11: encoding: [0x05,0x06,0x14,0xd6,0x6a,0xf4,0xe8,0xc1]

v_fma_f64 v[5:6], -|ttmp[14:15]|, 0xaf123456, null
// GFX11: encoding: [0x05,0x01,0x14,0xd6,0x7a,0xfe,0xf1,0x21,0x56,0x34,0x12,0xaf]

v_fma_f64 v[5:6], -|exec|, -|src_scc|, -|exec|
// GFX11: encoding: [0x05,0x07,0x14,0xd6,0x7e,0xfa,0xf9,0xe1]

v_fma_f64 v[5:6], null, 0.5, vcc
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0x7c,0xe0,0xa9,0x01]

v_fma_f64 v[5:6], -1, -1, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x14,0xd6,0xc1,0x82,0xfd,0x03,0x56,0x34,0x12,0xaf]

v_fma_f64 v[5:6], 0.5, null, -|src_scc| mul:2
// GFX11: encoding: [0x05,0x04,0x14,0xd6,0xf0,0xf8,0xf4,0x8b]

v_fma_f64 v[5:6], -|src_scc|, -|exec|, 0.5 mul:4
// GFX11: encoding: [0x05,0x03,0x14,0xd6,0xfd,0xfc,0xc0,0x73]

v_fma_f64 v[254:255], 0xaf123456, -|vcc|, -1 clamp div:2
// GFX11: encoding: [0xfe,0x82,0x14,0xd6,0xff,0xd4,0x04,0x5b,0x56,0x34,0x12,0xaf]

v_fma_legacy_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0x05,0x0e,0x00]

v_fma_legacy_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xff,0x05,0xa4,0x01]

v_fma_legacy_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x01,0xfe,0xff,0x01]

v_fma_legacy_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x69,0xd2,0xf8,0x01]

v_fma_legacy_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x6a,0xf6,0x0c,0x04]

v_fma_legacy_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_fma_legacy_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x09,0xd6,0x7b,0xfa,0xed,0xe1]

v_fma_legacy_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0x7d,0xe0,0xf5,0x01]

v_fma_legacy_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x09,0xd6,0x7e,0x82,0xad,0x01]

v_fma_legacy_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x09,0xd6,0x7f,0xf8,0xa8,0xa1]

v_fma_legacy_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x09,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_fma_legacy_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x09,0xd6,0xc1,0xfe,0xf4,0xc3]

v_fma_legacy_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x09,0xd6,0xf0,0xfa,0xc0,0x4b]

v_fma_legacy_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x09,0xd6,0xfd,0xd4,0x04,0x33]

v_fma_legacy_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x09,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_ldexp_f32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xff,0xff,0x03,0x00]

v_ldexp_f32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x01,0x04,0x00,0x00]

v_ldexp_f32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x69,0xd2,0x00,0x00]

v_ldexp_f32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x6a,0xf6,0x00,0x00]

v_ldexp_f32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_ldexp_f32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7b,0xfa,0x01,0x00]

v_ldexp_f32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7d,0xe0,0x01,0x00]

v_ldexp_f32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7e,0x82,0x01,0x00]

v_ldexp_f32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7f,0xf8,0x00,0x00]

v_ldexp_f32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0x7c,0xfc,0x00,0x00]

v_ldexp_f32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xc1,0xfe,0x00,0x00]

v_ldexp_f32 v5, 0.5, m0 mul:2
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xf0,0xfa,0x00,0x08]

v_ldexp_f32 v5, src_scc, vcc_lo mul:4
// GFX11: encoding: [0x05,0x00,0x1c,0xd7,0xfd,0xd4,0x00,0x10]

v_ldexp_f32 v255, -|0xaf123456|, vcc_hi clamp div:2
// GFX11: encoding: [0xff,0x81,0x1c,0xd7,0xff,0xd6,0x00,0x38,0x56,0x34,0x12,0xaf]

v_ldexp_f64 v[5:6], v[1:2], v2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v255
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xff,0x03,0x00]

v_ldexp_f64 v[5:6], v[1:2], s2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0x05,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], s105
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x01,0xd3,0x00,0x00]

v_ldexp_f64 v[5:6], v[254:255], ttmp15
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xfe,0xf7,0x00,0x00]

v_ldexp_f64 v[5:6], s[2:3], vcc_hi
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x02,0xd6,0x00,0x00]

v_ldexp_f64 v[5:6], s[104:105], vcc_lo
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x68,0xd4,0x00,0x00]

v_ldexp_f64 v[5:6], vcc, m0
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x6a,0xfa,0x00,0x00]

v_ldexp_f64 v[5:6], ttmp[14:15], exec_hi
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x7a,0xfe,0x00,0x00]

v_ldexp_f64 v[5:6], exec, exec_lo
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x7e,0xfc,0x00,0x00]

v_ldexp_f64 v[5:6], null, null
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0x7c,0xf8,0x00,0x00]

v_ldexp_f64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xc1,0x82,0x01,0x00]

v_ldexp_f64 v[5:6], 0.5, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x2b,0xd7,0xf0,0xe0,0x01,0x08]

v_ldexp_f64 v[5:6], -|src_scc|, src_scc mul:4
// GFX11: encoding: [0x05,0x01,0x2b,0xd7,0xfd,0xfa,0x01,0x30]

v_ldexp_f64 v[254:255], 0xaf123456, 0xaf123456 clamp div:2
// GFX11: encoding: [0xfe,0x80,0x2b,0xd7,0xff,0xfe,0x01,0x18,0x56,0x34,0x12,0xaf]

v_lerp_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0x05,0x0e,0x00]

v_lerp_u8 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xff,0x05,0xa4,0x01]

v_lerp_u8 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x01,0xfe,0xff,0x01]

v_lerp_u8 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x69,0xd2,0xf8,0x01]

v_lerp_u8 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x6a,0xf6,0x0c,0x04]

v_lerp_u8 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_lerp_u8 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7b,0xfa,0xed,0x01]

v_lerp_u8 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7d,0xe0,0xf5,0x01]

v_lerp_u8 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7e,0x82,0xad,0x01]

v_lerp_u8 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7f,0xf8,0xa8,0x01]

v_lerp_u8 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_lerp_u8 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xc1,0xfe,0xf4,0x03]

v_lerp_u8 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xf0,0xfa,0xc0,0x03]

v_lerp_u8 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x15,0xd6,0xfd,0xd4,0x04,0x03]

v_lerp_u8 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x15,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_lshl_add_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0x05,0x0e,0x00]

v_lshl_add_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xff,0x05,0xa4,0x01]

v_lshl_add_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x01,0xfe,0xff,0x01]

v_lshl_add_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x69,0xd2,0xf8,0x01]

v_lshl_add_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x6a,0xf6,0x0c,0x04]

v_lshl_add_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_lshl_add_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7b,0xfa,0xed,0x01]

v_lshl_add_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7d,0xe0,0xf5,0x01]

v_lshl_add_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7e,0x82,0xad,0x01]

v_lshl_add_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7f,0xf8,0xa8,0x01]

v_lshl_add_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_lshl_add_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xc1,0xfe,0xf4,0x03]

v_lshl_add_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xf0,0xfa,0xc0,0x03]

v_lshl_add_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x46,0xd6,0xfd,0xd4,0x04,0x03]

v_lshl_add_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x46,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_lshl_or_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0x05,0x0e,0x00]

v_lshl_or_b32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xff,0x05,0xa4,0x01]

v_lshl_or_b32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x01,0xfe,0xff,0x01]

v_lshl_or_b32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x69,0xd2,0xf8,0x01]

v_lshl_or_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x6a,0xf6,0x0c,0x04]

v_lshl_or_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_lshl_or_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7b,0xfa,0xed,0x01]

v_lshl_or_b32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7d,0xe0,0xf5,0x01]

v_lshl_or_b32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7e,0x82,0xad,0x01]

v_lshl_or_b32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7f,0xf8,0xa8,0x01]

v_lshl_or_b32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_lshl_or_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xc1,0xfe,0xf4,0x03]

v_lshl_or_b32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xf0,0xfa,0xc0,0x03]

v_lshl_or_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x56,0xd6,0xfd,0xd4,0x04,0x03]

v_lshl_or_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x56,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_lshlrev_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x05,0x02,0x00]

v_lshlrev_b16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xff,0xff,0x03,0x00]

v_lshlrev_b16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x01,0x04,0x00,0x00]

v_lshlrev_b16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x69,0xd2,0x00,0x00]

v_lshlrev_b16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x6a,0xf6,0x00,0x00]

v_lshlrev_b16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_lshlrev_b16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7b,0xfa,0x01,0x00]

v_lshlrev_b16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_lshlrev_b16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7e,0x82,0x01,0x00]

v_lshlrev_b16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7f,0xf8,0x00,0x00]

v_lshlrev_b16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0x7c,0xfc,0x00,0x00]

v_lshlrev_b16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xc1,0xfe,0x00,0x00]

v_lshlrev_b16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_lshlrev_b16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x38,0xd7,0xfd,0xd4,0x00,0x00]

v_lshlrev_b16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x38,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, vcc
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x01,0xd5,0x00,0x00]

v_lshlrev_b64 v[5:6], v255, exec
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xff,0xfd,0x00,0x00]

v_lshlrev_b64 v[5:6], exec_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x7e,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_hi, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x7f,0xfc,0x03,0x00]

v_lshlrev_b64 v[5:6], null, null
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0x7c,0xf8,0x00,0x00]

v_lshlrev_b64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xc1,0x82,0x01,0x00]

v_lshlrev_b64 v[5:6], 0.5, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xf0,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshlrev_b64 v[5:6], src_scc, src_scc
// GFX11: encoding: [0x05,0x00,0x3c,0xd7,0xfd,0xfa,0x01,0x00]

v_lshlrev_b64 v[254:255], 0xaf123456, 0.5
// GFX11: encoding: [0xfe,0x00,0x3c,0xd7,0xff,0xe0,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshrrev_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x05,0x02,0x00]

v_lshrrev_b16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xff,0xff,0x03,0x00]

v_lshrrev_b16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x01,0x04,0x00,0x00]

v_lshrrev_b16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x69,0xd2,0x00,0x00]

v_lshrrev_b16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x6a,0xf6,0x00,0x00]

v_lshrrev_b16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_lshrrev_b16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7b,0xfa,0x01,0x00]

v_lshrrev_b16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7e,0x82,0x01,0x00]

v_lshrrev_b16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7f,0xf8,0x00,0x00]

v_lshrrev_b16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0x7c,0xfc,0x00,0x00]

v_lshrrev_b16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xc1,0xfe,0x00,0x00]

v_lshrrev_b16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd7,0xfd,0xd4,0x00,0x00]

v_lshrrev_b16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x39,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, vcc
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x01,0xd5,0x00,0x00]

v_lshrrev_b64 v[5:6], v255, exec
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xff,0xfd,0x00,0x00]

v_lshrrev_b64 v[5:6], exec_lo, v[2:3]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x7e,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_hi, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x7f,0xfc,0x03,0x00]

v_lshrrev_b64 v[5:6], null, null
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0x7c,0xf8,0x00,0x00]

v_lshrrev_b64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xc1,0x82,0x01,0x00]

v_lshrrev_b64 v[5:6], 0.5, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xf0,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_lshrrev_b64 v[5:6], src_scc, src_scc
// GFX11: encoding: [0x05,0x00,0x3d,0xd7,0xfd,0xfa,0x01,0x00]

v_lshrrev_b64 v[254:255], 0xaf123456, 0.5
// GFX11: encoding: [0xfe,0x00,0x3d,0xd7,0xff,0xe0,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mad_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x01,0x05,0x0e,0x00]

v_mad_i16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0xff,0x05,0xa4,0x01]

v_mad_i16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x01,0xfe,0xff,0x01]

v_mad_i16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x69,0xd2,0xf8,0x01]

v_mad_i16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x6a,0xf6,0x0c,0x04]

v_mad_i16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_mad_i16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x7b,0xfa,0xed,0x01]

v_mad_i16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_mad_i16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x7e,0x82,0xad,0x01]

v_mad_i16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x53,0xd6,0x7f,0xf8,0xa8,0x01]

v_mad_i16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x53,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_mad_i16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x53,0xd6,0xc1,0xfe,0xf4,0x03]

v_mad_i16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x53,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_mad_i16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x53,0xd6,0xfd,0xd4,0x04,0x03]

v_mad_i16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc0,0x53,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_mad_i32_i16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x05,0x0e,0x04]

v_mad_i32_i16 v5, v255, v255, s3
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xff,0xff,0x0f,0x00]

v_mad_i32_i16 v5, s1, s2, v255
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x01,0x04,0xfc,0x07]

v_mad_i32_i16 v5, s105, s105, s105
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x69,0xd2,0xa4,0x01]

v_mad_i32_i16 v5, vcc_lo, ttmp15, vcc_lo
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x6a,0xf6,0xa8,0x01]

v_mad_i32_i16 v5, vcc_hi, 0xfe0b, vcc_hi
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x6b,0xfe,0xad,0x01,0x0b,0xfe,0x00,0x00]

v_mad_i32_i16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7b,0xfa,0xed,0x01]

v_mad_i32_i16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_mad_i32_i16 v5, exec_lo, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7e,0x82,0xfd,0x01]

v_mad_i32_i16 v5, exec_hi, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7f,0xf8,0xf8,0x01]

v_mad_i32_i16 v5, null, exec_lo, null
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0x7c,0xfc,0xf0,0x01]

v_mad_i32_i16 v5, -1, exec_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xc1,0xfe,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_mad_i32_i16 v5, 0.5, m0, -1 op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x5a,0xd6,0xff,0xfa,0x04,0x03,0x00,0x38,0x00,0x00]

v_mad_i32_i16 v5, src_scc, vcc_lo, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x5a,0xd6,0xfd,0xd4,0xf4,0x03]

v_mad_i32_i16 v255, 0xfe0b, vcc_hi, 0.5 op_sel:[0,1,0,0] clamp
// GFX11: encoding: [0xff,0x90,0x5a,0xd6,0xff,0xd6,0xc0,0x03,0x0b,0xfe,0x00,0x00]

v_mad_i32_i24 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0x05,0x0e,0x00]

v_mad_i32_i24 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xff,0x05,0xa4,0x01]

v_mad_i32_i24 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x01,0xfe,0xff,0x01]

v_mad_i32_i24 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x69,0xd2,0xf8,0x01]

v_mad_i32_i24 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x6a,0xf6,0x0c,0x04]

v_mad_i32_i24 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_mad_i32_i24 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7b,0xfa,0xed,0x01]

v_mad_i32_i24 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7d,0xe0,0xf5,0x01]

v_mad_i32_i24 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7e,0x82,0xad,0x01]

v_mad_i32_i24 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7f,0xf8,0xa8,0x01]

v_mad_i32_i24 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_mad_i32_i24 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xc1,0xfe,0xf4,0x03]

v_mad_i32_i24 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xf0,0xfa,0xc0,0x03]

v_mad_i32_i24 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x0a,0xd6,0xfd,0xd4,0x04,0x03]

v_mad_i32_i24 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x0a,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_mad_i64_i32 v[5:6], s6, s105, s105, s[6:7]
// W32: encoding: [0x05,0x06,0xff,0xd6,0x69,0xd2,0x18,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s6, ttmp15, ttmp15, s[104:105]
// W32: encoding: [0x05,0x06,0xff,0xd6,0x7b,0xf6,0xa0,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s6, m0, 0.5, ttmp[14:15]
// W32: encoding: [0x05,0x06,0xff,0xd6,0x7d,0xe0,0xe9,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s6, exec_lo, -1, exec
// W32: encoding: [0x05,0x06,0xff,0xd6,0x7e,0x82,0xf9,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s6, exec_hi, null, vcc
// W32: encoding: [0x05,0x06,0xff,0xd6,0x7f,0xf8,0xa8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s105, null, exec_lo, null
// W32: encoding: [0x05,0x69,0xff,0xd6,0x7c,0xfc,0xf0,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], vcc_lo, -1, exec_hi, -1
// W32: encoding: [0x05,0x6a,0xff,0xd6,0xc1,0xfe,0x04,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], vcc_hi, 0.5, m0, 0xaf123456
// W32: encoding: [0x05,0x6b,0xff,0xd6,0xf0,0xfa,0xfc,0x03,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], ttmp15, src_scc, vcc_lo, src_scc
// W32: encoding: [0x05,0x7b,0xff,0xd6,0xfd,0xd4,0xf4,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], s105, s105, s[6:7]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], ttmp15, ttmp15, s[104:105]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7b,0xf6,0xa0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], m0, 0.5, ttmp[14:15]
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7d,0xe0,0xe9,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], exec_lo, -1, exec
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7e,0x82,0xf9,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], exec_hi, null, vcc
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7f,0xf8,0xa8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[12:13], null, exec_lo, null
// W64: encoding: [0x05,0x0c,0xff,0xd6,0x7c,0xfc,0xf0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], s[104:105], -1, exec_hi, -1
// W64: encoding: [0x05,0x68,0xff,0xd6,0xc1,0xfe,0x04,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], vcc, 0.5, m0, 0xaf123456
// W64: encoding: [0x05,0x6a,0xff,0xd6,0xf0,0xfa,0xfc,0x03,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[5:6], ttmp[14:15], src_scc, vcc_lo, src_scc
// W64: encoding: [0x05,0x7a,0xff,0xd6,0xfd,0xd4,0xf4,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_i64_i32 v[254:255], null, 0xaf123456, vcc_hi, 0.5 clamp
// GFX11: encoding: [0xfe,0xfc,0xff,0xd6,0xff,0xd6,0xc0,0x03,0x56,0x34,0x12,0xaf]

v_mad_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x01,0x05,0x0e,0x00]

v_mad_u16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0xff,0x05,0xa4,0x01]

v_mad_u16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x01,0xfe,0xff,0x01]

v_mad_u16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x69,0xd2,0xf8,0x01]

v_mad_u16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x6a,0xf6,0x0c,0x04]

v_mad_u16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_mad_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x7b,0xfa,0xed,0x01]

v_mad_u16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_mad_u16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x7e,0x82,0xad,0x01]

v_mad_u16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x41,0xd6,0x7f,0xf8,0xa8,0x01]

v_mad_u16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x41,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_mad_u16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x41,0xd6,0xc1,0xfe,0xf4,0x03]

v_mad_u16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x41,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_mad_u16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x41,0xd6,0xfd,0xd4,0x04,0x03]

v_mad_u16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc0,0x41,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_mad_u32_u16 v5, v1, v2, v3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x05,0x0e,0x04]

v_mad_u32_u16 v5, v255, v255, s3
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xff,0xff,0x0f,0x00]

v_mad_u32_u16 v5, s1, s2, v255
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x01,0x04,0xfc,0x07]

v_mad_u32_u16 v5, s105, s105, s105
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x69,0xd2,0xa4,0x01]

v_mad_u32_u16 v5, vcc_lo, ttmp15, vcc_lo
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x6a,0xf6,0xa8,0x01]

v_mad_u32_u16 v5, vcc_hi, 0xfe0b, vcc_hi
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x6b,0xfe,0xad,0x01,0x0b,0xfe,0x00,0x00]

v_mad_u32_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7b,0xfa,0xed,0x01]

v_mad_u32_u16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_mad_u32_u16 v5, exec_lo, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7e,0x82,0xfd,0x01]

v_mad_u32_u16 v5, exec_hi, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7f,0xf8,0xf8,0x01]

v_mad_u32_u16 v5, null, exec_lo, null
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0x7c,0xfc,0xf0,0x01]

v_mad_u32_u16 v5, -1, exec_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xc1,0xfe,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_mad_u32_u16 v5, 0.5, m0, -1 op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x59,0xd6,0xff,0xfa,0x04,0x03,0x00,0x38,0x00,0x00]

v_mad_u32_u16 v5, src_scc, vcc_lo, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x59,0xd6,0xfd,0xd4,0xf4,0x03]

v_mad_u32_u16 v255, 0xfe0b, vcc_hi, 0.5 op_sel:[0,1,0,0] clamp
// GFX11: encoding: [0xff,0x90,0x59,0xd6,0xff,0xd6,0xc0,0x03,0x0b,0xfe,0x00,0x00]

v_mad_u32_u24 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0x05,0x0e,0x00]

v_mad_u32_u24 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xff,0x05,0xa4,0x01]

v_mad_u32_u24 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x01,0xfe,0xff,0x01]

v_mad_u32_u24 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x69,0xd2,0xf8,0x01]

v_mad_u32_u24 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x6a,0xf6,0x0c,0x04]

v_mad_u32_u24 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_mad_u32_u24 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7b,0xfa,0xed,0x01]

v_mad_u32_u24 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7d,0xe0,0xf5,0x01]

v_mad_u32_u24 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7e,0x82,0xad,0x01]

v_mad_u32_u24 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7f,0xf8,0xa8,0x01]

v_mad_u32_u24 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_mad_u32_u24 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xc1,0xfe,0xf4,0x03]

v_mad_u32_u24 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xf0,0xfa,0xc0,0x03]

v_mad_u32_u24 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x0b,0xd6,0xfd,0xd4,0x04,0x03]

v_mad_u32_u24 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x0b,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_mad_u64_u32 v[5:6], s6, s105, s105, s[6:7]
// W32: encoding: [0x05,0x06,0xfe,0xd6,0x69,0xd2,0x18,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s6, ttmp15, ttmp15, s[104:105]
// W32: encoding: [0x05,0x06,0xfe,0xd6,0x7b,0xf6,0xa0,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s6, m0, 0.5, ttmp[14:15]
// W32: encoding: [0x05,0x06,0xfe,0xd6,0x7d,0xe0,0xe9,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s6, exec_lo, -1, exec
// W32: encoding: [0x05,0x06,0xfe,0xd6,0x7e,0x82,0xf9,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s6, exec_hi, null, vcc
// W32: encoding: [0x05,0x06,0xfe,0xd6,0x7f,0xf8,0xa8,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s105, null, exec_lo, null
// W32: encoding: [0x05,0x69,0xfe,0xd6,0x7c,0xfc,0xf0,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], vcc_lo, -1, exec_hi, -1
// W32: encoding: [0x05,0x6a,0xfe,0xd6,0xc1,0xfe,0x04,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], vcc_hi, 0.5, m0, 0xaf123456
// W32: encoding: [0x05,0x6b,0xfe,0xd6,0xf0,0xfa,0xfc,0x03,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], ttmp15, src_scc, vcc_lo, src_scc
// W32: encoding: [0x05,0x7b,0xfe,0xd6,0xfd,0xd4,0xf4,0x03]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], s105, s105, s[6:7]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x69,0xd2,0x18,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], ttmp15, ttmp15, s[104:105]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7b,0xf6,0xa0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], m0, 0.5, ttmp[14:15]
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7d,0xe0,0xe9,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], exec_lo, -1, exec
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7e,0x82,0xf9,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], exec_hi, null, vcc
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7f,0xf8,0xa8,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[12:13], null, exec_lo, null
// W64: encoding: [0x05,0x0c,0xfe,0xd6,0x7c,0xfc,0xf0,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], s[104:105], -1, exec_hi, -1
// W64: encoding: [0x05,0x68,0xfe,0xd6,0xc1,0xfe,0x04,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], vcc, 0.5, m0, 0xaf123456
// W64: encoding: [0x05,0x6a,0xfe,0xd6,0xf0,0xfa,0xfc,0x03,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[5:6], ttmp[14:15], src_scc, vcc_lo, src_scc
// W64: encoding: [0x05,0x7a,0xfe,0xd6,0xfd,0xd4,0xf4,0x03]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_mad_u64_u32 v[254:255], null, 0xaf123456, vcc_hi, 0.5 clamp
// GFX11: encoding: [0xfe,0xfc,0xfe,0xd6,0xff,0xd6,0xc0,0x03,0x56,0x34,0x12,0xaf]

v_max3_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0x05,0x0e,0x00]

v_max3_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0xff,0x05,0xa4,0x01]

v_max3_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x01,0xfe,0xff,0x01]

v_max3_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x69,0xd2,0xf8,0x01]

v_max3_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x6a,0xf6,0x0c,0x04]

v_max3_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_max3_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x4c,0xd6,0x7b,0xfa,0xed,0xe1]

v_max3_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0x7d,0xe0,0xf5,0x01]

v_max3_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x4c,0xd6,0x7e,0x82,0xad,0x01]

v_max3_f16 v5, -|exec_hi|, null, -|vcc_lo| op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x7d,0x4c,0xd6,0x7f,0xf8,0xa8,0xa1]

v_max3_f16 v5, null, exec_lo, -|0xfe0b| op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x04,0x4c,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_max3_f16 v5, -1, -|exec_hi|, -|src_scc| op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x0e,0x4c,0xd6,0xc1,0xfe,0xf4,0xc3]

v_max3_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x4c,0xd6,0xf0,0xfa,0xc0,0x43]

v_max3_f16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x4c,0xd6,0xfd,0xd4,0x04,0x23]

v_max3_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc3,0x4c,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_max3_f16 v5, v255, s2, s105 mul:2
// GFX11: encoding: [0x05,0x00,0x4c,0xd6,0xff,0x05,0xa4,0x09]

v_max3_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0x05,0x0e,0x00]

v_max3_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0xff,0x05,0xa4,0x01]

v_max3_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x01,0xfe,0xff,0x01]

v_max3_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x69,0xd2,0xf8,0x01]

v_max3_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x6a,0xf6,0x0c,0x04]

v_max3_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_max3_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x1c,0xd6,0x7b,0xfa,0xed,0xe1]

v_max3_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0x7d,0xe0,0xf5,0x01]

v_max3_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x1c,0xd6,0x7e,0x82,0xad,0x01]

v_max3_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x1c,0xd6,0x7f,0xf8,0xa8,0xa1]

v_max3_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x1c,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_max3_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x1c,0xd6,0xc1,0xfe,0xf4,0xc3]

v_max3_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x1c,0xd6,0xf0,0xfa,0xc0,0x4b]

v_max3_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x1c,0xd6,0xfd,0xd4,0x04,0x33]

v_max3_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x1c,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_max3_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0x05,0x0e,0x00]

v_max3_i16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0xff,0x05,0xa4,0x01]

v_max3_i16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x01,0xfe,0xff,0x01]

v_max3_i16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x69,0xd2,0xf8,0x01]

v_max3_i16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x6a,0xf6,0x0c,0x04]

v_max3_i16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_max3_i16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7b,0xfa,0xed,0x01]

v_max3_i16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_max3_i16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7e,0x82,0xad,0x01]

v_max3_i16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x4d,0xd6,0x7f,0xf8,0xa8,0x01]

v_max3_i16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x4d,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_max3_i16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x4d,0xd6,0xc1,0xfe,0xf4,0x03]

v_max3_i16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x4d,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_max3_i16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x4d,0xd6,0xfd,0xd4,0x04,0x03]

v_max3_i16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x40,0x4d,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_max3_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0x05,0x0e,0x00]

v_max3_i32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xff,0x05,0xa4,0x01]

v_max3_i32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x01,0xfe,0xff,0x01]

v_max3_i32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x69,0xd2,0xf8,0x01]

v_max3_i32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x6a,0xf6,0x0c,0x04]

v_max3_i32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_max3_i32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7b,0xfa,0xed,0x01]

v_max3_i32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7d,0xe0,0xf5,0x01]

v_max3_i32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7e,0x82,0xad,0x01]

v_max3_i32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7f,0xf8,0xa8,0x01]

v_max3_i32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_max3_i32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xc1,0xfe,0xf4,0x03]

v_max3_i32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xf0,0xfa,0xc0,0x03]

v_max3_i32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x1d,0xd6,0xfd,0xd4,0x04,0x03]

v_max3_i32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x1d,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_max3_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0x05,0x0e,0x00]

v_max3_u16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0xff,0x05,0xa4,0x01]

v_max3_u16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x01,0xfe,0xff,0x01]

v_max3_u16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x69,0xd2,0xf8,0x01]

v_max3_u16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x6a,0xf6,0x0c,0x04]

v_max3_u16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_max3_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7b,0xfa,0xed,0x01]

v_max3_u16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_max3_u16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7e,0x82,0xad,0x01]

v_max3_u16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x4e,0xd6,0x7f,0xf8,0xa8,0x01]

v_max3_u16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x4e,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_max3_u16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x4e,0xd6,0xc1,0xfe,0xf4,0x03]

v_max3_u16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x4e,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_max3_u16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x4e,0xd6,0xfd,0xd4,0x04,0x03]

v_max3_u16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x40,0x4e,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_max3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0x05,0x0e,0x00]

v_max3_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xff,0x05,0xa4,0x01]

v_max3_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x01,0xfe,0xff,0x01]

v_max3_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x69,0xd2,0xf8,0x01]

v_max3_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x6a,0xf6,0x0c,0x04]

v_max3_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_max3_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7b,0xfa,0xed,0x01]

v_max3_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7d,0xe0,0xf5,0x01]

v_max3_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7e,0x82,0xad,0x01]

v_max3_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7f,0xf8,0xa8,0x01]

v_max3_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_max3_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xc1,0xfe,0xf4,0x03]

v_max3_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xf0,0xfa,0xc0,0x03]

v_max3_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x1e,0xd6,0xfd,0xd4,0x04,0x03]

v_max3_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x1e,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_max_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[254:255], v[254:255]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xfe,0xfd,0x03,0x00]

v_max_f64 v[5:6], s[2:3], s[4:5]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x02,0x08,0x00,0x00]

v_max_f64 v[5:6], s[104:105], s[104:105]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x68,0xd0,0x00,0x00]

v_max_f64 v[5:6], vcc, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x6a,0xf4,0x00,0x00]

v_max_f64 v[5:6], ttmp[14:15], 0xaf123456
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_max_f64 v[5:6], -|exec|, src_scc
// GFX11: encoding: [0x05,0x01,0x2a,0xd7,0x7e,0xfa,0x01,0x20]

v_max_f64 v[5:6], null, 0.5
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0x7c,0xe0,0x01,0x00]

v_max_f64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xc1,0x82,0x01,0x00]

v_max_f64 v[5:6], 0.5, null mul:2
// GFX11: encoding: [0x05,0x00,0x2a,0xd7,0xf0,0xf8,0x00,0x08]

v_max_f64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX11: encoding: [0x05,0x03,0x2a,0xd7,0xfd,0xfc,0x00,0x70]

v_max_f64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX11: encoding: [0xfe,0x82,0x2a,0xd7,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_max_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x05,0x02,0x00]

v_max_i16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0xff,0xff,0x03,0x00]

v_max_i16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x01,0x04,0x00,0x00]

v_max_i16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x69,0xd2,0x00,0x00]

v_max_i16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x6a,0xf6,0x00,0x00]

v_max_i16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_max_i16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7b,0xfa,0x01,0x00]

v_max_i16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_max_i16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7e,0x82,0x01,0x00]

v_max_i16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7f,0xf8,0x00,0x00]

v_max_i16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0x7c,0xfc,0x00,0x00]

v_max_i16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0xc1,0xfe,0x00,0x00]

v_max_i16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_max_i16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0a,0xd7,0xfd,0xd4,0x00,0x00]

v_max_i16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x0a,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_max_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x05,0x02,0x00]

v_max_u16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0xff,0xff,0x03,0x00]

v_max_u16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x01,0x04,0x00,0x00]

v_max_u16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x69,0xd2,0x00,0x00]

v_max_u16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x6a,0xf6,0x00,0x00]

v_max_u16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_max_u16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7b,0xfa,0x01,0x00]

v_max_u16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_max_u16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7e,0x82,0x01,0x00]

v_max_u16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7f,0xf8,0x00,0x00]

v_max_u16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0x7c,0xfc,0x00,0x00]

v_max_u16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0xc1,0xfe,0x00,0x00]

v_max_u16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_max_u16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x09,0xd7,0xfd,0xd4,0x00,0x00]

v_max_u16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x09,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_maxmin_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0x01,0x05,0x0e,0x00]

v_maxmin_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0xff,0x05,0xa4,0x01]

v_maxmin_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0x01,0xfe,0xff,0x01]

v_maxmin_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0x69,0xd2,0xf8,0x01]

v_maxmin_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0x6a,0xf6,0x0c,0x04]

v_maxmin_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_maxmin_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x60,0xd6,0x7b,0xfa,0xed,0xe1]

v_maxmin_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0x7d,0xe0,0xf5,0x01]

v_maxmin_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x60,0xd6,0x7e,0x82,0xad,0x01]

v_maxmin_f16 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x60,0xd6,0x7f,0xf8,0xa8,0xa1]

v_maxmin_f16 v5, null, exec_lo, -|0xfe0b|
// GFX11: encoding: [0x05,0x04,0x60,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_maxmin_f16 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x60,0xd6,0xc1,0xfe,0xf4,0xc3]

v_maxmin_f16 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x60,0xd6,0xf0,0xfa,0xc0,0x4b]

v_maxmin_f16 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x60,0xd6,0xfd,0xd4,0x04,0x33]

v_maxmin_f16 v255, -|0xfe0b|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x60,0xd6,0xff,0xd6,0xf0,0x79,0x0b,0xfe,0x00,0x00]

v_maxmin_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0x01,0x05,0x0e,0x00]

v_maxmin_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0xff,0x05,0xa4,0x01]

v_maxmin_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0x01,0xfe,0xff,0x01]

v_maxmin_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0x69,0xd2,0xf8,0x01]

v_maxmin_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0x6a,0xf6,0x0c,0x04]

v_maxmin_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_maxmin_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x5e,0xd6,0x7b,0xfa,0xed,0xe1]

v_maxmin_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0x7d,0xe0,0xf5,0x01]

v_maxmin_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x5e,0xd6,0x7e,0x82,0xad,0x01]

v_maxmin_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x5e,0xd6,0x7f,0xf8,0xa8,0xa1]

v_maxmin_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x5e,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_maxmin_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x5e,0xd6,0xc1,0xfe,0xf4,0xc3]

v_maxmin_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x5e,0xd6,0xf0,0xfa,0xc0,0x4b]

v_maxmin_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x5e,0xd6,0xfd,0xd4,0x04,0x33]

v_maxmin_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x5e,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_maxmin_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x01,0x05,0x0e,0x00]

v_maxmin_i32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0xff,0x05,0xa4,0x01]

v_maxmin_i32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x01,0xfe,0xff,0x01]

v_maxmin_i32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x69,0xd2,0xf8,0x01]

v_maxmin_i32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x6a,0xf6,0x0c,0x04]

v_maxmin_i32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_maxmin_i32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x7b,0xfa,0xed,0x01]

v_maxmin_i32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x7d,0xe0,0xf5,0x01]

v_maxmin_i32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x7e,0x82,0xad,0x01]

v_maxmin_i32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x7f,0xf8,0xa8,0x01]

v_maxmin_i32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_maxmin_i32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0xc1,0xfe,0xf4,0x03]

v_maxmin_i32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0xf0,0xfa,0xc0,0x03]

v_maxmin_i32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x64,0xd6,0xfd,0xd4,0x04,0x03]

v_maxmin_i32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x64,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_maxmin_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x01,0x05,0x0e,0x00]

v_maxmin_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0xff,0x05,0xa4,0x01]

v_maxmin_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x01,0xfe,0xff,0x01]

v_maxmin_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x69,0xd2,0xf8,0x01]

v_maxmin_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x6a,0xf6,0x0c,0x04]

v_maxmin_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_maxmin_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x7b,0xfa,0xed,0x01]

v_maxmin_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x7d,0xe0,0xf5,0x01]

v_maxmin_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x7e,0x82,0xad,0x01]

v_maxmin_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x7f,0xf8,0xa8,0x01]

v_maxmin_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_maxmin_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0xc1,0xfe,0xf4,0x03]

v_maxmin_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0xf0,0xfa,0xc0,0x03]

v_maxmin_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x62,0xd6,0xfd,0xd4,0x04,0x03]

v_maxmin_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x62,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_mbcnt_hi_u32_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xff,0xff,0x03,0x00]

v_mbcnt_hi_u32_b32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x01,0x04,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x69,0xd2,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x6a,0xf6,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mbcnt_hi_u32_b32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7b,0xfa,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7d,0xe0,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7e,0x82,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7f,0xf8,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0x7c,0xfc,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xc1,0xfe,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xf0,0xfa,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd7,0xfd,0xd4,0x00,0x00]

v_mbcnt_hi_u32_b32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x20,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mbcnt_lo_u32_b32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xff,0xff,0x03,0x00]

v_mbcnt_lo_u32_b32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x01,0x04,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x69,0xd2,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x6a,0xf6,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mbcnt_lo_u32_b32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7b,0xfa,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7d,0xe0,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7e,0x82,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7f,0xf8,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0x7c,0xfc,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xc1,0xfe,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xf0,0xfa,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd7,0xfd,0xd4,0x00,0x00]

v_mbcnt_lo_u32_b32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x1f,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_med3_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0x05,0x0e,0x00]

v_med3_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0xff,0x05,0xa4,0x01]

v_med3_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x01,0xfe,0xff,0x01]

v_med3_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x69,0xd2,0xf8,0x01]

v_med3_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x6a,0xf6,0x0c,0x04]

v_med3_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_med3_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x4f,0xd6,0x7b,0xfa,0xed,0xe1]

v_med3_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x4f,0xd6,0x7d,0xe0,0xf5,0x01]

v_med3_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x4f,0xd6,0x7e,0x82,0xad,0x01]

v_med3_f16 v5, -|exec_hi|, null, -|vcc_lo| op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x7d,0x4f,0xd6,0x7f,0xf8,0xa8,0xa1]

v_med3_f16 v5, null, exec_lo, -|0xfe0b| op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x04,0x4f,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_med3_f16 v5, -1, -|exec_hi|, -|src_scc| op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x0e,0x4f,0xd6,0xc1,0xfe,0xf4,0xc3]

v_med3_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x4f,0xd6,0xf0,0xfa,0xc0,0x43]

v_med3_f16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x4f,0xd6,0xfd,0xd4,0x04,0x23]

v_med3_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc3,0x4f,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_med3_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0] div:2
// GFX11: encoding: [0x05,0x10,0x4f,0xd6,0xf0,0xfa,0xc0,0x5b]

v_med3_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0x05,0x0e,0x00]

v_med3_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0xff,0x05,0xa4,0x01]

v_med3_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x01,0xfe,0xff,0x01]

v_med3_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x69,0xd2,0xf8,0x01]

v_med3_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x6a,0xf6,0x0c,0x04]

v_med3_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_med3_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x1f,0xd6,0x7b,0xfa,0xed,0xe1]

v_med3_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0x7d,0xe0,0xf5,0x01]

v_med3_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x1f,0xd6,0x7e,0x82,0xad,0x01]

v_med3_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x1f,0xd6,0x7f,0xf8,0xa8,0xa1]

v_med3_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x1f,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_med3_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x1f,0xd6,0xc1,0xfe,0xf4,0xc3]

v_med3_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x1f,0xd6,0xf0,0xfa,0xc0,0x4b]

v_med3_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x1f,0xd6,0xfd,0xd4,0x04,0x33]

v_med3_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x1f,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_med3_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0x05,0x0e,0x00]

v_med3_i16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0xff,0x05,0xa4,0x01]

v_med3_i16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x01,0xfe,0xff,0x01]

v_med3_i16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x69,0xd2,0xf8,0x01]

v_med3_i16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x6a,0xf6,0x0c,0x04]

v_med3_i16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_med3_i16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7b,0xfa,0xed,0x01]

v_med3_i16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_med3_i16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7e,0x82,0xad,0x01]

v_med3_i16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x50,0xd6,0x7f,0xf8,0xa8,0x01]

v_med3_i16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x50,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_med3_i16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x50,0xd6,0xc1,0xfe,0xf4,0x03]

v_med3_i16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x50,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_med3_i16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x50,0xd6,0xfd,0xd4,0x04,0x03]

v_med3_i16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x40,0x50,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_med3_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0x05,0x0e,0x00]

v_med3_i32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xff,0x05,0xa4,0x01]

v_med3_i32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x01,0xfe,0xff,0x01]

v_med3_i32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x69,0xd2,0xf8,0x01]

v_med3_i32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x6a,0xf6,0x0c,0x04]

v_med3_i32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_med3_i32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7b,0xfa,0xed,0x01]

v_med3_i32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7d,0xe0,0xf5,0x01]

v_med3_i32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7e,0x82,0xad,0x01]

v_med3_i32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7f,0xf8,0xa8,0x01]

v_med3_i32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_med3_i32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xc1,0xfe,0xf4,0x03]

v_med3_i32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xf0,0xfa,0xc0,0x03]

v_med3_i32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x20,0xd6,0xfd,0xd4,0x04,0x03]

v_med3_i32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x20,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_med3_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0x05,0x0e,0x00]

v_med3_u16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0xff,0x05,0xa4,0x01]

v_med3_u16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x01,0xfe,0xff,0x01]

v_med3_u16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x69,0xd2,0xf8,0x01]

v_med3_u16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x6a,0xf6,0x0c,0x04]

v_med3_u16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_med3_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7b,0xfa,0xed,0x01]

v_med3_u16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_med3_u16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7e,0x82,0xad,0x01]

v_med3_u16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x51,0xd6,0x7f,0xf8,0xa8,0x01]

v_med3_u16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x51,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_med3_u16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x51,0xd6,0xc1,0xfe,0xf4,0x03]

v_med3_u16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x51,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_med3_u16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x51,0xd6,0xfd,0xd4,0x04,0x03]

v_med3_u16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x40,0x51,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_med3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0x05,0x0e,0x00]

v_med3_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xff,0x05,0xa4,0x01]

v_med3_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x01,0xfe,0xff,0x01]

v_med3_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x69,0xd2,0xf8,0x01]

v_med3_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x6a,0xf6,0x0c,0x04]

v_med3_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_med3_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7b,0xfa,0xed,0x01]

v_med3_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7d,0xe0,0xf5,0x01]

v_med3_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7e,0x82,0xad,0x01]

v_med3_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7f,0xf8,0xa8,0x01]

v_med3_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_med3_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xc1,0xfe,0xf4,0x03]

v_med3_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xf0,0xfa,0xc0,0x03]

v_med3_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x21,0xd6,0xfd,0xd4,0x04,0x03]

v_med3_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x21,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_min3_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0x05,0x0e,0x00]

v_min3_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0xff,0x05,0xa4,0x01]

v_min3_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x01,0xfe,0xff,0x01]

v_min3_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x69,0xd2,0xf8,0x01]

v_min3_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x6a,0xf6,0x0c,0x04]

v_min3_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_min3_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x49,0xd6,0x7b,0xfa,0xed,0xe1]

v_min3_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x49,0xd6,0x7d,0xe0,0xf5,0x01]

v_min3_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x49,0xd6,0x7e,0x82,0xad,0x01]

v_min3_f16 v5, -|exec_hi|, null, -|vcc_lo| op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x7d,0x49,0xd6,0x7f,0xf8,0xa8,0xa1]

v_min3_f16 v5, null, exec_lo, -|0xfe0b| op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x04,0x49,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_min3_f16 v5, -1, -|exec_hi|, -|src_scc| op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x0e,0x49,0xd6,0xc1,0xfe,0xf4,0xc3]

v_min3_f16 v5, 0.5, -m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x49,0xd6,0xf0,0xfa,0xc0,0x43]

v_min3_f16 v5, -src_scc, |vcc_lo|, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x22,0x49,0xd6,0xfd,0xd4,0x04,0x23]

v_min3_f16 v255, -|0xfe0b|, -|vcc_hi|, null op_sel:[0,0,0,1] clamp
// GFX11: encoding: [0xff,0xc3,0x49,0xd6,0xff,0xd6,0xf0,0x61,0x0b,0xfe,0x00,0x00]

v_min3_f16 v5, m0, 0.5, m0 clamp mul:4
// GFX11: encoding: [0x05,0x80,0x49,0xd6,0x7d,0xe0,0xf5,0x11]

v_min3_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0x05,0x0e,0x00]

v_min3_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0xff,0x05,0xa4,0x01]

v_min3_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x01,0xfe,0xff,0x01]

v_min3_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x69,0xd2,0xf8,0x01]

v_min3_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x6a,0xf6,0x0c,0x04]

v_min3_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_min3_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x19,0xd6,0x7b,0xfa,0xed,0xe1]

v_min3_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0x7d,0xe0,0xf5,0x01]

v_min3_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x19,0xd6,0x7e,0x82,0xad,0x01]

v_min3_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x19,0xd6,0x7f,0xf8,0xa8,0xa1]

v_min3_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x19,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_min3_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x19,0xd6,0xc1,0xfe,0xf4,0xc3]

v_min3_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x19,0xd6,0xf0,0xfa,0xc0,0x4b]

v_min3_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x19,0xd6,0xfd,0xd4,0x04,0x33]

v_min3_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x19,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_min3_i16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0x05,0x0e,0x00]

v_min3_i16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0xff,0x05,0xa4,0x01]

v_min3_i16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x01,0xfe,0xff,0x01]

v_min3_i16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x69,0xd2,0xf8,0x01]

v_min3_i16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x6a,0xf6,0x0c,0x04]

v_min3_i16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_min3_i16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7b,0xfa,0xed,0x01]

v_min3_i16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_min3_i16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7e,0x82,0xad,0x01]

v_min3_i16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x4a,0xd6,0x7f,0xf8,0xa8,0x01]

v_min3_i16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x4a,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_min3_i16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x4a,0xd6,0xc1,0xfe,0xf4,0x03]

v_min3_i16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x4a,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_min3_i16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x4a,0xd6,0xfd,0xd4,0x04,0x03]

v_min3_i16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x40,0x4a,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_min3_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0x05,0x0e,0x00]

v_min3_i32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xff,0x05,0xa4,0x01]

v_min3_i32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x01,0xfe,0xff,0x01]

v_min3_i32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x69,0xd2,0xf8,0x01]

v_min3_i32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x6a,0xf6,0x0c,0x04]

v_min3_i32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_min3_i32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7b,0xfa,0xed,0x01]

v_min3_i32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7d,0xe0,0xf5,0x01]

v_min3_i32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7e,0x82,0xad,0x01]

v_min3_i32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7f,0xf8,0xa8,0x01]

v_min3_i32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_min3_i32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xc1,0xfe,0xf4,0x03]

v_min3_i32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xf0,0xfa,0xc0,0x03]

v_min3_i32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x1a,0xd6,0xfd,0xd4,0x04,0x03]

v_min3_i32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x1a,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_min3_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0x05,0x0e,0x00]

v_min3_u16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0xff,0x05,0xa4,0x01]

v_min3_u16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x01,0xfe,0xff,0x01]

v_min3_u16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x69,0xd2,0xf8,0x01]

v_min3_u16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x6a,0xf6,0x0c,0x04]

v_min3_u16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_min3_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7b,0xfa,0xed,0x01]

v_min3_u16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7d,0xfe,0xf5,0x01,0x00,0x38,0x00,0x00]

v_min3_u16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7e,0x82,0xad,0x01]

v_min3_u16 v5, exec_hi, null, vcc_lo op_sel:[1,1,1,1]
// GFX11: encoding: [0x05,0x78,0x4b,0xd6,0x7f,0xf8,0xa8,0x01]

v_min3_u16 v5, null, exec_lo, 0xfe0b op_sel:[0,0,0,0]
// GFX11: encoding: [0x05,0x00,0x4b,0xd6,0x7c,0xfc,0xfc,0x03,0x0b,0xfe,0x00,0x00]

v_min3_u16 v5, -1, exec_hi, src_scc op_sel:[1,0,0,0]
// GFX11: encoding: [0x05,0x08,0x4b,0xd6,0xc1,0xfe,0xf4,0x03]

v_min3_u16 v5, 0.5, m0, 0.5 op_sel:[0,1,0,0]
// GFX11: encoding: [0x05,0x10,0x4b,0xd6,0xff,0xfa,0xfc,0x03,0x00,0x38,0x00,0x00]

v_min3_u16 v5, src_scc, vcc_lo, -1 op_sel:[0,0,1,0]
// GFX11: encoding: [0x05,0x20,0x4b,0xd6,0xfd,0xd4,0x04,0x03]

v_min3_u16 v255, 0xfe0b, vcc_hi, null op_sel:[0,0,0,1]
// GFX11: encoding: [0xff,0x40,0x4b,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_min3_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0x05,0x0e,0x00]

v_min3_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xff,0x05,0xa4,0x01]

v_min3_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x01,0xfe,0xff,0x01]

v_min3_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x69,0xd2,0xf8,0x01]

v_min3_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x6a,0xf6,0x0c,0x04]

v_min3_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_min3_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7b,0xfa,0xed,0x01]

v_min3_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7d,0xe0,0xf5,0x01]

v_min3_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7e,0x82,0xad,0x01]

v_min3_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7f,0xf8,0xa8,0x01]

v_min3_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_min3_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xc1,0xfe,0xf4,0x03]

v_min3_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xf0,0xfa,0xc0,0x03]

v_min3_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x1b,0xd6,0xfd,0xd4,0x04,0x03]

v_min3_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x1b,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_min_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[254:255], v[254:255]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xfe,0xfd,0x03,0x00]

v_min_f64 v[5:6], s[2:3], s[4:5]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x02,0x08,0x00,0x00]

v_min_f64 v[5:6], s[104:105], s[104:105]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x68,0xd0,0x00,0x00]

v_min_f64 v[5:6], vcc, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x6a,0xf4,0x00,0x00]

v_min_f64 v[5:6], ttmp[14:15], 0xaf123456
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_min_f64 v[5:6], -|exec|, src_scc
// GFX11: encoding: [0x05,0x01,0x29,0xd7,0x7e,0xfa,0x01,0x20]

v_min_f64 v[5:6], null, 0.5
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0x7c,0xe0,0x01,0x00]

v_min_f64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xc1,0x82,0x01,0x00]

v_min_f64 v[5:6], 0.5, null mul:2
// GFX11: encoding: [0x05,0x00,0x29,0xd7,0xf0,0xf8,0x00,0x08]

v_min_f64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX11: encoding: [0x05,0x03,0x29,0xd7,0xfd,0xfc,0x00,0x70]

v_min_f64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX11: encoding: [0xfe,0x82,0x29,0xd7,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_min_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x05,0x02,0x00]

v_min_i16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0xff,0xff,0x03,0x00]

v_min_i16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x01,0x04,0x00,0x00]

v_min_i16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x69,0xd2,0x00,0x00]

v_min_i16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x6a,0xf6,0x00,0x00]

v_min_i16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_min_i16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7b,0xfa,0x01,0x00]

v_min_i16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_min_i16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7e,0x82,0x01,0x00]

v_min_i16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7f,0xf8,0x00,0x00]

v_min_i16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0x7c,0xfc,0x00,0x00]

v_min_i16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0xc1,0xfe,0x00,0x00]

v_min_i16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_min_i16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0c,0xd7,0xfd,0xd4,0x00,0x00]

v_min_i16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x0c,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_min_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x05,0x02,0x00]

v_min_u16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xff,0xff,0x03,0x00]

v_min_u16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x01,0x04,0x00,0x00]

v_min_u16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x69,0xd2,0x00,0x00]

v_min_u16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x6a,0xf6,0x00,0x00]

v_min_u16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_min_u16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7b,0xfa,0x01,0x00]

v_min_u16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_min_u16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7e,0x82,0x01,0x00]

v_min_u16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7f,0xf8,0x00,0x00]

v_min_u16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0x7c,0xfc,0x00,0x00]

v_min_u16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xc1,0xfe,0x00,0x00]

v_min_u16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_min_u16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x0b,0xd7,0xfd,0xd4,0x00,0x00]

v_min_u16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x0b,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_minmax_f16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0x01,0x05,0x0e,0x00]

v_minmax_f16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0xff,0x05,0xa4,0x01]

v_minmax_f16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0x01,0xfe,0xff,0x01]

v_minmax_f16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0x69,0xd2,0xf8,0x01]

v_minmax_f16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0x6a,0xf6,0x0c,0x04]

v_minmax_f16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_minmax_f16 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x61,0xd6,0x7b,0xfa,0xed,0xe1]

v_minmax_f16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0x7d,0xe0,0xf5,0x01]

v_minmax_f16 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x61,0xd6,0x7e,0x82,0xad,0x01]

v_minmax_f16 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x61,0xd6,0x7f,0xf8,0xa8,0xa1]

v_minmax_f16 v5, null, exec_lo, -|0xfe0b|
// GFX11: encoding: [0x05,0x04,0x61,0xd6,0x7c,0xfc,0xfc,0x83,0x0b,0xfe,0x00,0x00]

v_minmax_f16 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x61,0xd6,0xc1,0xfe,0xf4,0xc3]

v_minmax_f16 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x61,0xd6,0xf0,0xfa,0xc0,0x4b]

v_minmax_f16 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x61,0xd6,0xfd,0xd4,0x04,0x33]

v_minmax_f16 v255, -|0xfe0b|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x61,0xd6,0xff,0xd6,0xf0,0x79,0x0b,0xfe,0x00,0x00]

v_minmax_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0x01,0x05,0x0e,0x00]

v_minmax_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0xff,0x05,0xa4,0x01]

v_minmax_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0x01,0xfe,0xff,0x01]

v_minmax_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0x69,0xd2,0xf8,0x01]

v_minmax_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0x6a,0xf6,0x0c,0x04]

v_minmax_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_minmax_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x5f,0xd6,0x7b,0xfa,0xed,0xe1]

v_minmax_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0x7d,0xe0,0xf5,0x01]

v_minmax_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x5f,0xd6,0x7e,0x82,0xad,0x01]

v_minmax_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x5f,0xd6,0x7f,0xf8,0xa8,0xa1]

v_minmax_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x5f,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_minmax_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x5f,0xd6,0xc1,0xfe,0xf4,0xc3]

v_minmax_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x5f,0xd6,0xf0,0xfa,0xc0,0x4b]

v_minmax_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x5f,0xd6,0xfd,0xd4,0x04,0x33]

v_minmax_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x5f,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_minmax_i32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x01,0x05,0x0e,0x00]

v_minmax_i32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0xff,0x05,0xa4,0x01]

v_minmax_i32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x01,0xfe,0xff,0x01]

v_minmax_i32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x69,0xd2,0xf8,0x01]

v_minmax_i32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x6a,0xf6,0x0c,0x04]

v_minmax_i32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_minmax_i32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x7b,0xfa,0xed,0x01]

v_minmax_i32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x7d,0xe0,0xf5,0x01]

v_minmax_i32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x7e,0x82,0xad,0x01]

v_minmax_i32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x7f,0xf8,0xa8,0x01]

v_minmax_i32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_minmax_i32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0xc1,0xfe,0xf4,0x03]

v_minmax_i32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0xf0,0xfa,0xc0,0x03]

v_minmax_i32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x65,0xd6,0xfd,0xd4,0x04,0x03]

v_minmax_i32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x65,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_minmax_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x01,0x05,0x0e,0x00]

v_minmax_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0xff,0x05,0xa4,0x01]

v_minmax_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x01,0xfe,0xff,0x01]

v_minmax_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x69,0xd2,0xf8,0x01]

v_minmax_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x6a,0xf6,0x0c,0x04]

v_minmax_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_minmax_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x7b,0xfa,0xed,0x01]

v_minmax_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x7d,0xe0,0xf5,0x01]

v_minmax_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x7e,0x82,0xad,0x01]

v_minmax_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x7f,0xf8,0xa8,0x01]

v_minmax_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_minmax_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0xc1,0xfe,0xf4,0x03]

v_minmax_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0xf0,0xfa,0xc0,0x03]

v_minmax_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x63,0xd6,0xfd,0xd4,0x04,0x03]

v_minmax_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x63,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0xea,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v255, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xff,0xeb,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s2, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0x05,0xe8,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s105, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x01,0xd3,0xe8,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[254:255], ttmp15, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0xfe,0xf7,0x18,0x00]

v_mqsad_pk_u16_u8 v[5:6], s[2:3], vcc_hi, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x02,0xd6,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[104:105], vcc_lo, s[104:105]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x68,0xd4,0xa0,0x01]

v_mqsad_pk_u16_u8 v[5:6], vcc, m0, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x6a,0xfa,0xf8,0x07]

v_mqsad_pk_u16_u8 v[5:6], ttmp[14:15], exec_hi, null
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x7a,0xfe,0xf0,0x01]

v_mqsad_pk_u16_u8 v[5:6], exec, exec_lo, exec
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x7e,0xfc,0xf8,0x01]

v_mqsad_pk_u16_u8 v[5:6], null, null, vcc
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0x7c,0xf8,0xa8,0x01]

v_mqsad_pk_u16_u8 v[5:6], -1, -1, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0xc1,0x82,0xfd,0x03,0x56,0x34,0x12,0xaf]

v_mqsad_pk_u16_u8 v[5:6], 0.5, 0.5, src_scc
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0xf0,0xe0,0xf5,0x03]

v_mqsad_pk_u16_u8 v[5:6], src_scc, src_scc, 0.5
// GFX11: encoding: [0x05,0x00,0x3b,0xd6,0xfd,0xfa,0xc1,0x03]

v_mqsad_pk_u16_u8 v[254:255], 0xaf123456, 0xaf123456, -1 clamp
// GFX11: encoding: [0xfe,0x80,0x3b,0xd6,0xff,0xfe,0x05,0x03,0x56,0x34,0x12,0xaf]

v_mqsad_u32_u8 v[5:8], v[1:2], v2, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x01,0x05,0xf2,0x07]

v_mqsad_u32_u8 v[5:8], v[1:2], v255, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x01,0xff,0xf3,0x07]

v_mqsad_u32_u8 v[5:8], v[1:2], s2, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x01,0x05,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], v[1:2], s105, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x01,0xd3,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], v[254:255], ttmp15, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0xfe,0xf7,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], s[2:3], vcc_hi, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x02,0xd6,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], s[104:105], vcc_lo, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x68,0xd4,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], vcc, m0, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x6a,0xfa,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], ttmp[14:15], exec_hi, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x7a,0xfe,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], exec, exec_lo, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x7e,0xfc,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], null, null, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0x7c,0xf8,0xf0,0x07]

v_mqsad_u32_u8 v[5:8], -1, -1, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0xc1,0x82,0xf1,0x07]

v_mqsad_u32_u8 v[5:8], 0.5, 0.5, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0xf0,0xe0,0xf1,0x07]

v_mqsad_u32_u8 v[5:8], src_scc, src_scc, v[252:255]
// GFX11: encoding: [0x05,0x00,0x3d,0xd6,0xfd,0xfa,0xf1,0x07]

v_mqsad_u32_u8 v[252:255], 0xaf123456, 0xaf123456, v[3:6] clamp
// GFX11: encoding: [0xfc,0x80,0x3d,0xd6,0xff,0xfe,0x0d,0x04,0x56,0x34,0x12,0xaf]

v_msad_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0x05,0x0e,0x00]

v_msad_u8 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xff,0x05,0xa4,0x01]

v_msad_u8 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x01,0xfe,0xff,0x01]

v_msad_u8 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x69,0xd2,0xf8,0x01]

v_msad_u8 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x6a,0xf6,0x0c,0x04]

v_msad_u8 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_msad_u8 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7b,0xfa,0xed,0x01]

v_msad_u8 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7d,0xe0,0xf5,0x01]

v_msad_u8 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7e,0x82,0xad,0x01]

v_msad_u8 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7f,0xf8,0xa8,0x01]

v_msad_u8 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_msad_u8 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xc1,0xfe,0xf4,0x03]

v_msad_u8 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xf0,0xfa,0xc0,0x03]

v_msad_u8 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x39,0xd6,0xfd,0xd4,0x04,0x03]

v_msad_u8 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x39,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_mul_f64 v[5:6], v[1:2], v[2:3]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[254:255], v[254:255]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xfe,0xfd,0x03,0x00]

v_mul_f64 v[5:6], s[2:3], s[4:5]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x02,0x08,0x00,0x00]

v_mul_f64 v[5:6], s[104:105], s[104:105]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x68,0xd0,0x00,0x00]

v_mul_f64 v[5:6], vcc, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x6a,0xf4,0x00,0x00]

v_mul_f64 v[5:6], ttmp[14:15], 0xaf123456
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_f64 v[5:6], -|exec|, src_scc
// GFX11: encoding: [0x05,0x01,0x28,0xd7,0x7e,0xfa,0x01,0x20]

v_mul_f64 v[5:6], null, 0.5
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0x7c,0xe0,0x01,0x00]

v_mul_f64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xc1,0x82,0x01,0x00]

v_mul_f64 v[5:6], 0.5, null mul:2
// GFX11: encoding: [0x05,0x00,0x28,0xd7,0xf0,0xf8,0x00,0x08]

v_mul_f64 v[5:6], -|src_scc|, -|exec| mul:4
// GFX11: encoding: [0x05,0x03,0x28,0xd7,0xfd,0xfc,0x00,0x70]

v_mul_f64 v[254:255], 0xaf123456, -|vcc| clamp div:2
// GFX11: encoding: [0xfe,0x82,0x28,0xd7,0xff,0xd4,0x00,0x58,0x56,0x34,0x12,0xaf]

v_mul_hi_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xff,0xff,0x03,0x00]

v_mul_hi_i32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x01,0x04,0x00,0x00]

v_mul_hi_i32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x69,0xd2,0x00,0x00]

v_mul_hi_i32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x6a,0xf6,0x00,0x00]

v_mul_hi_i32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_hi_i32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7b,0xfa,0x01,0x00]

v_mul_hi_i32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7d,0xe0,0x01,0x00]

v_mul_hi_i32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7e,0x82,0x01,0x00]

v_mul_hi_i32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7f,0xf8,0x00,0x00]

v_mul_hi_i32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0x7c,0xfc,0x00,0x00]

v_mul_hi_i32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xc1,0xfe,0x00,0x00]

v_mul_hi_i32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xf0,0xfa,0x00,0x00]

v_mul_hi_i32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x2e,0xd7,0xfd,0xd4,0x00,0x00]

v_mul_hi_i32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x2e,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mul_hi_u32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xff,0xff,0x03,0x00]

v_mul_hi_u32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x01,0x04,0x00,0x00]

v_mul_hi_u32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x69,0xd2,0x00,0x00]

v_mul_hi_u32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x6a,0xf6,0x00,0x00]

v_mul_hi_u32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_hi_u32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7b,0xfa,0x01,0x00]

v_mul_hi_u32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7d,0xe0,0x01,0x00]

v_mul_hi_u32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7e,0x82,0x01,0x00]

v_mul_hi_u32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7f,0xf8,0x00,0x00]

v_mul_hi_u32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0x7c,0xfc,0x00,0x00]

v_mul_hi_u32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xc1,0xfe,0x00,0x00]

v_mul_hi_u32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xf0,0xfa,0x00,0x00]

v_mul_hi_u32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x2d,0xd7,0xfd,0xd4,0x00,0x00]

v_mul_hi_u32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x2d,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mul_lo_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xff,0xff,0x03,0x00]

v_mul_lo_u16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x01,0x04,0x00,0x00]

v_mul_lo_u16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x69,0xd2,0x00,0x00]

v_mul_lo_u16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x6a,0xf6,0x00,0x00]

v_mul_lo_u16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_mul_lo_u16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7b,0xfa,0x01,0x00]

v_mul_lo_u16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7e,0x82,0x01,0x00]

v_mul_lo_u16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7f,0xf8,0x00,0x00]

v_mul_lo_u16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0x7c,0xfc,0x00,0x00]

v_mul_lo_u16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xc1,0xfe,0x00,0x00]

v_mul_lo_u16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x05,0xd7,0xfd,0xd4,0x00,0x00]

v_mul_lo_u16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x05,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_mul_lo_u32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xff,0xff,0x03,0x00]

v_mul_lo_u32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x01,0x04,0x00,0x00]

v_mul_lo_u32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x69,0xd2,0x00,0x00]

v_mul_lo_u32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x6a,0xf6,0x00,0x00]

v_mul_lo_u32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_mul_lo_u32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7b,0xfa,0x01,0x00]

v_mul_lo_u32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7d,0xe0,0x01,0x00]

v_mul_lo_u32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7e,0x82,0x01,0x00]

v_mul_lo_u32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7f,0xf8,0x00,0x00]

v_mul_lo_u32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0x7c,0xfc,0x00,0x00]

v_mul_lo_u32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xc1,0xfe,0x00,0x00]

v_mul_lo_u32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xf0,0xfa,0x00,0x00]

v_mul_lo_u32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x2c,0xd7,0xfd,0xd4,0x00,0x00]

v_mul_lo_u32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x2c,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_mullit_f32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0x05,0x0e,0x00]

v_mullit_f32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0xff,0x05,0xa4,0x01]

v_mullit_f32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x01,0xfe,0xff,0x01]

v_mullit_f32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x69,0xd2,0xf8,0x01]

v_mullit_f32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x6a,0xf6,0x0c,0x04]

v_mullit_f32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_mullit_f32 v5, -|ttmp15|, -|src_scc|, -|ttmp15|
// GFX11: encoding: [0x05,0x07,0x18,0xd6,0x7b,0xfa,0xed,0xe1]

v_mullit_f32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0x7d,0xe0,0xf5,0x01]

v_mullit_f32 v5, |exec_lo|, -1, vcc_hi
// GFX11: encoding: [0x05,0x01,0x18,0xd6,0x7e,0x82,0xad,0x01]

v_mullit_f32 v5, -|exec_hi|, null, -|vcc_lo|
// GFX11: encoding: [0x05,0x05,0x18,0xd6,0x7f,0xf8,0xa8,0xa1]

v_mullit_f32 v5, null, exec_lo, -|0xaf123456|
// GFX11: encoding: [0x05,0x04,0x18,0xd6,0x7c,0xfc,0xfc,0x83,0x56,0x34,0x12,0xaf]

v_mullit_f32 v5, -1, -|exec_hi|, -|src_scc|
// GFX11: encoding: [0x05,0x06,0x18,0xd6,0xc1,0xfe,0xf4,0xc3]

v_mullit_f32 v5, 0.5, -m0, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x18,0xd6,0xf0,0xfa,0xc0,0x4b]

v_mullit_f32 v5, -src_scc, |vcc_lo|, -1 mul:4
// GFX11: encoding: [0x05,0x02,0x18,0xd6,0xfd,0xd4,0x04,0x33]

v_mullit_f32 v255, -|0xaf123456|, -|vcc_hi|, null clamp div:2
// GFX11: encoding: [0xff,0x83,0x18,0xd6,0xff,0xd6,0xf0,0x79,0x56,0x34,0x12,0xaf]

v_or3_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0x05,0x0e,0x00]

v_or3_b32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xff,0x05,0xa4,0x01]

v_or3_b32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x01,0xfe,0xff,0x01]

v_or3_b32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x69,0xd2,0xf8,0x01]

v_or3_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x6a,0xf6,0x0c,0x04]

v_or3_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_or3_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7b,0xfa,0xed,0x01]

v_or3_b32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7d,0xe0,0xf5,0x01]

v_or3_b32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7e,0x82,0xad,0x01]

v_or3_b32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7f,0xf8,0xa8,0x01]

v_or3_b32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_or3_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xc1,0xfe,0xf4,0x03]

v_or3_b32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xf0,0xfa,0xc0,0x03]

v_or3_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x58,0xd6,0xfd,0xd4,0x04,0x03]

v_or3_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x58,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_or_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x05,0x02,0x00]

v_or_b16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0xff,0x03,0x00]

v_or_b16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x01,0x04,0x00,0x00]

v_or_b16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x69,0xd2,0x00,0x00]

v_or_b16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x6a,0xf6,0x00,0x00]

v_or_b16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_or_b16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7b,0xfa,0x01,0x00]

v_or_b16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_or_b16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7e,0x82,0x01,0x00]

v_or_b16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7f,0xf8,0x00,0x00]

v_or_b16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0x7c,0xfc,0x00,0x00]

v_or_b16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xc1,0xfe,0x00,0x00]

v_or_b16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_or_b16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x63,0xd7,0xfd,0xd4,0x00,0x00]

v_or_b16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x63,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_pack_b32_f16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x05,0x02,0x00]

v_pack_b32_f16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xff,0xff,0x03,0x00]

v_pack_b32_f16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x01,0x04,0x00,0x00]

v_pack_b32_f16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x69,0xd2,0x00,0x00]

v_pack_b32_f16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x6a,0xf6,0x00,0x00]

v_pack_b32_f16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_pack_b32_f16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7b,0xfa,0x01,0x00]

v_pack_b32_f16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7d,0xe0,0x01,0x00]

v_pack_b32_f16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7e,0x82,0x01,0x00]

v_pack_b32_f16 v5, |exec_hi|, null
// GFX11: encoding: [0x05,0x01,0x11,0xd7,0x7f,0xf8,0x00,0x00]

v_pack_b32_f16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0x7c,0xfc,0x00,0x00]

v_pack_b32_f16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xc1,0xfe,0x00,0x00]

v_pack_b32_f16 v5, 0.5, -m0 op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x11,0xd7,0xf0,0xfa,0x00,0x40]

v_pack_b32_f16 v5, -src_scc, |vcc_lo| op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x0a,0x11,0xd7,0xfd,0xd4,0x00,0x20]

v_pack_b32_f16 v255, -|0xfe0b|, -|vcc_hi| op_sel:[0,1,0]
// GFX11: encoding: [0xff,0x13,0x11,0xd7,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_perm_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0x05,0x0e,0x00]

v_perm_b32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xff,0x05,0xa4,0x01]

v_perm_b32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x01,0xfe,0xff,0x01]

v_perm_b32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x69,0xd2,0xf8,0x01]

v_perm_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x6a,0xf6,0x0c,0x04]

v_perm_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_perm_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7b,0xfa,0xed,0x01]

v_perm_b32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7d,0xe0,0xf5,0x01]

v_perm_b32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7e,0x82,0xad,0x01]

v_perm_b32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7f,0xf8,0xa8,0x01]

v_perm_b32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_perm_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xc1,0xfe,0xf4,0x03]

v_perm_b32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xf0,0xfa,0xc0,0x03]

v_perm_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x44,0xd6,0xfd,0xd4,0x04,0x03]

v_perm_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x44,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_permlane16_b32 v5, v1, s2, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0x0c,0x00]

v_permlane16_b32 v5, v1, s105, s105
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd3,0xa4,0x01]

v_permlane16_b32 v5, v1, ttmp15, ttmp15
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xf7,0xec,0x01]

v_permlane16_b32 v5, v1, vcc_hi, exec_lo
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd7,0xf8,0x01]

v_permlane16_b32 v5, v1, vcc_lo, m0
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xd5,0xf4,0x01]

v_permlane16_b32 v5, v1, m0, vcc_hi
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xfb,0xac,0x01]

v_permlane16_b32 v5, v1, exec_hi, vcc_lo
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xff,0xa8,0x01]

v_permlane16_b32 v5, v1, exec_lo, src_scc
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xfd,0xf4,0x03]

v_permlane16_b32 v5, v1, null, 0.5 op_sel:[1,1]
// GFX11: encoding: [0x05,0x18,0x5b,0xd6,0x01,0xf9,0xc0,0x03]

v_permlane16_b32 v5, v1, -1, -1 op_sel:[0,0]
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x83,0x05,0x03]

v_permlane16_b32 v5, v1, 0.5, null op_sel:[1,0]
// GFX11: encoding: [0x05,0x08,0x5b,0xd6,0x01,0xe1,0xf1,0x01]

v_permlane16_b32 v255, v255, src_scc, exec_hi op_sel:[0,1]
// GFX11: encoding: [0xff,0x10,0x5b,0xd6,0xff,0xfb,0xfd,0x01]

v_permlane16_b32 v5, v1, 0xaf123456, s3
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xff,0x0d,0x00,0x56,0x34,0x12,0xaf]

v_permlane16_b32 v5, v1, s2, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0x05,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_permlane16_b32 v5, v1, 0x12345678, 0x12345678
// GFX11: encoding: [0x05,0x00,0x5b,0xd6,0x01,0xff,0xfd,0x03,0x78,0x56,0x34,0x12]

v_permlanex16_b32 v5, v1, s2, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0x0c,0x00]

v_permlanex16_b32 v5, v1, s105, s105
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd3,0xa4,0x01]

v_permlanex16_b32 v5, v1, ttmp15, ttmp15
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xf7,0xec,0x01]

v_permlanex16_b32 v5, v1, vcc_hi, exec_lo
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd7,0xf8,0x01]

v_permlanex16_b32 v5, v1, vcc_lo, m0
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xd5,0xf4,0x01]

v_permlanex16_b32 v5, v1, m0, vcc_hi
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xfb,0xac,0x01]

v_permlanex16_b32 v5, v1, exec_hi, vcc_lo
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xff,0xa8,0x01]

v_permlanex16_b32 v5, v1, exec_lo, src_scc
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xfd,0xf4,0x03]

v_permlanex16_b32 v5, v1, null, 0.5 op_sel:[1,1]
// GFX11: encoding: [0x05,0x18,0x5c,0xd6,0x01,0xf9,0xc0,0x03]

v_permlanex16_b32 v5, v1, -1, -1 op_sel:[0,0]
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x83,0x05,0x03]

v_permlanex16_b32 v5, v1, 0.5, null op_sel:[1,0]
// GFX11: encoding: [0x05,0x08,0x5c,0xd6,0x01,0xe1,0xf1,0x01]

v_permlanex16_b32 v255, v255, src_scc, exec_hi op_sel:[0,1]
// GFX11: encoding: [0xff,0x10,0x5c,0xd6,0xff,0xfb,0xfd,0x01]

v_permlanex16_b32 v5, v1, 0xaf123456, s3
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xff,0x0d,0x00,0x56,0x34,0x12,0xaf]

v_permlanex16_b32 v5, v1, s2, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0x05,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_permlanex16_b32 v5, v1, 0x12345678, 0x12345678
// GFX11: encoding: [0x05,0x00,0x5c,0xd6,0x01,0xff,0xfd,0x03,0x78,0x56,0x34,0x12]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0xea,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v255, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xff,0xeb,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s2, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0x05,0xe8,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s105, ttmp[14:15]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x01,0xd3,0xe8,0x01]

v_qsad_pk_u16_u8 v[5:6], v[254:255], ttmp15, s[6:7]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0xfe,0xf7,0x18,0x00]

v_qsad_pk_u16_u8 v[5:6], s[2:3], vcc_hi, v[3:4]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x02,0xd6,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], s[104:105], vcc_lo, s[104:105]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x68,0xd4,0xa0,0x01]

v_qsad_pk_u16_u8 v[5:6], vcc, m0, v[254:255]
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x6a,0xfa,0xf8,0x07]

v_qsad_pk_u16_u8 v[5:6], ttmp[14:15], exec_hi, null
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x7a,0xfe,0xf0,0x01]

v_qsad_pk_u16_u8 v[5:6], exec, exec_lo, exec
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x7e,0xfc,0xf8,0x01]

v_qsad_pk_u16_u8 v[5:6], null, null, vcc
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0x7c,0xf8,0xa8,0x01]

v_qsad_pk_u16_u8 v[5:6], -1, -1, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0xc1,0x82,0xfd,0x03,0x56,0x34,0x12,0xaf]

v_qsad_pk_u16_u8 v[5:6], 0.5, 0.5, src_scc
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0xf0,0xe0,0xf5,0x03]

v_qsad_pk_u16_u8 v[5:6], src_scc, src_scc, 0.5
// GFX11: encoding: [0x05,0x00,0x3a,0xd6,0xfd,0xfa,0xc1,0x03]

v_qsad_pk_u16_u8 v[254:255], 0xaf123456, 0xaf123456, -1 clamp
// GFX11: encoding: [0xfe,0x80,0x3a,0xd6,0xff,0xfe,0x05,0x03,0x56,0x34,0x12,0xaf]

v_readlane_b32 s5, v1, s2
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0x05,0x00,0x00]

v_readlane_b32 s5, v1, s105
// GFX11: encoding: [0x05,0x00,0x60,0xd7,0x01,0xd3,0x00,0x00]

v_readlane_b32 s105, v1, ttmp15
// GFX11: encoding: [0x69,0x00,0x60,0xd7,0x01,0xf7,0x00,0x00]

v_readlane_b32 vcc_lo, v1, vcc_hi
// GFX11: encoding: [0x6a,0x00,0x60,0xd7,0x01,0xd7,0x00,0x00]

v_readlane_b32 vcc_hi, v1, vcc_lo
// GFX11: encoding: [0x6b,0x00,0x60,0xd7,0x01,0xd5,0x00,0x00]

v_readlane_b32 ttmp15, v1, m0
// GFX11: encoding: [0x7b,0x00,0x60,0xd7,0x01,0xfb,0x00,0x00]

v_readlane_b32 null, v255, null
// GFX11: encoding: [0x7c,0x00,0x60,0xd7,0xff,0xf9,0x00,0x00]

v_sad_hi_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0x05,0x0e,0x00]

v_sad_hi_u8 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xff,0x05,0xa4,0x01]

v_sad_hi_u8 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x01,0xfe,0xff,0x01]

v_sad_hi_u8 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x69,0xd2,0xf8,0x01]

v_sad_hi_u8 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x6a,0xf6,0x0c,0x04]

v_sad_hi_u8 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_sad_hi_u8 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7b,0xfa,0xed,0x01]

v_sad_hi_u8 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7d,0xe0,0xf5,0x01]

v_sad_hi_u8 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7e,0x82,0xad,0x01]

v_sad_hi_u8 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7f,0xf8,0xa8,0x01]

v_sad_hi_u8 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_sad_hi_u8 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xc1,0xfe,0xf4,0x03]

v_sad_hi_u8 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xf0,0xfa,0xc0,0x03]

v_sad_hi_u8 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x23,0xd6,0xfd,0xd4,0x04,0x03]

v_sad_hi_u8 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x23,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_sad_u16 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0x05,0x0e,0x00]

v_sad_u16 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xff,0x05,0xa4,0x01]

v_sad_u16 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x01,0xfe,0xff,0x01]

v_sad_u16 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x69,0xd2,0xf8,0x01]

v_sad_u16 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x6a,0xf6,0x0c,0x04]

v_sad_u16 v5, vcc_hi, 0xfe0b, v255
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x6b,0xfe,0xfd,0x07,0x0b,0xfe,0x00,0x00]

v_sad_u16 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7b,0xfa,0xed,0x01]

v_sad_u16 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7d,0xe0,0xf5,0x01]

v_sad_u16 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7e,0x82,0xad,0x01]

v_sad_u16 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7f,0xf8,0xa8,0x01]

v_sad_u16 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_sad_u16 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xc1,0xfe,0xf4,0x03]

v_sad_u16 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xf0,0xfa,0xc0,0x03]

v_sad_u16 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x24,0xd6,0xfd,0xd4,0x04,0x03]

v_sad_u16 v255, 0xfe0b, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x24,0xd6,0xff,0xd6,0xf0,0x01,0x0b,0xfe,0x00,0x00]

v_sad_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0x05,0x0e,0x00]

v_sad_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xff,0x05,0xa4,0x01]

v_sad_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x01,0xfe,0xff,0x01]

v_sad_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x69,0xd2,0xf8,0x01]

v_sad_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x6a,0xf6,0x0c,0x04]

v_sad_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_sad_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7b,0xfa,0xed,0x01]

v_sad_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7d,0xe0,0xf5,0x01]

v_sad_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7e,0x82,0xad,0x01]

v_sad_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7f,0xf8,0xa8,0x01]

v_sad_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_sad_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xc1,0xfe,0xf4,0x03]

v_sad_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xf0,0xfa,0xc0,0x03]

v_sad_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x25,0xd6,0xfd,0xd4,0x04,0x03]

v_sad_u32 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x25,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_sad_u8 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0x05,0x0e,0x00]

v_sad_u8 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xff,0x05,0xa4,0x01]

v_sad_u8 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x01,0xfe,0xff,0x01]

v_sad_u8 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x69,0xd2,0xf8,0x01]

v_sad_u8 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x6a,0xf6,0x0c,0x04]

v_sad_u8 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_sad_u8 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7b,0xfa,0xed,0x01]

v_sad_u8 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7d,0xe0,0xf5,0x01]

v_sad_u8 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7e,0x82,0xad,0x01]

v_sad_u8 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7f,0xf8,0xa8,0x01]

v_sad_u8 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_sad_u8 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xc1,0xfe,0xf4,0x03]

v_sad_u8 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xf0,0xfa,0xc0,0x03]

v_sad_u8 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x22,0xd6,0xfd,0xd4,0x04,0x03]

v_sad_u8 v255, 0xaf123456, vcc_hi, null clamp
// GFX11: encoding: [0xff,0x80,0x22,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_sub_co_u32 v5, s6, v1, v2
// W32: encoding: [0x05,0x06,0x01,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, v255, v255
// W32: encoding: [0x05,0x06,0x01,0xd7,0xff,0xff,0x03,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, s1, s2
// W32: encoding: [0x05,0x06,0x01,0xd7,0x01,0x04,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, s105, s105
// W32: encoding: [0x05,0x06,0x01,0xd7,0x69,0xd2,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, vcc_lo, ttmp15
// W32: encoding: [0x05,0x06,0x01,0xd7,0x6a,0xf6,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, vcc_hi, 0xaf123456
// W32: encoding: [0x05,0x06,0x01,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, ttmp15, src_scc
// W32: encoding: [0x05,0x06,0x01,0xd7,0x7b,0xfa,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, m0, 0.5
// W32: encoding: [0x05,0x06,0x01,0xd7,0x7d,0xe0,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, exec_lo, -1
// W32: encoding: [0x05,0x06,0x01,0xd7,0x7e,0x82,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s6, exec_hi, null
// W32: encoding: [0x05,0x06,0x01,0xd7,0x7f,0xf8,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s105, null, exec_lo
// W32: encoding: [0x05,0x69,0x01,0xd7,0x7c,0xfc,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, vcc_lo, -1, exec_hi
// W32: encoding: [0x05,0x6a,0x01,0xd7,0xc1,0xfe,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, vcc_hi, 0.5, m0
// W32: encoding: [0x05,0x6b,0x01,0xd7,0xf0,0xfa,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, ttmp15, src_scc, vcc_lo
// W32: encoding: [0x05,0x7b,0x01,0xd7,0xfd,0xd4,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], v1, v2
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], v255, v255
// W64: encoding: [0x05,0x0c,0x01,0xd7,0xff,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], s1, s2
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x01,0x04,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], s105, s105
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x69,0xd2,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], vcc_lo, ttmp15
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x6a,0xf6,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], vcc_hi, 0xaf123456
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], ttmp15, src_scc
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x7b,0xfa,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], m0, 0.5
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x7d,0xe0,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], exec_lo, -1
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x7e,0x82,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], exec_hi, null
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x7f,0xf8,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[12:13], null, exec_lo
// W64: encoding: [0x05,0x0c,0x01,0xd7,0x7c,0xfc,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, s[104:105], -1, exec_hi
// W64: encoding: [0x05,0x68,0x01,0xd7,0xc1,0xfe,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v5, vcc, 0.5, m0
// W64: encoding: [0x05,0x6a,0x01,0xd7,0xf0,0xfa,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_sub_co_u32 v5, ttmp[14:15], src_scc, vcc_lo
// W64: encoding: [0x05,0x7a,0x01,0xd7,0xfd,0xd4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32 v255, null, 0xaf123456, vcc_hi clamp
// GFX11: encoding: [0xff,0xfc,0x01,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_sub_nc_i16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0xff,0xff,0x03,0x00]

v_sub_nc_i16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x01,0x04,0x00,0x00]

v_sub_nc_i16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x69,0xd2,0x00,0x00]

v_sub_nc_i16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x6a,0xf6,0x00,0x00]

v_sub_nc_i16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_sub_nc_i16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7b,0xfa,0x01,0x00]

v_sub_nc_i16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_i16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7e,0x82,0x01,0x00]

v_sub_nc_i16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0x7f,0xf8,0x00,0x00]

v_sub_nc_i16 v5, null, exec_lo op_sel:[1,1,1]
// GFX11: encoding: [0x05,0x58,0x0e,0xd7,0x7c,0xfc,0x00,0x00]

v_sub_nc_i16 v5, -1, exec_hi op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x0e,0xd7,0xc1,0xfe,0x00,0x00]

v_sub_nc_i16 v5, 0.5, m0 op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x08,0x0e,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_i16 v5, src_scc, vcc_lo op_sel:[0,1,0]
// GFX11: encoding: [0x05,0x10,0x0e,0xd7,0xfd,0xd4,0x00,0x00]

v_sub_nc_i16 v255, 0xfe0b, vcc_hi op_sel:[0,0,1] clamp
// GFX11: encoding: [0xff,0xc0,0x0e,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_sub_nc_i32 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_i32 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xff,0xff,0x03,0x00]

v_sub_nc_i32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x01,0x04,0x00,0x00]

v_sub_nc_i32 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x69,0xd2,0x00,0x00]

v_sub_nc_i32 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x6a,0xf6,0x00,0x00]

v_sub_nc_i32 v5, vcc_hi, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_sub_nc_i32 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7b,0xfa,0x01,0x00]

v_sub_nc_i32 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7d,0xe0,0x01,0x00]

v_sub_nc_i32 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7e,0x82,0x01,0x00]

v_sub_nc_i32 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7f,0xf8,0x00,0x00]

v_sub_nc_i32 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0x7c,0xfc,0x00,0x00]

v_sub_nc_i32 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xc1,0xfe,0x00,0x00]

v_sub_nc_i32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xf0,0xfa,0x00,0x00]

v_sub_nc_i32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x25,0xd7,0xfd,0xd4,0x00,0x00]

v_sub_nc_i32 v255, 0xaf123456, vcc_hi clamp
// GFX11: encoding: [0xff,0x80,0x25,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_sub_nc_u16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x05,0x02,0x00]

v_sub_nc_u16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0xff,0xff,0x03,0x00]

v_sub_nc_u16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x01,0x04,0x00,0x00]

v_sub_nc_u16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x69,0xd2,0x00,0x00]

v_sub_nc_u16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x6a,0xf6,0x00,0x00]

v_sub_nc_u16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_sub_nc_u16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7b,0xfa,0x01,0x00]

v_sub_nc_u16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_u16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7e,0x82,0x01,0x00]

v_sub_nc_u16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0x7f,0xf8,0x00,0x00]

v_sub_nc_u16 v5, null, exec_lo op_sel:[1,1,1]
// GFX11: encoding: [0x05,0x58,0x04,0xd7,0x7c,0xfc,0x00,0x00]

v_sub_nc_u16 v5, -1, exec_hi op_sel:[0,0,0]
// GFX11: encoding: [0x05,0x00,0x04,0xd7,0xc1,0xfe,0x00,0x00]

v_sub_nc_u16 v5, 0.5, m0 op_sel:[1,0,0]
// GFX11: encoding: [0x05,0x08,0x04,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_sub_nc_u16 v5, src_scc, vcc_lo op_sel:[0,1,0]
// GFX11: encoding: [0x05,0x10,0x04,0xd7,0xfd,0xd4,0x00,0x00]

v_sub_nc_u16 v255, 0xfe0b, vcc_hi op_sel:[0,0,1] clamp
// GFX11: encoding: [0xff,0xc0,0x04,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_subrev_co_u32 v5, s6, v1, v2
// W32: encoding: [0x05,0x06,0x02,0xd7,0x01,0x05,0x02,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, v255, v255
// W32: encoding: [0x05,0x06,0x02,0xd7,0xff,0xff,0x03,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, s1, s2
// W32: encoding: [0x05,0x06,0x02,0xd7,0x01,0x04,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, s105, s105
// W32: encoding: [0x05,0x06,0x02,0xd7,0x69,0xd2,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, vcc_lo, ttmp15
// W32: encoding: [0x05,0x06,0x02,0xd7,0x6a,0xf6,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, vcc_hi, 0xaf123456
// W32: encoding: [0x05,0x06,0x02,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, ttmp15, src_scc
// W32: encoding: [0x05,0x06,0x02,0xd7,0x7b,0xfa,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, m0, 0.5
// W32: encoding: [0x05,0x06,0x02,0xd7,0x7d,0xe0,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, exec_lo, -1
// W32: encoding: [0x05,0x06,0x02,0xd7,0x7e,0x82,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s6, exec_hi, null
// W32: encoding: [0x05,0x06,0x02,0xd7,0x7f,0xf8,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s105, null, exec_lo
// W32: encoding: [0x05,0x69,0x02,0xd7,0x7c,0xfc,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, vcc_lo, -1, exec_hi
// W32: encoding: [0x05,0x6a,0x02,0xd7,0xc1,0xfe,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, vcc_hi, 0.5, m0
// W32: encoding: [0x05,0x6b,0x02,0xd7,0xf0,0xfa,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, ttmp15, src_scc, vcc_lo
// W32: encoding: [0x05,0x7b,0x02,0xd7,0xfd,0xd4,0x00,0x00]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], v1, v2
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x01,0x05,0x02,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], v255, v255
// W64: encoding: [0x05,0x0c,0x02,0xd7,0xff,0xff,0x03,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], s1, s2
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x01,0x04,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], s105, s105
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x69,0xd2,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], vcc_lo, ttmp15
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x6a,0xf6,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], vcc_hi, 0xaf123456
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], ttmp15, src_scc
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x7b,0xfa,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], m0, 0.5
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x7d,0xe0,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], exec_lo, -1
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x7e,0x82,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], exec_hi, null
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x7f,0xf8,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[12:13], null, exec_lo
// W64: encoding: [0x05,0x0c,0x02,0xd7,0x7c,0xfc,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, s[104:105], -1, exec_hi
// W64: encoding: [0x05,0x68,0x02,0xd7,0xc1,0xfe,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v5, vcc, 0.5, m0
// W64: encoding: [0x05,0x6a,0x02,0xd7,0xf0,0xfa,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: operands are not valid for this GPU or mode

v_subrev_co_u32 v5, ttmp[14:15], src_scc, vcc_lo
// W64: encoding: [0x05,0x7a,0x02,0xd7,0xfd,0xd4,0x00,0x00]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32 v255, null, 0xaf123456, vcc_hi clamp
// GFX11: encoding: [0xff,0xfc,0x02,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_trig_preop_f64 v[5:6], v[1:2], v2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v255
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xff,0x03,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0x05,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s105
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x01,0xd3,0x00,0x00]

v_trig_preop_f64 v[5:6], v[254:255], ttmp15
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xfe,0xf7,0x00,0x00]

v_trig_preop_f64 v[5:6], s[2:3], vcc_hi
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x02,0xd6,0x00,0x00]

v_trig_preop_f64 v[5:6], s[104:105], vcc_lo
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x68,0xd4,0x00,0x00]

v_trig_preop_f64 v[5:6], vcc, m0
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x6a,0xfa,0x00,0x00]

v_trig_preop_f64 v[5:6], ttmp[14:15], exec_hi
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x7a,0xfe,0x00,0x00]

v_trig_preop_f64 v[5:6], exec, exec_lo
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x7e,0xfc,0x00,0x00]

v_trig_preop_f64 v[5:6], null, null
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0x7c,0xf8,0x00,0x00]

v_trig_preop_f64 v[5:6], -1, -1
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xc1,0x82,0x01,0x00]

v_trig_preop_f64 v[5:6], 0.5, 0.5 mul:2
// GFX11: encoding: [0x05,0x00,0x2f,0xd7,0xf0,0xe0,0x01,0x08]

v_trig_preop_f64 v[5:6], -|src_scc|, src_scc mul:4
// GFX11: encoding: [0x05,0x01,0x2f,0xd7,0xfd,0xfa,0x01,0x30]

v_trig_preop_f64 v[254:255], 0xaf123456, 0xaf123456 clamp div:2
// GFX11: encoding: [0xfe,0x80,0x2f,0xd7,0xff,0xfe,0x01,0x18,0x56,0x34,0x12,0xaf]

v_writelane_b32 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x01,0x04,0x00,0x00]

v_writelane_b32 v5, s105, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x69,0x04,0x00,0x00]

v_writelane_b32 v5, vcc_lo, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x6a,0x04,0x00,0x00]

v_writelane_b32 v5, vcc_hi, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x6b,0x04,0x00,0x00]

v_writelane_b32 v5, ttmp15, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x7b,0x04,0x00,0x00]

v_writelane_b32 v5, m0, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x7d,0x04,0x00,0x00]

v_writelane_b32 v5, exec_lo, s2
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x7e,0x04,0x00,0x00]

v_writelane_b32 v5, exec_hi, s105
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x7f,0xd2,0x00,0x00]

v_writelane_b32 v5, null, ttmp15
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0x7c,0xf6,0x00,0x00]

v_writelane_b32 v5, -1, null
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0xc1,0xf8,0x00,0x00]

v_writelane_b32 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0xf0,0xfa,0x00,0x00]

v_writelane_b32 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x61,0xd7,0xfd,0xd4,0x00,0x00]

v_writelane_b32 v255, 0xaf123456, vcc_hi
// GFX11: encoding: [0xff,0x00,0x61,0xd7,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_xad_u32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0x05,0x0e,0x00]

v_xad_u32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xff,0x05,0xa4,0x01]

v_xad_u32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x01,0xfe,0xff,0x01]

v_xad_u32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x69,0xd2,0xf8,0x01]

v_xad_u32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x6a,0xf6,0x0c,0x04]

v_xad_u32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_xad_u32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7b,0xfa,0xed,0x01]

v_xad_u32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7d,0xe0,0xf5,0x01]

v_xad_u32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7e,0x82,0xad,0x01]

v_xad_u32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7f,0xf8,0xa8,0x01]

v_xad_u32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_xad_u32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xc1,0xfe,0xf4,0x03]

v_xad_u32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xf0,0xfa,0xc0,0x03]

v_xad_u32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x45,0xd6,0xfd,0xd4,0x04,0x03]

v_xad_u32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x45,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_xor3_b32 v5, v1, v2, s3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0x05,0x0e,0x00]

v_xor3_b32 v5, v255, s2, s105
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xff,0x05,0xa4,0x01]

v_xor3_b32 v5, s1, v255, exec_hi
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x01,0xfe,0xff,0x01]

v_xor3_b32 v5, s105, s105, exec_lo
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x69,0xd2,0xf8,0x01]

v_xor3_b32 v5, vcc_lo, ttmp15, v3
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x6a,0xf6,0x0c,0x04]

v_xor3_b32 v5, vcc_hi, 0xaf123456, v255
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x6b,0xfe,0xfd,0x07,0x56,0x34,0x12,0xaf]

v_xor3_b32 v5, ttmp15, src_scc, ttmp15
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7b,0xfa,0xed,0x01]

v_xor3_b32 v5, m0, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7d,0xe0,0xf5,0x01]

v_xor3_b32 v5, exec_lo, -1, vcc_hi
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7e,0x82,0xad,0x01]

v_xor3_b32 v5, exec_hi, null, vcc_lo
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7f,0xf8,0xa8,0x01]

v_xor3_b32 v5, null, exec_lo, 0xaf123456
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0x7c,0xfc,0xfc,0x03,0x56,0x34,0x12,0xaf]

v_xor3_b32 v5, -1, exec_hi, src_scc
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xc1,0xfe,0xf4,0x03]

v_xor3_b32 v5, 0.5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xf0,0xfa,0xc0,0x03]

v_xor3_b32 v5, src_scc, vcc_lo, -1
// GFX11: encoding: [0x05,0x00,0x40,0xd6,0xfd,0xd4,0x04,0x03]

v_xor3_b32 v255, 0xaf123456, vcc_hi, null
// GFX11: encoding: [0xff,0x00,0x40,0xd6,0xff,0xd6,0xf0,0x01,0x56,0x34,0x12,0xaf]

v_xor_b16 v5, v1, v2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x05,0x02,0x00]

v_xor_b16 v5, v255, v255
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0xff,0x03,0x00]

v_xor_b16 v5, s1, s2
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x01,0x04,0x00,0x00]

v_xor_b16 v5, s105, s105
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x69,0xd2,0x00,0x00]

v_xor_b16 v5, vcc_lo, ttmp15
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x6a,0xf6,0x00,0x00]

v_xor_b16 v5, vcc_hi, 0xfe0b
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_xor_b16 v5, ttmp15, src_scc
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7b,0xfa,0x01,0x00]

v_xor_b16 v5, m0, 0.5
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7d,0xfe,0x01,0x00,0x00,0x38,0x00,0x00]

v_xor_b16 v5, exec_lo, -1
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7e,0x82,0x01,0x00]

v_xor_b16 v5, exec_hi, null
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7f,0xf8,0x00,0x00]

v_xor_b16 v5, null, exec_lo
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0x7c,0xfc,0x00,0x00]

v_xor_b16 v5, -1, exec_hi
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xc1,0xfe,0x00,0x00]

v_xor_b16 v5, 0.5, m0
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xff,0xfa,0x00,0x00,0x00,0x38,0x00,0x00]

v_xor_b16 v5, src_scc, vcc_lo
// GFX11: encoding: [0x05,0x00,0x64,0xd7,0xfd,0xd4,0x00,0x00]

v_xor_b16 v255, 0xfe0b, vcc_hi
// GFX11: encoding: [0xff,0x00,0x64,0xd7,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]
