; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Verify that an excessive size to memchr() isn't truncated to an in-bounds
; value that results in the call being incorrectly folded (as might happen
; when LLVM is compiled in ILP32 mode).

declare ptr @memchr(ptr, i32, i64)

@ax = external global [0 x i8]
@a12345 = constant [5 x i8] c"\01\02\03\04\05"


; Do not fold memchr(ax, 1, UINT_MAX + (size_t)1) to null.  Only the first
; byte in ax must be dereferenceable.

define ptr @call_memchr_ax_2_uimax_p1() {
; CHECK-LABEL: @call_memchr_ax_2_uimax_p1(
; CHECK-NEXT:    [[RES:%.*]] = call ptr @memchr(ptr noundef nonnull dereferenceable(1) @ax, i32 1, i64 4294967296)
; CHECK-NEXT:    ret ptr [[RES]]
;

  %res = call ptr @memchr(ptr @ax, i32 1, i64 4294967296)
  ret ptr %res
}


; Do not fold memchr(ax, 1, UINT_MAX + (size_t)2) to *ax == 1 ? ax : null.
; As above, only the first byte in ax must be dereferenceable.

define ptr @call_memchr_ax_2_uimax_p2() {
; CHECK-LABEL: @call_memchr_ax_2_uimax_p2(
; CHECK-NEXT:    [[RES:%.*]] = call ptr @memchr(ptr noundef nonnull dereferenceable(1) @ax, i32 1, i64 4294967296)
; CHECK-NEXT:    ret ptr [[RES]]
;

  %res = call ptr @memchr(ptr @ax, i32 1, i64 4294967296)
  ret ptr %res
}


; Fold memchr(a12345, 3, UINT_MAX + (size_t)2) to a12345 + 2 (and not to
; null).

define ptr @fold_memchr_a12345_3_uimax_p2() {
; CHECK-LABEL: @fold_memchr_a12345_3_uimax_p2(
; CHECK-NEXT:    ret ptr getelementptr inbounds ([5 x i8], ptr @a12345, i64 0, i64 2)
;

  %res = call ptr @memchr(ptr @a12345, i32 3, i64 4294967297)
  ret ptr %res
}


; Do not fold memchr(a12345, c, UINT_MAX + (size_t)2).

define ptr @fold_memchr_a12345_c_uimax_p2(i32 %0) {
; CHECK-LABEL: @fold_memchr_a12345_c_uimax_p2(
; CHECK-NEXT:    [[RES:%.*]] = call ptr @memchr(ptr noundef nonnull dereferenceable(1) @a12345, i32 [[TMP0:%.*]], i64 4294967297)
; CHECK-NEXT:    ret ptr [[RES]]
;

  %res = call ptr @memchr(ptr @a12345, i32 %0, i64 4294967297)
  ret ptr %res
}
