; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 < %s | FileCheck %s

%struct.key_t = type { i32, [16 x i8] }

declare void @llvm.memset.p0i8.i64(ptr, i8, i64, i1)
declare void @test1(ptr)

define i32 @test() nounwind {
; CHECK-LABEL: test:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.w $zero, $sp, 16
; CHECK-NEXT:    st.d $zero, $sp, 8
; CHECK-NEXT:    st.d $zero, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 4
; CHECK-NEXT:    bl %plt(test1)
; CHECK-NEXT:    move $a0, $zero
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
  %key = alloca %struct.key_t, align 4
  call void @llvm.memset.p0i8.i64(ptr %key, i8 0, i64 20, i1 false)
  %1 = getelementptr inbounds %struct.key_t, ptr %key, i64 0, i32 1, i64 0
  call void @test1(ptr %1)
  ret i32 0
}

;; Note: will create an emergency spill slot, if (!isInt<11>(StackSize)).
;; Should involve only one SP-adjusting addi per adjustment.
define void @test_large_frame_size_2032() {
; CHECK-LABEL: test_large_frame_size_2032:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -2032
; CHECK-NEXT:    .cfi_def_cfa_offset 2032
; CHECK-NEXT:    addi.d $sp, $sp, 2032
; CHECK-NEXT:    ret
  %1 = alloca i8, i32 2016 ; + 16(emergency slot) = 2032
  ret void
}

;; Should involve two SP-adjusting addi's when adjusting SP up, but only one
;; when adjusting down.
define void @test_large_frame_size_2048() {
; CHECK-LABEL: test_large_frame_size_2048:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -2048
; CHECK-NEXT:    .cfi_def_cfa_offset 2048
; CHECK-NEXT:    addi.d $sp, $sp, 2032
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = alloca i8, i32 2032 ; + 16(emergency slot) = 2048
  ret void
}

;; Should involve two SP-adjusting addi's per adjustment.
define void @test_large_frame_size_2064() {
; CHECK-LABEL: test_large_frame_size_2064:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -2048
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 2064
; CHECK-NEXT:    addi.d $sp, $sp, 2032
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
  %1 = alloca i8, i32 2048 ; + 16(emergency slot) = 2064
  ret void
}

;; NOTE: Due to the problem with the emegency spill slot, the scratch register
;; will not be used when the fp is eliminated. To make this test valid, add the
;; attribute "frame-pointer=all".

;; SP should be adjusted with help of a scratch register.
define void @test_large_frame_size_1234576() "frame-pointer"="all" {
; CHECK-LABEL: test_large_frame_size_1234576:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -2032
; CHECK-NEXT:    .cfi_def_cfa_offset 2032
; CHECK-NEXT:    st.d $ra, $sp, 2024 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 2016 # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset 1, -8
; CHECK-NEXT:    .cfi_offset 22, -16
; CHECK-NEXT:    addi.d $fp, $sp, 2032
; CHECK-NEXT:    .cfi_def_cfa 22, 0
; CHECK-NEXT:    lu12i.w $a0, 300
; CHECK-NEXT:    ori $a0, $a0, 3760
; CHECK-NEXT:    sub.d $sp, $sp, $a0
; CHECK-NEXT:    lu12i.w $a0, 300
; CHECK-NEXT:    ori $a0, $a0, 3760
; CHECK-NEXT:    add.d $sp, $sp, $a0
; CHECK-NEXT:    ld.d $fp, $sp, 2016 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 2024 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 2032
; CHECK-NEXT:    ret
  %1 = alloca i8, i32 1234567
  ret void
}
