; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i64_stride8_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride8_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps (%r11), %xmm6
; SSE-NEXT:    movaps (%r10), %xmm7
; SSE-NEXT:    movaps %xmm0, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm3[0]
; SSE-NEXT:    movaps %xmm6, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm7[0]
; SSE-NEXT:    movaps %xmm4, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; SSE-NEXT:    movaps %xmm4, 96(%rax)
; SSE-NEXT:    movaps %xmm6, 112(%rax)
; SSE-NEXT:    movaps %xmm2, 80(%rax)
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps %xmm11, 32(%rax)
; SSE-NEXT:    movaps %xmm10, 48(%rax)
; SSE-NEXT:    movaps %xmm9, 16(%rax)
; SSE-NEXT:    movaps %xmm8, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride8_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r11), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride8_vf2:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps (%r11), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r9), %ymm2, %ymm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm3, %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride8_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vmovdqa (%r11), %xmm3
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vinserti128 $1, (%r10), %ymm3, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <2 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <2 x i64>, ptr %in.vecptr6, align 64
  %in.vec7 = load <2 x i64>, ptr %in.vecptr7, align 64
  %1 = shufflevector <2 x i64> %in.vec0, <2 x i64> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i64> %in.vec2, <2 x i64> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i64> %in.vec4, <2 x i64> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <2 x i64> %in.vec6, <2 x i64> %in.vec7, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = shufflevector <4 x i64> %1, <4 x i64> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = shufflevector <4 x i64> %3, <4 x i64> %4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %7 = shufflevector <8 x i64> %5, <8 x i64> %6, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %interleaved.vec = shufflevector <16 x i64> %7, <16 x i64> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  store <16 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride8_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride8_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm4
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps (%rsi), %xmm10
; SSE-NEXT:    movaps 16(%rsi), %xmm11
; SSE-NEXT:    movaps (%rdx), %xmm1
; SSE-NEXT:    movaps 16(%rdx), %xmm3
; SSE-NEXT:    movaps (%rcx), %xmm7
; SSE-NEXT:    movaps 16(%rcx), %xmm12
; SSE-NEXT:    movaps (%r8), %xmm5
; SSE-NEXT:    movaps 16(%r8), %xmm0
; SSE-NEXT:    movaps (%r9), %xmm13
; SSE-NEXT:    movaps (%r10), %xmm6
; SSE-NEXT:    movaps 16(%r10), %xmm9
; SSE-NEXT:    movaps (%rax), %xmm14
; SSE-NEXT:    movaps 16(%rax), %xmm15
; SSE-NEXT:    movaps %xmm1, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm7[0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; SSE-NEXT:    movaps %xmm4, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm10[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm10[1]
; SSE-NEXT:    movaps %xmm3, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm12[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm12[1]
; SSE-NEXT:    movaps %xmm2, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm11[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm11[1]
; SSE-NEXT:    movaps %xmm6, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm14[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm14[1]
; SSE-NEXT:    movaps %xmm5, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm13[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm13[1]
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm15[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm15[1]
; SSE-NEXT:    movaps 16(%r9), %xmm15
; SSE-NEXT:    movaps %xmm0, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm15[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm15[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps %xmm9, 240(%rax)
; SSE-NEXT:    movaps %xmm8, 160(%rax)
; SSE-NEXT:    movaps %xmm13, 176(%rax)
; SSE-NEXT:    movaps %xmm5, 96(%rax)
; SSE-NEXT:    movaps %xmm6, 112(%rax)
; SSE-NEXT:    movaps %xmm14, 32(%rax)
; SSE-NEXT:    movaps %xmm11, 48(%rax)
; SSE-NEXT:    movaps %xmm2, 192(%rax)
; SSE-NEXT:    movaps %xmm3, 208(%rax)
; SSE-NEXT:    movaps %xmm12, 128(%rax)
; SSE-NEXT:    movaps %xmm10, 144(%rax)
; SSE-NEXT:    movaps %xmm4, 64(%rax)
; SSE-NEXT:    movaps %xmm1, 80(%rax)
; SSE-NEXT:    movaps %xmm7, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride8_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%r11), %ymm1
; AVX1-ONLY-NEXT:    vmovaps (%r10), %ymm4
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovaps 16(%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm6
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm5[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm4[1],ymm1[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm6[1],xmm5[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm6[1],xmm5[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm6[0],xmm5[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm5
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm5[1],xmm3[1]
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm7
; AVX1-ONLY-NEXT:    vmovaps (%r11), %xmm8
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm8[1],xmm7[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm5[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm8[0],xmm7[0]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm8
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm8[1],xmm7[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm8[0],xmm7[0]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm8
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm11
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm11[1],xmm8[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vmovaps %xmm8, 16(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm12, 80(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm7, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm10, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm5, 48(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm3, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm9, 112(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm6, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 128(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride8_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm4
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %ymm5
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm6
; AVX2-ONLY-NEXT:    vmovaps (%r11), %ymm7
; AVX2-ONLY-NEXT:    vmovaps (%r10), %ymm8
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm1[0],ymm6[0],ymm1[2],ymm6[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm9[2,3],ymm0[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm8[1],ymm7[3],ymm8[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm6[1],ymm1[3],ymm6[3]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm7[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm7[2,3],ymm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm4[2,3]
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm3
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm4
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm4[1],xmm3[1]
; AVX2-ONLY-NEXT:    vmovaps (%r10), %xmm7
; AVX2-ONLY-NEXT:    vmovaps (%r11), %xmm8
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm8[0],xmm7[0]
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm8
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm11
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm12
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm12[1],xmm11[1]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm8[0],xmm7[0]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm12[0],xmm11[0]
; AVX2-ONLY-NEXT:    vmovaps %xmm8, 16(%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm7, (%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm13, 80(%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm10, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm4, 48(%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm3, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm9, 112(%rax)
; AVX2-ONLY-NEXT:    vmovaps %xmm5, 96(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 128(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 192(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 224(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride8_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-NEXT:    vmovdqa (%r11), %ymm3
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512-NEXT:    vinserti64x4 $1, (%r10), %zmm3, %zmm3
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [0,4,8,12,0,4,8,12]
; AVX512-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512-NEXT:    vpermt2q %zmm3, %zmm4, %zmm5
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm4
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,5,9,13,1,5,9,13]
; AVX512-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512-NEXT:    vpermt2q %zmm3, %zmm5, %zmm6
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm5[0,1,2,3],zmm6[4,5,6,7]
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [2,6,10,14,2,6,10,14]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm6 = zmm6[0,1,2,3],zmm7[4,5,6,7]
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,7,11,15,3,7,11,15]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm2
; AVX512-NEXT:    vpermt2q %zmm1, %zmm7, %zmm0
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm2[4,5,6,7]
; AVX512-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <4 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <4 x i64>, ptr %in.vecptr6, align 64
  %in.vec7 = load <4 x i64>, ptr %in.vecptr7, align 64
  %1 = shufflevector <4 x i64> %in.vec0, <4 x i64> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i64> %in.vec2, <4 x i64> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i64> %in.vec4, <4 x i64> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <4 x i64> %in.vec6, <4 x i64> %in.vec7, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <8 x i64> %1, <8 x i64> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = shufflevector <8 x i64> %3, <8 x i64> %4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %7 = shufflevector <16 x i64> %5, <16 x i64> %6, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %interleaved.vec = shufflevector <32 x i64> %7, <32 x i64> poison, <32 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  store <32 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride8_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride8_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $152, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm3
; SSE-NEXT:    movaps 16(%rdi), %xmm5
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps 16(%rsi), %xmm13
; SSE-NEXT:    movaps (%rdx), %xmm4
; SSE-NEXT:    movaps 16(%rdx), %xmm7
; SSE-NEXT:    movaps (%rcx), %xmm2
; SSE-NEXT:    movaps 16(%rcx), %xmm14
; SSE-NEXT:    movaps (%r8), %xmm6
; SSE-NEXT:    movaps 16(%r8), %xmm9
; SSE-NEXT:    movaps (%r9), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm0
; SSE-NEXT:    movaps (%r10), %xmm8
; SSE-NEXT:    movaps 16(%r10), %xmm15
; SSE-NEXT:    movaps (%rax), %xmm12
; SSE-NEXT:    movaps %xmm3, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm1[0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm2[1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm11[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm11[1]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm12[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm12[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm13[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm13[1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm14[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm14[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm13
; SSE-NEXT:    movaps 32(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm13, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm1[1]
; SSE-NEXT:    movaps 32(%rdx), %xmm14
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps 32(%r8), %xmm8
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 32(%r10), %xmm10
; SSE-NEXT:    movaps 32(%rax), %xmm0
; SSE-NEXT:    movaps %xmm10, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rdi), %xmm6
; SSE-NEXT:    movaps 48(%rsi), %xmm2
; SSE-NEXT:    movaps %xmm6, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm2[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movaps 48(%r8), %xmm1
; SSE-NEXT:    movaps 48(%r9), %xmm3
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    movaps 48(%r10), %xmm3
; SSE-NEXT:    movaps 48(%rax), %xmm5
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm5[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm3, 496(%rax)
; SSE-NEXT:    movaps %xmm1, 480(%rax)
; SSE-NEXT:    movaps %xmm2, 464(%rax)
; SSE-NEXT:    movaps %xmm6, 448(%rax)
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps %xmm4, 416(%rax)
; SSE-NEXT:    movaps %xmm7, 400(%rax)
; SSE-NEXT:    movaps %xmm9, 384(%rax)
; SSE-NEXT:    movaps %xmm10, 368(%rax)
; SSE-NEXT:    movaps %xmm8, 352(%rax)
; SSE-NEXT:    movaps %xmm14, 336(%rax)
; SSE-NEXT:    movaps %xmm13, 320(%rax)
; SSE-NEXT:    movaps %xmm11, 304(%rax)
; SSE-NEXT:    movaps %xmm12, 288(%rax)
; SSE-NEXT:    movaps %xmm15, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $152, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride8_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $104, %rsp
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm10
; AVX1-ONLY-NEXT:    vmovaps 16(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 48(%r9), %xmm7
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm12
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],mem[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm9[0],xmm8[0]
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm14
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm5, %ymm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm5[0],ymm15[1],ymm5[2],ymm15[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm9 = xmm9[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm14[4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3],ymm9[4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm13[0],xmm11[0]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm14
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm9, %ymm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[0],ymm15[1],ymm9[2],ymm15[2]
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm13[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm13[0,1],ymm11[2,3],ymm13[4,5],ymm11[6,7]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm15[0],ymm7[0],ymm15[2],ymm7[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3],mem[4,5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm12[0],xmm10[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm14, %ymm14
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm14[0],ymm1[1],ymm14[2],ymm1[2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm10, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3],mem[4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm4[1],ymm0[2],ymm4[2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm15[1],xmm7[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm5[1],xmm6[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 192(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 224(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, (%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 384(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 448(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovapd %ymm14, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm13, 416(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 480(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 320(%rdx)
; AVX1-ONLY-NEXT:    vmovapd %ymm9, 256(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 352(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX1-ONLY-NEXT:    addq $104, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride8_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    pushq %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm6
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm9
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm10
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm7
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm7[1],xmm5[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm11
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm14
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm13
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm15[1],xmm14[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm4[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm10[1],xmm9[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm13[1],xmm11[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm7[0],xmm5[0]
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm7
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm5, %ymm5
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm3, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm8
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm15[0],xmm14[0]
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm15
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm5, %ymm5
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm12, %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm12
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm10[0],xmm9[0]
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm14
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm9, %ymm9
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm6, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm13[0],xmm11[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm9, %ymm9
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm12[0],ymm14[0],ymm12[2],ymm14[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1,2,3,4,5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm11
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm15[1],ymm11[1],ymm15[3],ymm11[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm13[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm15[0],ymm11[0],ymm15[2],ymm11[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm15
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm3
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm13[0],ymm15[0],ymm13[2],ymm15[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm12[1],ymm14[1],ymm12[3],ymm14[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm13
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm12[2,3],ymm13[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm8[1],ymm7[3],ymm8[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm8
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3],ymm8[2,3]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 224(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 384(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 416(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 128(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 160(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, (%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 256(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX2-ONLY-NEXT:    popq %rax
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i64_stride8_vf8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm6
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm9
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm7
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm8
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512F-NEXT:    vmovdqa64 (%r11), %zmm1
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm3
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [1,9,1,9,1,9,1,9]
; AVX512F-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm4, %zmm5
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm0, %zmm4
; AVX512F-NEXT:    movb $-64, %r8b
; AVX512F-NEXT:    kmovw %r8d, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm4 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %xmm10
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm11
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm11[1],xmm10[1]
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm12
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm14
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm14[1],xmm12[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm5, %ymm13, %ymm5
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm4, %zmm16
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [6,14,6,14,6,14,6,14]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k1} = zmm1[0],zmm3[0],zmm1[2],zmm3[2],zmm1[4],zmm3[4],zmm1[6],zmm3[6]
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm6, %zmm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,6,14>
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm7, %zmm15
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm15[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm13, %zmm5
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [7,15,7,15,7,15,7,15]
; AVX512F-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm13, %zmm15
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm15 {%k1} = zmm1[1],zmm3[1],zmm1[3],zmm3[3],zmm1[5],zmm3[5],zmm1[7],zmm3[7]
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm6, %zmm13
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,7,15>
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm7, %zmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm15, %zmm13
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [4,12,4,12,4,12,4,12]
; AVX512F-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm4, %zmm15
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm17 = zmm0[0],zmm2[0],zmm0[2],zmm2[2],zmm0[4],zmm2[4],zmm0[6],zmm2[6]
; AVX512F-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,4,12>
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm7, %zmm15
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm15[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm17, %zmm4
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [5,13,5,13,5,13,5,13]
; AVX512F-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm15, %zmm17
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm18 = zmm0[1],zmm2[1],zmm0[3],zmm2[3],zmm0[5],zmm2[5],zmm0[7],zmm2[7]
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm18 {%k1}
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm15, %zmm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,5,13>
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm7, %zmm9
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm6, %zmm18, %zmm6
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [0,8,0,8,0,8,0,8]
; AVX512F-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm7, %zmm8
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm7 {%k1}
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm11[0],xmm10[0]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm9 = xmm14[0],xmm12[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm8, %ymm9, %ymm8
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm7, %zmm7
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [2,10,2,10,2,10,2,10]
; AVX512F-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm8, %zmm9
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm0, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm8 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %ymm9
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm10
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm12
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm14
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm15 = ymm14[0],ymm12[0],ymm14[2],ymm12[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm11 = ymm15[2,3],ymm11[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm11, %zmm8, %zmm8
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [3,11,3,11,3,11,3,11]
; AVX512F-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm11, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm11, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm14[1],ymm12[1],ymm14[3],ymm12[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm8, 128(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 320(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 256(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm13, 448(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 64(%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride8_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm8
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%r11), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm3
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [1,9,1,9,1,9,1,9]
; AVX512BW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm4, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm4
; AVX512BW-NEXT:    movb $-64, %r8b
; AVX512BW-NEXT:    kmovd %r8d, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm10
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm11
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm11[1],xmm10[1]
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm12
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm14
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm14[1],xmm12[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm13, %ymm5
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm4, %zmm16
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k1} = zmm1[0],zmm3[0],zmm1[2],zmm3[2],zmm1[4],zmm3[4],zmm1[6],zmm3[6]
; AVX512BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm5
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,6,14>
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm15
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm15[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm13, %zmm5
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm15
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm15 {%k1} = zmm1[1],zmm3[1],zmm1[3],zmm3[3],zmm1[5],zmm3[5],zmm1[7],zmm3[7]
; AVX512BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm13
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,7,15>
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm4
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm15, %zmm13
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [4,12,4,12,4,12,4,12]
; AVX512BW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm4, %zmm15
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm17 = zmm0[0],zmm2[0],zmm0[2],zmm2[2],zmm0[4],zmm2[4],zmm0[6],zmm2[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm9, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,4,12>
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm15
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm15[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm17, %zmm4
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [5,13,5,13,5,13,5,13]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm17
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm18 = zmm0[1],zmm2[1],zmm0[3],zmm2[3],zmm0[5],zmm2[5],zmm0[7],zmm2[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm18 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm15, %zmm6
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm9 = <u,u,5,13>
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm9
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm18, %zmm6
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [0,8,0,8,0,8,0,8]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm8
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm7 {%k1}
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm11[0],xmm10[0]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm9 = xmm14[0],xmm12[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm8, %ymm9, %ymm8
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm7, %zmm7
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm8, %zmm9
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm9
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm10
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX512BW-NEXT:    vmovdqa (%rsi), %ymm12
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm14
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm15 = ymm14[0],ymm12[0],ymm14[2],ymm12[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm11 = ymm15[2,3],ymm11[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm11, %zmm8, %zmm8
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm11, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm14[1],ymm12[1],ymm14[3],ymm12[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 64(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <8 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <8 x i64>, ptr %in.vecptr6, align 64
  %in.vec7 = load <8 x i64>, ptr %in.vecptr7, align 64
  %1 = shufflevector <8 x i64> %in.vec0, <8 x i64> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i64> %in.vec2, <8 x i64> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i64> %in.vec4, <8 x i64> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <8 x i64> %in.vec6, <8 x i64> %in.vec7, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <16 x i64> %1, <16 x i64> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = shufflevector <16 x i64> %3, <16 x i64> %4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %7 = shufflevector <32 x i64> %5, <32 x i64> %6, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %interleaved.vec = shufflevector <64 x i64> %7, <64 x i64> poison, <64 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 56, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 49, i32 57, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 50, i32 58, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 51, i32 59, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 52, i32 60, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 53, i32 61, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 54, i32 62, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47, i32 55, i32 63>
  store <64 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride8_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride8_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $664, %rsp # imm = 0x298
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm9
; SSE-NEXT:    movaps 16(%rdx), %xmm10
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm1
; SSE-NEXT:    movaps (%r8), %xmm11
; SSE-NEXT:    movaps 16(%r8), %xmm12
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps 16(%r9), %xmm3
; SSE-NEXT:    movaps (%r10), %xmm13
; SSE-NEXT:    movaps 16(%r10), %xmm15
; SSE-NEXT:    movaps (%rax), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm2[0]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm2[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm4[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm5[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm6[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm1[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm3[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdx), %xmm2
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r10), %xmm2
; SSE-NEXT:    movaps 32(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r10), %xmm2
; SSE-NEXT:    movaps 48(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r10), %xmm2
; SSE-NEXT:    movaps 64(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r10), %xmm15
; SSE-NEXT:    movaps 80(%rax), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm11
; SSE-NEXT:    movaps 96(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm1[1]
; SSE-NEXT:    movaps 96(%rdx), %xmm13
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movaps 96(%r8), %xmm8
; SSE-NEXT:    movaps 96(%r9), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 96(%r10), %xmm9
; SSE-NEXT:    movaps 96(%rax), %xmm0
; SSE-NEXT:    movaps %xmm9, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm6
; SSE-NEXT:    movaps 112(%rsi), %xmm2
; SSE-NEXT:    movaps %xmm6, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm2[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movaps 112(%r8), %xmm1
; SSE-NEXT:    movaps 112(%r9), %xmm3
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    movaps 112(%r10), %xmm3
; SSE-NEXT:    movaps 112(%rax), %xmm5
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm5[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm3, 1008(%rax)
; SSE-NEXT:    movaps %xmm1, 992(%rax)
; SSE-NEXT:    movaps %xmm2, 976(%rax)
; SSE-NEXT:    movaps %xmm6, 960(%rax)
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps %xmm4, 928(%rax)
; SSE-NEXT:    movaps %xmm7, 912(%rax)
; SSE-NEXT:    movaps %xmm10, 896(%rax)
; SSE-NEXT:    movaps %xmm9, 880(%rax)
; SSE-NEXT:    movaps %xmm8, 864(%rax)
; SSE-NEXT:    movaps %xmm13, 848(%rax)
; SSE-NEXT:    movaps %xmm11, 832(%rax)
; SSE-NEXT:    movaps %xmm12, 816(%rax)
; SSE-NEXT:    movaps %xmm14, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps %xmm15, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $664, %rsp # imm = 0x298
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride8_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm13
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm7[1],ymm3[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 16(%r9), %xmm12
; AVX1-ONLY-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm8
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm8[0],xmm7[0]
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm9, %ymm11
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[0],ymm11[1],ymm9[2],ymm11[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm9
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm14[0],ymm13[0],ymm14[2],ymm13[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],mem[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm9[0],ymm12[0],ymm9[2],ymm12[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],mem[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2],ymm5[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm12[0],ymm0[0],ymm12[2],ymm0[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm7[0],ymm9[0],ymm7[2],ymm9[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 80(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r9), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 80(%r8), %xmm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 80(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm8
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm8[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm10, %ymm11
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%r10), %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm10 = ymm10[0],ymm11[1],ymm10[2],ymm11[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 112(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 112(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 112(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],mem[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%rax), %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm4[0,1,2,3,4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm14[1],xmm13[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm15[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3],ymm14[4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2,3],ymm13[4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = xmm12[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm15[4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm7[1],xmm9[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 88(%rdx), %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm5[1],xmm6[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 88(%r10), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 960(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 928(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 896(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 864(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 832(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 736(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 704(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rdx)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 480(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 448(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 224(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rdx)
; AVX1-ONLY-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride8_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $488, %rsp # imm = 0x1E8
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, (%rsp) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm6
; AVX2-ONLY-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm13
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm7
; AVX2-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm13[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm9
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm12
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm11
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm12[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%rcx), %xmm7
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %xmm10
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm8
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm8[1],xmm10[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %xmm5
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm5[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm1
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%r10), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1,2,3],ymm14[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd (%rsp), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm13 = xmm13[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm13, %ymm13
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm13 = xmm13[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm13, %ymm13
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm13 = xmm13[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm13, %ymm13
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm9, %ymm9
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm13[0,1,2,3,4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm12[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm11, %ymm11
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm7, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm8[0],xmm10[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%r10), %ymm7, %ymm7
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm6, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm3, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%r10), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm6
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm3[0],ymm6[0],ymm3[2],ymm6[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm6[1],ymm3[3],ymm6[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm7
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm6[0],ymm7[0],ymm6[2],ymm7[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm8
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm10
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm8[0],ymm10[0],ymm8[2],ymm10[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm6[1],ymm7[1],ymm6[3],ymm7[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm7
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[2,3],ymm7[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm8[1],ymm10[1],ymm8[3],ymm10[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm8
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm7[2,3],ymm8[2,3]
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm10
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm11
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm10[0],ymm11[0],ymm10[2],ymm11[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 80(%rcx), %ymm9
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %ymm9
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm9[0],ymm0[0],ymm9[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm13[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 80(%rax), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm10[1],ymm11[1],ymm10[3],ymm11[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%rdx), %ymm11
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm10[2,3],ymm11[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm9[1],ymm0[1],ymm9[3],ymm0[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%r10), %ymm9
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm9[2,3]
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm11
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm9[0],ymm11[0],ymm9[2],ymm11[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%rcx), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %ymm15
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm12 = ymm15[0],ymm0[0],ymm15[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm12[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm12[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm9[1],ymm11[1],ymm9[3],ymm11[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%rdx), %ymm11
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm11[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%r10), %ymm11
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm11[2,3]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 960(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 928(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm14, 896(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 736(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 704(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 672(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 640(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 480(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 448(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 416(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 224(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 192(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rdx)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-ONLY-NEXT:    addq $488, %rsp # imm = 0x1E8
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i64_stride8_vf16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm7
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm19
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm9
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512F-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm30
; AVX512F-NEXT:    vmovdqa64 64(%r9), %zmm27
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm8
; AVX512F-NEXT:    vmovdqa64 64(%r10), %zmm1
; AVX512F-NEXT:    vmovdqa64 (%rax), %zmm31
; AVX512F-NEXT:    vmovdqa64 64(%rax), %zmm29
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [1,9,1,9,1,9,1,9]
; AVX512F-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm14, %zmm2
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm14, %zmm3
; AVX512F-NEXT:    movb $-64, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %xmm2
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %xmm16
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %xmm17
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm10 = xmm6[1],xmm2[1]
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm11
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm12
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm12[1],xmm11[1]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm10, %ymm20, %ymm10
; AVX512F-NEXT:    vinserti64x4 $0, %ymm10, %zmm3, %zmm21
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [0,8,0,8,0,8,0,8]
; AVX512F-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm20, %zmm3
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm20, %zmm10
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm10 {%k1}
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm6[0],xmm2[0]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm12[0],xmm11[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm22
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [5,13,5,13,5,13,5,13]
; AVX512F-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm3, %zmm2
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm5[1],zmm30[1],zmm5[3],zmm30[3],zmm5[5],zmm30[5],zmm5[7],zmm30[7]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm3, %zmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,5,13>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm11, %zmm10
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm6, %zmm23
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [4,12,4,12,4,12,4,12]
; AVX512F-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm6, %zmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm10 = zmm5[0],zmm30[0],zmm5[2],zmm30[2],zmm5[4],zmm30[4],zmm5[6],zmm30[6]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm6, %zmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,4,12>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm12, %zmm15
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm15[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm24
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [7,15,7,15,7,15,7,15]
; AVX512F-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm10, %zmm15
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm15 {%k1} = zmm8[1],zmm31[1],zmm8[3],zmm31[3],zmm8[5],zmm31[5],zmm8[7],zmm31[7]
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm10, %zmm13
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,7,15>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm2, %zmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm15, %zmm25
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [6,14,6,14,6,14,6,14]
; AVX512F-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm26, %zmm4
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k1} = zmm8[0],zmm31[0],zmm8[2],zmm31[2],zmm8[4],zmm31[4],zmm8[6],zmm31[6]
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm26, %zmm7
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm19 = <u,u,6,14>
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm19, %zmm9
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm7, %zmm4, %zmm18
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm14, %zmm4
; AVX512F-NEXT:    vpermi2q %zmm27, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm14 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm17[1],xmm16[1]
; AVX512F-NEXT:    vmovdqa 64(%rsi), %xmm7
; AVX512F-NEXT:    vmovdqa 64(%rdi), %xmm9
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm9[1],xmm7[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm4, %ymm13, %ymm4
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm14, %zmm28
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm20, %zmm4
; AVX512F-NEXT:    vpermi2q %zmm27, %zmm0, %zmm20
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm20 {%k1}
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm13
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm17[0],xmm16[0]
; AVX512F-NEXT:    vmovdqa64 64(%rsi), %zmm16
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm9[0],xmm7[0]
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %zmm14
; AVX512F-NEXT:    vinserti128 $1, %xmm4, %ymm7, %ymm4
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm20, %zmm17
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm3, %zmm4
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm7 = zmm0[1],zmm27[1],zmm0[3],zmm27[3],zmm0[5],zmm27[5],zmm0[7],zmm27[7]
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %zmm4
; AVX512F-NEXT:    vpermi2q %zmm16, %zmm13, %zmm3
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm14, %zmm11
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm11[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm7, %zmm3
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm6, %zmm7
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm0[0],zmm27[0],zmm0[2],zmm27[2],zmm0[4],zmm27[4],zmm0[6],zmm27[6]
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512F-NEXT:    vpermi2q %zmm16, %zmm13, %zmm6
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm14, %zmm12
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm12[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm6, %zmm9, %zmm6
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm10, %zmm7
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm7 {%k1} = zmm1[1],zmm29[1],zmm1[3],zmm29[3],zmm1[5],zmm29[5],zmm1[7],zmm29[7]
; AVX512F-NEXT:    vpermi2q %zmm16, %zmm13, %zmm10
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm14, %zmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm10[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm7, %zmm2
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm26, %zmm7
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k1} = zmm1[0],zmm29[0],zmm1[2],zmm29[2],zmm1[4],zmm29[4],zmm1[6],zmm29[6]
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm26, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm19, %zmm14
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm7, %zmm4
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [3,11,3,11,3,11,3,11]
; AVX512F-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm7, %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm7, %zmm10
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %ymm9
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm11
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm11[1],ymm9[1],ymm11[3],ymm9[3]
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm13
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm14
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm15 = ymm14[1],ymm13[1],ymm14[3],ymm13[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm15[2,3],ymm12[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm12, %zmm10, %zmm10
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512F-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm12, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm12, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm5 {%k1}
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm11[0],ymm9[0],ymm11[2],ymm9[2]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm14[0],ymm13[0],ymm14[2],ymm13[2]
; AVX512F-NEXT:    vmovdqa 64(%rsi), %ymm11
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX512F-NEXT:    vmovdqa 64(%rdi), %ymm9
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm5, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm7, %zmm8
; AVX512F-NEXT:    vpermi2q %zmm27, %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqa 64(%rcx), %ymm8
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm12, %zmm1
; AVX512F-NEXT:    vmovdqa 64(%rdx), %ymm13
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm12, %zmm0
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm13[1],ymm8[1],ymm13[3],ymm8[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm14 = ymm9[1],ymm11[1],ymm9[3],ymm11[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm14[2,3],ymm12[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm12, %zmm7, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm13[0],ymm8[0],ymm13[2],ymm8[2]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm9[0],ymm11[0],ymm9[2],ymm11[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm8[2,3],ymm1[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovdqa64 %zmm0, 640(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 704(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 128(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 192(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 896(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm2, 960(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 768(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm3, 832(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm17, 512(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm28, 576(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm18, 384(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm25, 448(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm24, 256(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm23, 320(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm22, (%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm21, 64(%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride8_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm30
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm27
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm8
; AVX512BW-NEXT:    vmovdqa64 64(%r10), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm31
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm29
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [1,9,1,9,1,9,1,9]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm14, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm14, %zmm3
; AVX512BW-NEXT:    movb $-64, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %xmm16
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %xmm17
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm10 = xmm6[1],xmm2[1]
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm11
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm12
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm12[1],xmm11[1]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm10, %ymm20, %ymm10
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm10, %zmm3, %zmm21
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [0,8,0,8,0,8,0,8]
; AVX512BW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm20, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm20, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm10 {%k1}
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm6[0],xmm2[0]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm12[0],xmm11[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm22
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [5,13,5,13,5,13,5,13]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm3, %zmm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm5[1],zmm30[1],zmm5[3],zmm30[3],zmm5[5],zmm30[5],zmm5[7],zmm30[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm3, %zmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,5,13>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm11, %zmm10
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm6, %zmm23
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [4,12,4,12,4,12,4,12]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm6, %zmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm10 = zmm5[0],zmm30[0],zmm5[2],zmm30[2],zmm5[4],zmm30[4],zmm5[6],zmm30[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,4,12>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm12, %zmm15
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm15[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm24
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm10, %zmm15
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm15 {%k1} = zmm8[1],zmm31[1],zmm8[3],zmm31[3],zmm8[5],zmm31[5],zmm8[7],zmm31[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm10, %zmm13
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,7,15>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm4
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm15, %zmm25
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm26, %zmm4
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k1} = zmm8[0],zmm31[0],zmm8[2],zmm31[2],zmm8[4],zmm31[4],zmm8[6],zmm31[6]
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm26, %zmm7
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm19 = <u,u,6,14>
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm19, %zmm9
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm7, %zmm4, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm14, %zmm4
; AVX512BW-NEXT:    vpermi2q %zmm27, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm14 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm17[1],xmm16[1]
; AVX512BW-NEXT:    vmovdqa 64(%rsi), %xmm7
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %xmm9
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm9[1],xmm7[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm4, %ymm13, %ymm4
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm14, %zmm28
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm20, %zmm4
; AVX512BW-NEXT:    vpermi2q %zmm27, %zmm0, %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm20 {%k1}
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm13
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm17[0],xmm16[0]
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm16
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm9[0],xmm7[0]
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm14
; AVX512BW-NEXT:    vinserti128 $1, %xmm4, %ymm7, %ymm4
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm20, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm3, %zmm4
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm7 = zmm0[1],zmm27[1],zmm0[3],zmm27[3],zmm0[5],zmm27[5],zmm0[7],zmm27[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm4
; AVX512BW-NEXT:    vpermi2q %zmm16, %zmm13, %zmm3
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm11[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm7, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm7
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm0[0],zmm27[0],zmm0[2],zmm27[2],zmm0[4],zmm27[4],zmm0[6],zmm27[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm16, %zmm13, %zmm6
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm12
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm12[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm9, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm10, %zmm7
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm7 {%k1} = zmm1[1],zmm29[1],zmm1[3],zmm29[3],zmm1[5],zmm29[5],zmm1[7],zmm29[7]
; AVX512BW-NEXT:    vpermi2q %zmm16, %zmm13, %zmm10
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm10[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm7, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm26, %zmm7
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k1} = zmm1[0],zmm29[0],zmm1[2],zmm29[2],zmm1[4],zmm29[4],zmm1[6],zmm29[6]
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm26, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm19, %zmm14
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm7, %zmm4
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm7, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm7, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm9
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm11
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm11[1],ymm9[1],ymm11[3],ymm9[3]
; AVX512BW-NEXT:    vmovdqa (%rsi), %ymm13
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm14
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm15 = ymm14[1],ymm13[1],ymm14[3],ymm13[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm15[2,3],ymm12[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm12, %zmm10, %zmm10
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm12, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm12, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm5 {%k1}
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm11[0],ymm9[0],ymm11[2],ymm9[2]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm14[0],ymm13[0],ymm14[2],ymm13[2]
; AVX512BW-NEXT:    vmovdqa 64(%rsi), %ymm11
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm9
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm5, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm7, %zmm8
; AVX512BW-NEXT:    vpermi2q %zmm27, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rcx), %ymm8
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqa 64(%rdx), %ymm13
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm12, %zmm0
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm13[1],ymm8[1],ymm13[3],ymm8[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm14 = ymm9[1],ymm11[1],ymm9[3],ymm11[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm14[2,3],ymm12[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm12, %zmm7, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm13[0],ymm8[0],ymm13[2],ymm8[2]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm9[0],ymm11[0],ymm9[2],ymm11[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm8[2,3],ymm1[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 896(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 960(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 832(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm28, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 64(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <16 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <16 x i64>, ptr %in.vecptr6, align 64
  %in.vec7 = load <16 x i64>, ptr %in.vecptr7, align 64
  %1 = shufflevector <16 x i64> %in.vec0, <16 x i64> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i64> %in.vec2, <16 x i64> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i64> %in.vec4, <16 x i64> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <16 x i64> %in.vec6, <16 x i64> %in.vec7, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <32 x i64> %1, <32 x i64> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = shufflevector <32 x i64> %3, <32 x i64> %4, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %7 = shufflevector <64 x i64> %5, <64 x i64> %6, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %interleaved.vec = shufflevector <128 x i64> %7, <128 x i64> poison, <128 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 96, i32 112, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 97, i32 113, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 98, i32 114, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 99, i32 115, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 100, i32 116, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 101, i32 117, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 102, i32 118, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 103, i32 119, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 104, i32 120, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 105, i32 121, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 106, i32 122, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 107, i32 123, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 108, i32 124, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 109, i32 125, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 110, i32 126, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95, i32 111, i32 127>
  store <128 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride8_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride8_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1688, %rsp # imm = 0x698
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps 16(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm9
; SSE-NEXT:    movaps 16(%rdx), %xmm10
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps 16(%rcx), %xmm2
; SSE-NEXT:    movaps (%r8), %xmm11
; SSE-NEXT:    movaps 16(%r8), %xmm12
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps 16(%r9), %xmm4
; SSE-NEXT:    movaps (%r10), %xmm13
; SSE-NEXT:    movaps 16(%r10), %xmm14
; SSE-NEXT:    movaps (%rax), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm1[0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm1[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm3[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm5[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm2[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm4[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdx), %xmm2
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r10), %xmm2
; SSE-NEXT:    movaps 32(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r10), %xmm2
; SSE-NEXT:    movaps 48(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r10), %xmm2
; SSE-NEXT:    movaps 64(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r10), %xmm2
; SSE-NEXT:    movaps 80(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps 96(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r10), %xmm2
; SSE-NEXT:    movaps 96(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r8), %xmm2
; SSE-NEXT:    movaps 112(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r10), %xmm2
; SSE-NEXT:    movaps 112(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm2
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r8), %xmm2
; SSE-NEXT:    movaps 128(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r10), %xmm2
; SSE-NEXT:    movaps 128(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm2
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r8), %xmm2
; SSE-NEXT:    movaps 144(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r10), %xmm2
; SSE-NEXT:    movaps 144(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm2
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r8), %xmm2
; SSE-NEXT:    movaps 160(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r10), %xmm2
; SSE-NEXT:    movaps 160(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm2
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm2
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r8), %xmm2
; SSE-NEXT:    movaps 176(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r10), %xmm2
; SSE-NEXT:    movaps 176(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm2
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm2
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r8), %xmm2
; SSE-NEXT:    movaps 192(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r10), %xmm2
; SSE-NEXT:    movaps 192(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdi), %xmm2
; SSE-NEXT:    movaps 208(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdx), %xmm2
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r8), %xmm2
; SSE-NEXT:    movaps 208(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r10), %xmm15
; SSE-NEXT:    movaps 208(%rax), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rdi), %xmm11
; SSE-NEXT:    movaps 224(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm1[1]
; SSE-NEXT:    movaps 224(%rdx), %xmm13
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movaps 224(%r8), %xmm8
; SSE-NEXT:    movaps 224(%r9), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 224(%r10), %xmm9
; SSE-NEXT:    movaps 224(%rax), %xmm0
; SSE-NEXT:    movaps %xmm9, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps 240(%rdi), %xmm6
; SSE-NEXT:    movaps 240(%rsi), %xmm2
; SSE-NEXT:    movaps %xmm6, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm2[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-NEXT:    movaps 240(%rdx), %xmm2
; SSE-NEXT:    movaps 240(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movaps 240(%r8), %xmm1
; SSE-NEXT:    movaps 240(%r9), %xmm3
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    movaps 240(%r10), %xmm3
; SSE-NEXT:    movaps 240(%rax), %xmm5
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm5[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm3, 2032(%rax)
; SSE-NEXT:    movaps %xmm1, 2016(%rax)
; SSE-NEXT:    movaps %xmm2, 2000(%rax)
; SSE-NEXT:    movaps %xmm6, 1984(%rax)
; SSE-NEXT:    movaps %xmm0, 1968(%rax)
; SSE-NEXT:    movaps %xmm4, 1952(%rax)
; SSE-NEXT:    movaps %xmm7, 1936(%rax)
; SSE-NEXT:    movaps %xmm10, 1920(%rax)
; SSE-NEXT:    movaps %xmm9, 1904(%rax)
; SSE-NEXT:    movaps %xmm8, 1888(%rax)
; SSE-NEXT:    movaps %xmm13, 1872(%rax)
; SSE-NEXT:    movaps %xmm11, 1856(%rax)
; SSE-NEXT:    movaps %xmm12, 1840(%rax)
; SSE-NEXT:    movaps %xmm14, 1824(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1808(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1792(%rax)
; SSE-NEXT:    movaps %xmm15, 1776(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1760(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1744(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1712(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1696(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1680(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1664(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1648(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1632(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1600(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1584(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1552(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $1688, %rsp # imm = 0x698
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride8_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $2056, %rsp # imm = 0x808
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm7[1],ymm3[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 16(%r9), %xmm14
; AVX1-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm8
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm8[0],xmm7[0]
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm9, %ymm11
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[0],ymm11[1],ymm9[2],ymm11[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm7, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm13[0],ymm12[0],ymm13[2],ymm12[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],mem[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm9[0],ymm14[0],ymm9[2],ymm14[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],mem[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2],ymm5[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm10[0],ymm8[0],ymm10[2],ymm8[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 80(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 80(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 136(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 136(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 144(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%r9), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 144(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm14[0],ymm0[2],ymm14[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 144(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 160(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rax), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 168(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 168(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%rsi), %xmm15
; AVX1-ONLY-NEXT:    vmovaps 176(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm15[0],ymm0[2],ymm15[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 176(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%r9), %xmm13
; AVX1-ONLY-NEXT:    vmovaps 176(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm13[0],ymm0[2],ymm13[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 176(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rax), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 200(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 200(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vmovaps 208(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm12[0],ymm0[2],ymm12[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 208(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%r9), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 208(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm11[0],ymm0[2],ymm11[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 208(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 224(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rax), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 232(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 232(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 240(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm7[0],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 240(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 240(%r8), %xmm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 240(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm9[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm10[1],xmm8[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 88(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 88(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 152(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm14[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 152(%r10), %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = mem[0,1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 184(%rdx), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 184(%r10), %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2,3],ymm13[4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm12[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 216(%rdx), %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm12[4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = mem[0,1],xmm11[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 216(%r10), %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1,2,3],ymm11[4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm5[1],xmm7[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 248(%rdx), %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm5[0,1,2,3],ymm7[4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 248(%r10), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 2016(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 1984(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1952(%rdx)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1920(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1888(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1856(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1824(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1792(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 1760(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm15, 1728(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1696(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1664(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1632(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1600(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1568(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1536(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm13, 1504(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 1472(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1440(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1408(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1376(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1344(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1312(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 1280(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 1216(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1184(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1120(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1088(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1024(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 992(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 960(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 928(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 896(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 832(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 736(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 704(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 480(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 448(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 224(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 192(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rdx)
; AVX1-ONLY-NEXT:    addq $2056, %rsp # imm = 0x808
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride8_vf32:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $1704, %rsp # imm = 0x6A8
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm6
; AVX2-ONLY-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm7
; AVX2-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 136(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 128(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 136(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 128(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, (%rsp) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 168(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 160(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %xmm13
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 168(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 160(%rax), %xmm12
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %xmm11
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm10[1],xmm11[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 200(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%rcx), %xmm9
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %xmm7
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm8[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 200(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%rax), %xmm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %xmm5
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm5[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 232(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rcx), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%r9), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %xmm1
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 232(%r10), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm0[0,1,2,3],ymm15[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rax), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd (%rsp), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 160(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm13 = xmm13[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 160(%r10), %ymm13, %ymm13
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm12, %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm10[0],xmm11[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm9, %ymm9
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2,3,4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm7[0],xmm8[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%r10), %ymm7, %ymm7
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm6, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 224(%rdx), %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm3, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 224(%r10), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 80(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 80(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 144(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 144(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 152(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 152(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm4[0],ymm1[0],ymm4[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 176(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm2[0],ymm0[0],ymm2[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 176(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm4[1],ymm1[1],ymm4[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 184(%rdx), %ymm3
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 184(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm4[0],ymm2[0],ymm4[2],ymm2[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 208(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 192(%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 208(%rax), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm4[1],ymm2[1],ymm4[3],ymm2[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm4[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %ymm4
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm15[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 240(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %ymm15
; AVX2-ONLY-NEXT:    vmovaps 224(%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm15[0],ymm0[0],ymm15[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm13[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 240(%rax), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm4[1],ymm1[3],ymm4[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm1[2,3],ymm4[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%r10), %ymm4
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3],ymm4[2,3]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 2016(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 1984(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm12, 1952(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm14, 1920(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 1760(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1728(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1696(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1664(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 1504(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 1472(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1440(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1408(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 1248(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 1216(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1184(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1152(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 992(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 960(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 928(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 736(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 704(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 480(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm15, 448(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1888(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1856(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1824(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1792(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1632(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1600(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1568(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1536(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1376(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1344(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1312(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1280(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1120(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1088(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1056(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1024(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-ONLY-NEXT:    addq $1704, %rsp # imm = 0x6A8
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i64_stride8_vf32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    subq $2632, %rsp # imm = 0xA48
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovaps 128(%rdi), %zmm0
; AVX512F-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm6
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512F-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512F-NEXT:    vmovdqa64 64(%rsi), %zmm1
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512F-NEXT:    vmovaps 192(%rdx), %zmm2
; AVX512F-NEXT:    vmovups %zmm2, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovaps 128(%rdx), %zmm2
; AVX512F-NEXT:    vmovups %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %zmm8
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm22
; AVX512F-NEXT:    vmovdqa64 64(%r8), %zmm19
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512F-NEXT:    vmovdqa64 64(%r9), %zmm25
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm18
; AVX512F-NEXT:    vmovdqa64 64(%r10), %zmm17
; AVX512F-NEXT:    vmovdqa64 (%rax), %zmm21
; AVX512F-NEXT:    vmovdqa64 64(%rax), %zmm20
; AVX512F-NEXT:    movb $-64, %r11b
; AVX512F-NEXT:    kmovw %r11d, %k1
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [4,12,4,12,4,12,4,12]
; AVX512F-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm12, %zmm7
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm22[0],zmm29[0],zmm22[2],zmm29[2],zmm22[4],zmm29[4],zmm22[6],zmm29[6]
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm12, %zmm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,4,12>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm11, %zmm10
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm7, %zmm9, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [5,13,5,13,5,13,5,13]
; AVX512F-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm14, %zmm7
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm9 = zmm22[1],zmm29[1],zmm22[3],zmm29[3],zmm22[5],zmm29[5],zmm22[7],zmm29[7]
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm14, %zmm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,5,13>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm13, %zmm10
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm7, %zmm9, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512F-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm15, %zmm7
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k1} = zmm18[0],zmm21[0],zmm18[2],zmm21[2],zmm18[4],zmm21[4],zmm18[6],zmm21[6]
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm15, %zmm9
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,6,14>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm11, %zmm10
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm9, %zmm7, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [7,15,7,15,7,15,7,15]
; AVX512F-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm26, %zmm7
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm7 {%k1} = zmm18[1],zmm21[1],zmm18[3],zmm21[3],zmm18[5],zmm21[5],zmm18[7],zmm21[7]
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm26, %zmm0
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm28 = <u,u,7,15>
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm28, %zmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm7, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm12, %zmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm2 = zmm19[0],zmm25[0],zmm19[2],zmm25[2],zmm19[4],zmm25[4],zmm19[6],zmm25[6]
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm12, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,4,12>
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm4, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm14, %zmm0
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm2 = zmm19[1],zmm25[1],zmm19[3],zmm25[3],zmm19[5],zmm25[5],zmm19[7],zmm25[7]
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm14, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm13, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm15, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm11, %zmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm15, %zmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm2 {%k1} = zmm17[0],zmm20[0],zmm17[2],zmm20[2],zmm17[4],zmm20[4],zmm17[6],zmm20[6]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm26, %zmm6
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm26, %zmm1
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm1 {%k1} = zmm17[1],zmm20[1],zmm17[3],zmm20[3],zmm17[5],zmm20[5],zmm17[7],zmm20[7]
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm28, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm4, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm7, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm11, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm28, %zmm13
; AVX512F-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm13, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm13, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm13, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm28, %zmm13
; AVX512F-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm12, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm14, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm15, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm26, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 128(%r10), %zmm28
; AVX512F-NEXT:    vmovdqa64 128(%rax), %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm12, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm14, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 128(%r8), %zmm16
; AVX512F-NEXT:    vmovdqa64 128(%r9), %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm15, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512F-NEXT:    vmovdqa64 192(%r10), %zmm23
; AVX512F-NEXT:    vmovdqa64 192(%rax), %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm12, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %zmm2
; AVX512F-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm2, %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm14, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm2, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 192(%r8), %zmm31
; AVX512F-NEXT:    vmovdqa64 192(%r9), %zmm3
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm15, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm2, %zmm15
; AVX512F-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm26, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm27
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm26, %zmm27
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm26, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [0,8,0,8,0,8,0,8]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm30
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm5, %zmm30
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [1,9,1,9,1,9,1,9]
; AVX512F-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [2,10,2,10,2,10,2,10]
; AVX512F-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm26, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm0, %zmm18
; AVX512F-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm24
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm5, %zmm24
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm6, %zmm22
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm21
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm26, %zmm21
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm29
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm5, %zmm29
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm26, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm0, %zmm17
; AVX512F-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm6, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm20
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm26, %zmm20
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm0, %zmm19
; AVX512F-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm19
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm5, %zmm19
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm25
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm6, %zmm25
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 {%k1} = zmm28[0],zmm4[0],zmm28[2],zmm4[2],zmm28[4],zmm4[4],zmm28[6],zmm4[6]
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm27 {%k1} = zmm28[1],zmm4[1],zmm28[3],zmm4[3],zmm28[5],zmm4[5],zmm28[7],zmm4[7]
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm26, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm0, %zmm28
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm5, %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm6, %zmm15
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm12
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm26, %zmm12
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm14 = zmm16[0],zmm13[0],zmm16[2],zmm13[2],zmm16[4],zmm13[4],zmm16[6],zmm13[6]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm17 = zmm16[1],zmm13[1],zmm16[3],zmm13[3],zmm16[5],zmm13[5],zmm16[7],zmm13[7]
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm0, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm5, %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm18
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm6, %zmm18
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm10 {%k1} = zmm23[0],zmm1[0],zmm23[2],zmm1[2],zmm23[4],zmm1[4],zmm23[6],zmm1[6]
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm23[1],zmm1[1],zmm23[3],zmm1[3],zmm23[5],zmm1[5],zmm23[7],zmm1[7]
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm26, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm23
; AVX512F-NEXT:    vpermi2q %zmm3, %zmm31, %zmm5
; AVX512F-NEXT:    vpermi2q %zmm3, %zmm31, %zmm6
; AVX512F-NEXT:    vpermi2q %zmm3, %zmm31, %zmm26
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm10 = zmm31[0],zmm3[0],zmm31[2],zmm3[2],zmm31[4],zmm3[4],zmm31[6],zmm3[6]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm11 = zmm31[1],zmm3[1],zmm31[3],zmm3[3],zmm31[5],zmm3[5],zmm31[7],zmm3[7]
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm31
; AVX512F-NEXT:    vmovdqa64 %zmm30, %zmm24 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm30 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm4, %ymm30, %ymm4
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm24, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm22 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm22, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512F-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %xmm29
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm22 = xmm29[0],xmm4[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm2, %ymm22, %ymm2
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm7, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm29[1],xmm4[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm8, %zmm30
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9 {%k1}
; AVX512F-NEXT:    vmovdqa 128(%rcx), %xmm1
; AVX512F-NEXT:    vmovdqa 128(%rdx), %xmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vmovdqa 128(%rsi), %xmm7
; AVX512F-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm19 = xmm8[0],xmm7[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm4, %ymm19, %ymm4
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm9, %zmm29
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm15 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm8[1],xmm7[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm15, %zmm24
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm2 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm14, %zmm22
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm7 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm7, %zmm17, %zmm7
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm8 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm8 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm8, %zmm0, %zmm8
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm9 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm9, %zmm27, %zmm27
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm5 {%k1}
; AVX512F-NEXT:    vmovdqa 192(%rcx), %xmm13
; AVX512F-NEXT:    vmovdqa 192(%rdx), %xmm14
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm14[0],xmm13[0]
; AVX512F-NEXT:    vmovdqa64 192(%rsi), %xmm17
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %xmm19
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm25 = xmm19[0],xmm17[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm15, %ymm25, %ymm15
; AVX512F-NEXT:    vinserti64x4 $0, %ymm15, %zmm5, %zmm25
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm6 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm14[1],xmm13[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm14 = xmm19[1],xmm17[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512F-NEXT:    vinserti64x4 $0, %ymm13, %zmm6, %zmm6
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm13 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm13, %zmm10, %zmm10
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm13 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm13, %zmm11, %zmm11
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm13 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm13, %zmm0, %zmm13
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, (%rsp), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm14 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm14, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %ymm15
; AVX512F-NEXT:    vmovdqa64 (%rdx), %ymm17
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm17[0],ymm15[0],ymm17[2],ymm15[2]
; AVX512F-NEXT:    vmovdqa64 (%rsi), %ymm18
; AVX512F-NEXT:    vmovdqa64 (%rdi), %ymm19
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm19[0],ymm18[0],ymm19[2],ymm18[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm21, %zmm21
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm17[1],ymm15[1],ymm17[3],ymm15[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm15 = ymm19[1],ymm18[1],ymm19[3],ymm18[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm15[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm1, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512F-NEXT:    vmovdqa 64(%rsi), %ymm15
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %ymm17
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %ymm18
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %ymm19
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm19[0],ymm18[0],ymm19[2],ymm18[2]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm17[0],ymm15[0],ymm17[2],ymm15[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm4[2,3],ymm9[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm20, %zmm4
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm9 = ymm19[1],ymm18[1],ymm19[3],ymm18[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm15 = ymm17[1],ymm15[1],ymm17[3],ymm15[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm15[2,3],ymm9[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm9, %zmm1, %zmm9
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512F-NEXT:    vmovdqa 128(%rcx), %ymm15
; AVX512F-NEXT:    vmovdqa64 128(%rdx), %ymm17
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm17[0],ymm15[0],ymm17[2],ymm15[2]
; AVX512F-NEXT:    vmovdqa64 128(%rsi), %ymm18
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %ymm19
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm19[0],ymm18[0],ymm19[2],ymm18[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm1[2,3],ymm5[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm12, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm16 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm5 = ymm17[1],ymm15[1],ymm17[3],ymm15[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm19[1],ymm18[1],ymm19[3],ymm18[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm12[2,3],ymm5[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm16, %zmm5
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512F-NEXT:    vmovdqa 192(%rcx), %ymm12
; AVX512F-NEXT:    vmovdqa 192(%rdx), %ymm15
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm15[0],ymm12[0],ymm15[2],ymm12[2]
; AVX512F-NEXT:    vmovdqa64 192(%rsi), %ymm16
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %ymm17
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm17[0],ymm16[0],ymm17[2],ymm16[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm2[2,3],ymm0[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm31 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm15[1],ymm12[1],ymm15[3],ymm12[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm17[1],ymm16[1],ymm17[3],ymm16[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm12[2,3],ymm2[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm31, %zmm2
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovdqa64 %zmm2, 1728(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm0, 1664(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 1216(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm1, 1152(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 640(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm3, 192(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm21, 128(%rax)
; AVX512F-NEXT:    vmovaps %zmm14, 1984(%rax)
; AVX512F-NEXT:    vmovaps %zmm13, 1920(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm11, 1856(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 1792(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 1600(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm25, 1536(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm27, 1472(%rax)
; AVX512F-NEXT:    vmovaps %zmm8, 1408(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 1344(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm22, 1280(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm24, 1088(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm29, 1024(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 768(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm30, 576(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, (%rax)
; AVX512F-NEXT:    addq $2632, %rsp # imm = 0xA48
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride8_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $2632, %rsp # imm = 0xA48
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovaps 128(%rdi), %zmm0
; AVX512BW-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-NEXT:    vmovaps 192(%rdx), %zmm2
; AVX512BW-NEXT:    vmovups %zmm2, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovaps 128(%rdx), %zmm2
; AVX512BW-NEXT:    vmovups %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm8
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm22
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm19
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm25
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm18
; AVX512BW-NEXT:    vmovdqa64 64(%r10), %zmm17
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm21
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm20
; AVX512BW-NEXT:    movb $-64, %r11b
; AVX512BW-NEXT:    kmovd %r11d, %k1
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [4,12,4,12,4,12,4,12]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm12, %zmm7
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm22[0],zmm29[0],zmm22[2],zmm29[2],zmm22[4],zmm29[4],zmm22[6],zmm29[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm12, %zmm7
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,4,12>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm11, %zmm10
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm7, %zmm9, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [5,13,5,13,5,13,5,13]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm14, %zmm7
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm9 = zmm22[1],zmm29[1],zmm22[3],zmm29[3],zmm22[5],zmm29[5],zmm22[7],zmm29[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm14, %zmm7
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm13 = <u,u,5,13>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm13, %zmm10
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm7, %zmm9, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm15, %zmm7
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k1} = zmm18[0],zmm21[0],zmm18[2],zmm21[2],zmm18[4],zmm21[4],zmm18[6],zmm21[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm9
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm11 = <u,u,6,14>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm11, %zmm10
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm9, %zmm7, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm26, %zmm7
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm7 {%k1} = zmm18[1],zmm21[1],zmm18[3],zmm21[3],zmm18[5],zmm21[5],zmm18[7],zmm21[7]
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm28 = <u,u,7,15>
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm28, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm12, %zmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm2 = zmm19[0],zmm25[0],zmm19[2],zmm25[2],zmm19[4],zmm25[4],zmm19[6],zmm25[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm12, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,u,4,12>
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm4, %zmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm14, %zmm0
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm2 = zmm19[1],zmm25[1],zmm19[3],zmm25[3],zmm19[5],zmm25[5],zmm19[7],zmm25[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm13, %zmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm11, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm15, %zmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm2 {%k1} = zmm17[0],zmm20[0],zmm17[2],zmm20[2],zmm17[4],zmm20[4],zmm17[6],zmm20[6]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm26, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm26, %zmm1
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm1 {%k1} = zmm17[1],zmm20[1],zmm17[3],zmm20[3],zmm17[5],zmm20[5],zmm17[7],zmm20[7]
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm28, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm4, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm11, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm28, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm13 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm13, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm13, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm13, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm28, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm26, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%r10), %zmm28
; AVX512BW-NEXT:    vmovdqa64 128(%rax), %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm12, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm16
; AVX512BW-NEXT:    vmovdqa64 128(%r9), %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-NEXT:    vmovdqa64 192(%r10), %zmm23
; AVX512BW-NEXT:    vmovdqa64 192(%rax), %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm12, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm14, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm2, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%r8), %zmm31
; AVX512BW-NEXT:    vmovdqa64 192(%r9), %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm2, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm26, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [0,8,0,8,0,8,0,8]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm5, %zmm30
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [1,9,1,9,1,9,1,9]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm26, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm0, %zmm18
; AVX512BW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm5, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm26, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm5, %zmm29
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm26, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm0, %zmm17
; AVX512BW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm6, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm26, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm0, %zmm19
; AVX512BW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm25
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 {%k1} = zmm28[0],zmm4[0],zmm28[2],zmm4[2],zmm28[4],zmm4[4],zmm28[6],zmm4[6]
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm27 {%k1} = zmm28[1],zmm4[1],zmm28[3],zmm4[3],zmm28[5],zmm4[5],zmm28[7],zmm4[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm26, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm28
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm5, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm6, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm26, %zmm12
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm14 = zmm16[0],zmm13[0],zmm16[2],zmm13[2],zmm16[4],zmm13[4],zmm16[6],zmm13[6]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm17 = zmm16[1],zmm13[1],zmm16[3],zmm13[3],zmm16[5],zmm13[5],zmm16[7],zmm13[7]
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm18
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm10 {%k1} = zmm23[0],zmm1[0],zmm23[2],zmm1[2],zmm23[4],zmm1[4],zmm23[6],zmm1[6]
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm23[1],zmm1[1],zmm23[3],zmm1[3],zmm23[5],zmm1[5],zmm23[7],zmm1[7]
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm26, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm23
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm31, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm31, %zmm6
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm31, %zmm26
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm10 = zmm31[0],zmm3[0],zmm31[2],zmm3[2],zmm31[4],zmm3[4],zmm31[6],zmm3[6]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm11 = zmm31[1],zmm3[1],zmm31[3],zmm3[3],zmm31[5],zmm3[5],zmm31[7],zmm3[7]
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm24 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm3
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm2[0],xmm3[0]
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm30 = xmm0[0],xmm1[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm4, %ymm30, %ymm4
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm24, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm22 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm22, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rcx), %xmm0
; AVX512BW-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX512BW-NEXT:    vmovdqa 64(%rsi), %xmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %xmm29
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm22 = xmm29[0],xmm4[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm2, %ymm22, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm7, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm29[1],xmm4[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm8, %zmm30
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa 128(%rcx), %xmm1
; AVX512BW-NEXT:    vmovdqa 128(%rdx), %xmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm2[0],xmm1[0]
; AVX512BW-NEXT:    vmovdqa 128(%rsi), %xmm7
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm19 = xmm8[0],xmm7[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm4, %ymm19, %ymm4
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm9, %zmm29
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm15 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm8[1],xmm7[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm15, %zmm24
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm2 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm14, %zmm22
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm7 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm7, %zmm17, %zmm7
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm8 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm8 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm8, %zmm0, %zmm8
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm9 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm9, %zmm27, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqa 192(%rcx), %xmm13
; AVX512BW-NEXT:    vmovdqa 192(%rdx), %xmm14
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm14[0],xmm13[0]
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %xmm17
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %xmm19
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm25 = xmm19[0],xmm17[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm15, %ymm25, %ymm15
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm15, %zmm5, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm6 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm13 = xmm14[1],xmm13[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm14 = xmm19[1],xmm17[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm13, %ymm14, %ymm13
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm13, %zmm6, %zmm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm13 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm13, %zmm10, %zmm10
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm13 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm13, %zmm11, %zmm11
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm13 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm13 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm13, %zmm0, %zmm13
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, (%rsp), %ymm0, %ymm14 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm14 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm14, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm15
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %ymm17
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm17[0],ymm15[0],ymm17[2],ymm15[2]
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %ymm18
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %ymm19
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm19[0],ymm18[0],ymm19[2],ymm18[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm21, %zmm21
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm17[1],ymm15[1],ymm17[3],ymm15[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm15 = ymm19[1],ymm18[1],ymm19[3],ymm18[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm15[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rsi), %ymm15
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %ymm17
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %ymm18
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %ymm19
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm19[0],ymm18[0],ymm19[2],ymm18[2]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm17[0],ymm15[0],ymm17[2],ymm15[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm4[2,3],ymm9[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm20, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm9 = ymm19[1],ymm18[1],ymm19[3],ymm18[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm15 = ymm17[1],ymm15[1],ymm17[3],ymm15[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm15[2,3],ymm9[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm9, %zmm1, %zmm9
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k1}
; AVX512BW-NEXT:    vmovdqa 128(%rcx), %ymm15
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %ymm17
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm17[0],ymm15[0],ymm17[2],ymm15[2]
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %ymm18
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %ymm19
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm19[0],ymm18[0],ymm19[2],ymm18[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm1[2,3],ymm5[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm16 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm5 = ymm17[1],ymm15[1],ymm17[3],ymm15[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm19[1],ymm18[1],ymm19[3],ymm18[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm12[2,3],ymm5[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm16, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k1}
; AVX512BW-NEXT:    vmovdqa 192(%rcx), %ymm12
; AVX512BW-NEXT:    vmovdqa 192(%rdx), %ymm15
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm15[0],ymm12[0],ymm15[2],ymm12[2]
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %ymm16
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %ymm17
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm17[0],ymm16[0],ymm17[2],ymm16[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm2[2,3],ymm0[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm31 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm15[1],ymm12[1],ymm15[3],ymm12[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm12 = ymm17[1],ymm16[1],ymm17[3],ymm16[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm12[2,3],ymm2[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm31, %zmm2
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 1728(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 1664(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 1216(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 1152(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 128(%rax)
; AVX512BW-NEXT:    vmovaps %zmm14, 1984(%rax)
; AVX512BW-NEXT:    vmovaps %zmm13, 1920(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 1856(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 1792(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 1600(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 1536(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 1472(%rax)
; AVX512BW-NEXT:    vmovaps %zmm8, 1408(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 1344(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 1280(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 1088(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 1024(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 576(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, (%rax)
; AVX512BW-NEXT:    addq $2632, %rsp # imm = 0xA48
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <32 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <32 x i64>, ptr %in.vecptr6, align 64
  %in.vec7 = load <32 x i64>, ptr %in.vecptr7, align 64
  %1 = shufflevector <32 x i64> %in.vec0, <32 x i64> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i64> %in.vec2, <32 x i64> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i64> %in.vec4, <32 x i64> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <32 x i64> %in.vec6, <32 x i64> %in.vec7, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <64 x i64> %1, <64 x i64> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %6 = shufflevector <64 x i64> %3, <64 x i64> %4, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %7 = shufflevector <128 x i64> %5, <128 x i64> %6, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %interleaved.vec = shufflevector <256 x i64> %7, <256 x i64> poison, <256 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 224, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 225, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 226, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 227, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 228, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 229, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 230, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 231, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 232, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 233, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 234, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 235, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 236, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 237, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 238, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 239, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 240, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 241, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 242, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 243, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 244, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 245, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 246, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 247, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 248, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 249, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 250, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 251, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 252, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 253, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 254, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223, i32 255>
  store <256 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride8_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride8_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $3736, %rsp # imm = 0xE98
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps 16(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm9
; SSE-NEXT:    movaps 16(%rdx), %xmm10
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps 16(%rcx), %xmm2
; SSE-NEXT:    movaps 16(%r8), %xmm12
; SSE-NEXT:    movaps (%r8), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm4
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps 16(%r10), %xmm14
; SSE-NEXT:    movaps (%r10), %xmm13
; SSE-NEXT:    movaps (%rax), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm1[0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm1[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm3[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm5[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm2[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm4[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdx), %xmm2
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r10), %xmm2
; SSE-NEXT:    movaps 32(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r10), %xmm2
; SSE-NEXT:    movaps 48(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r10), %xmm2
; SSE-NEXT:    movaps 64(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r10), %xmm2
; SSE-NEXT:    movaps 80(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps 96(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r10), %xmm2
; SSE-NEXT:    movaps 96(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r8), %xmm2
; SSE-NEXT:    movaps 112(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r10), %xmm2
; SSE-NEXT:    movaps 112(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm2
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r8), %xmm2
; SSE-NEXT:    movaps 128(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r10), %xmm2
; SSE-NEXT:    movaps 128(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm2
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r8), %xmm2
; SSE-NEXT:    movaps 144(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r10), %xmm2
; SSE-NEXT:    movaps 144(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm2
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r8), %xmm2
; SSE-NEXT:    movaps 160(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r10), %xmm2
; SSE-NEXT:    movaps 160(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm2
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm2
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r8), %xmm2
; SSE-NEXT:    movaps 176(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r10), %xmm2
; SSE-NEXT:    movaps 176(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm2
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm2
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r8), %xmm2
; SSE-NEXT:    movaps 192(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r10), %xmm2
; SSE-NEXT:    movaps 192(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdi), %xmm2
; SSE-NEXT:    movaps 208(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdx), %xmm2
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r8), %xmm2
; SSE-NEXT:    movaps 208(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r10), %xmm2
; SSE-NEXT:    movaps 208(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdi), %xmm2
; SSE-NEXT:    movaps 224(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdx), %xmm2
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%r8), %xmm2
; SSE-NEXT:    movaps 224(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%r10), %xmm2
; SSE-NEXT:    movaps 224(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%rdi), %xmm2
; SSE-NEXT:    movaps 240(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%rdx), %xmm2
; SSE-NEXT:    movaps 240(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%r8), %xmm2
; SSE-NEXT:    movaps 240(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%r10), %xmm2
; SSE-NEXT:    movaps 240(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdi), %xmm2
; SSE-NEXT:    movaps 256(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdx), %xmm2
; SSE-NEXT:    movaps 256(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%r8), %xmm2
; SSE-NEXT:    movaps 256(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%r10), %xmm2
; SSE-NEXT:    movaps 256(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%rdi), %xmm2
; SSE-NEXT:    movaps 272(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%rdx), %xmm2
; SSE-NEXT:    movaps 272(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%r8), %xmm2
; SSE-NEXT:    movaps 272(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%r10), %xmm2
; SSE-NEXT:    movaps 272(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%rdi), %xmm2
; SSE-NEXT:    movaps 288(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%rdx), %xmm2
; SSE-NEXT:    movaps 288(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%r8), %xmm2
; SSE-NEXT:    movaps 288(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%r10), %xmm2
; SSE-NEXT:    movaps 288(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%rdi), %xmm2
; SSE-NEXT:    movaps 304(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%rdx), %xmm2
; SSE-NEXT:    movaps 304(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%r8), %xmm2
; SSE-NEXT:    movaps 304(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%r10), %xmm2
; SSE-NEXT:    movaps 304(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%rdi), %xmm2
; SSE-NEXT:    movaps 320(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%rdx), %xmm2
; SSE-NEXT:    movaps 320(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%r8), %xmm2
; SSE-NEXT:    movaps 320(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%r10), %xmm2
; SSE-NEXT:    movaps 320(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%rdi), %xmm2
; SSE-NEXT:    movaps 336(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%rdx), %xmm2
; SSE-NEXT:    movaps 336(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%r8), %xmm2
; SSE-NEXT:    movaps 336(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%r10), %xmm2
; SSE-NEXT:    movaps 336(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%rdi), %xmm2
; SSE-NEXT:    movaps 352(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%rdx), %xmm2
; SSE-NEXT:    movaps 352(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%r8), %xmm2
; SSE-NEXT:    movaps 352(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%r10), %xmm2
; SSE-NEXT:    movaps 352(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdi), %xmm2
; SSE-NEXT:    movaps 368(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdx), %xmm2
; SSE-NEXT:    movaps 368(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%r8), %xmm2
; SSE-NEXT:    movaps 368(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%r10), %xmm2
; SSE-NEXT:    movaps 368(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%rdi), %xmm2
; SSE-NEXT:    movaps 384(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%rdx), %xmm2
; SSE-NEXT:    movaps 384(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%r8), %xmm2
; SSE-NEXT:    movaps 384(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%r10), %xmm2
; SSE-NEXT:    movaps 384(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%rdi), %xmm2
; SSE-NEXT:    movaps 400(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%rdx), %xmm2
; SSE-NEXT:    movaps 400(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%r8), %xmm2
; SSE-NEXT:    movaps 400(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%r10), %xmm2
; SSE-NEXT:    movaps 400(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%rdi), %xmm2
; SSE-NEXT:    movaps 416(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%rdx), %xmm2
; SSE-NEXT:    movaps 416(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%r8), %xmm2
; SSE-NEXT:    movaps 416(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%r10), %xmm2
; SSE-NEXT:    movaps 416(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%rdi), %xmm2
; SSE-NEXT:    movaps 432(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%rdx), %xmm2
; SSE-NEXT:    movaps 432(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%r8), %xmm2
; SSE-NEXT:    movaps 432(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%r10), %xmm2
; SSE-NEXT:    movaps 432(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%rdi), %xmm2
; SSE-NEXT:    movaps 448(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%rdx), %xmm2
; SSE-NEXT:    movaps 448(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%r8), %xmm2
; SSE-NEXT:    movaps 448(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%r10), %xmm2
; SSE-NEXT:    movaps 448(%rax), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 464(%rdi), %xmm2
; SSE-NEXT:    movaps 464(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 464(%rdx), %xmm2
; SSE-NEXT:    movaps 464(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 464(%r8), %xmm2
; SSE-NEXT:    movaps 464(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 464(%r10), %xmm15
; SSE-NEXT:    movaps 464(%rax), %xmm1
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm1[1]
; SSE-NEXT:    movaps 480(%rdi), %xmm11
; SSE-NEXT:    movaps 480(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm1[1]
; SSE-NEXT:    movaps 480(%rdx), %xmm13
; SSE-NEXT:    movaps 480(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movaps 480(%r8), %xmm10
; SSE-NEXT:    movaps 480(%r9), %xmm0
; SSE-NEXT:    movaps %xmm10, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps 480(%r10), %xmm9
; SSE-NEXT:    movaps 480(%rax), %xmm0
; SSE-NEXT:    movaps %xmm9, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps 496(%rdi), %xmm6
; SSE-NEXT:    movaps 496(%rsi), %xmm2
; SSE-NEXT:    movaps %xmm6, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm2[1]
; SSE-NEXT:    movaps 496(%rdx), %xmm2
; SSE-NEXT:    movaps 496(%rcx), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movaps 496(%r8), %xmm1
; SSE-NEXT:    movaps 496(%r9), %xmm3
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; SSE-NEXT:    movaps 496(%r10), %xmm3
; SSE-NEXT:    movaps 496(%rax), %xmm5
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm5[1]
; SSE-NEXT:    movaps %xmm3, 4080(%rcx)
; SSE-NEXT:    movaps %xmm1, 4064(%rcx)
; SSE-NEXT:    movaps %xmm2, 4048(%rcx)
; SSE-NEXT:    movaps %xmm6, 4032(%rcx)
; SSE-NEXT:    movaps %xmm0, 4016(%rcx)
; SSE-NEXT:    movaps %xmm4, 4000(%rcx)
; SSE-NEXT:    movaps %xmm7, 3984(%rcx)
; SSE-NEXT:    movaps %xmm8, 3968(%rcx)
; SSE-NEXT:    movaps %xmm9, 3952(%rcx)
; SSE-NEXT:    movaps %xmm10, 3936(%rcx)
; SSE-NEXT:    movaps %xmm13, 3920(%rcx)
; SSE-NEXT:    movaps %xmm11, 3904(%rcx)
; SSE-NEXT:    movaps %xmm12, 3888(%rcx)
; SSE-NEXT:    movaps %xmm14, 3872(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3856(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3840(%rcx)
; SSE-NEXT:    movaps %xmm15, 3824(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3808(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3792(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3776(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3760(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3744(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3728(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3712(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3696(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3680(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3664(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3648(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3632(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3616(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3600(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3584(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3568(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3552(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3536(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3520(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3504(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3488(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3472(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3456(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3440(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3424(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3408(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3392(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3376(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3360(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3344(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3328(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3312(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3296(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3280(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3264(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3248(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3232(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3216(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3200(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3184(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3168(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3152(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3136(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3120(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3104(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3088(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3072(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3056(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3040(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3024(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3008(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2992(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2976(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2960(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2944(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2928(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2912(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2896(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2880(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2864(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2848(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2832(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2816(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2800(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2784(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2768(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2752(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2736(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2720(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2704(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2688(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2672(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2656(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2640(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2624(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2608(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2592(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2576(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2560(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2544(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2528(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2512(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2496(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2480(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2096(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2080(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2064(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2048(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2032(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2016(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2000(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1984(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1968(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1952(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1936(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1920(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1904(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1888(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1872(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1856(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1840(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1824(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1808(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1792(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1776(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1760(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1744(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1712(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1696(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1680(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1664(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1648(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1632(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1600(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1584(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1552(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    addq $3736, %rsp # imm = 0xE98
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride8_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $4712, %rsp # imm = 0x1268
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm10
; AVX1-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm6[1],ymm4[2],ymm6[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm6
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm4[0]
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm7, %ymm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0],ymm9[1],ymm7[2],ymm9[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm4, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm6[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm11[0],ymm10[0],ymm11[2],ymm10[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],mem[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm4[0],ymm3[0],ymm4[2],ymm3[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],mem[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2],ymm5[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm3
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 64(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 80(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 80(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 128(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 136(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 136(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 144(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 144(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 168(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 168(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 176(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 176(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 192(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 200(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 200(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 208(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 208(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 232(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 232(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 240(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 240(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 256(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 256(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 256(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 256(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 256(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 264(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 264(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 272(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 272(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 272(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 272(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 272(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 272(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 288(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 288(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 288(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 288(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 288(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 296(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 296(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 304(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 304(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 304(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 304(%r9), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 304(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm11[0],ymm0[2],ymm11[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 304(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 320(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 320(%rdx), %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 320(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 320(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 320(%r10), %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 328(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 328(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 336(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 336(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 336(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 336(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 336(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 336(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 352(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 352(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 352(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 352(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 352(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 352(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 360(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 360(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 368(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 368(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 368(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 368(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 368(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 368(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 384(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 384(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 384(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 384(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 392(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 392(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 400(%rsi), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 400(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm14[0],ymm0[2],ymm14[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 400(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 400(%r9), %xmm12
; AVX1-ONLY-NEXT:    vmovaps 400(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm12[0],ymm0[2],ymm12[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 400(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 416(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 416(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 416(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 416(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 416(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 416(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 416(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 416(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 424(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 424(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 432(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 432(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm9[0],ymm0[2],ymm9[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 432(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 432(%r9), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 432(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm8[0],ymm0[2],ymm8[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 432(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 448(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 448(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 448(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 448(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 448(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 448(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 448(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 448(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 456(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 456(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 464(%rsi), %xmm15
; AVX1-ONLY-NEXT:    vmovaps 464(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm15[0],ymm0[2],ymm15[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 464(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 464(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 464(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 464(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 480(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 480(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 480(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 480(%rdx), %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 480(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 480(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 480(%r8), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, 480(%r10), %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 488(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 488(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 496(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 496(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm7[0],ymm0[2],ymm7[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 496(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 496(%r9), %xmm10
; AVX1-ONLY-NEXT:    vmovaps 496(%r8), %xmm13
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm10[0],ymm13[2],ymm10[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vbroadcastsd 496(%rax), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 88(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 88(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 152(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 152(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 184(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 184(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 216(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 216(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 248(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 248(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 280(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 280(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 312(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm11[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 312(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 344(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 344(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 376(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 376(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm14[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 408(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm12[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 408(%r10), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm9[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 440(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 440(%r10), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0,1,2,3],ymm2[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = mem[0,1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 472(%rdx), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm2[0,1,2,3],ymm15[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = mem[0,1],xmm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 472(%r10), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm15[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovlps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = mem[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 504(%rdx), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm15[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm13[1],xmm10[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 504(%r10), %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm13[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 4064(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 4032(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 4000(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3968(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3936(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3904(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3872(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3840(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 3808(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 3776(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3744(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3712(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3680(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3648(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3616(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3584(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 3552(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 3520(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3488(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3456(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3424(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3392(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3360(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3328(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 3296(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 3264(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3232(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3200(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3168(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3136(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3104(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3072(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 3040(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 3008(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2976(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2944(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2912(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2880(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2848(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2816(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 2784(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 2752(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2720(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2688(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2656(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2624(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2592(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2560(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 2528(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 2496(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2464(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2432(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2400(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2368(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2336(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2304(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm13, 2272(%rdx)
; AVX1-ONLY-NEXT:    vmovaps %ymm15, 2240(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2208(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2176(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2144(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2112(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2080(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2048(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2016(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1984(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1952(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1920(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1888(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1856(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1824(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1792(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1760(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1728(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1696(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1664(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1632(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1600(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1568(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1536(%rdx)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1504(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1472(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1440(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1408(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1376(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1344(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1312(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1280(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1216(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1184(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1120(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1088(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1024(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 928(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 896(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 832(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 736(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rdx)
; AVX1-ONLY-NEXT:    addq $4712, %rsp # imm = 0x1268
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride8_vf64:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $3912, %rsp # imm = 0xF48
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%r10), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 136(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 128(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 136(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 128(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 168(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 160(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 168(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 160(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 200(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 200(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 232(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 232(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 264(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 256(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 264(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 256(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 296(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 288(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 296(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 288(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 328(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 320(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%r9), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%r8), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 328(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 320(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 360(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 352(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 360(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 352(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 392(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 384(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 392(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 384(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%rsi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 424(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 416(%rcx), %xmm13
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%r8), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 424(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 416(%rax), %xmm12
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%rsi), %xmm11
; AVX2-ONLY-NEXT:    vmovaps 448(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm10[1],xmm11[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 456(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 448(%rcx), %xmm7
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%r9), %xmm9
; AVX2-ONLY-NEXT:    vmovaps 448(%r8), %xmm8
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm8[1],xmm9[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 456(%r10), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 448(%rax), %xmm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%rsi), %xmm5
; AVX2-ONLY-NEXT:    vmovaps 480(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm5[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 488(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 480(%rcx), %xmm1
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%r9), %xmm3
; AVX2-ONLY-NEXT:    vmovaps 480(%r8), %xmm2
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm2[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 488(%r10), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm0[0,1,2,3],ymm15[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 480(%rax), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 32(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 160(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 160(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 224(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 224(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 256(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 256(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsp), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 288(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 288(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 320(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 320(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 352(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 352(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 384(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 384(%r10), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 416(%rdx), %ymm14, %ymm14
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm13, %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm13 = xmm13[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 416(%r10), %ymm13, %ymm13
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm12, %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm10[0],xmm11[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 448(%rdx), %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm7, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm8[0],xmm9[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 448(%r10), %ymm7, %ymm7
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm6, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 480(%rdx), %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm3[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 480(%r10), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 16(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 48(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 80(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 80(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 144(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 144(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 152(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 152(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 176(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 176(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 184(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 184(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 208(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 192(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 208(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 240(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 224(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 240(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 272(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 256(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 272(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 280(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 280(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 304(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 288(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 304(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 312(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 312(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 336(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 320(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 336(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 344(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 344(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 368(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 352(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 368(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 376(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 376(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 384(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 400(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 384(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 400(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 408(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 408(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 416(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 432(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 416(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 432(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 440(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 440(%r10), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 448(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 464(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 448(%r9), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 464(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 472(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 472(%r10), %ymm2
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm2[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 480(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 496(%rcx), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovaps 480(%r9), %ymm6
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm3[0],ymm6[0],ymm3[2],ymm6[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 496(%rax), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 504(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm1[2,3],ymm2[2,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm6[1],ymm3[3],ymm6[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 504(%r10), %ymm2
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm1[2,3],ymm2[2,3]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 4064(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 4032(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 4000(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 3968(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3808(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 3776(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3744(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3712(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 3552(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 3520(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3488(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3456(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 3296(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 3264(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3232(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3200(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 3040(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 3008(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2976(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2944(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 2784(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 2752(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2720(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2688(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 2528(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm12, 2496(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2464(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2432(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm14, 2272(%rdx)
; AVX2-ONLY-NEXT:    vmovaps %ymm15, 2240(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2208(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2176(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2016(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1984(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1952(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1920(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1760(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1728(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1696(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1664(%rdx)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1504(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1472(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1440(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1408(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1248(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1216(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1184(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1152(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 960(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 928(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 736(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 704(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3936(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3904(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3872(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3840(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3680(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3648(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3616(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3584(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3424(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3392(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3360(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3328(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3168(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3136(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3104(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3072(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2912(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2880(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2848(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2816(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2656(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2624(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2592(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2560(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2400(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2368(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2336(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2304(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2144(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2112(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2080(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2048(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1888(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1856(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1824(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1792(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1632(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1600(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1568(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1536(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1376(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1344(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1312(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1280(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1120(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1088(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1056(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1024(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-ONLY-NEXT:    addq $3912, %rsp # imm = 0xF48
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i64_stride8_vf64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    subq $5384, %rsp # imm = 0x1508
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm8
; AVX512F-NEXT:    vmovdqa64 128(%rsi), %zmm16
; AVX512F-NEXT:    vmovdqa64 64(%rsi), %zmm17
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %zmm6
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm9
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm11
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512F-NEXT:    vmovdqa64 64(%r8), %zmm24
; AVX512F-NEXT:    vmovdqa64 128(%r8), %zmm20
; AVX512F-NEXT:    vmovdqa64 64(%r9), %zmm25
; AVX512F-NEXT:    vmovdqa64 128(%r9), %zmm22
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm18
; AVX512F-NEXT:    vmovdqa64 64(%r10), %zmm23
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm21
; AVX512F-NEXT:    vmovdqa64 64(%rax), %zmm26
; AVX512F-NEXT:    vmovdqa64 (%rax), %zmm19
; AVX512F-NEXT:    movb $-64, %r11b
; AVX512F-NEXT:    kmovw %r11d, %k1
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [4,12,4,12,4,12,4,12]
; AVX512F-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm14, %zmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm10 = zmm2[0],zmm18[0],zmm2[2],zmm18[2],zmm2[4],zmm18[4],zmm2[6],zmm18[6]
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm14, %zmm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,4,12>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm15, %zmm13
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm10, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [5,13,5,13,5,13,5,13]
; AVX512F-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm12, %zmm0
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm10 = zmm2[1],zmm18[1],zmm2[3],zmm18[3],zmm2[5],zmm18[5],zmm2[7],zmm18[7]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm12, %zmm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,5,13>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm2, %zmm13
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm10, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [6,14,6,14,6,14,6,14]
; AVX512F-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm27
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm13, %zmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k1} = zmm21[0],zmm19[0],zmm21[2],zmm19[2],zmm21[4],zmm19[4],zmm21[6],zmm19[6]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm13, %zmm10
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,6,14>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm5, %zmm13
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm13[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm10, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [7,15,7,15,7,15,7,15]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm0, %zmm10
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm10 {%k1} = zmm21[1],zmm19[1],zmm21[3],zmm19[3],zmm21[5],zmm19[5],zmm21[7],zmm19[7]
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm8
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm27 = <u,u,7,15>
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm27, %zmm9
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm10, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm14, %zmm8
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm24[0],zmm25[0],zmm24[2],zmm25[2],zmm24[4],zmm25[4],zmm24[6],zmm25[6]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm14, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm15, %zmm10
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm12, %zmm8
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm9 = zmm24[1],zmm25[1],zmm24[3],zmm25[3],zmm24[5],zmm25[5],zmm24[7],zmm25[7]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm12, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm2, %zmm10
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm5, %zmm9
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm24, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm11, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 {%k1} = zmm23[0],zmm26[0],zmm23[2],zmm26[2],zmm23[4],zmm26[4],zmm23[6],zmm26[6]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 128(%r10), %zmm9
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm0, %zmm4
; AVX512F-NEXT:    vmovdqa64 128(%rax), %zmm18
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm0, %zmm5
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm5 {%k1} = zmm23[1],zmm26[1],zmm23[3],zmm26[3],zmm23[5],zmm26[5],zmm23[7],zmm26[7]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm14, %zmm4
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm5 = zmm20[0],zmm22[0],zmm20[2],zmm22[2],zmm20[4],zmm22[4],zmm20[6],zmm22[6]
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm14, %zmm6
; AVX512F-NEXT:    vmovdqa64 128(%rdx), %zmm4
; AVX512F-NEXT:    vmovdqa64 128(%rcx), %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm15, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm6, %zmm5, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm12, %zmm5
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm20[1],zmm22[1],zmm20[3],zmm22[3],zmm20[5],zmm22[5],zmm20[7],zmm22[7]
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm12, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm2, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm6, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm11, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm10, %zmm6
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm11, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm9[0],zmm18[0],zmm9[2],zmm18[2],zmm9[4],zmm18[4],zmm9[6],zmm18[6]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm6, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm0, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm27, %zmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm0, %zmm2
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm9[1],zmm18[1],zmm9[3],zmm18[3],zmm9[5],zmm18[5],zmm9[7],zmm18[7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 192(%r10), %zmm9
; AVX512F-NEXT:    vmovdqa64 192(%rax), %zmm20
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm14, %zmm1
; AVX512F-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512F-NEXT:    vmovdqa64 192(%r9), %zmm10
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm4 = zmm2[0],zmm10[0],zmm2[2],zmm10[2],zmm2[4],zmm10[4],zmm2[6],zmm10[6]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k1}
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm14, %zmm6
; AVX512F-NEXT:    vmovdqa64 192(%rdx), %zmm2
; AVX512F-NEXT:    vmovdqa64 192(%rcx), %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm15, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm6, %zmm4, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm12, %zmm4
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm16[1],zmm10[1],zmm16[3],zmm10[3],zmm16[5],zmm10[5],zmm16[7],zmm10[7]
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm12, %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm13, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm11, %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm3, %zmm6
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm11, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm9[0],zmm20[0],zmm9[2],zmm20[2],zmm9[4],zmm20[4],zmm9[6],zmm20[6]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm0, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm27, %zmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm2
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm9[1],zmm20[1],zmm9[3],zmm20[3],zmm9[5],zmm20[5],zmm9[7],zmm20[7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 256(%r10), %zmm9
; AVX512F-NEXT:    vmovdqa64 256(%rax), %zmm22
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm14, %zmm1
; AVX512F-NEXT:    vmovdqa64 256(%r8), %zmm5
; AVX512F-NEXT:    vmovdqa64 256(%r9), %zmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm4 = zmm5[0],zmm2[0],zmm5[2],zmm2[2],zmm5[4],zmm2[4],zmm5[6],zmm2[6]
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k1}
; AVX512F-NEXT:    vmovdqa64 256(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa64 256(%rsi), %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm14, %zmm6
; AVX512F-NEXT:    vmovdqa64 256(%rdx), %zmm2
; AVX512F-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm15, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm6, %zmm4, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm12, %zmm4
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm17[1],zmm16[1],zmm17[3],zmm16[3],zmm17[5],zmm16[5],zmm17[7],zmm16[7]
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm12, %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm13, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm11, %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm3, %zmm6
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm11, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm9[0],zmm22[0],zmm9[2],zmm22[2],zmm9[4],zmm22[4],zmm9[6],zmm22[6]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm0, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm27, %zmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm0, %zmm2
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm9[1],zmm22[1],zmm9[3],zmm22[3],zmm9[5],zmm22[5],zmm9[7],zmm22[7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 320(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa64 320(%rsi), %zmm17
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm14, %zmm4
; AVX512F-NEXT:    vmovdqa64 320(%rdx), %zmm2
; AVX512F-NEXT:    vmovdqa64 320(%rcx), %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm15, %zmm5
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %ymm4, %ymm24
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm3, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm27, %zmm2
; AVX512F-NEXT:    vmovdqa64 384(%rdx), %zmm8
; AVX512F-NEXT:    vmovdqa64 384(%rcx), %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm15, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm13, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm5, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm27, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 448(%rdx), %zmm3
; AVX512F-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm3, %zmm15
; AVX512F-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm3, %zmm13
; AVX512F-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm3, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm27, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 320(%r10), %zmm26
; AVX512F-NEXT:    vmovdqa64 320(%rax), %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm14, %zmm3
; AVX512F-NEXT:    vmovdqa64 320(%r8), %zmm13
; AVX512F-NEXT:    vmovdqa64 320(%r9), %zmm15
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm13[0],zmm15[0],zmm13[2],zmm15[2],zmm13[4],zmm15[4],zmm13[6],zmm15[6]
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512F-NEXT:    vinserti64x4 $0, %ymm24, %zmm9, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm12, %zmm3
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm5 = zmm13[1],zmm15[1],zmm13[3],zmm15[3],zmm13[5],zmm15[5],zmm13[7],zmm15[7]
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm5 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm12, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm5, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm11, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm7[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm11, %zmm5
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm5 {%k1} = zmm26[0],zmm16[0],zmm26[2],zmm16[2],zmm26[4],zmm16[4],zmm26[6],zmm16[6]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm5, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm0, %zmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm0, %zmm2
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm26[1],zmm16[1],zmm26[3],zmm16[3],zmm26[5],zmm16[5],zmm26[7],zmm16[7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 384(%rdi), %zmm3
; AVX512F-NEXT:    vmovdqa64 384(%rsi), %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm14, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm12, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm11, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 384(%r10), %zmm29
; AVX512F-NEXT:    vmovdqa64 384(%rax), %zmm3
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm14, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm4, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 384(%r8), %zmm25
; AVX512F-NEXT:    vmovdqa64 384(%r9), %zmm12
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm31
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm11, %zmm31
; AVX512F-NEXT:    vmovdqa64 448(%r10), %zmm28
; AVX512F-NEXT:    vmovdqa64 448(%rax), %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm14, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqa64 448(%rsi), %zmm1
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm5, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm4, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 448(%r8), %zmm17
; AVX512F-NEXT:    vmovdqa64 448(%r9), %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm30
; AVX512F-NEXT:    vpermt2q %zmm8, %zmm11, %zmm30
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm5, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm0, %zmm24
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm27
; AVX512F-NEXT:    vpermt2q %zmm8, %zmm0, %zmm27
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [0,8,0,8,0,8,0,8]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [1,9,1,9,1,9,1,9]
; AVX512F-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm6, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [2,10,2,10,2,10,2,10]
; AVX512F-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm2, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [3,11,3,11,3,11,3,11]
; AVX512F-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm1, %zmm21
; AVX512F-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm21
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm2, %zmm21
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm1, %zmm23
; AVX512F-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm19
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm2, %zmm19
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm2, %zmm14
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm2, %zmm11
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm6, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm2, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm6, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm2, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm1, %zmm26
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm22
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm5, %zmm22
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm6, %zmm23
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm2, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm1, %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm31 {%k1} = zmm29[0],zmm3[0],zmm29[2],zmm3[2],zmm29[4],zmm3[4],zmm29[6],zmm3[6]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm24 {%k1} = zmm29[1],zmm3[1],zmm29[3],zmm3[3],zmm29[5],zmm3[5],zmm29[7],zmm3[7]
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm2, %zmm20
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm1, %zmm29
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm5, %zmm15
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm16
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm6, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm18
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm2, %zmm18
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm3 = zmm25[0],zmm12[0],zmm25[2],zmm12[2],zmm25[4],zmm12[4],zmm25[6],zmm12[6]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm4 = zmm25[1],zmm12[1],zmm25[3],zmm12[3],zmm25[5],zmm12[5],zmm25[7],zmm12[7]
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm1, %zmm25
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm6, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm30 {%k1} = zmm28[0],zmm9[0],zmm28[2],zmm9[2],zmm28[4],zmm9[4],zmm28[6],zmm9[6]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm27 {%k1} = zmm28[1],zmm9[1],zmm28[3],zmm9[3],zmm28[5],zmm9[5],zmm28[7],zmm9[7]
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm12
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm2, %zmm12
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm1, %zmm28
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm17, %zmm5
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm17, %zmm6
; AVX512F-NEXT:    vpermi2q %zmm8, %zmm17, %zmm2
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm17[0],zmm8[0],zmm17[2],zmm8[2],zmm17[4],zmm8[4],zmm17[6],zmm8[6]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} zmm0 = zmm17[1],zmm8[1],zmm17[3],zmm8[3],zmm17[5],zmm8[5],zmm17[7],zmm8[7]
; AVX512F-NEXT:    vpermt2q %zmm8, %zmm1, %zmm17
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm3 {%k1}
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm4 {%k1}
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm4, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm31, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm24, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm9, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm30, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm27, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %ymm0
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm8
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm8[0],ymm4[0],ymm8[2],ymm4[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm9[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm21, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm8[1],ymm4[1],ymm8[3],ymm4[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512F-NEXT:    vmovdqa 64(%rsi), %ymm0
; AVX512F-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512F-NEXT:    vmovdqa 64(%rcx), %ymm3
; AVX512F-NEXT:    vmovdqa 64(%rdx), %ymm4
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm4[0],ymm3[0],ymm4[2],ymm3[2]
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm19, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm9 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm4[1],ymm3[1],ymm4[3],ymm3[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512F-NEXT:    vmovdqa 128(%rcx), %ymm0
; AVX512F-NEXT:    vmovdqa 128(%rdx), %ymm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-NEXT:    vmovdqa 128(%rsi), %ymm8
; AVX512F-NEXT:    vmovdqa 128(%rdi), %ymm9
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm14, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm4 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm4, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512F-NEXT:    vmovdqa 192(%rcx), %ymm0
; AVX512F-NEXT:    vmovdqa 192(%rdx), %ymm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-NEXT:    vmovdqa 192(%rsi), %ymm4
; AVX512F-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm14 = ymm8[0],ymm4[0],ymm8[2],ymm4[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm14[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm11, %zmm24
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm8[1],ymm4[1],ymm8[3],ymm4[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm21
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqa 256(%rcx), %ymm0
; AVX512F-NEXT:    vmovdqa 256(%rdx), %ymm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-NEXT:    vmovdqa 256(%rsi), %ymm4
; AVX512F-NEXT:    vmovdqa 256(%rdi), %ymm8
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm14 = ymm8[0],ymm4[0],ymm8[2],ymm4[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm14[2,3],ymm3[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm10, %zmm19
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm8[1],ymm4[1],ymm8[3],ymm4[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm10
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqa 320(%rcx), %ymm1
; AVX512F-NEXT:    vmovdqa 320(%rdx), %ymm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX512F-NEXT:    vmovdqa 320(%rsi), %ymm4
; AVX512F-NEXT:    vmovdqa 320(%rdi), %ymm14
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm14[0],ymm4[0],ymm14[2],ymm4[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm9[2,3],ymm0[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm7, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm13 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm14[1],ymm4[1],ymm14[3],ymm4[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm13, %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm18 {%k1}
; AVX512F-NEXT:    vmovdqa 384(%rcx), %ymm1
; AVX512F-NEXT:    vmovdqa 384(%rdx), %ymm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX512F-NEXT:    vmovdqa 384(%rsi), %ymm7
; AVX512F-NEXT:    vmovdqa 384(%rdi), %ymm9
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm14 = ymm9[0],ymm7[0],ymm9[2],ymm7[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm14[2,3],ymm4[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm18, %zmm18
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm25 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm9[1],ymm7[1],ymm9[3],ymm7[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm25, %zmm25
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqa 448(%rcx), %ymm1
; AVX512F-NEXT:    vmovdqa 448(%rdx), %ymm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX512F-NEXT:    vmovdqa 448(%rsi), %ymm7
; AVX512F-NEXT:    vmovdqa 448(%rdi), %ymm9
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} ymm12 = ymm9[0],ymm7[0],ymm9[2],ymm7[2]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm12[2,3],ymm4[2,3]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm4
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm9[1],ymm7[1],ymm9[3],ymm7[3]
; AVX512F-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm17 {%k1}
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm17, %zmm9
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512F-NEXT:    vmovdqa (%rcx), %xmm2
; AVX512F-NEXT:    vmovdqa (%rdx), %xmm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX512F-NEXT:    vmovdqa (%rsi), %xmm7
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm12
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm14 = xmm12[0],xmm7[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm1, %ymm14, %ymm1
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm11, %zmm11
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm3[1],xmm2[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm3 = xmm12[1],xmm7[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm7
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX512F-NEXT:    vmovdqa 64(%rdx), %xmm12
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm12[0],xmm2[0]
; AVX512F-NEXT:    vmovdqa 64(%rsi), %xmm14
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %xmm17
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm17[0],xmm14[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm3, %ymm20, %ymm3
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm1, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm12[1],xmm2[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm12 = xmm17[1],xmm14[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm12, %ymm2
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa 128(%rcx), %xmm12
; AVX512F-NEXT:    vmovdqa 128(%rdx), %xmm14
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm17 = xmm14[0],xmm12[0]
; AVX512F-NEXT:    vmovdqa64 128(%rsi), %xmm20
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %xmm26
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm28 = xmm26[0],xmm20[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm17, %ymm28, %ymm17
; AVX512F-NEXT:    vinserti64x4 $0, %ymm17, %zmm1, %zmm17
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm12 = xmm14[1],xmm12[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm14 = xmm26[1],xmm20[1]
; AVX512F-NEXT:    vinserti128 $1, %xmm12, %ymm14, %ymm12
; AVX512F-NEXT:    vinserti64x4 $0, %ymm12, %zmm1, %zmm12
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa 192(%rcx), %xmm14
; AVX512F-NEXT:    vmovdqa64 192(%rdx), %xmm20
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm26 = xmm20[0],xmm14[0]
; AVX512F-NEXT:    vmovdqa64 192(%rsi), %xmm28
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %xmm29
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm30 = xmm29[0],xmm28[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm26, %ymm30, %ymm26
; AVX512F-NEXT:    vinserti64x4 $0, %ymm26, %zmm1, %zmm26
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm14 = xmm20[1],xmm14[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm29[1],xmm28[1]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm14, %ymm20, %ymm14
; AVX512F-NEXT:    vinserti64x4 $0, %ymm14, %zmm1, %zmm14
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 256(%rcx), %xmm20
; AVX512F-NEXT:    vmovdqa64 256(%rdx), %xmm28
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm29 = xmm28[0],xmm20[0]
; AVX512F-NEXT:    vmovdqa64 256(%rsi), %xmm30
; AVX512F-NEXT:    vmovdqa 256(%rdi), %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm31 = xmm0[0],xmm30[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm29, %ymm31, %ymm29
; AVX512F-NEXT:    vinserti64x4 $0, %ymm29, %zmm1, %zmm29
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm28[1],xmm20[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm30[1]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm27, %zmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512F-NEXT:    vmovdqa64 320(%rcx), %xmm20
; AVX512F-NEXT:    vmovdqa64 320(%rdx), %xmm28
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm30 = xmm28[0],xmm20[0]
; AVX512F-NEXT:    vmovdqa64 320(%rsi), %xmm31
; AVX512F-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm27 = xmm0[0],xmm31[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm30, %ymm27, %ymm27
; AVX512F-NEXT:    vinserti64x4 $0, %ymm27, %zmm22, %zmm22
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm23 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm28[1],xmm20[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm31[1]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm23, %zmm0
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm15 {%k1}
; AVX512F-NEXT:    vmovdqa64 384(%rcx), %xmm20
; AVX512F-NEXT:    vmovdqa64 384(%rdx), %xmm23
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm27 = xmm23[0],xmm20[0]
; AVX512F-NEXT:    vmovdqa64 384(%rsi), %xmm28
; AVX512F-NEXT:    vmovdqa64 384(%rdi), %xmm30
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm31 = xmm30[0],xmm28[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm27, %ymm31, %ymm27
; AVX512F-NEXT:    vinserti64x4 $0, %ymm27, %zmm15, %zmm15
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm16 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm23[1],xmm20[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm23 = xmm30[1],xmm28[1]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm20, %ymm23, %ymm20
; AVX512F-NEXT:    vinserti64x4 $0, %ymm20, %zmm16, %zmm16
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512F-NEXT:    vmovdqa64 448(%rcx), %xmm20
; AVX512F-NEXT:    vmovdqa64 448(%rdx), %xmm23
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm27 = xmm23[0],xmm20[0]
; AVX512F-NEXT:    vmovdqa64 448(%rsi), %xmm28
; AVX512F-NEXT:    vmovdqa64 448(%rdi), %xmm30
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm31 = xmm30[0],xmm28[0]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm27, %ymm31, %ymm27
; AVX512F-NEXT:    vinserti64x4 $0, %ymm27, %zmm5, %zmm5
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm6 {%k1}
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm23[1],xmm20[1]
; AVX512F-NEXT:    vpunpckhqdq {{.*#+}} xmm23 = xmm30[1],xmm28[1]
; AVX512F-NEXT:    vinserti32x4 $1, %xmm20, %ymm23, %ymm20
; AVX512F-NEXT:    vinserti64x4 $0, %ymm20, %zmm6, %zmm6
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovdqa64 %zmm9, 3776(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 3712(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm25, 3264(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm18, 3200(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm13, 2752(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm8, 2688(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 2240(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm19, 2176(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm21, 1728(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm24, 1664(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 1216(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 1152(%rax)
; AVX512F-NEXT:    vmovups (%rsp), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 704(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 640(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 192(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 128(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 4032(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3968(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3904(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3840(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 3648(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 3584(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3520(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3456(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3392(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3328(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 3136(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm15, 3072(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 3008(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 2944(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 2880(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm4, 2816(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm0, 2624(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm22, 2560(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 2496(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 2432(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 2304(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm1, 2112(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm29, 2048(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1920(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm14, 1600(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm26, 1536(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1344(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 1280(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm12, 1088(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm17, 1024(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 768(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm2, 576(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm3, 512(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512F-NEXT:    addq $5384, %rsp # imm = 0x1508
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride8_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $5384, %rsp # imm = 0x1508
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm8
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm16
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm11
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm24
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm20
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm25
; AVX512BW-NEXT:    vmovdqa64 128(%r9), %zmm22
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm18
; AVX512BW-NEXT:    vmovdqa64 64(%r10), %zmm23
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm21
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm26
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm19
; AVX512BW-NEXT:    movb $-64, %r11b
; AVX512BW-NEXT:    kmovd %r11d, %k1
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [4,12,4,12,4,12,4,12]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm14, %zmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm10 = zmm2[0],zmm18[0],zmm2[2],zmm18[2],zmm2[4],zmm18[4],zmm2[6],zmm18[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm15 = <u,u,4,12>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm15, %zmm13
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [5,13,5,13,5,13,5,13]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm12, %zmm0
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm10 = zmm2[1],zmm18[1],zmm2[3],zmm18[3],zmm2[5],zmm18[5],zmm2[7],zmm18[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm12, %zmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,u,5,13>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm2, %zmm13
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm27
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm13, %zmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k1} = zmm21[0],zmm19[0],zmm21[2],zmm19[2],zmm21[4],zmm19[4],zmm21[6],zmm19[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm13, %zmm10
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm5 = <u,u,6,14>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm5, %zmm13
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm13[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm10, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm0, %zmm10
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm10 {%k1} = zmm21[1],zmm19[1],zmm21[3],zmm19[3],zmm21[5],zmm19[5],zmm21[7],zmm19[7]
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm8
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm27 = <u,u,7,15>
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm27, %zmm9
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm10, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm14, %zmm8
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm24[0],zmm25[0],zmm24[2],zmm25[2],zmm24[4],zmm25[4],zmm24[6],zmm25[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm14, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm10
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm12, %zmm8
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm9 = zmm24[1],zmm25[1],zmm24[3],zmm25[3],zmm24[5],zmm25[5],zmm24[7],zmm25[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm12, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm2, %zmm10
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm11, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm5, %zmm9
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm24, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm11, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 {%k1} = zmm23[0],zmm26[0],zmm23[2],zmm26[2],zmm23[4],zmm26[4],zmm23[6],zmm26[6]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%r10), %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqa64 128(%rax), %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm0, %zmm5
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm5 {%k1} = zmm23[1],zmm26[1],zmm23[3],zmm26[3],zmm23[5],zmm26[5],zmm23[7],zmm26[7]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm14, %zmm4
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm5 = zmm20[0],zmm22[0],zmm20[2],zmm22[2],zmm20[4],zmm22[4],zmm20[6],zmm22[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm14, %zmm6
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm5, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm12, %zmm5
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm20[1],zmm22[1],zmm20[3],zmm22[3],zmm20[5],zmm22[5],zmm20[7],zmm22[7]
; AVX512BW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm12, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm2, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm11, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm10, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm11, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm9[0],zmm18[0],zmm9[2],zmm18[2],zmm9[4],zmm18[4],zmm9[6],zmm18[6]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm27, %zmm4
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm0, %zmm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm9[1],zmm18[1],zmm9[3],zmm18[3],zmm9[5],zmm18[5],zmm9[7],zmm18[7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%r10), %zmm9
; AVX512BW-NEXT:    vmovdqa64 192(%rax), %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqa64 192(%r8), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%r9), %zmm10
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 = zmm2[0],zmm10[0],zmm2[2],zmm10[2],zmm2[4],zmm10[4],zmm2[6],zmm10[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm14, %zmm6
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm4, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm12, %zmm4
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm16[1],zmm10[1],zmm16[3],zmm10[3],zmm16[5],zmm10[5],zmm16[7],zmm10[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm12, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm13, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm11, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm3, %zmm6
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm11, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm9[0],zmm20[0],zmm9[2],zmm20[2],zmm9[4],zmm20[4],zmm9[6],zmm20[6]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm27, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm0, %zmm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm9[1],zmm20[1],zmm9[3],zmm20[3],zmm9[5],zmm20[5],zmm9[7],zmm20[7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 256(%r10), %zmm9
; AVX512BW-NEXT:    vmovdqa64 256(%rax), %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqa64 256(%r8), %zmm5
; AVX512BW-NEXT:    vmovdqa64 256(%r9), %zmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 = zmm5[0],zmm2[0],zmm5[2],zmm2[2],zmm5[4],zmm2[4],zmm5[6],zmm2[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 256(%rsi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm14, %zmm6
; AVX512BW-NEXT:    vmovdqa64 256(%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm4, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm12, %zmm4
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm6 = zmm17[1],zmm16[1],zmm17[3],zmm16[3],zmm17[5],zmm16[5],zmm17[7],zmm16[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm12, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm13, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm11, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm3, %zmm6
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm11, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm9[0],zmm22[0],zmm9[2],zmm22[2],zmm9[4],zmm22[4],zmm9[6],zmm22[6]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm27, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm0, %zmm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm9[1],zmm22[1],zmm9[3],zmm22[3],zmm9[5],zmm22[5],zmm9[7],zmm22[7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 320(%rsi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm14, %zmm4
; AVX512BW-NEXT:    vmovdqa64 320(%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 320(%rcx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm15, %zmm5
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %ymm4, %ymm24
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm3, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm27, %zmm2
; AVX512BW-NEXT:    vmovdqa64 384(%rdx), %zmm8
; AVX512BW-NEXT:    vmovdqa64 384(%rcx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm13, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm27, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%rdx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm3, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm3, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm27, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 320(%r10), %zmm26
; AVX512BW-NEXT:    vmovdqa64 320(%rax), %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm14, %zmm3
; AVX512BW-NEXT:    vmovdqa64 320(%r8), %zmm13
; AVX512BW-NEXT:    vmovdqa64 320(%r9), %zmm15
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm13[0],zmm15[0],zmm13[2],zmm15[2],zmm13[4],zmm15[4],zmm13[6],zmm15[6]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm24, %zmm9, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm12, %zmm3
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm5 = zmm13[1],zmm15[1],zmm13[3],zmm15[3],zmm13[5],zmm15[5],zmm13[7],zmm15[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm12, %zmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm5, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm11, %zmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm7[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm11, %zmm5
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm5 {%k1} = zmm26[0],zmm16[0],zmm26[2],zmm16[2],zmm26[4],zmm16[4],zmm26[6],zmm16[6]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm5, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm0, %zmm1
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm0, %zmm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm2 {%k1} = zmm26[1],zmm16[1],zmm26[3],zmm16[3],zmm26[5],zmm16[5],zmm26[7],zmm16[7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 384(%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm14, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm12, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm11, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 384(%r10), %zmm29
; AVX512BW-NEXT:    vmovdqa64 384(%rax), %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm4, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 384(%r8), %zmm25
; AVX512BW-NEXT:    vmovdqa64 384(%r9), %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm11, %zmm31
; AVX512BW-NEXT:    vmovdqa64 448(%r10), %zmm28
; AVX512BW-NEXT:    vmovdqa64 448(%rax), %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 448(%rsi), %zmm1
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm5, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm4, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%r8), %zmm17
; AVX512BW-NEXT:    vmovdqa64 448(%r9), %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm11, %zmm30
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm5, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm0, %zmm27
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [0,8,0,8,0,8,0,8]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [1,9,1,9,1,9,1,9]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm1, %zmm21
; AVX512BW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm23
; AVX512BW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm2, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm5, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm1, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm5, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm6, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm2, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm1, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm31 {%k1} = zmm29[0],zmm3[0],zmm29[2],zmm3[2],zmm29[4],zmm3[4],zmm29[6],zmm3[6]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm24 {%k1} = zmm29[1],zmm3[1],zmm29[3],zmm3[3],zmm29[5],zmm3[5],zmm29[7],zmm3[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm29
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm5, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm2, %zmm18
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm3 = zmm25[0],zmm12[0],zmm25[2],zmm12[2],zmm25[4],zmm12[4],zmm25[6],zmm12[6]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm4 = zmm25[1],zmm12[1],zmm25[3],zmm12[3],zmm25[5],zmm12[5],zmm25[7],zmm12[7]
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm1, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm30 {%k1} = zmm28[0],zmm9[0],zmm28[2],zmm9[2],zmm28[4],zmm9[4],zmm28[6],zmm9[6]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm27 {%k1} = zmm28[1],zmm9[1],zmm28[3],zmm9[3],zmm28[5],zmm9[5],zmm28[7],zmm9[7]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm2, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm28
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm17, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm17, %zmm6
; AVX512BW-NEXT:    vpermi2q %zmm8, %zmm17, %zmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} zmm9 = zmm17[0],zmm8[0],zmm17[2],zmm8[2],zmm17[4],zmm8[4],zmm17[6],zmm8[6]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} zmm0 = zmm17[1],zmm8[1],zmm17[3],zmm8[3],zmm17[5],zmm8[5],zmm17[7],zmm8[7]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm1, %zmm17
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm3 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm4 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm4, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm31, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm24, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm30, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm27, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512BW-NEXT:    vmovdqa (%rsi), %ymm4
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm8
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm8[0],ymm4[0],ymm8[2],ymm4[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm9[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm21, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm8[1],ymm4[1],ymm8[3],ymm4[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rsi), %ymm0
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512BW-NEXT:    vmovdqa 64(%rcx), %ymm3
; AVX512BW-NEXT:    vmovdqa 64(%rdx), %ymm4
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm4[0],ymm3[0],ymm4[2],ymm3[2]
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm19, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm4[1],ymm3[1],ymm4[3],ymm3[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqa 128(%rcx), %ymm0
; AVX512BW-NEXT:    vmovdqa 128(%rdx), %ymm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512BW-NEXT:    vmovdqa 128(%rsi), %ymm8
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm9
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm14, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm4 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqa 192(%rcx), %ymm0
; AVX512BW-NEXT:    vmovdqa 192(%rdx), %ymm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512BW-NEXT:    vmovdqa 192(%rsi), %ymm4
; AVX512BW-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm14 = ymm8[0],ymm4[0],ymm8[2],ymm4[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm14[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm11, %zmm24
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm8[1],ymm4[1],ymm8[3],ymm4[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm21
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa 256(%rcx), %ymm0
; AVX512BW-NEXT:    vmovdqa 256(%rdx), %ymm1
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512BW-NEXT:    vmovdqa 256(%rsi), %ymm4
; AVX512BW-NEXT:    vmovdqa 256(%rdi), %ymm8
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm14 = ymm8[0],ymm4[0],ymm8[2],ymm4[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm3 = ymm14[2,3],ymm3[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm10, %zmm19
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm8[1],ymm4[1],ymm8[3],ymm4[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm10
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa 320(%rcx), %ymm1
; AVX512BW-NEXT:    vmovdqa 320(%rdx), %ymm3
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX512BW-NEXT:    vmovdqa 320(%rsi), %ymm4
; AVX512BW-NEXT:    vmovdqa 320(%rdi), %ymm14
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm14[0],ymm4[0],ymm14[2],ymm4[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm9[2,3],ymm0[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm7, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm13 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm14[1],ymm4[1],ymm14[3],ymm4[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm13, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm18 {%k1}
; AVX512BW-NEXT:    vmovdqa 384(%rcx), %ymm1
; AVX512BW-NEXT:    vmovdqa 384(%rdx), %ymm3
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX512BW-NEXT:    vmovdqa 384(%rsi), %ymm7
; AVX512BW-NEXT:    vmovdqa 384(%rdi), %ymm9
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm14 = ymm9[0],ymm7[0],ymm9[2],ymm7[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm14[2,3],ymm4[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm18, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm25 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm9[1],ymm7[1],ymm9[3],ymm7[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm25, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa 448(%rcx), %ymm1
; AVX512BW-NEXT:    vmovdqa 448(%rdx), %ymm3
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX512BW-NEXT:    vmovdqa 448(%rsi), %ymm7
; AVX512BW-NEXT:    vmovdqa 448(%rdi), %ymm9
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} ymm12 = ymm9[0],ymm7[0],ymm9[2],ymm7[2]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm12[2,3],ymm4[2,3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm4
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm9[1],ymm7[1],ymm9[3],ymm7[3]
; AVX512BW-NEXT:    vperm2i128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm17 {%k1}
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm17, %zmm9
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqa (%rcx), %xmm2
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm3
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX512BW-NEXT:    vmovdqa (%rsi), %xmm7
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm12
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm14 = xmm12[0],xmm7[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm14, %ymm1
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm11, %zmm11
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm3[1],xmm2[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm3 = xmm12[1],xmm7[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rcx), %xmm2
; AVX512BW-NEXT:    vmovdqa 64(%rdx), %xmm12
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm12[0],xmm2[0]
; AVX512BW-NEXT:    vmovdqa 64(%rsi), %xmm14
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %xmm17
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm17[0],xmm14[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm3, %ymm20, %ymm3
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm12[1],xmm2[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm12 = xmm17[1],xmm14[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm12, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa 128(%rcx), %xmm12
; AVX512BW-NEXT:    vmovdqa 128(%rdx), %xmm14
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm17 = xmm14[0],xmm12[0]
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %xmm20
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %xmm26
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm28 = xmm26[0],xmm20[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm17, %ymm28, %ymm17
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm17, %zmm1, %zmm17
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm12 = xmm14[1],xmm12[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm14 = xmm26[1],xmm20[1]
; AVX512BW-NEXT:    vinserti128 $1, %xmm12, %ymm14, %ymm12
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm12, %zmm1, %zmm12
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa 192(%rcx), %xmm14
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %xmm20
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm26 = xmm20[0],xmm14[0]
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %xmm28
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %xmm29
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm30 = xmm29[0],xmm28[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm26, %ymm30, %ymm26
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm26, %zmm1, %zmm26
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm14 = xmm20[1],xmm14[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm29[1],xmm28[1]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm14, %ymm20, %ymm14
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm14, %zmm1, %zmm14
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 256(%rcx), %xmm20
; AVX512BW-NEXT:    vmovdqa64 256(%rdx), %xmm28
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm29 = xmm28[0],xmm20[0]
; AVX512BW-NEXT:    vmovdqa64 256(%rsi), %xmm30
; AVX512BW-NEXT:    vmovdqa 256(%rdi), %xmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm31 = xmm0[0],xmm30[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm29, %ymm31, %ymm29
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm29, %zmm1, %zmm29
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm28[1],xmm20[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm30[1]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm27, %zmm1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k1}
; AVX512BW-NEXT:    vmovdqa64 320(%rcx), %xmm20
; AVX512BW-NEXT:    vmovdqa64 320(%rdx), %xmm28
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm30 = xmm28[0],xmm20[0]
; AVX512BW-NEXT:    vmovdqa64 320(%rsi), %xmm31
; AVX512BW-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm27 = xmm0[0],xmm31[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm30, %ymm27, %ymm27
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm27, %zmm22, %zmm22
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm23 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm28[1],xmm20[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm31[1]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm23, %zmm0
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm15 {%k1}
; AVX512BW-NEXT:    vmovdqa64 384(%rcx), %xmm20
; AVX512BW-NEXT:    vmovdqa64 384(%rdx), %xmm23
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm27 = xmm23[0],xmm20[0]
; AVX512BW-NEXT:    vmovdqa64 384(%rsi), %xmm28
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %xmm30
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm31 = xmm30[0],xmm28[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm27, %ymm31, %ymm27
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm27, %zmm15, %zmm15
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm16 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm23[1],xmm20[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm23 = xmm30[1],xmm28[1]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm20, %ymm23, %ymm20
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm20, %zmm16, %zmm16
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqa64 448(%rcx), %xmm20
; AVX512BW-NEXT:    vmovdqa64 448(%rdx), %xmm23
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm27 = xmm23[0],xmm20[0]
; AVX512BW-NEXT:    vmovdqa64 448(%rsi), %xmm28
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %xmm30
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm31 = xmm30[0],xmm28[0]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm27, %ymm31, %ymm27
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm27, %zmm5, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm6 {%k1}
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm20 = xmm23[1],xmm20[1]
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} xmm23 = xmm30[1],xmm28[1]
; AVX512BW-NEXT:    vinserti32x4 $1, %xmm20, %ymm23, %ymm20
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm20, %zmm6, %zmm6
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 3776(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 3712(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 3264(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 3200(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 2752(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 2688(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 2240(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 2176(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 1728(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 1664(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 1216(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 1152(%rax)
; AVX512BW-NEXT:    vmovups (%rsp), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 704(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 640(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 192(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 128(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 4032(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3968(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3904(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3840(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 3648(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 3584(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3520(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3456(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3392(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3328(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 3136(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 3072(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 3008(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 2944(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 2880(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm4, 2816(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 2624(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 2560(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2496(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2432(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2304(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 2112(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 2048(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1920(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 1600(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 1536(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1344(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1280(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 1088(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 1024(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 512(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512BW-NEXT:    addq $5384, %rsp # imm = 0x1508
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <64 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <64 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <64 x i64>, ptr %in.vecptr6, align 64
  %in.vec7 = load <64 x i64>, ptr %in.vecptr7, align 64
  %1 = shufflevector <64 x i64> %in.vec0, <64 x i64> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i64> %in.vec2, <64 x i64> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <64 x i64> %in.vec4, <64 x i64> %in.vec5, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <64 x i64> %in.vec6, <64 x i64> %in.vec7, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <128 x i64> %1, <128 x i64> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %6 = shufflevector <128 x i64> %3, <128 x i64> %4, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %7 = shufflevector <256 x i64> %5, <256 x i64> %6, <512 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319, i32 320, i32 321, i32 322, i32 323, i32 324, i32 325, i32 326, i32 327, i32 328, i32 329, i32 330, i32 331, i32 332, i32 333, i32 334, i32 335, i32 336, i32 337, i32 338, i32 339, i32 340, i32 341, i32 342, i32 343, i32 344, i32 345, i32 346, i32 347, i32 348, i32 349, i32 350, i32 351, i32 352, i32 353, i32 354, i32 355, i32 356, i32 357, i32 358, i32 359, i32 360, i32 361, i32 362, i32 363, i32 364, i32 365, i32 366, i32 367, i32 368, i32 369, i32 370, i32 371, i32 372, i32 373, i32 374, i32 375, i32 376, i32 377, i32 378, i32 379, i32 380, i32 381, i32 382, i32 383, i32 384, i32 385, i32 386, i32 387, i32 388, i32 389, i32 390, i32 391, i32 392, i32 393, i32 394, i32 395, i32 396, i32 397, i32 398, i32 399, i32 400, i32 401, i32 402, i32 403, i32 404, i32 405, i32 406, i32 407, i32 408, i32 409, i32 410, i32 411, i32 412, i32 413, i32 414, i32 415, i32 416, i32 417, i32 418, i32 419, i32 420, i32 421, i32 422, i32 423, i32 424, i32 425, i32 426, i32 427, i32 428, i32 429, i32 430, i32 431, i32 432, i32 433, i32 434, i32 435, i32 436, i32 437, i32 438, i32 439, i32 440, i32 441, i32 442, i32 443, i32 444, i32 445, i32 446, i32 447, i32 448, i32 449, i32 450, i32 451, i32 452, i32 453, i32 454, i32 455, i32 456, i32 457, i32 458, i32 459, i32 460, i32 461, i32 462, i32 463, i32 464, i32 465, i32 466, i32 467, i32 468, i32 469, i32 470, i32 471, i32 472, i32 473, i32 474, i32 475, i32 476, i32 477, i32 478, i32 479, i32 480, i32 481, i32 482, i32 483, i32 484, i32 485, i32 486, i32 487, i32 488, i32 489, i32 490, i32 491, i32 492, i32 493, i32 494, i32 495, i32 496, i32 497, i32 498, i32 499, i32 500, i32 501, i32 502, i32 503, i32 504, i32 505, i32 506, i32 507, i32 508, i32 509, i32 510, i32 511>
  %interleaved.vec = shufflevector <512 x i64> %7, <512 x i64> poison, <512 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 320, i32 384, i32 448, i32 1, i32 65, i32 129, i32 193, i32 257, i32 321, i32 385, i32 449, i32 2, i32 66, i32 130, i32 194, i32 258, i32 322, i32 386, i32 450, i32 3, i32 67, i32 131, i32 195, i32 259, i32 323, i32 387, i32 451, i32 4, i32 68, i32 132, i32 196, i32 260, i32 324, i32 388, i32 452, i32 5, i32 69, i32 133, i32 197, i32 261, i32 325, i32 389, i32 453, i32 6, i32 70, i32 134, i32 198, i32 262, i32 326, i32 390, i32 454, i32 7, i32 71, i32 135, i32 199, i32 263, i32 327, i32 391, i32 455, i32 8, i32 72, i32 136, i32 200, i32 264, i32 328, i32 392, i32 456, i32 9, i32 73, i32 137, i32 201, i32 265, i32 329, i32 393, i32 457, i32 10, i32 74, i32 138, i32 202, i32 266, i32 330, i32 394, i32 458, i32 11, i32 75, i32 139, i32 203, i32 267, i32 331, i32 395, i32 459, i32 12, i32 76, i32 140, i32 204, i32 268, i32 332, i32 396, i32 460, i32 13, i32 77, i32 141, i32 205, i32 269, i32 333, i32 397, i32 461, i32 14, i32 78, i32 142, i32 206, i32 270, i32 334, i32 398, i32 462, i32 15, i32 79, i32 143, i32 207, i32 271, i32 335, i32 399, i32 463, i32 16, i32 80, i32 144, i32 208, i32 272, i32 336, i32 400, i32 464, i32 17, i32 81, i32 145, i32 209, i32 273, i32 337, i32 401, i32 465, i32 18, i32 82, i32 146, i32 210, i32 274, i32 338, i32 402, i32 466, i32 19, i32 83, i32 147, i32 211, i32 275, i32 339, i32 403, i32 467, i32 20, i32 84, i32 148, i32 212, i32 276, i32 340, i32 404, i32 468, i32 21, i32 85, i32 149, i32 213, i32 277, i32 341, i32 405, i32 469, i32 22, i32 86, i32 150, i32 214, i32 278, i32 342, i32 406, i32 470, i32 23, i32 87, i32 151, i32 215, i32 279, i32 343, i32 407, i32 471, i32 24, i32 88, i32 152, i32 216, i32 280, i32 344, i32 408, i32 472, i32 25, i32 89, i32 153, i32 217, i32 281, i32 345, i32 409, i32 473, i32 26, i32 90, i32 154, i32 218, i32 282, i32 346, i32 410, i32 474, i32 27, i32 91, i32 155, i32 219, i32 283, i32 347, i32 411, i32 475, i32 28, i32 92, i32 156, i32 220, i32 284, i32 348, i32 412, i32 476, i32 29, i32 93, i32 157, i32 221, i32 285, i32 349, i32 413, i32 477, i32 30, i32 94, i32 158, i32 222, i32 286, i32 350, i32 414, i32 478, i32 31, i32 95, i32 159, i32 223, i32 287, i32 351, i32 415, i32 479, i32 32, i32 96, i32 160, i32 224, i32 288, i32 352, i32 416, i32 480, i32 33, i32 97, i32 161, i32 225, i32 289, i32 353, i32 417, i32 481, i32 34, i32 98, i32 162, i32 226, i32 290, i32 354, i32 418, i32 482, i32 35, i32 99, i32 163, i32 227, i32 291, i32 355, i32 419, i32 483, i32 36, i32 100, i32 164, i32 228, i32 292, i32 356, i32 420, i32 484, i32 37, i32 101, i32 165, i32 229, i32 293, i32 357, i32 421, i32 485, i32 38, i32 102, i32 166, i32 230, i32 294, i32 358, i32 422, i32 486, i32 39, i32 103, i32 167, i32 231, i32 295, i32 359, i32 423, i32 487, i32 40, i32 104, i32 168, i32 232, i32 296, i32 360, i32 424, i32 488, i32 41, i32 105, i32 169, i32 233, i32 297, i32 361, i32 425, i32 489, i32 42, i32 106, i32 170, i32 234, i32 298, i32 362, i32 426, i32 490, i32 43, i32 107, i32 171, i32 235, i32 299, i32 363, i32 427, i32 491, i32 44, i32 108, i32 172, i32 236, i32 300, i32 364, i32 428, i32 492, i32 45, i32 109, i32 173, i32 237, i32 301, i32 365, i32 429, i32 493, i32 46, i32 110, i32 174, i32 238, i32 302, i32 366, i32 430, i32 494, i32 47, i32 111, i32 175, i32 239, i32 303, i32 367, i32 431, i32 495, i32 48, i32 112, i32 176, i32 240, i32 304, i32 368, i32 432, i32 496, i32 49, i32 113, i32 177, i32 241, i32 305, i32 369, i32 433, i32 497, i32 50, i32 114, i32 178, i32 242, i32 306, i32 370, i32 434, i32 498, i32 51, i32 115, i32 179, i32 243, i32 307, i32 371, i32 435, i32 499, i32 52, i32 116, i32 180, i32 244, i32 308, i32 372, i32 436, i32 500, i32 53, i32 117, i32 181, i32 245, i32 309, i32 373, i32 437, i32 501, i32 54, i32 118, i32 182, i32 246, i32 310, i32 374, i32 438, i32 502, i32 55, i32 119, i32 183, i32 247, i32 311, i32 375, i32 439, i32 503, i32 56, i32 120, i32 184, i32 248, i32 312, i32 376, i32 440, i32 504, i32 57, i32 121, i32 185, i32 249, i32 313, i32 377, i32 441, i32 505, i32 58, i32 122, i32 186, i32 250, i32 314, i32 378, i32 442, i32 506, i32 59, i32 123, i32 187, i32 251, i32 315, i32 379, i32 443, i32 507, i32 60, i32 124, i32 188, i32 252, i32 316, i32 380, i32 444, i32 508, i32 61, i32 125, i32 189, i32 253, i32 317, i32 381, i32 445, i32 509, i32 62, i32 126, i32 190, i32 254, i32 318, i32 382, i32 446, i32 510, i32 63, i32 127, i32 191, i32 255, i32 319, i32 383, i32 447, i32 511>
  store <512 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX2-FAST: {{.*}}
; AVX2-FAST-PERLANE: {{.*}}
; AVX2-SLOW: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F-FAST: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; AVX512F-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
