; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-windows-msvc < %s -mattr=-sse | FileCheck %s
; RUN: llc -mtriple=x86_64-windows-gnu < %s -mattr=-sse | FileCheck %s

define void @recv_double(double %v, ptr %p) {
; CHECK-LABEL: recv_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rcx, (%rdx)
; CHECK-NEXT:    retq
  store double %v, ptr %p
  ret void
}

define void @recv_float(float %v, ptr %p) {
; CHECK-LABEL: recv_float:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %ecx, (%rdx)
; CHECK-NEXT:    retq
  store float %v, ptr %p
  ret void
}

define dso_local double @ret_double(ptr %p) {
; CHECK-LABEL: ret_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq (%rcx), %rax
; CHECK-NEXT:    retq
entry:
  %v = load double, ptr %p
  ret double %v
}

define dso_local float @ret_float(ptr %p) {
; CHECK-LABEL: ret_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl (%rcx), %eax
; CHECK-NEXT:    retq
entry:
  %v = load float, ptr %p
  ret float %v
}

declare void @take_double(double)
declare void @take_float(float)

define void @pass_double(ptr %p) {
; CHECK-LABEL: pass_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    .seh_stackalloc 40
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    movq (%rcx), %rcx
; CHECK-NEXT:    callq take_double
; CHECK-NEXT:    nop
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    retq
; CHECK-NEXT:    .seh_endproc
  %v = load double, ptr %p
  call void @take_double(double %v)
  ret void
}

define void @pass_float(ptr %p) {
; CHECK-LABEL: pass_float:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    .seh_stackalloc 40
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    movl (%rcx), %ecx
; CHECK-NEXT:    callq take_float
; CHECK-NEXT:    nop
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    retq
; CHECK-NEXT:    .seh_endproc
  %v = load float, ptr %p
  call void @take_float(float %v)
  ret void
}

declare double @produce_double()
declare float @produce_float()

define void @call_double(ptr %p) {
; CHECK-LABEL: call_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rsi
; CHECK-NEXT:    .seh_pushreg %rsi
; CHECK-NEXT:    subq $32, %rsp
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    movq %rcx, %rsi
; CHECK-NEXT:    callq produce_double
; CHECK-NEXT:    movq %rax, (%rsi)
; CHECK-NEXT:    addq $32, %rsp
; CHECK-NEXT:    popq %rsi
; CHECK-NEXT:    retq
; CHECK-NEXT:    .seh_endproc
  %v = call double @produce_double()
  store double %v, ptr %p
  ret void
}

define void @call_float(ptr %p) {
; CHECK-LABEL: call_float:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rsi
; CHECK-NEXT:    .seh_pushreg %rsi
; CHECK-NEXT:    subq $32, %rsp
; CHECK-NEXT:    .seh_stackalloc 32
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    movq %rcx, %rsi
; CHECK-NEXT:    callq produce_float
; CHECK-NEXT:    movl %eax, (%rsi)
; CHECK-NEXT:    addq $32, %rsp
; CHECK-NEXT:    popq %rsi
; CHECK-NEXT:    retq
; CHECK-NEXT:    .seh_endproc
  %v = call float @produce_float()
  store float %v, ptr %p
  ret void
}
