; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-none-eabi -mattr=-fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64-none-eabi -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

define <8 x half> @add_h(<8 x half> %a, <8 x half> %b) {
; CHECK-CVT-LABEL: add_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[2]
; CHECK-CVT-NEXT:    mov h7, v0.h[2]
; CHECK-CVT-NEXT:    mov h16, v1.h[3]
; CHECK-CVT-NEXT:    mov h17, v0.h[3]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fadd s4, s5, s4
; CHECK-CVT-NEXT:    fcvt s5, h6
; CHECK-CVT-NEXT:    fcvt s6, h7
; CHECK-CVT-NEXT:    fcvt s7, h16
; CHECK-CVT-NEXT:    fcvt s16, h17
; CHECK-CVT-NEXT:    fadd s3, s3, s2
; CHECK-CVT-NEXT:    fcvt h2, s4
; CHECK-CVT-NEXT:    fadd s4, s6, s5
; CHECK-CVT-NEXT:    mov h5, v1.h[4]
; CHECK-CVT-NEXT:    mov h6, v0.h[4]
; CHECK-CVT-NEXT:    fadd s7, s16, s7
; CHECK-CVT-NEXT:    fcvt h3, s3
; CHECK-CVT-NEXT:    mov h16, v0.h[5]
; CHECK-CVT-NEXT:    fcvt h7, s7
; CHECK-CVT-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    fcvt s5, h6
; CHECK-CVT-NEXT:    mov h6, v1.h[5]
; CHECK-CVT-NEXT:    mov v2.h[2], v3.h[0]
; CHECK-CVT-NEXT:    fadd s3, s5, s4
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s5, h16
; CHECK-CVT-NEXT:    mov h6, v1.h[6]
; CHECK-CVT-NEXT:    mov h16, v0.h[6]
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], v7.h[0]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    fcvt h3, s3
; CHECK-CVT-NEXT:    fadd s4, s5, s4
; CHECK-CVT-NEXT:    fcvt s5, h6
; CHECK-CVT-NEXT:    fcvt s6, h16
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fadd s4, s6, s5
; CHECK-CVT-NEXT:    fadd s0, s0, s1
; CHECK-CVT-NEXT:    mov v2.h[5], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    mov v2.h[6], v3.h[0]
; CHECK-CVT-NEXT:    mov v2.h[7], v0.h[0]
; CHECK-CVT-NEXT:    mov v0.16b, v2.16b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: add_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fadd v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    ret
entry:
  %0 = fadd <8 x half> %a, %b
  ret <8 x half> %0
}


define <8 x half> @sub_h(<8 x half> %a, <8 x half> %b) {
; CHECK-CVT-LABEL: sub_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[2]
; CHECK-CVT-NEXT:    mov h7, v0.h[2]
; CHECK-CVT-NEXT:    mov h16, v1.h[3]
; CHECK-CVT-NEXT:    mov h17, v0.h[3]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fsub s4, s5, s4
; CHECK-CVT-NEXT:    fcvt s5, h6
; CHECK-CVT-NEXT:    fcvt s6, h7
; CHECK-CVT-NEXT:    fcvt s7, h16
; CHECK-CVT-NEXT:    fcvt s16, h17
; CHECK-CVT-NEXT:    fsub s3, s3, s2
; CHECK-CVT-NEXT:    fcvt h2, s4
; CHECK-CVT-NEXT:    fsub s4, s6, s5
; CHECK-CVT-NEXT:    mov h5, v1.h[4]
; CHECK-CVT-NEXT:    mov h6, v0.h[4]
; CHECK-CVT-NEXT:    fsub s7, s16, s7
; CHECK-CVT-NEXT:    fcvt h3, s3
; CHECK-CVT-NEXT:    mov h16, v0.h[5]
; CHECK-CVT-NEXT:    fcvt h7, s7
; CHECK-CVT-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    fcvt s5, h6
; CHECK-CVT-NEXT:    mov h6, v1.h[5]
; CHECK-CVT-NEXT:    mov v2.h[2], v3.h[0]
; CHECK-CVT-NEXT:    fsub s3, s5, s4
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s5, h16
; CHECK-CVT-NEXT:    mov h6, v1.h[6]
; CHECK-CVT-NEXT:    mov h16, v0.h[6]
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], v7.h[0]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    fcvt h3, s3
; CHECK-CVT-NEXT:    fsub s4, s5, s4
; CHECK-CVT-NEXT:    fcvt s5, h6
; CHECK-CVT-NEXT:    fcvt s6, h16
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fsub s4, s6, s5
; CHECK-CVT-NEXT:    fsub s0, s0, s1
; CHECK-CVT-NEXT:    mov v2.h[5], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    mov v2.h[6], v3.h[0]
; CHECK-CVT-NEXT:    mov v2.h[7], v0.h[0]
; CHECK-CVT-NEXT:    mov v0.16b, v2.16b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sub_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fsub v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    ret
entry:
  %0 = fsub <8 x half> %a, %b
  ret <8 x half> %0
}


define <8 x half> @mul_h(<8 x half> %a, <8 x half> %b) {
; CHECK-CVT-LABEL: mul_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[2]
; CHECK-CVT-NEXT:    mov h7, v0.h[2]
; CHECK-CVT-NEXT:    mov h16, v0.h[3]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fmul s4, s5, s4
; CHECK-CVT-NEXT:    mov h5, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fmul s3, s3, s2
; CHECK-CVT-NEXT:    fcvt h2, s4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    fcvt s5, h16
; CHECK-CVT-NEXT:    fmul s6, s7, s6
; CHECK-CVT-NEXT:    mov h7, v1.h[4]
; CHECK-CVT-NEXT:    mov h16, v0.h[4]
; CHECK-CVT-NEXT:    fcvt h3, s3
; CHECK-CVT-NEXT:    fmul s4, s5, s4
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    fcvt h6, s6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-CVT-NEXT:    mov h3, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s16, h16
; CHECK-CVT-NEXT:    fcvt h4, s4
; CHECK-CVT-NEXT:    fcvt s5, h5
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov v2.h[2], v6.h[0]
; CHECK-CVT-NEXT:    fmul s6, s16, s7
; CHECK-CVT-NEXT:    mov h7, v1.h[6]
; CHECK-CVT-NEXT:    mov h16, v0.h[6]
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    fmul s3, s5, s3
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], v4.h[0]
; CHECK-CVT-NEXT:    fcvt h4, s6
; CHECK-CVT-NEXT:    fcvt s5, h7
; CHECK-CVT-NEXT:    fcvt s6, h16
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt h3, s3
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], v4.h[0]
; CHECK-CVT-NEXT:    fmul s4, s6, s5
; CHECK-CVT-NEXT:    fmul s0, s0, s1
; CHECK-CVT-NEXT:    mov v2.h[5], v3.h[0]
; CHECK-CVT-NEXT:    fcvt h3, s4
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    mov v2.h[6], v3.h[0]
; CHECK-CVT-NEXT:    mov v2.h[7], v0.h[0]
; CHECK-CVT-NEXT:    mov v0.16b, v2.16b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: mul_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fmul v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    ret
entry:
  %0 = fmul <8 x half> %a, %b
  ret <8 x half> %0
}


define <8 x half> @div_h(<8 x half> %a, <8 x half> %b) {
; CHECK-CVT-LABEL: div_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h0
; CHECK-CVT-NEXT:    mov h5, v0.h[2]
; CHECK-CVT-NEXT:    mov h6, v0.h[3]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v0.h[5]
; CHECK-CVT-NEXT:    mov h17, v0.h[6]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s5, h5
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcvt s16, h16
; CHECK-CVT-NEXT:    fcvt s17, h17
; CHECK-CVT-NEXT:    fdiv s2, s3, s2
; CHECK-CVT-NEXT:    fcvt s3, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fdiv s3, s4, s3
; CHECK-CVT-NEXT:    mov h4, v1.h[2]
; CHECK-CVT-NEXT:    fcvt h18, s2
; CHECK-CVT-NEXT:    fcvt s4, h4
; CHECK-CVT-NEXT:    fdiv s4, s5, s4
; CHECK-CVT-NEXT:    mov h5, v1.h[3]
; CHECK-CVT-NEXT:    fcvt h2, s3
; CHECK-CVT-NEXT:    fcvt s5, h5
; CHECK-CVT-NEXT:    mov v2.h[1], v18.h[0]
; CHECK-CVT-NEXT:    fdiv s5, s6, s5
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    fcvt h4, s4
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-CVT-NEXT:    fdiv s6, s7, s6
; CHECK-CVT-NEXT:    mov h7, v1.h[5]
; CHECK-CVT-NEXT:    fcvt h4, s5
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    mov v2.h[3], v4.h[0]
; CHECK-CVT-NEXT:    fdiv s7, s16, s7
; CHECK-CVT-NEXT:    mov h16, v1.h[6]
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    fcvt s16, h16
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fdiv s3, s17, s16
; CHECK-CVT-NEXT:    fdiv s0, s0, s1
; CHECK-CVT-NEXT:    fcvt h1, s6
; CHECK-CVT-NEXT:    mov v2.h[4], v1.h[0]
; CHECK-CVT-NEXT:    fcvt h1, s7
; CHECK-CVT-NEXT:    mov v2.h[5], v1.h[0]
; CHECK-CVT-NEXT:    fcvt h1, s3
; CHECK-CVT-NEXT:    mov v2.h[6], v1.h[0]
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    mov v2.h[7], v0.h[0]
; CHECK-CVT-NEXT:    mov v0.16b, v2.16b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: div_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fdiv v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    ret
entry:
  %0 = fdiv <8 x half> %a, %b
  ret <8 x half> %0
}


define <8 x half> @load_h(ptr %a) {
; CHECK-LABEL: load_h:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load <8 x half>, ptr %a, align 4
  ret <8 x half> %0
}


define void @store_h(ptr %a, <8 x half> %b) {
; CHECK-LABEL: store_h:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
entry:
  store <8 x half> %b, ptr %a, align 4
  ret void
}

define <8 x half> @s_to_h(<8 x float> %a) {
; CHECK-LABEL: s_to_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %1 = fptrunc <8 x float> %a to <8 x half>
  ret <8 x half> %1
}

define <8 x half> @d_to_h(<8 x double> %a) {
; CHECK-LABEL: d_to_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov d4, v0.d[1]
; CHECK-NEXT:    fcvt h0, d0
; CHECK-NEXT:    mov d5, v1.d[1]
; CHECK-NEXT:    fcvt h1, d1
; CHECK-NEXT:    fcvt h4, d4
; CHECK-NEXT:    mov v0.h[1], v4.h[0]
; CHECK-NEXT:    fcvt h4, d5
; CHECK-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-NEXT:    fcvt h1, d2
; CHECK-NEXT:    mov d2, v2.d[1]
; CHECK-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-NEXT:    fcvt h2, d2
; CHECK-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-NEXT:    fcvt h1, d3
; CHECK-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-NEXT:    mov d2, v3.d[1]
; CHECK-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-NEXT:    fcvt h1, d2
; CHECK-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-NEXT:    ret
  %1 = fptrunc <8 x double> %a to <8 x half>
  ret <8 x half> %1
}

define <8 x float> @h_to_s(<8 x half> %a) {
; CHECK-LABEL: h_to_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NEXT:    ret
  %1 = fpext <8 x half> %a to <8 x float>
  ret <8 x float> %1
}

define <8 x double> @h_to_d(<8 x half> %a) {
; CHECK-LABEL: h_to_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    mov h3, v0.h[3]
; CHECK-NEXT:    mov h4, v0.h[2]
; CHECK-NEXT:    fcvt d0, h0
; CHECK-NEXT:    mov h5, v2.h[1]
; CHECK-NEXT:    mov h6, v2.h[3]
; CHECK-NEXT:    mov h7, v2.h[2]
; CHECK-NEXT:    fcvt d16, h1
; CHECK-NEXT:    fcvt d17, h3
; CHECK-NEXT:    fcvt d1, h4
; CHECK-NEXT:    fcvt d2, h2
; CHECK-NEXT:    fcvt d4, h5
; CHECK-NEXT:    fcvt d5, h6
; CHECK-NEXT:    fcvt d3, h7
; CHECK-NEXT:    mov v0.d[1], v16.d[0]
; CHECK-NEXT:    mov v1.d[1], v17.d[0]
; CHECK-NEXT:    mov v2.d[1], v4.d[0]
; CHECK-NEXT:    mov v3.d[1], v5.d[0]
; CHECK-NEXT:    ret
  %1 = fpext <8 x half> %a to <8 x double>
  ret <8 x double> %1
}


define <8 x half> @bitcast_i_to_h(float, <8 x i16> %a) {
; CHECK-LABEL: bitcast_i_to_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = bitcast <8 x i16> %a to <8 x half>
  ret <8 x half> %2
}

define <8 x i16> @bitcast_h_to_i(float, <8 x half> %a) {
; CHECK-LABEL: bitcast_h_to_i:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = bitcast <8 x half> %a to <8 x i16>
  ret <8 x i16> %2
}

define <4 x half> @sitofp_v4i8(<4 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_v4i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-CVT-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_v4i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = sitofp <4 x i8> %a to <4 x half>
  ret <4 x half> %1
}

define <8 x half> @sitofp_v8i8(<8 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_v8i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_v8i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = sitofp <8 x i8> %a to <8 x half>
  ret <8 x half> %1
}

define <16 x half> @sitofp_v16i8(<16 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_v16i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-CVT-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    sshll2 v2.4s, v1.8h, #0
; CHECK-CVT-NEXT:    sshll v1.4s, v1.4h, #0
; CHECK-CVT-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    scvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    scvtf v3.4s, v3.4s
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v2.4h, v2.4s
; CHECK-CVT-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-CVT-NEXT:    fcvtn v3.4h, v3.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-CVT-NEXT:    mov v0.d[1], v3.d[0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_v16i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-FP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-FP16-NEXT:    scvtf v1.8h, v1.8h
; CHECK-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = sitofp <16 x i8> %a to <16 x half>
  ret <16 x half> %1
}

define <8 x half> @sitofp_i16(<8 x i16> %a) #0 {
; CHECK-CVT-LABEL: sitofp_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = sitofp <8 x i16> %a to <8 x half>
  ret <8 x half> %1
}

define <8 x half> @sitofp_i32(<8 x i32> %a) #0 {
; CHECK-LABEL: sitofp_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf v1.4s, v1.4s
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %1 = sitofp <8 x i32> %a to <8 x half>
  ret <8 x half> %1
}


define <8 x half> @sitofp_i64(<8 x i64> %a) #0 {
; CHECK-LABEL: sitofp_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    scvtf v2.2d, v2.2d
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    scvtf v3.2d, v3.2d
; CHECK-NEXT:    scvtf v1.2d, v1.2d
; CHECK-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %1 = sitofp <8 x i64> %a to <8 x half>
  ret <8 x half> %1
}

define <4 x half> @uitofp_v4i8(<4 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_v4i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_v4i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = uitofp <4 x i8> %a to <4 x half>
  ret <4 x half> %1
}

define <8 x half> @uitofp_v8i8(<8 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_v8i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_v8i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = uitofp <8 x i8> %a to <8 x half>
  ret <8 x half> %1
}

define <16 x half> @uitofp_v16i8(<16 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_v16i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll2 v1.8h, v0.16b, #0
; CHECK-CVT-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    ushll2 v2.4s, v1.8h, #0
; CHECK-CVT-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-CVT-NEXT:    ushll2 v3.4s, v0.8h, #0
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v2.4h, v2.4s
; CHECK-CVT-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-CVT-NEXT:    fcvtn v3.4h, v3.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-CVT-NEXT:    mov v0.d[1], v3.d[0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_v16i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ushll2 v1.8h, v0.16b, #0
; CHECK-FP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-FP16-NEXT:    ucvtf v1.8h, v1.8h
; CHECK-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = uitofp <16 x i8> %a to <16 x half>
  ret <16 x half> %1
}


define <8 x half> @uitofp_i16(<8 x i16> %a) #0 {
; CHECK-CVT-LABEL: uitofp_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = uitofp <8 x i16> %a to <8 x half>
  ret <8 x half> %1
}


define <8 x half> @uitofp_i32(<8 x i32> %a) #0 {
; CHECK-LABEL: uitofp_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %1 = uitofp <8 x i32> %a to <8 x half>
  ret <8 x half> %1
}


define <8 x half> @uitofp_i64(<8 x i64> %a) #0 {
; CHECK-LABEL: uitofp_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
  %1 = uitofp <8 x i64> %a to <8 x half>
  ret <8 x half> %1
}

define void @test_insert_at_zero(half %a, ptr %b) #0 {
; CHECK-LABEL: test_insert_at_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $q0
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %1 = insertelement <8 x half> undef, half %a, i64 0
  store <8 x half> %1, ptr %b, align 4
  ret void
}

define <8 x i8> @fptosi_i8(<8 x half> %a) #0 {
; CHECK-CVT-LABEL: fptosi_i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-CVT-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-CVT-NEXT:    xtn v0.8b, v0.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptosi_i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs v0.8h, v0.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fptosi<8 x half> %a to <8 x i8>
  ret <8 x i8> %1
}

define <8 x i16> @fptosi_i16(<8 x half> %a) #0 {
; CHECK-CVT-LABEL: fptosi_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-CVT-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptosi_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fptosi<8 x half> %a to <8 x i16>
  ret <8 x i16> %1
}

define <8 x i8> @fptoui_i8(<8 x half> %a) #0 {
; CHECK-CVT-LABEL: fptoui_i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-CVT-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-CVT-NEXT:    xtn v0.8b, v0.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptoui_i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fptoui<8 x half> %a to <8 x i8>
  ret <8 x i8> %1
}

define <8 x i16> @fptoui_i16(<8 x half> %a) #0 {
; CHECK-CVT-LABEL: fptoui_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl2 v1.4s, v0.8h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-CVT-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptoui_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu v0.8h, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fptoui<8 x half> %a to <8 x i16>
  ret <8 x i16> %1
}

define <8 x i1> @test_fcmp_une(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_une:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, ne
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, ne
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_une:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmeq v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp une <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ueq(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ueq:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v0.h[4]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, vc
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, eq
; CHECK-CVT-NEXT:    csinv w9, w9, wzr, vc
; CHECK-CVT-NEXT:    fcvt s4, h4
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fmov s3, w9
; CHECK-CVT-NEXT:    mov h5, v1.h[4]
; CHECK-CVT-NEXT:    csetm w9, eq
; CHECK-CVT-NEXT:    mov v3.h[1], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, vc
; CHECK-CVT-NEXT:    fcmp s2, s4
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    mov h5, v1.h[5]
; CHECK-CVT-NEXT:    mov h6, v0.h[5]
; CHECK-CVT-NEXT:    csetm w9, eq
; CHECK-CVT-NEXT:    mov v3.h[2], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, vc
; CHECK-CVT-NEXT:    fcmp s4, s2
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    csetm w9, eq
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    mov v3.h[3], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, vc
; CHECK-CVT-NEXT:    fcmp s4, s2
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    csetm w9, eq
; CHECK-CVT-NEXT:    mov v3.h[4], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, vc
; CHECK-CVT-NEXT:    fcmp s4, s2
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v3.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, vc
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v3.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, vc
; CHECK-CVT-NEXT:    mov v3.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v3.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ueq:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v2.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    fcmgt v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ueq <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ugt(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ugt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, hi
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, hi
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ugt:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ugt <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_uge(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_uge:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, pl
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, pl
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_uge:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp uge <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ult(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ult:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, lt
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, lt
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ult:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ult <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ule(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ule:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, le
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, le
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ule:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ule <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_uno(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_uno:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, vs
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, vs
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_uno:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v2.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    fcmgt v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-FP16-NEXT:    mvn v0.16b, v0.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp uno <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_one(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_one:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v0.h[4]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, le
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, mi
; CHECK-CVT-NEXT:    csinv w9, w9, wzr, le
; CHECK-CVT-NEXT:    fcvt s4, h4
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fmov s3, w9
; CHECK-CVT-NEXT:    mov h5, v1.h[4]
; CHECK-CVT-NEXT:    csetm w9, mi
; CHECK-CVT-NEXT:    mov v3.h[1], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, le
; CHECK-CVT-NEXT:    fcmp s2, s4
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    mov h5, v1.h[5]
; CHECK-CVT-NEXT:    mov h6, v0.h[5]
; CHECK-CVT-NEXT:    csetm w9, mi
; CHECK-CVT-NEXT:    mov v3.h[2], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, le
; CHECK-CVT-NEXT:    fcmp s4, s2
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    csetm w9, mi
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    mov v3.h[3], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, le
; CHECK-CVT-NEXT:    fcmp s4, s2
; CHECK-CVT-NEXT:    fcvt s2, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    csetm w9, mi
; CHECK-CVT-NEXT:    mov v3.h[4], w8
; CHECK-CVT-NEXT:    csinv w8, w9, wzr, le
; CHECK-CVT-NEXT:    fcmp s4, s2
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v3.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, le
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v3.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    csinv w8, w8, wzr, le
; CHECK-CVT-NEXT:    mov v3.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v3.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_one:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v2.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    fcmgt v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp one <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_oeq(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_oeq:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, eq
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, eq
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_oeq:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmeq v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp oeq <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ogt(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ogt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, gt
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, gt
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ogt:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ogt <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_oge(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_oge:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, ge
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, ge
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_oge:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp oge <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_olt(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_olt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, mi
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, mi
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_olt:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp olt <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ole(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ole:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, ls
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, ls
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ole:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ole <8 x half> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ord(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ord:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    mov h2, v1.h[1]
; CHECK-CVT-NEXT:    mov h3, v0.h[1]
; CHECK-CVT-NEXT:    fcvt s4, h1
; CHECK-CVT-NEXT:    fcvt s5, h0
; CHECK-CVT-NEXT:    mov h6, v1.h[4]
; CHECK-CVT-NEXT:    mov h7, v0.h[4]
; CHECK-CVT-NEXT:    mov h16, v1.h[5]
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    fcvt s6, h6
; CHECK-CVT-NEXT:    fcvt s7, h7
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    mov h2, v1.h[2]
; CHECK-CVT-NEXT:    mov h3, v0.h[2]
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    fcmp s5, s4
; CHECK-CVT-NEXT:    fcvt s2, h2
; CHECK-CVT-NEXT:    mov h4, v1.h[3]
; CHECK-CVT-NEXT:    fcvt s3, h3
; CHECK-CVT-NEXT:    mov h5, v0.h[3]
; CHECK-CVT-NEXT:    csetm w9, vc
; CHECK-CVT-NEXT:    fcmp s3, s2
; CHECK-CVT-NEXT:    fmov s2, w9
; CHECK-CVT-NEXT:    fcvt s3, h4
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v0.h[5]
; CHECK-CVT-NEXT:    mov v2.h[1], w8
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h16
; CHECK-CVT-NEXT:    fcvt s4, h5
; CHECK-CVT-NEXT:    mov h5, v1.h[6]
; CHECK-CVT-NEXT:    mov v2.h[2], w8
; CHECK-CVT-NEXT:    mov h1, v1.h[7]
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    fcmp s7, s6
; CHECK-CVT-NEXT:    mov h6, v0.h[6]
; CHECK-CVT-NEXT:    mov h0, v0.h[7]
; CHECK-CVT-NEXT:    mov v2.h[3], w8
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    fcvt s3, h5
; CHECK-CVT-NEXT:    fcvt s4, h6
; CHECK-CVT-NEXT:    fcvt s1, h1
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    mov v2.h[4], w8
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    fcmp s4, s3
; CHECK-CVT-NEXT:    mov v2.h[5], w8
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    fcmp s0, s1
; CHECK-CVT-NEXT:    mov v2.h[6], w8
; CHECK-CVT-NEXT:    csetm w8, vc
; CHECK-CVT-NEXT:    mov v2.h[7], w8
; CHECK-CVT-NEXT:    xtn v0.8b, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ord:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v2.8h, v0.8h, v1.8h
; CHECK-FP16-NEXT:    fcmgt v0.8h, v1.8h, v0.8h
; CHECK-FP16-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-FP16-NEXT:    xtn v0.8b, v0.8h
; CHECK-FP16-NEXT:    ret
  %1 = fcmp ord <8 x half> %a, %b
  ret <8 x i1> %1
}

attributes #0 = { nounwind }
