; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -S -mtriple=riscv64 -mattr=+v,+f,+d -riscv-v-vector-bits-min=-1 | FileCheck %s

define void @sin() {
; CHECK-LABEL: 'sin'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.sin.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.sin.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.sin.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.sin.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.sin.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.sin.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.sin.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.sin.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.sin.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.sin.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.sin.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.sin.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.sin.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.sin.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.sin.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.sin.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.sin.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.sin.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.sin.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.sin.f32(float undef)
  call <2 x float> @llvm.sin.v2f32(<2 x float> undef)
  call <4 x float> @llvm.sin.v4f32(<4 x float> undef)
  call <8 x float> @llvm.sin.v8f32(<8 x float> undef)
  call <16 x float> @llvm.sin.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.sin.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.sin.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.sin.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.sin.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.sin.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.sin.f64(double undef)
  call <2 x double> @llvm.sin.v2f64(<2 x double> undef)
  call <4 x double> @llvm.sin.v4f64(<4 x double> undef)
  call <8 x double> @llvm.sin.v8f64(<8 x double> undef)
  call <16 x double> @llvm.sin.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.sin.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.sin.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.sin.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.sin.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @cos() {
; CHECK-LABEL: 'cos'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.cos.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.cos.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.cos.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.cos.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.cos.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.cos.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.cos.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.cos.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.cos.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.cos.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.cos.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.cos.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.cos.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.cos.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.cos.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.cos.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.cos.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.cos.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.cos.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.cos.f32(float undef)
  call <2 x float> @llvm.cos.v2f32(<2 x float> undef)
  call <4 x float> @llvm.cos.v4f32(<4 x float> undef)
  call <8 x float> @llvm.cos.v8f32(<8 x float> undef)
  call <16 x float> @llvm.cos.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.cos.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.cos.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.cos.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.cos.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.cos.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.cos.f64(double undef)
  call <2 x double> @llvm.cos.v2f64(<2 x double> undef)
  call <4 x double> @llvm.cos.v4f64(<4 x double> undef)
  call <8 x double> @llvm.cos.v8f64(<8 x double> undef)
  call <16 x double> @llvm.cos.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.cos.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.cos.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.cos.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.cos.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @exp() {
; CHECK-LABEL: 'exp'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.exp.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.exp.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.exp.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.exp.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.exp.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.exp.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.exp.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.exp.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.exp.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.exp.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.exp.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.exp.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.exp.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.exp.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.exp.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.exp.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.exp.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.exp.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.exp.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.exp.f32(float undef)
  call <2 x float> @llvm.exp.v2f32(<2 x float> undef)
  call <4 x float> @llvm.exp.v4f32(<4 x float> undef)
  call <8 x float> @llvm.exp.v8f32(<8 x float> undef)
  call <16 x float> @llvm.exp.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.exp.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.exp.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.exp.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.exp.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.exp.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.exp.f64(double undef)
  call <2 x double> @llvm.exp.v2f64(<2 x double> undef)
  call <4 x double> @llvm.exp.v4f64(<4 x double> undef)
  call <8 x double> @llvm.exp.v8f64(<8 x double> undef)
  call <16 x double> @llvm.exp.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.exp.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.exp.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.exp.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.exp.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @exp2() {
; CHECK-LABEL: 'exp2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.exp2.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.exp2.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.exp2.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.exp2.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.exp2.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.exp2.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.exp2.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.exp2.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.exp2.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.exp2.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.exp2.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.exp2.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.exp2.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.exp2.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.exp2.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.exp2.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.exp2.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.exp2.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.exp2.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.exp2.f32(float undef)
  call <2 x float> @llvm.exp2.v2f32(<2 x float> undef)
  call <4 x float> @llvm.exp2.v4f32(<4 x float> undef)
  call <8 x float> @llvm.exp2.v8f32(<8 x float> undef)
  call <16 x float> @llvm.exp2.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.exp2.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.exp2.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.exp2.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.exp2.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.exp2.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.exp2.f64(double undef)
  call <2 x double> @llvm.exp2.v2f64(<2 x double> undef)
  call <4 x double> @llvm.exp2.v4f64(<4 x double> undef)
  call <8 x double> @llvm.exp2.v8f64(<8 x double> undef)
  call <16 x double> @llvm.exp2.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.exp2.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.exp2.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.exp2.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.exp2.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @log() {
; CHECK-LABEL: 'log'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.log.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.log.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.log.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.log.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.log.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.log.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.log.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.log.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.log.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.log.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.log.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.log.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.log.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.log.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.log.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.log.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.log.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.log.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.log.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.log.f32(float undef)
  call <2 x float> @llvm.log.v2f32(<2 x float> undef)
  call <4 x float> @llvm.log.v4f32(<4 x float> undef)
  call <8 x float> @llvm.log.v8f32(<8 x float> undef)
  call <16 x float> @llvm.log.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.log.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.log.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.log.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.log.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.log.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.log.f64(double undef)
  call <2 x double> @llvm.log.v2f64(<2 x double> undef)
  call <4 x double> @llvm.log.v4f64(<4 x double> undef)
  call <8 x double> @llvm.log.v8f64(<8 x double> undef)
  call <16 x double> @llvm.log.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.log.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.log.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.log.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.log.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @log10() {
; CHECK-LABEL: 'log10'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.log10.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.log10.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.log10.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.log10.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.log10.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.log10.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.log10.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.log10.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.log10.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.log10.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.log10.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.log10.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.log10.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.log10.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.log10.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.log10.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.log10.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.log10.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.log10.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.log10.f32(float undef)
  call <2 x float> @llvm.log10.v2f32(<2 x float> undef)
  call <4 x float> @llvm.log10.v4f32(<4 x float> undef)
  call <8 x float> @llvm.log10.v8f32(<8 x float> undef)
  call <16 x float> @llvm.log10.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.log10.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.log10.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.log10.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.log10.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.log10.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.log10.f64(double undef)
  call <2 x double> @llvm.log10.v2f64(<2 x double> undef)
  call <4 x double> @llvm.log10.v4f64(<4 x double> undef)
  call <8 x double> @llvm.log10.v8f64(<8 x double> undef)
  call <16 x double> @llvm.log10.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.log10.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.log10.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.log10.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.log10.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @log2() {
; CHECK-LABEL: 'log2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.log2.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.log2.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.log2.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.log2.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.log2.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.log2.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.log2.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.log2.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.log2.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.log2.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.log2.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.log2.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.log2.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.log2.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.log2.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.log2.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.log2.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.log2.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.log2.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.log2.f32(float undef)
  call <2 x float> @llvm.log2.v2f32(<2 x float> undef)
  call <4 x float> @llvm.log2.v4f32(<4 x float> undef)
  call <8 x float> @llvm.log2.v8f32(<8 x float> undef)
  call <16 x float> @llvm.log2.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.log2.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.log2.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.log2.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.log2.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.log2.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.log2.f64(double undef)
  call <2 x double> @llvm.log2.v2f64(<2 x double> undef)
  call <4 x double> @llvm.log2.v4f64(<4 x double> undef)
  call <8 x double> @llvm.log2.v8f64(<8 x double> undef)
  call <16 x double> @llvm.log2.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.log2.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.log2.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.log2.nvx4f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.log2.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

declare float @llvm.sin.f32(float)
declare <2 x float> @llvm.sin.v2f32(<2 x float>)
declare <4 x float> @llvm.sin.v4f32(<4 x float>)
declare <8 x float> @llvm.sin.v8f32(<8 x float>)
declare <16 x float> @llvm.sin.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.sin.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.sin.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.sin.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.sin.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.sin.nvx16f32(<vscale x 16 x float>)
declare double @llvm.sin.f64(double)
declare <2 x double> @llvm.sin.v2f64(<2 x double>)
declare <4 x double> @llvm.sin.v4f64(<4 x double>)
declare <8 x double> @llvm.sin.v8f64(<8 x double>)
declare <16 x double> @llvm.sin.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.sin.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.sin.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.sin.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.sin.nvx8f64(<vscale x 8 x double>)

declare float @llvm.cos.f32(float)
declare <2 x float> @llvm.cos.v2f32(<2 x float>)
declare <4 x float> @llvm.cos.v4f32(<4 x float>)
declare <8 x float> @llvm.cos.v8f32(<8 x float>)
declare <16 x float> @llvm.cos.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.cos.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.cos.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.cos.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.cos.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.cos.nvx16f32(<vscale x 16 x float>)
declare double @llvm.cos.f64(double)
declare <2 x double> @llvm.cos.v2f64(<2 x double>)
declare <4 x double> @llvm.cos.v4f64(<4 x double>)
declare <8 x double> @llvm.cos.v8f64(<8 x double>)
declare <16 x double> @llvm.cos.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.cos.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.cos.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.cos.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.cos.nvx8f64(<vscale x 8 x double>)

declare float @llvm.exp.f32(float)
declare <2 x float> @llvm.exp.v2f32(<2 x float>)
declare <4 x float> @llvm.exp.v4f32(<4 x float>)
declare <8 x float> @llvm.exp.v8f32(<8 x float>)
declare <16 x float> @llvm.exp.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.exp.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.exp.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.exp.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.exp.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.exp.nvx16f32(<vscale x 16 x float>)
declare double @llvm.exp.f64(double)
declare <2 x double> @llvm.exp.v2f64(<2 x double>)
declare <4 x double> @llvm.exp.v4f64(<4 x double>)
declare <8 x double> @llvm.exp.v8f64(<8 x double>)
declare <16 x double> @llvm.exp.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.exp.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.exp.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.exp.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.exp.nvx8f64(<vscale x 8 x double>)

declare float @llvm.exp2.f32(float)
declare <2 x float> @llvm.exp2.v2f32(<2 x float>)
declare <4 x float> @llvm.exp2.v4f32(<4 x float>)
declare <8 x float> @llvm.exp2.v8f32(<8 x float>)
declare <16 x float> @llvm.exp2.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.exp2.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.exp2.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.exp2.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.exp2.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.exp2.nvx16f32(<vscale x 16 x float>)
declare double @llvm.exp2.f64(double)
declare <2 x double> @llvm.exp2.v2f64(<2 x double>)
declare <4 x double> @llvm.exp2.v4f64(<4 x double>)
declare <8 x double> @llvm.exp2.v8f64(<8 x double>)
declare <16 x double> @llvm.exp2.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.exp2.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.exp2.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.exp2.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.exp2.nvx8f64(<vscale x 8 x double>)

declare float @llvm.log.f32(float)
declare <2 x float> @llvm.log.v2f32(<2 x float>)
declare <4 x float> @llvm.log.v4f32(<4 x float>)
declare <8 x float> @llvm.log.v8f32(<8 x float>)
declare <16 x float> @llvm.log.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.log.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.log.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.log.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.log.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.log.nvx16f32(<vscale x 16 x float>)
declare double @llvm.log.f64(double)
declare <2 x double> @llvm.log.v2f64(<2 x double>)
declare <4 x double> @llvm.log.v4f64(<4 x double>)
declare <8 x double> @llvm.log.v8f64(<8 x double>)
declare <16 x double> @llvm.log.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.log.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.log.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.log.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.log.nvx8f64(<vscale x 8 x double>)

declare float @llvm.log10.f32(float)
declare <2 x float> @llvm.log10.v2f32(<2 x float>)
declare <4 x float> @llvm.log10.v4f32(<4 x float>)
declare <8 x float> @llvm.log10.v8f32(<8 x float>)
declare <16 x float> @llvm.log10.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.log10.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.log10.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.log10.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.log10.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.log10.nvx16f32(<vscale x 16 x float>)
declare double @llvm.log10.f64(double)
declare <2 x double> @llvm.log10.v2f64(<2 x double>)
declare <4 x double> @llvm.log10.v4f64(<4 x double>)
declare <8 x double> @llvm.log10.v8f64(<8 x double>)
declare <16 x double> @llvm.log10.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.log10.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.log10.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.log10.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.log10.nvx8f64(<vscale x 8 x double>)

declare float @llvm.log2.f32(float)
declare <2 x float> @llvm.log2.v2f32(<2 x float>)
declare <4 x float> @llvm.log2.v4f32(<4 x float>)
declare <8 x float> @llvm.log2.v8f32(<8 x float>)
declare <16 x float> @llvm.log2.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.log2.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.log2.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.log2.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.log2.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.log2.nvx16f32(<vscale x 16 x float>)
declare double @llvm.log2.f64(double)
declare <2 x double> @llvm.log2.v2f64(<2 x double>)
declare <4 x double> @llvm.log2.v4f64(<4 x double>)
declare <8 x double> @llvm.log2.v8f64(<8 x double>)
declare <16 x double> @llvm.log2.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.log2.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.log2.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.log2.nvx4f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.log2.nvx8f64(<vscale x 8 x double>)
