; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK

define arm_aapcs_vfpcc i32 @test1(ptr %ptr, i32 %arg1, <4 x i32> %arg2, <4 x i32> %arg3) {
; CHECK-LABEL: test1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vaddv.u32 r2, q1
; CHECK-NEXT:    vaddva.u32 r2, q0
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    adds r0, r2, r1
; CHECK-NEXT:    bx lr
entry:
  %reduce1 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg2)
  %reduce2 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg3)
  %add1 = add i32 %reduce1, %reduce2
  store i32 %add1, i32* %ptr, align 4
  %add2 = add i32 %add1, %arg1
  ret i32 %add2
}

define arm_aapcs_vfpcc i32 @test2(ptr %ptr, i32 %arg1, <4 x i32> %arg2, <4 x i32> %arg3) {
; CHECK-LABEL: test2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vaddv.u32 r2, q1
; CHECK-NEXT:    vaddva.u32 r2, q0
; CHECK-NEXT:    str r2, [r0]
; CHECK-NEXT:    adds r0, r1, r2
; CHECK-NEXT:    bx lr
entry:
  %reduce1 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg2)
  %reduce2 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg3)
  %add1 = add i32 %reduce1, %reduce2
  store i32 %add1, i32* %ptr, align 4
  %add2 = add i32 %arg1, %add1
  ret i32 %add2
}

define arm_aapcs_vfpcc i32 @test3(ptr %ptr, i32 %arg1, i32 %arg2, <4 x i32> %arg3, <4 x i32> %arg4) {
; CHECK-LABEL: test3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    mov r12, r1
; CHECK-NEXT:    vaddva.u32 r2, q1
; CHECK-NEXT:    vaddva.u32 r12, q0
; CHECK-NEXT:    str.w r12, [r0]
; CHECK-NEXT:    add.w r0, r12, r2
; CHECK-NEXT:    bx lr
entry:
  %reduce1 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg3)
  %reduce2 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %arg4)
  %add1 = add i32 %arg1, %reduce1
  store i32 %add1, i32* %ptr, align 4
  %add2 = add i32 %arg2, %reduce2
  %add3 = add i32 %add1, %add2
  ret i32 %add3
}

define arm_aapcs_vfpcc i32 @test4(ptr %ptr, i32 %arg1, ptr %arg2) {
; CHECK-LABEL: test4:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r2]
; CHECK-NEXT:    mov r12, r1
; CHECK-NEXT:    vaddva.u32 r12, q0
; CHECK-NEXT:    vldrw.u32 q0, [r2, #4]
; CHECK-NEXT:    str.w r12, [r0]
; CHECK-NEXT:    vaddva.u32 r12, q0
; CHECK-NEXT:    mov r0, r12
; CHECK-NEXT:    bx lr
entry:
  %load1 = load <4 x i32>, <4 x i32>* %arg2, align 4
  %gep = getelementptr inbounds i32, i32* %arg2, i32 1
  %load2 = load <4 x i32>, <4 x i32>* %gep, align 4
  %reduce1 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %load1)
  %reduce2 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %load2)
  %add1 = add i32 %arg1, %reduce1
  store i32 %add1, i32* %ptr, align 4
  %add2 = add i32 %add1, %reduce2
  ret i32 %add2
}

define arm_aapcs_vfpcc i32 @test5(ptr %ptr, i32 %arg1, ptr %arg2) {
; CHECK-LABEL: test5:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q0, [r2, #4]
; CHECK-NEXT:    mov r12, r1
; CHECK-NEXT:    vaddva.u32 r12, q0
; CHECK-NEXT:    vldrw.u32 q0, [r2]
; CHECK-NEXT:    str.w r12, [r0]
; CHECK-NEXT:    vaddva.u32 r12, q0
; CHECK-NEXT:    mov r0, r12
; CHECK-NEXT:    bx lr
entry:
  %load1 = load <4 x i32>, <4 x i32>* %arg2, align 4
  %gep = getelementptr inbounds i32, i32* %arg2, i32 1
  %load2 = load <4 x i32>, <4 x i32>* %gep, align 4
  %reduce1 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %load1)
  %reduce2 = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %load2)
  %add1 = add i32 %arg1, %reduce2
  store i32 %add1, i32* %ptr, align 4
  %add2 = add i32 %add1, %reduce1
  ret i32 %add2
}

define arm_aapcs_vfpcc i16 @vaddv_shuffle_v16i8(<16 x i8> %s0) {
; CHECK-LABEL: vaddv_shuffle_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vaddv.u8 r0, q0
; CHECK-NEXT:    bx lr
entry:
  %s2 = shufflevector <16 x i8> %s0, <16 x i8> %s0, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %s1 = zext <16 x i8> %s2 to <16 x i16>
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s1)
  ret i16 %result
}

define arm_aapcs_vfpcc i16 @vaddv_shuffle_v16i8_duplicate(<16 x i8> %s0) {
; CHECK-LABEL: vaddv_shuffle_v16i8_duplicate:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.u8 r1, q0[2]
; CHECK-NEXT:    vmov.8 q1[0], r0
; CHECK-NEXT:    vmov.8 q1[1], r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.8 q1[2], r1
; CHECK-NEXT:    vmov.u8 r1, q0[6]
; CHECK-NEXT:    vmov.8 q1[3], r1
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    vmov.8 q1[4], r1
; CHECK-NEXT:    vmov.u8 r1, q0[10]
; CHECK-NEXT:    vmov.8 q1[5], r1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.8 q1[6], r1
; CHECK-NEXT:    vmov.u8 r1, q0[14]
; CHECK-NEXT:    vmov.8 q1[7], r1
; CHECK-NEXT:    vmov.8 q1[8], r0
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    vmov.8 q1[9], r0
; CHECK-NEXT:    vmov.u8 r0, q0[5]
; CHECK-NEXT:    vmov.8 q1[10], r0
; CHECK-NEXT:    vmov.u8 r0, q0[7]
; CHECK-NEXT:    vmov.8 q1[11], r0
; CHECK-NEXT:    vmov.u8 r0, q0[9]
; CHECK-NEXT:    vmov.8 q1[12], r0
; CHECK-NEXT:    vmov.u8 r0, q0[11]
; CHECK-NEXT:    vmov.8 q1[13], r0
; CHECK-NEXT:    vmov.u8 r0, q0[13]
; CHECK-NEXT:    vmov.8 q1[14], r0
; CHECK-NEXT:    vmov.u8 r0, q0[15]
; CHECK-NEXT:    vmov.8 q1[15], r0
; CHECK-NEXT:    vaddv.u8 r0, q1
; CHECK-NEXT:    bx lr
entry:
  %s2 = shufflevector <16 x i8> %s0, <16 x i8> %s0, <16 x i32> <i32 1, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %s1 = zext <16 x i8> %s2 to <16 x i16>
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s1)
  ret i16 %result
}

define arm_aapcs_vfpcc i16 @vaddv_shuffle_v16i8_undef(<16 x i8> %s0) {
; CHECK-LABEL: vaddv_shuffle_v16i8_undef:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vmov.8 q1[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[4]
; CHECK-NEXT:    vmov.8 q1[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[6]
; CHECK-NEXT:    vmov.8 q1[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[8]
; CHECK-NEXT:    vmov.8 q1[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[10]
; CHECK-NEXT:    vmov.8 q1[5], r0
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.8 q1[6], r0
; CHECK-NEXT:    vmov.u8 r0, q0[14]
; CHECK-NEXT:    vmov.8 q1[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.8 q1[8], r0
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    vmov.8 q1[9], r0
; CHECK-NEXT:    vmov.u8 r0, q0[5]
; CHECK-NEXT:    vmov.8 q1[10], r0
; CHECK-NEXT:    vmov.u8 r0, q0[7]
; CHECK-NEXT:    vmov.8 q1[11], r0
; CHECK-NEXT:    vmov.u8 r0, q0[9]
; CHECK-NEXT:    vmov.8 q1[12], r0
; CHECK-NEXT:    vmov.u8 r0, q0[11]
; CHECK-NEXT:    vmov.8 q1[13], r0
; CHECK-NEXT:    vmov.u8 r0, q0[13]
; CHECK-NEXT:    vmov.8 q1[14], r0
; CHECK-NEXT:    vmov.u8 r0, q0[15]
; CHECK-NEXT:    vmov.8 q1[15], r0
; CHECK-NEXT:    vaddv.u8 r0, q1
; CHECK-NEXT:    bx lr
entry:
  %s2 = shufflevector <16 x i8> %s0, <16 x i8> %s0, <16 x i32> <i32 undef, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %s1 = zext <16 x i8> %s2 to <16 x i16>
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s1)
  ret i16 %result
}

define arm_aapcs_vfpcc i64 @vaddv_shuffle_v4i32_long(<4 x i32> %s0) {
; CHECK-LABEL: vaddv_shuffle_v4i32_long:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vaddlv.u32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %s2 = shufflevector <4 x i32> %s0, <4 x i32> %s0, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s1 = zext <4 x i32> %s2 to <4 x i64>
  %r = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s1)
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @vaddv_shuffle_v4i32_long_a(<4 x i32> %s0, i64 %a) {
; CHECK-LABEL: vaddv_shuffle_v4i32_long_a:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vaddlva.u32 r0, r1, q0
; CHECK-NEXT:    bx lr
entry:
  %s2 = shufflevector <4 x i32> %s0, <4 x i32> %s0, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s1 = zext <4 x i32> %s2 to <4 x i64>
  %r = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s1)
  %r2 = add i64 %r, %a
  ret i64 %r2
}

define arm_aapcs_vfpcc i16 @vmla_shuffle_v16i8(<16 x i8> %s0, <16 x i8> %s0b) {
; CHECK-LABEL: vmla_shuffle_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlav.s8 r0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s2a = shufflevector <16 x i8> %s0, <16 x i8> %s0, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %s1a = sext <16 x i8> %s2a to <16 x i16>
  %s2b = shufflevector <16 x i8> %s0b, <16 x i8> %s0, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %s1b = sext <16 x i8> %s2b to <16 x i16>
  %s1 = mul <16 x i16> %s1a, %s1b
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s1)
  ret i16 %result
}

define arm_aapcs_vfpcc i16 @vmla_shuffle_v16i8_unequal(<16 x i8> %s0, <16 x i8> %s0b) {
; CHECK-LABEL: vmla_shuffle_v16i8_unequal:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q1[0]
; CHECK-NEXT:    vmov.8 q2[0], r0
; CHECK-NEXT:    vmov.u8 r0, q1[2]
; CHECK-NEXT:    vmov.8 q2[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[4]
; CHECK-NEXT:    vmov.8 q2[2], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.8 q2[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.8 q2[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.8 q2[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.8 q2[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q2[7], r0
; CHECK-NEXT:    vmov.u8 r0, q1[1]
; CHECK-NEXT:    vmov.8 q2[8], r0
; CHECK-NEXT:    vmov.u8 r0, q1[3]
; CHECK-NEXT:    vmov.8 q2[9], r0
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.8 q2[10], r0
; CHECK-NEXT:    vmov.u8 r0, q1[7]
; CHECK-NEXT:    vmov.8 q2[11], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.8 q2[12], r0
; CHECK-NEXT:    vmov.u8 r0, q1[11]
; CHECK-NEXT:    vmov.8 q2[13], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.8 q2[14], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.8 q2[15], r0
; CHECK-NEXT:    vmov.u8 r0, q0[0]
; CHECK-NEXT:    vmov.8 q1[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vmov.8 q1[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[4]
; CHECK-NEXT:    vmov.8 q1[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[6]
; CHECK-NEXT:    vmov.8 q1[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[8]
; CHECK-NEXT:    vmov.8 q1[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[10]
; CHECK-NEXT:    vmov.8 q1[5], r0
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.8 q1[6], r0
; CHECK-NEXT:    vmov.u8 r0, q0[14]
; CHECK-NEXT:    vmov.8 q1[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.8 q1[8], r0
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    vmov.8 q1[9], r0
; CHECK-NEXT:    vmov.u8 r0, q0[5]
; CHECK-NEXT:    vmov.8 q1[10], r0
; CHECK-NEXT:    vmov.u8 r0, q0[7]
; CHECK-NEXT:    vmov.8 q1[11], r0
; CHECK-NEXT:    vmov.u8 r0, q0[9]
; CHECK-NEXT:    vmov.8 q1[12], r0
; CHECK-NEXT:    vmov.u8 r0, q0[11]
; CHECK-NEXT:    vmov.8 q1[13], r0
; CHECK-NEXT:    vmov.u8 r0, q0[13]
; CHECK-NEXT:    vmov.8 q1[14], r0
; CHECK-NEXT:    vmov.u8 r0, q0[15]
; CHECK-NEXT:    vmov.8 q1[15], r0
; CHECK-NEXT:    vmlav.s8 r0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %s2a = shufflevector <16 x i8> %s0, <16 x i8> %s0, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %s1a = sext <16 x i8> %s2a to <16 x i16>
  %s2b = shufflevector <16 x i8> %s0b, <16 x i8> %s0, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 15, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 14>
  %s1b = sext <16 x i8> %s2b to <16 x i16>
  %s1 = mul <16 x i16> %s1a, %s1b
  %result = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %s1)
  ret i16 %result
}

define arm_aapcs_vfpcc i64 @vmla_shuffle_v4i32_long(<4 x i32> %s0, <4 x i32> %s0b) {
; CHECK-LABEL: vmla_shuffle_v4i32_long:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalv.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s2a = shufflevector <4 x i32> %s0, <4 x i32> %s0, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s1a = zext <4 x i32> %s2a to <4 x i64>
  %s2b = shufflevector <4 x i32> %s0b, <4 x i32> %s0, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s1b = zext <4 x i32> %s2b to <4 x i64>
  %s1 = mul <4 x i64> %s1a, %s1b
  %r = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s1)
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @vmla_shuffle_v4i32_long_a(<4 x i32> %s0, <4 x i32> %s0b, i64 %a) {
; CHECK-LABEL: vmla_shuffle_v4i32_long_a:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalva.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %s2a = shufflevector <4 x i32> %s0, <4 x i32> %s0, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s1a = zext <4 x i32> %s2a to <4 x i64>
  %s2b = shufflevector <4 x i32> %s0b, <4 x i32> %s0, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %s1b = zext <4 x i32> %s2b to <4 x i64>
  %s1 = mul <4 x i64> %s1a, %s1b
  %r = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %s1)
  %r2 = add i64 %r, %a
  ret i64 %r2
}

declare i32 @llvm.vector.reduce.add.v4i32(<4 x i32>)
declare i64 @llvm.vector.reduce.add.v4i64(<4 x i64>)
declare i16 @llvm.vector.reduce.add.v16i16(<16 x i16>)
