; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s
; RUN: llc < %s -mtriple=aarch64-- -global-isel -global-isel-abort=1 | FileCheck %s --check-prefix=GISEL

define <4 x i32> @sextbool_add_vector(<4 x i32> %c1, <4 x i32> %c2, <4 x i32> %x) {
; CHECK-LABEL: sextbool_add_vector:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    add v0.4s, v2.4s, v0.4s
; CHECK-NEXT:    ret
;
; GISEL-LABEL: sextbool_add_vector:
; GISEL:       // %bb.0:
; GISEL-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; GISEL-NEXT:    add v0.4s, v2.4s, v0.4s
; GISEL-NEXT:    ret
  %c = icmp eq <4 x i32> %c1, %c2
  %b = sext <4 x i1> %c to <4 x i32>
  %s = add <4 x i32> %x, %b
  ret <4 x i32> %s
}

define <4 x i32> @zextbool_sub_vector(<4 x i32> %c1, <4 x i32> %c2, <4 x i32> %x) {
; CHECK-LABEL: zextbool_sub_vector:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    add v0.4s, v2.4s, v0.4s
; CHECK-NEXT:    ret
;
; GISEL-LABEL: zextbool_sub_vector:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, .LCPI1_0
; GISEL-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; GISEL-NEXT:    ldr q3, [x8, :lo12:.LCPI1_0]
; GISEL-NEXT:    and v0.16b, v0.16b, v3.16b
; GISEL-NEXT:    sub v0.4s, v2.4s, v0.4s
; GISEL-NEXT:    ret
  %c = icmp eq <4 x i32> %c1, %c2
  %b = zext <4 x i1> %c to <4 x i32>
  %s = sub <4 x i32> %x, %b
  ret <4 x i32> %s
}

define i32 @assertsext_sub_1(i1 signext %cond, i32 %y) {
; CHECK-LABEL: assertsext_sub_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w1, w0
; CHECK-NEXT:    ret
;
; GISEL-LABEL: assertsext_sub_1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0x1
; GISEL-NEXT:    sub w0, w1, w8
; GISEL-NEXT:    ret
  %e = zext i1 %cond to i32
  %r = sub i32 %y, %e
  ret i32 %r
}

define i32 @assertsext_add_1(i1 signext %cond, i32 %y) {
; CHECK-LABEL: assertsext_add_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w0, w1, w0
; CHECK-NEXT:    ret
;
; GISEL-LABEL: assertsext_add_1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0x1
; GISEL-NEXT:    add w0, w8, w1
; GISEL-NEXT:    ret
  %e = zext i1 %cond to i32
  %r = add i32 %e, %y
  ret i32 %r
}

define i32 @assertsext_add_1_commute(i1 signext %cond, i32 %y) {
; CHECK-LABEL: assertsext_add_1_commute:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w0, w1, w0
; CHECK-NEXT:    ret
;
; GISEL-LABEL: assertsext_add_1_commute:
; GISEL:       // %bb.0:
; GISEL-NEXT:    and w8, w0, #0x1
; GISEL-NEXT:    add w0, w1, w8
; GISEL-NEXT:    ret
  %e = zext i1 %cond to i32
  %r = add i32 %y, %e
  ret i32 %r
}

define i32 @callee_signext_i1(i1 signext %0) {
; CHECK-LABEL: callee_signext_i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
;
; GISEL-LABEL: callee_signext_i1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    ret
  %r = sext i1 %0 to i32
  ret i32 %r
}

define i32 @caller_signext_i1() {
; CHECK-LABEL: caller_signext_i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    mov w0, #-1
; CHECK-NEXT:    bl callee_signext_i1
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; GISEL-LABEL: caller_signext_i1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; GISEL-NEXT:    .cfi_def_cfa_offset 16
; GISEL-NEXT:    .cfi_offset w30, -16
; GISEL-NEXT:    mov w8, #1
; GISEL-NEXT:    sbfx w0, w8, #0, #1
; GISEL-NEXT:    bl callee_signext_i1
; GISEL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; GISEL-NEXT:    ret
  %r = call i32 @callee_signext_i1(i1 signext true)
  ret i32 %r
}
