; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s


target triple = "aarch64-unknown-linux-gnu"

;
; truncate i16 -> i8
;

define <16 x i8> @trunc_v16i16_v16i8(ptr %in) nounwind {
; CHECK-LABEL: trunc_v16i16_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %in
  %b = trunc <16 x i16> %a to <16 x i8>
  ret <16 x i8> %b
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v32i16_v32i8(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v32i16_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z3.b, z3.b, z3.b
; CHECK-NEXT:    uzp1 z2.b, z2.b, z2.b
; CHECK-NEXT:    splice z3.b, p0, z3.b, z2.b
; CHECK-NEXT:    add z1.b, z3.b, z3.b
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i16>, ptr %in
  %b = trunc <32 x i16> %a to <32 x i8>
  %c = add <32 x i8> %b, %b
  store <32 x i8> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v64i16_v64i8(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v64i16_v64i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #64]
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ldp q2, q3, [x0, #96]
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z2.b, z2.b, z2.b
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z3.b, z3.b, z3.b
; CHECK-NEXT:    splice z2.b, p0, z2.b, z3.b
; CHECK-NEXT:    uzp1 z4.b, z4.b, z4.b
; CHECK-NEXT:    ldp q6, q7, [x0, #32]
; CHECK-NEXT:    uzp1 z1.b, z5.b, z5.b
; CHECK-NEXT:    splice z4.b, p0, z4.b, z1.b
; CHECK-NEXT:    uzp1 z3.b, z6.b, z6.b
; CHECK-NEXT:    uzp1 z1.b, z7.b, z7.b
; CHECK-NEXT:    splice z3.b, p0, z3.b, z1.b
; CHECK-NEXT:    add z1.b, z2.b, z2.b
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    add z0.b, z4.b, z4.b
; CHECK-NEXT:    add z1.b, z3.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <64 x i16>, ptr %in
  %b = trunc <64 x i16> %a to <64 x i8>
  %c = add <64 x i8> %b, %b
  store <64 x i8> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v128i16_v128i8(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v128i16_v128i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #192]
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    ldp q2, q3, [x0, #224]
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z2.b, z2.b, z2.b
; CHECK-NEXT:    ldp q6, q7, [x0, #128]
; CHECK-NEXT:    uzp1 z3.b, z3.b, z3.b
; CHECK-NEXT:    splice z2.b, p0, z2.b, z3.b
; CHECK-NEXT:    add z2.b, z2.b, z2.b
; CHECK-NEXT:    uzp1 z6.b, z6.b, z6.b
; CHECK-NEXT:    ldp q1, q3, [x0, #160]
; CHECK-NEXT:    uzp1 z7.b, z7.b, z7.b
; CHECK-NEXT:    splice z6.b, p0, z6.b, z7.b
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    ldp q16, q17, [x0, #64]
; CHECK-NEXT:    uzp1 z3.b, z3.b, z3.b
; CHECK-NEXT:    splice z1.b, p0, z1.b, z3.b
; CHECK-NEXT:    add z1.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z16.b, z16.b, z16.b
; CHECK-NEXT:    ldp q7, q18, [x0, #96]
; CHECK-NEXT:    uzp1 z17.b, z17.b, z17.b
; CHECK-NEXT:    splice z16.b, p0, z16.b, z17.b
; CHECK-NEXT:    uzp1 z7.b, z7.b, z7.b
; CHECK-NEXT:    ldp q4, q5, [x0, #32]
; CHECK-NEXT:    uzp1 z3.b, z18.b, z18.b
; CHECK-NEXT:    splice z7.b, p0, z7.b, z3.b
; CHECK-NEXT:    uzp1 z4.b, z4.b, z4.b
; CHECK-NEXT:    ldp q19, q20, [x0]
; CHECK-NEXT:    uzp1 z3.b, z5.b, z5.b
; CHECK-NEXT:    stp q0, q2, [x1, #96]
; CHECK-NEXT:    add z0.b, z6.b, z6.b
; CHECK-NEXT:    splice z4.b, p0, z4.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x1, #64]
; CHECK-NEXT:    add z0.b, z16.b, z16.b
; CHECK-NEXT:    uzp1 z18.b, z19.b, z19.b
; CHECK-NEXT:    add z1.b, z7.b, z7.b
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    add z1.b, z4.b, z4.b
; CHECK-NEXT:    uzp1 z17.b, z20.b, z20.b
; CHECK-NEXT:    splice z18.b, p0, z18.b, z17.b
; CHECK-NEXT:    add z0.b, z18.b, z18.b
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <128 x i16>, ptr %in
  %b = trunc <128 x i16> %a to <128 x i8>
  %c = add <128 x i8> %b, %b
  store <128 x i8> %c, ptr %out
  ret void
}

;
; truncate i32 -> i8
;

define <8 x i8> @trunc_v8i32_v8i8(ptr %in) nounwind {
; CHECK-LABEL: trunc_v8i32_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %in
  %b = trunc <8 x i32> %a to <8 x i8>
  ret <8 x i8> %b
}

define <16 x i8> @trunc_v16i32_v16i8(ptr %in) nounwind {
; CHECK-LABEL: trunc_v16i32_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    uzp1 z1.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z3.h, p0, z3.h, z2.h
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z3.b, z3.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <16 x i32>, ptr %in
  %b = trunc <16 x i32> %a to <16 x i8>
  ret <16 x i8> %b
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v32i32_v32i8(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v32i32_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #96]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ptrue p1.b, vl8
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q2, q3, [x0, #64]
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z2.h, p0, z2.h, z3.h
; CHECK-NEXT:    uzp1 z1.b, z2.b, z2.b
; CHECK-NEXT:    splice z1.b, p1, z1.b, z0.b
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    ldp q6, q7, [x0, #32]
; CHECK-NEXT:    uzp1 z3.h, z5.h, z5.h
; CHECK-NEXT:    splice z4.h, p0, z4.h, z3.h
; CHECK-NEXT:    uzp1 z2.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z0.h, z7.h, z7.h
; CHECK-NEXT:    splice z2.h, p0, z2.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z2.b, z2.b
; CHECK-NEXT:    uzp1 z2.b, z4.b, z4.b
; CHECK-NEXT:    splice z2.b, p1, z2.b, z0.b
; CHECK-NEXT:    add z0.b, z1.b, z1.b
; CHECK-NEXT:    add z1.b, z2.b, z2.b
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i32>, ptr %in
  %b = trunc <32 x i32> %a to <32 x i8>
  %c = add <32 x i8> %b, %b
  store <32 x i8> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v64i32_v64i8(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v64i32_v64i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #128]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ptrue p1.b, vl8
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q2, q3, [x0, #160]
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z2.h, p0, z2.h, z3.h
; CHECK-NEXT:    uzp1 z2.b, z2.b, z2.b
; CHECK-NEXT:    ldp q1, q17, [x0, #224]
; CHECK-NEXT:    splice z0.b, p1, z0.b, z2.b
; CHECK-NEXT:    add z0.b, z0.b, z0.b
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    ldp q18, q2, [x0, #192]
; CHECK-NEXT:    uzp1 z17.h, z17.h, z17.h
; CHECK-NEXT:    splice z1.h, p0, z1.h, z17.h
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z18.h, z18.h, z18.h
; CHECK-NEXT:    ldp q4, q5, [x0, #64]
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z18.h, p0, z18.h, z2.h
; CHECK-NEXT:    uzp1 z2.b, z18.b, z18.b
; CHECK-NEXT:    splice z2.b, p1, z2.b, z1.b
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    ldp q6, q7, [x0, #96]
; CHECK-NEXT:    uzp1 z5.h, z5.h, z5.h
; CHECK-NEXT:    splice z4.h, p0, z4.h, z5.h
; CHECK-NEXT:    uzp1 z4.b, z4.b, z4.b
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    ldp q3, q16, [x0]
; CHECK-NEXT:    uzp1 z1.h, z7.h, z7.h
; CHECK-NEXT:    splice z6.h, p0, z6.h, z1.h
; CHECK-NEXT:    uzp1 z1.b, z6.b, z6.b
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z4.b, p1, z4.b, z1.b
; CHECK-NEXT:    add z1.b, z2.b, z2.b
; CHECK-NEXT:    ldp q19, q20, [x0, #32]
; CHECK-NEXT:    uzp1 z16.h, z16.h, z16.h
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    splice z3.h, p0, z3.h, z16.h
; CHECK-NEXT:    add z1.b, z4.b, z4.b
; CHECK-NEXT:    uzp1 z3.b, z3.b, z3.b
; CHECK-NEXT:    uzp1 z18.h, z19.h, z19.h
; CHECK-NEXT:    uzp1 z17.h, z20.h, z20.h
; CHECK-NEXT:    splice z18.h, p0, z18.h, z17.h
; CHECK-NEXT:    uzp1 z16.b, z18.b, z18.b
; CHECK-NEXT:    splice z3.b, p1, z3.b, z16.b
; CHECK-NEXT:    add z0.b, z3.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <64 x i32>, ptr %in
  %b = trunc <64 x i32> %a to <64 x i8>
  %c = add <64 x i8> %b, %b
  store <64 x i8> %c, ptr %out
  ret void
}

;
; truncate i32 -> i16
;

define <8 x i16> @trunc_v8i32_v8i16(ptr %in) nounwind {
; CHECK-LABEL: trunc_v8i32_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %in
  %b = trunc <8 x i32> %a to <8 x i16>
  ret <8 x i16> %b
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v16i32_v16i16(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v16i32_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z3.h, p0, z3.h, z2.h
; CHECK-NEXT:    add z1.h, z3.h, z3.h
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %a = load <16 x i32>, ptr %in
  %b = trunc <16 x i32> %a to <16 x i16>
  %c = add <16 x i16> %b, %b
  store <16 x i16> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v32i32_v32i16(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v32i32_v32i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #64]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q2, q3, [x0, #96]
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z2.h, p0, z2.h, z3.h
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    ldp q6, q7, [x0, #32]
; CHECK-NEXT:    uzp1 z1.h, z5.h, z5.h
; CHECK-NEXT:    splice z4.h, p0, z4.h, z1.h
; CHECK-NEXT:    uzp1 z3.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z1.h, z7.h, z7.h
; CHECK-NEXT:    splice z3.h, p0, z3.h, z1.h
; CHECK-NEXT:    add z1.h, z2.h, z2.h
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    add z0.h, z4.h, z4.h
; CHECK-NEXT:    add z1.h, z3.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i32>, ptr %in
  %b = trunc <32 x i32> %a to <32 x i16>
  %c = add <32 x i16> %b, %b
  store <32 x i16> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v64i32_v64i16(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v64i32_v64i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #192]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q2, q3, [x0, #224]
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    ldp q6, q7, [x0, #128]
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z2.h, p0, z2.h, z3.h
; CHECK-NEXT:    add z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    ldp q1, q3, [x0, #160]
; CHECK-NEXT:    uzp1 z7.h, z7.h, z7.h
; CHECK-NEXT:    splice z6.h, p0, z6.h, z7.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    ldp q16, q17, [x0, #64]
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z1.h, p0, z1.h, z3.h
; CHECK-NEXT:    add z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z16.h, z16.h, z16.h
; CHECK-NEXT:    ldp q7, q18, [x0, #96]
; CHECK-NEXT:    uzp1 z17.h, z17.h, z17.h
; CHECK-NEXT:    splice z16.h, p0, z16.h, z17.h
; CHECK-NEXT:    uzp1 z7.h, z7.h, z7.h
; CHECK-NEXT:    ldp q4, q5, [x0, #32]
; CHECK-NEXT:    uzp1 z3.h, z18.h, z18.h
; CHECK-NEXT:    splice z7.h, p0, z7.h, z3.h
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    ldp q19, q20, [x0]
; CHECK-NEXT:    uzp1 z3.h, z5.h, z5.h
; CHECK-NEXT:    stp q0, q2, [x1, #96]
; CHECK-NEXT:    add z0.h, z6.h, z6.h
; CHECK-NEXT:    splice z4.h, p0, z4.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x1, #64]
; CHECK-NEXT:    add z0.h, z16.h, z16.h
; CHECK-NEXT:    uzp1 z18.h, z19.h, z19.h
; CHECK-NEXT:    add z1.h, z7.h, z7.h
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    add z1.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z17.h, z20.h, z20.h
; CHECK-NEXT:    splice z18.h, p0, z18.h, z17.h
; CHECK-NEXT:    add z0.h, z18.h, z18.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <64 x i32>, ptr %in
  %b = trunc <64 x i32> %a to <64 x i16>
  %c = add <64 x i16> %b, %b
  store <64 x i16> %c, ptr %out
  ret void
}

;
; truncate i64 -> i8
;

; NOTE: v4i8 is not legal so result i8 elements are held within i16 containers.
define <4 x i8> @trunc_v4i64_v4i8(ptr %in) nounwind {
; CHECK-LABEL: trunc_v4i64_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %a = load <4 x i64>, ptr %in
  %b = trunc <4 x i64> %a to <4 x i8>
  ret <4 x i8> %b
}

define <8 x i8> @trunc_v8i64_v8i8(ptr %in) nounwind {
; CHECK-LABEL: trunc_v8i64_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z3.s, p0, z3.s, z2.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z1.h, z3.h, z3.h
; CHECK-NEXT:    splice z1.h, p0, z1.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %in
  %b = trunc <8 x i64> %a to <8 x i8>
  ret <8 x i8> %b
}

define <16 x i8> @trunc_v16i64_v16i8(ptr %in) nounwind {
; CHECK-LABEL: trunc_v16i64_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #96]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q2, q3, [x0, #64]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    uzp1 z4.s, z4.s, z4.s
; CHECK-NEXT:    uzp1 z1.b, z1.b, z1.b
; CHECK-NEXT:    ldp q6, q7, [x0, #32]
; CHECK-NEXT:    uzp1 z3.s, z5.s, z5.s
; CHECK-NEXT:    splice z4.s, p0, z4.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z6.s, z6.s
; CHECK-NEXT:    uzp1 z0.s, z7.s, z7.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z0.s
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z2.h, z4.h, z4.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z2.b, z2.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <16 x i64>, ptr %in
  %b = trunc <16 x i64> %a to <16 x i8>
  ret <16 x i8> %b
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v32i64_v32i8(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v32i64_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #224]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    ptrue p2.b, vl8
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q2, q3, [x0, #192]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    ldp q1, q16, [x0, #160]
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z0.h
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z0.b, z2.b, z2.b
; CHECK-NEXT:    ldp q3, q17, [x0, #128]
; CHECK-NEXT:    uzp1 z16.s, z16.s, z16.s
; CHECK-NEXT:    splice z1.s, p0, z1.s, z16.s
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    uzp1 z17.s, z17.s, z17.s
; CHECK-NEXT:    splice z3.s, p0, z3.s, z17.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z1.h
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z1.b, z3.b, z3.b
; CHECK-NEXT:    splice z1.b, p2, z1.b, z0.b
; CHECK-NEXT:    uzp1 z4.s, z4.s, z4.s
; CHECK-NEXT:    ldp q6, q7, [x0, #64]
; CHECK-NEXT:    uzp1 z5.s, z5.s, z5.s
; CHECK-NEXT:    splice z4.s, p0, z4.s, z5.s
; CHECK-NEXT:    uzp1 z6.s, z6.s, z6.s
; CHECK-NEXT:    ldp q18, q19, [x0, #96]
; CHECK-NEXT:    uzp1 z7.s, z7.s, z7.s
; CHECK-NEXT:    splice z6.s, p0, z6.s, z7.s
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z16.s, z18.s, z18.s
; CHECK-NEXT:    ldp q2, q3, [x0, #32]
; CHECK-NEXT:    uzp1 z0.s, z19.s, z19.s
; CHECK-NEXT:    splice z16.s, p0, z16.s, z0.s
; CHECK-NEXT:    uzp1 z0.h, z16.h, z16.h
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z6.h, p1, z6.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z6.b, z6.b
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    uzp1 z3.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z2.h
; CHECK-NEXT:    uzp1 z2.b, z3.b, z3.b
; CHECK-NEXT:    splice z2.b, p2, z2.b, z0.b
; CHECK-NEXT:    add z0.b, z1.b, z1.b
; CHECK-NEXT:    add z1.b, z2.b, z2.b
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i64>, ptr %in
  %b = trunc <32 x i64> %a to <32 x i8>
  %c = add <32 x i8> %b, %b
  store <32 x i8> %c, ptr %out
  ret void
}

;
; truncate i64 -> i16
;

define <4 x i16> @trunc_v4i64_v4i16(ptr %in) nounwind {
; CHECK-LABEL: trunc_v4i64_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %a = load <4 x i64>, ptr %in
  %b = trunc <4 x i64> %a to <4 x i16>
  ret <4 x i16> %b
}

define <8 x i16> @trunc_v8i64_v8i16(ptr %in) nounwind {
; CHECK-LABEL: trunc_v8i64_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z1.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z3.s, p0, z3.s, z2.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z0.h, z3.h, z3.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %in
  %b = trunc <8 x i64> %a to <8 x i16>
  ret <8 x i16> %b
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v16i64_v16i16(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v16i64_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #96]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q2, q3, [x0, #64]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    uzp1 z4.s, z4.s, z4.s
; CHECK-NEXT:    ldp q6, q7, [x0, #32]
; CHECK-NEXT:    uzp1 z3.s, z5.s, z5.s
; CHECK-NEXT:    splice z4.s, p0, z4.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z6.s, z6.s
; CHECK-NEXT:    uzp1 z0.s, z7.s, z7.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z0.s
; CHECK-NEXT:    uzp1 z0.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z2.h, z4.h, z4.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z0.h
; CHECK-NEXT:    add z0.h, z1.h, z1.h
; CHECK-NEXT:    add z1.h, z2.h, z2.h
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %a = load <16 x i64>, ptr %in
  %b = trunc <16 x i64> %a to <16 x i16>
  %c = add <16 x i16> %b, %b
  store <16 x i16> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v32i64_v32i16(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v32i64_v32i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #128]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q2, q3, [x0, #160]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    ldp q1, q17, [x0, #224]
; CHECK-NEXT:    splice z0.h, p1, z0.h, z2.h
; CHECK-NEXT:    add z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    ldp q18, q2, [x0, #192]
; CHECK-NEXT:    uzp1 z17.s, z17.s, z17.s
; CHECK-NEXT:    splice z1.s, p0, z1.s, z17.s
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z18.s, z18.s, z18.s
; CHECK-NEXT:    ldp q4, q5, [x0, #64]
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z18.s, p0, z18.s, z2.s
; CHECK-NEXT:    uzp1 z2.h, z18.h, z18.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z1.h
; CHECK-NEXT:    uzp1 z4.s, z4.s, z4.s
; CHECK-NEXT:    ldp q6, q7, [x0, #96]
; CHECK-NEXT:    uzp1 z5.s, z5.s, z5.s
; CHECK-NEXT:    splice z4.s, p0, z4.s, z5.s
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z6.s, z6.s, z6.s
; CHECK-NEXT:    ldp q3, q16, [x0]
; CHECK-NEXT:    uzp1 z1.s, z7.s, z7.s
; CHECK-NEXT:    splice z6.s, p0, z6.s, z1.s
; CHECK-NEXT:    uzp1 z1.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z4.h, p1, z4.h, z1.h
; CHECK-NEXT:    add z1.h, z2.h, z2.h
; CHECK-NEXT:    ldp q19, q20, [x0, #32]
; CHECK-NEXT:    uzp1 z16.s, z16.s, z16.s
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    splice z3.s, p0, z3.s, z16.s
; CHECK-NEXT:    add z1.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    uzp1 z18.s, z19.s, z19.s
; CHECK-NEXT:    uzp1 z17.s, z20.s, z20.s
; CHECK-NEXT:    splice z18.s, p0, z18.s, z17.s
; CHECK-NEXT:    uzp1 z16.h, z18.h, z18.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z16.h
; CHECK-NEXT:    add z0.h, z3.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i64>, ptr %in
  %b = trunc <32 x i64> %a to <32 x i16>
  %c = add <32 x i16> %b, %b
  store <32 x i16> %c, ptr %out
  ret void
}

;
; truncate i64 -> i32
;

define <4 x i32> @trunc_v4i64_v4i32(ptr %in) nounwind {
; CHECK-LABEL: trunc_v4i64_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %a = load <4 x i64>, ptr %in
  %b = trunc <4 x i64> %a to <4 x i32>
  ret <4 x i32> %b
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v8i64_v8i32(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v8i64_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    add z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z3.s, p0, z3.s, z2.s
; CHECK-NEXT:    add z1.s, z3.s, z3.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %a = load <8 x i64>, ptr %in
  %b = trunc <8 x i64> %a to <8 x i32>
  %c = add <8 x i32> %b, %b
  store <8 x i32> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v16i64_v16i32(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v16i64_v16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #64]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q2, q3, [x0, #96]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    add z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    ldp q4, q5, [x0]
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    uzp1 z4.s, z4.s, z4.s
; CHECK-NEXT:    ldp q6, q7, [x0, #32]
; CHECK-NEXT:    uzp1 z1.s, z5.s, z5.s
; CHECK-NEXT:    splice z4.s, p0, z4.s, z1.s
; CHECK-NEXT:    uzp1 z3.s, z6.s, z6.s
; CHECK-NEXT:    uzp1 z1.s, z7.s, z7.s
; CHECK-NEXT:    splice z3.s, p0, z3.s, z1.s
; CHECK-NEXT:    add z1.s, z2.s, z2.s
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    add z0.s, z4.s, z4.s
; CHECK-NEXT:    add z1.s, z3.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <16 x i64>, ptr %in
  %b = trunc <16 x i64> %a to <16 x i32>
  %c = add <16 x i32> %b, %b
  store <16 x i32> %c, ptr %out
  ret void
}

; NOTE: Extra 'add' is to prevent the truncate being combined with the store.
define void @trunc_v32i64_v32i32(ptr %in, ptr %out) nounwind {
; CHECK-LABEL: trunc_v32i64_v32i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #192]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q2, q3, [x0, #224]
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    add z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    ldp q6, q7, [x0, #128]
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    add z2.s, z2.s, z2.s
; CHECK-NEXT:    uzp1 z6.s, z6.s, z6.s
; CHECK-NEXT:    ldp q1, q3, [x0, #160]
; CHECK-NEXT:    uzp1 z7.s, z7.s, z7.s
; CHECK-NEXT:    splice z6.s, p0, z6.s, z7.s
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    ldp q16, q17, [x0, #64]
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    splice z1.s, p0, z1.s, z3.s
; CHECK-NEXT:    add z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z16.s, z16.s, z16.s
; CHECK-NEXT:    ldp q7, q18, [x0, #96]
; CHECK-NEXT:    uzp1 z17.s, z17.s, z17.s
; CHECK-NEXT:    splice z16.s, p0, z16.s, z17.s
; CHECK-NEXT:    uzp1 z7.s, z7.s, z7.s
; CHECK-NEXT:    ldp q4, q5, [x0, #32]
; CHECK-NEXT:    uzp1 z3.s, z18.s, z18.s
; CHECK-NEXT:    splice z7.s, p0, z7.s, z3.s
; CHECK-NEXT:    uzp1 z4.s, z4.s, z4.s
; CHECK-NEXT:    ldp q19, q20, [x0]
; CHECK-NEXT:    uzp1 z3.s, z5.s, z5.s
; CHECK-NEXT:    stp q0, q2, [x1, #96]
; CHECK-NEXT:    add z0.s, z6.s, z6.s
; CHECK-NEXT:    splice z4.s, p0, z4.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x1, #64]
; CHECK-NEXT:    add z0.s, z16.s, z16.s
; CHECK-NEXT:    uzp1 z18.s, z19.s, z19.s
; CHECK-NEXT:    add z1.s, z7.s, z7.s
; CHECK-NEXT:    stp q0, q1, [x1, #32]
; CHECK-NEXT:    add z1.s, z4.s, z4.s
; CHECK-NEXT:    uzp1 z17.s, z20.s, z20.s
; CHECK-NEXT:    splice z18.s, p0, z18.s, z17.s
; CHECK-NEXT:    add z0.s, z18.s, z18.s
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %a = load <32 x i64>, ptr %in
  %b = trunc <32 x i64> %a to <32 x i32>
  %c = add <32 x i32> %b, %b
  store <32 x i32> %c, ptr %out
  ret void
}
