# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-u74 -mattr=+c -timeline \
# RUN:   -timeline-max-cycles=1000 -iterations=1 < %s | FileCheck %s

c.lui a0, 1
c.add a0, a0
c.addi a0, 1
c.addw a0, a0
c.addiw a0, 1
c.sub a0, a0
c.subw a0, a0
c.and a0, a0
c.andi a0, 1
c.or a0, a0
c.xor a0, a0
c.slli a0, 1
c.srli a0, 1
c.srai a0, 1
c.add a0, a0
beqz a0, 1f
1:
c.add a0, a0
bnez a0, 1f
1:
c.add a0, a0
c.jr a0

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      20
# CHECK-NEXT: Total Cycles:      21
# CHECK-NEXT: Total uOps:        20

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.95
# CHECK-NEXT: IPC:               0.95
# CHECK-NEXT: Block RThroughput: 10.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        lui	a0, 1
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        addi	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        addw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        addiw	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sub	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        subw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        and	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        andi	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        or	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        xor	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        slli	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        srli	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        srai	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        beqz	a0, .Ltmp0
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        bnez	a0, .Ltmp1
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        jr	a0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFive7FDiv
# CHECK-NEXT: [1]   - SiFive7IDiv
# CHECK-NEXT: [2]   - SiFive7PipeA
# CHECK-NEXT: [3]   - SiFive7PipeB
# CHECK-NEXT: [4]   - SiFive7PipeV
# CHECK-NEXT: [5]   - SiFive7VA
# CHECK-NEXT: [6]   - SiFive7VL
# CHECK-NEXT: [7]   - SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -     9.00   11.00   -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     lui	a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     addi	a0, a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     addw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     addiw	a0, a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     sub	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     subw	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     and	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     andi	a0, a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     or	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     xor	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     slli	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     srli	a0, a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     srai	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     beqz	a0, .Ltmp0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     bnez	a0, .Ltmp1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     jr	a0

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789
# CHECK-NEXT: Index     0123456789          0

# CHECK:      [0,0]     DeeE .    .    .    .   lui	a0, 1
# CHECK-NEXT: [0,1]     .DeeE.    .    .    .   add	a0, a0, a0
# CHECK-NEXT: [0,2]     . DeeE    .    .    .   addi	a0, a0, 1
# CHECK-NEXT: [0,3]     .  DeeE   .    .    .   addw	a0, a0, a0
# CHECK-NEXT: [0,4]     .   DeeE  .    .    .   addiw	a0, a0, 1
# CHECK-NEXT: [0,5]     .    DeeE .    .    .   sub	a0, a0, a0
# CHECK-NEXT: [0,6]     .    .DeeE.    .    .   subw	a0, a0, a0
# CHECK-NEXT: [0,7]     .    . DeeE    .    .   and	a0, a0, a0
# CHECK-NEXT: [0,8]     .    .  DeeE   .    .   andi	a0, a0, 1
# CHECK-NEXT: [0,9]     .    .   DeeE  .    .   or	a0, a0, a0
# CHECK-NEXT: [0,10]    .    .    DeeE .    .   xor	a0, a0, a0
# CHECK-NEXT: [0,11]    .    .    .DeeE.    .   slli	a0, a0, 1
# CHECK-NEXT: [0,12]    .    .    . DeeE    .   srli	a0, a0, 1
# CHECK-NEXT: [0,13]    .    .    .  DeeE   .   srai	a0, a0, 1
# CHECK-NEXT: [0,14]    .    .    .   DeeE  .   add	a0, a0, a0
# CHECK-NEXT: [0,15]    .    .    .    DeeE .   beqz	a0, .Ltmp0
# CHECK-NEXT: [0,16]    .    .    .    DeeE .   add	a0, a0, a0
# CHECK-NEXT: [0,17]    .    .    .    .DeeE.   bnez	a0, .Ltmp1
# CHECK-NEXT: [0,18]    .    .    .    .DeeE.   add	a0, a0, a0
# CHECK-NEXT: [0,19]    .    .    .    . DeeE   jr	a0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       lui	a0, 1
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       addi	a0, a0, 1
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       addw	a0, a0, a0
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       addiw	a0, a0, 1
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       sub	a0, a0, a0
# CHECK-NEXT: 6.     1     0.0    0.0    0.0       subw	a0, a0, a0
# CHECK-NEXT: 7.     1     0.0    0.0    0.0       and	a0, a0, a0
# CHECK-NEXT: 8.     1     0.0    0.0    0.0       andi	a0, a0, 1
# CHECK-NEXT: 9.     1     0.0    0.0    0.0       or	a0, a0, a0
# CHECK-NEXT: 10.    1     0.0    0.0    0.0       xor	a0, a0, a0
# CHECK-NEXT: 11.    1     0.0    0.0    0.0       slli	a0, a0, 1
# CHECK-NEXT: 12.    1     0.0    0.0    0.0       srli	a0, a0, 1
# CHECK-NEXT: 13.    1     0.0    0.0    0.0       srai	a0, a0, 1
# CHECK-NEXT: 14.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 15.    1     0.0    0.0    0.0       beqz	a0, .Ltmp0
# CHECK-NEXT: 16.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 17.    1     0.0    0.0    0.0       bnez	a0, .Ltmp1
# CHECK-NEXT: 18.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 19.    1     0.0    0.0    0.0       jr	a0
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
