; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I

define i32 @and_add_lsr(i32 %x, i32 %y) {
; RV32I-LABEL: and_add_lsr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    srli a1, a1, 20
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_add_lsr:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    srliw a1, a1, 20
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
  %1 = add i32 %x, 4095
  %2 = lshr i32 %y, 20
  %r = and i32 %2, %1
  ret i32 %r
}
