; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "\b(sp)\b" --filter "^\s*(ld[^r]|st[^r]|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; The base test file was generated by ./llvm/test/CodeGen/AArch64/Atomics/generate-tests.py
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+lse2 -O0 | FileCheck %s --check-prefixes=CHECK,-O0
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+lse2 -O1 | FileCheck %s --check-prefixes=CHECK,-O1

define dso_local i8 @atomicrmw_xchg_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_aligned_monotonic:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    stxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_aligned_acquire:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    stxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_aligned_release:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    stlxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_aligned_acq_rel:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    stlxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_aligned_seq_cst:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    stlxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xchg_i16_aligned_monotonic:
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xchg_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    stxrh w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xchg_i16_aligned_acquire:
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xchg_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    stxrh w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xchg_i16_aligned_release:
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xchg_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    stlxrh w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xchg_i16_aligned_acq_rel:
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xchg_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xchg_i16_aligned_seq_cst:
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xchg_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    stlxrh w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xchg_i32_aligned_monotonic:
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xchg_i32_aligned_monotonic:
; -O1:    ldxr w0, [x8]
; -O1:    stxr w9, w1, [x8]
    %r = atomicrmw xchg ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xchg_i32_aligned_acquire:
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xchg_i32_aligned_acquire:
; -O1:    ldaxr w0, [x8]
; -O1:    stxr w9, w1, [x8]
    %r = atomicrmw xchg ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xchg_i32_aligned_release:
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xchg_i32_aligned_release:
; -O1:    ldxr w0, [x8]
; -O1:    stlxr w9, w1, [x8]
    %r = atomicrmw xchg ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xchg_i32_aligned_acq_rel:
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xchg_i32_aligned_acq_rel:
; -O1:    ldaxr w0, [x8]
; -O1:    stlxr w9, w1, [x8]
    %r = atomicrmw xchg ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xchg_i32_aligned_seq_cst:
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xchg_i32_aligned_seq_cst:
; -O1:    ldaxr w0, [x8]
; -O1:    stlxr w9, w1, [x8]
    %r = atomicrmw xchg ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xchg_i64_aligned_monotonic:
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xchg_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    stxr w9, x1, [x8]
    %r = atomicrmw xchg ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xchg_i64_aligned_acquire:
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xchg_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    stxr w9, x1, [x8]
    %r = atomicrmw xchg ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xchg_i64_aligned_release:
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xchg_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    stlxr w9, x1, [x8]
    %r = atomicrmw xchg ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xchg_i64_aligned_acq_rel:
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xchg_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    stlxr w9, x1, [x8]
    %r = atomicrmw xchg ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xchg_i64_aligned_seq_cst:
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xchg_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    stlxr w9, x1, [x8]
    %r = atomicrmw xchg ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_monotonic:
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_monotonic:
; -O1:    ldxp x8, x1, [x0]
; -O1:    stxp w9, x2, x3, [x0]
    %r = atomicrmw xchg ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_acquire:
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_acquire:
; -O1:    ldaxp x8, x1, [x0]
; -O1:    stxp w9, x2, x3, [x0]
    %r = atomicrmw xchg ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_release:
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_release:
; -O1:    ldxp x8, x1, [x0]
; -O1:    stlxp w9, x2, x3, [x0]
    %r = atomicrmw xchg ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_acq_rel:
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_acq_rel:
; -O1:    ldaxp x8, x1, [x0]
; -O1:    stlxp w9, x2, x3, [x0]
    %r = atomicrmw xchg ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_seq_cst:
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_seq_cst:
; -O1:    ldaxp x8, x1, [x0]
; -O1:    stlxp w9, x2, x3, [x0]
    %r = atomicrmw xchg ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_unaligned_monotonic:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    stxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_unaligned_acquire:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    stxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_unaligned_release:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    stlxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_unaligned_acq_rel:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    stlxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xchg_i8_unaligned_seq_cst:
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xchg_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    stlxrb w9, w1, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_release(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_aligned_monotonic:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_aligned_acquire:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_aligned_release:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_aligned_acq_rel:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_aligned_seq_cst:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_aligned_monotonic:
; -O0:    add w12, w9, w8, uxth
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_add_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_aligned_acquire:
; -O0:    add w12, w9, w8, uxth
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_add_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_aligned_release:
; -O0:    add w12, w9, w8, uxth
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_add_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_aligned_acq_rel:
; -O0:    add w12, w9, w8, uxth
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_add_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_aligned_seq_cst:
; -O0:    add w12, w9, w8, uxth
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_add_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_aligned_monotonic:
; -O0:    add w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_add_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_aligned_acquire:
; -O0:    add w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_add_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_aligned_release:
; -O0:    add w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_add_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_aligned_acq_rel:
; -O0:    add w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_add_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_aligned_seq_cst:
; -O0:    add w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_add_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_aligned_monotonic:
; -O0:    add x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_add_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    add x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw add ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_aligned_acquire:
; -O0:    add x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_add_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    add x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw add ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_aligned_release:
; -O0:    add x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_add_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    add x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw add ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_aligned_acq_rel:
; -O0:    add x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_add_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    add x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw add ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_aligned_seq_cst:
; -O0:    add x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_add_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    add x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw add ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_monotonic:
; -O0:    adds x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    subs w10, w10, #1
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    adds x9, x0, x2
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw add ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_acquire:
; -O0:    adds x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    subs w10, w10, #1
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    adds x9, x0, x2
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw add ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_release:
; -O0:    adds x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    subs w10, w10, #1
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    adds x9, x0, x2
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw add ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_acq_rel:
; -O0:    adds x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    subs w10, w10, #1
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    adds x9, x0, x2
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw add ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_seq_cst:
; -O0:    adds x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    subs w10, w10, #1
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    adds x9, x0, x2
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw add ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_unaligned_monotonic:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_unaligned_acquire:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_unaligned_release:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_unaligned_acq_rel:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_add_i8_unaligned_seq_cst:
; -O0:    add w12, w8, w10, uxth
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_add_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    add w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_monotonic:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_monotonic:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_acquire:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_acquire:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_release:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_release:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_acq_rel:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_acq_rel:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_seq_cst:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_seq_cst:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_monotonic:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_monotonic:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_acquire:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_acquire:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_release:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_release:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_acq_rel:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_acq_rel:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_seq_cst:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_seq_cst:
; -O1:    add w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_monotonic:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_monotonic:
; -O1:    add x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_acquire:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_acquire:
; -O1:    add x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_release:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_release:
; -O1:    add x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_acq_rel:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_acq_rel:
; -O1:    add x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_seq_cst:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_seq_cst:
; -O1:    add x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_monotonic:
; -O0:    adds x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_acquire:
; -O0:    adds x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_release:
; -O0:    adds x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_acq_rel:
; -O0:    adds x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_seq_cst:
; -O0:    adds x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_aligned_monotonic:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_aligned_acquire:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_aligned_release:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_aligned_acq_rel:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_aligned_seq_cst:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_aligned_monotonic:
; -O0:    subs w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_sub_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_aligned_acquire:
; -O0:    subs w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_sub_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_aligned_release:
; -O0:    subs w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_sub_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_aligned_acq_rel:
; -O0:    subs w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_sub_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_aligned_seq_cst:
; -O0:    subs w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_sub_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_aligned_monotonic:
; -O0:    subs w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_sub_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_aligned_acquire:
; -O0:    subs w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_sub_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_aligned_release:
; -O0:    subs w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_sub_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_aligned_acq_rel:
; -O0:    subs w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_sub_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_aligned_seq_cst:
; -O0:    subs w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_sub_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_aligned_monotonic:
; -O0:    subs x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_sub_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    sub x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw sub ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_aligned_acquire:
; -O0:    subs x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_sub_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    sub x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw sub ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_aligned_release:
; -O0:    subs x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_sub_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    sub x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw sub ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_aligned_acq_rel:
; -O0:    subs x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_sub_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    sub x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw sub ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_aligned_seq_cst:
; -O0:    subs x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_sub_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    sub x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw sub ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_monotonic:
; -O0:    subs x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    subs x9, x0, x2
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw sub ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_acquire:
; -O0:    subs x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    subs x9, x0, x2
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw sub ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_release:
; -O0:    subs x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    subs x9, x0, x2
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw sub ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_acq_rel:
; -O0:    subs x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    subs x9, x0, x2
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw sub ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_seq_cst:
; -O0:    subs x14, x8, x10
; -O0:    and w10, w8, #0x1
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    subs x9, x0, x2
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw sub ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_unaligned_monotonic:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_unaligned_acquire:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_unaligned_release:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_unaligned_acq_rel:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_sub_i8_unaligned_seq_cst:
; -O0:    subs w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_sub_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    sub w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_monotonic:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_monotonic:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_acquire:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_acquire:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_release:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_release:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_acq_rel:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_acq_rel:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_seq_cst:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_seq_cst:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_monotonic:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_monotonic:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_acquire:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_acquire:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_release:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_release:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_acq_rel:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_acq_rel:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_seq_cst:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_seq_cst:
; -O1:    sub w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_monotonic:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_monotonic:
; -O1:    sub x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_acquire:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_acquire:
; -O1:    sub x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_release:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_release:
; -O1:    sub x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_acq_rel:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_acq_rel:
; -O1:    sub x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_seq_cst:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_seq_cst:
; -O1:    sub x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_monotonic:
; -O0:    subs x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_acquire:
; -O0:    subs x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_release:
; -O0:    subs x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_acq_rel:
; -O0:    subs x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_seq_cst:
; -O0:    subs x9, x8, x9
; -O0:    and w11, w8, #0x1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_aligned_monotonic:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_aligned_acquire:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_aligned_release:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_aligned_acq_rel:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_aligned_seq_cst:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_aligned_monotonic:
; -O0:    and w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_and_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_aligned_acquire:
; -O0:    and w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_and_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_aligned_release:
; -O0:    and w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_and_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_aligned_acq_rel:
; -O0:    and w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_and_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_aligned_seq_cst:
; -O0:    and w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_and_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_aligned_monotonic:
; -O0:    and w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_and_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_aligned_acquire:
; -O0:    and w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_and_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_aligned_release:
; -O0:    and w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_and_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_aligned_acq_rel:
; -O0:    and w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_and_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_aligned_seq_cst:
; -O0:    and w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_and_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_aligned_monotonic:
; -O0:    and x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_and_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw and ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_aligned_acquire:
; -O0:    and x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_and_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw and ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_aligned_release:
; -O0:    and x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_and_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw and ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_aligned_acq_rel:
; -O0:    and x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_and_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw and ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_aligned_seq_cst:
; -O0:    and x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_and_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw and ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_monotonic:
; -O0:    and x14, x8, x10
; -O0:    and x15, x8, x9
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    and x10, x1, x3
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw and ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_acquire:
; -O0:    and x14, x8, x10
; -O0:    and x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    and x10, x1, x3
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw and ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_release:
; -O0:    and x14, x8, x10
; -O0:    and x15, x8, x9
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    and x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw and ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_acq_rel:
; -O0:    and x14, x8, x10
; -O0:    and x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    and x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw and ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_seq_cst:
; -O0:    and x14, x8, x10
; -O0:    and x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    and x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw and ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_unaligned_monotonic:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_unaligned_acquire:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_unaligned_release:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_unaligned_acq_rel:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_and_i8_unaligned_seq_cst:
; -O0:    and w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_and_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_monotonic:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_acquire:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_release:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_acq_rel:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_seq_cst:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_monotonic:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_acquire:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_release:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_acq_rel:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_seq_cst:
; -O1:    and w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_monotonic:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_monotonic:
; -O1:    and x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_acquire:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_acquire:
; -O1:    and x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_release:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_release:
; -O1:    and x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_acq_rel:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_acq_rel:
; -O1:    and x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_seq_cst:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_seq_cst:
; -O1:    and x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_release:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_monotonic:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_acquire:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_release:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_acq_rel:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_seq_cst:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_monotonic:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_acquire:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_release:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_acq_rel:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_seq_cst:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_monotonic:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_acquire:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_release:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_acq_rel:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_seq_cst:
; -O0:    and w9, w8, w9
; -O0:    mvn w12, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    mvn x12, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    mvn x9, x9
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw nand ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    mvn x12, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    mvn x9, x9
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw nand ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_release:
; -O0:    and x9, x8, x9
; -O0:    mvn x12, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    mvn x9, x9
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw nand ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    mvn x12, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    mvn x9, x9
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw nand ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    mvn x12, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    and x9, x0, x1
; -O1:    mvn x9, x9
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw nand ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x14, x9
; -O0:    mvn x15, x8
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    mvn x9, x9
; -O1:    and x10, x1, x3
; -O1:    mvn x10, x10
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw nand ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x14, x9
; -O0:    mvn x15, x8
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    mvn x9, x9
; -O1:    and x10, x1, x3
; -O1:    mvn x10, x10
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw nand ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_release:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x14, x9
; -O0:    mvn x15, x8
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    mvn x9, x9
; -O1:    and x10, x1, x3
; -O1:    mvn x10, x10
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw nand ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x14, x9
; -O0:    mvn x15, x8
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    mvn x9, x9
; -O1:    and x10, x1, x3
; -O1:    mvn x10, x10
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw nand ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x14, x9
; -O0:    mvn x15, x8
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    and x9, x0, x2
; -O1:    mvn x9, x9
; -O1:    and x10, x1, x3
; -O1:    mvn x10, x10
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw nand ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_monotonic:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_acquire:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_release:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_acq_rel:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_seq_cst:
; -O0:    and w8, w10, w8
; -O0:    mvn w12, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    and w9, w8, w1
; -O1:    mvn w9, w9
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw nand ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_monotonic:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_acquire:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_release:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_acq_rel:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_seq_cst:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_monotonic:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_acquire:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_release:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_acq_rel:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_seq_cst:
; -O1:    and w8, w0, w19
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_monotonic:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_monotonic:
; -O1:    and x8, x0, x19
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_acquire:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_acquire:
; -O1:    and x8, x0, x19
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_release:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_release:
; -O1:    and x8, x0, x19
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_acq_rel:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_acq_rel:
; -O1:    and x8, x0, x19
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_seq_cst:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_seq_cst:
; -O1:    and x8, x0, x19
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_release:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x20
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_aligned_monotonic:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_aligned_acquire:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_aligned_release:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_aligned_acq_rel:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_aligned_seq_cst:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_aligned_monotonic:
; -O0:    orr w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_or_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_aligned_acquire:
; -O0:    orr w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_or_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_aligned_release:
; -O0:    orr w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_or_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_aligned_acq_rel:
; -O0:    orr w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_or_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_aligned_seq_cst:
; -O0:    orr w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_or_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_aligned_monotonic:
; -O0:    orr w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_or_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_aligned_acquire:
; -O0:    orr w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_or_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_aligned_release:
; -O0:    orr w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_or_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_aligned_acq_rel:
; -O0:    orr w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_or_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_aligned_seq_cst:
; -O0:    orr w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_or_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_aligned_monotonic:
; -O0:    orr x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_or_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    orr x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw or ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_aligned_acquire:
; -O0:    orr x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_or_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    orr x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw or ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_aligned_release:
; -O0:    orr x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_or_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    orr x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw or ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_aligned_acq_rel:
; -O0:    orr x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_or_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    orr x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw or ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_aligned_seq_cst:
; -O0:    orr x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_or_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    orr x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw or ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_monotonic:
; -O0:    orr x14, x8, x10
; -O0:    orr x15, x8, x9
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    orr x9, x0, x2
; -O1:    orr x10, x1, x3
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw or ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_acquire:
; -O0:    orr x14, x8, x10
; -O0:    orr x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    orr x9, x0, x2
; -O1:    orr x10, x1, x3
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw or ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_release:
; -O0:    orr x14, x8, x10
; -O0:    orr x15, x8, x9
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    orr x9, x0, x2
; -O1:    orr x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw or ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_acq_rel:
; -O0:    orr x14, x8, x10
; -O0:    orr x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    orr x9, x0, x2
; -O1:    orr x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw or ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_seq_cst:
; -O0:    orr x14, x8, x10
; -O0:    orr x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    orr x9, x0, x2
; -O1:    orr x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw or ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_unaligned_monotonic:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_unaligned_acquire:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_unaligned_release:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_unaligned_acq_rel:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_or_i8_unaligned_seq_cst:
; -O0:    orr w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_or_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    orr w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_monotonic:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_monotonic:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_acquire:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_acquire:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_release:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_release:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_acq_rel:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_acq_rel:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_seq_cst:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_seq_cst:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_monotonic:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_monotonic:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_acquire:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_acquire:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_release:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_release:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_acq_rel:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_acq_rel:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_seq_cst:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_seq_cst:
; -O1:    orr w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_monotonic:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_monotonic:
; -O1:    orr x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_acquire:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_acquire:
; -O1:    orr x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_release:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_release:
; -O1:    orr x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_acq_rel:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_acq_rel:
; -O1:    orr x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_seq_cst:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_seq_cst:
; -O1:    orr x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_monotonic:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_acquire:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_release:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_acq_rel:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_seq_cst:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_aligned_monotonic:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_aligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_aligned_acquire:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_aligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_aligned_release:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_aligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_aligned_acq_rel:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_aligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_aligned_seq_cst:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_aligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_aligned_monotonic:
; -O0:    eor w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xor_i16_aligned_monotonic:
; -O1:    ldxrh w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_aligned_acquire:
; -O0:    eor w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xor_i16_aligned_acquire:
; -O1:    ldaxrh w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_aligned_release:
; -O0:    eor w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xor_i16_aligned_release:
; -O1:    ldxrh w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_aligned_acq_rel:
; -O0:    eor w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xor_i16_aligned_acq_rel:
; -O1:    ldaxrh w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_aligned_seq_cst:
; -O0:    eor w12, w8, w9
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_xor_i16_aligned_seq_cst:
; -O1:    ldaxrh w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_aligned_monotonic:
; -O0:    eor w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xor_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_aligned_acquire:
; -O0:    eor w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xor_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_aligned_release:
; -O0:    eor w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xor_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_aligned_acq_rel:
; -O0:    eor w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xor_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_aligned_seq_cst:
; -O0:    eor w12, w8, w9
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_xor_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_aligned_monotonic:
; -O0:    eor x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xor_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    eor x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw xor ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_aligned_acquire:
; -O0:    eor x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xor_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    eor x9, x0, x1
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw xor ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_aligned_release:
; -O0:    eor x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xor_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    eor x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw xor ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_aligned_acq_rel:
; -O0:    eor x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xor_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    eor x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw xor ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_aligned_seq_cst:
; -O0:    eor x12, x8, x9
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_xor_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    eor x9, x0, x1
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw xor ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_monotonic:
; -O0:    eor x14, x8, x10
; -O0:    eor x15, x8, x9
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    eor x9, x0, x2
; -O1:    eor x10, x1, x3
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw xor ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_acquire:
; -O0:    eor x14, x8, x10
; -O0:    eor x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    eor x9, x0, x2
; -O1:    eor x10, x1, x3
; -O1:    stxp w11, x9, x10, [x8]
    %r = atomicrmw xor ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_release:
; -O0:    eor x14, x8, x10
; -O0:    eor x15, x8, x9
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    eor x9, x0, x2
; -O1:    eor x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw xor ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_acq_rel:
; -O0:    eor x14, x8, x10
; -O0:    eor x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    eor x9, x0, x2
; -O1:    eor x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw xor ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_seq_cst:
; -O0:    eor x14, x8, x10
; -O0:    eor x15, x8, x9
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    eor x9, x0, x2
; -O1:    eor x10, x1, x3
; -O1:    stlxp w11, x9, x10, [x8]
    %r = atomicrmw xor ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_unaligned_monotonic:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_unaligned_monotonic:
; -O1:    ldxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_unaligned_acquire:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_unaligned_acquire:
; -O1:    ldaxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_unaligned_release:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_unaligned_release:
; -O1:    ldxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_unaligned_acq_rel:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_unaligned_acq_rel:
; -O1:    ldaxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_xor_i8_unaligned_seq_cst:
; -O0:    eor w12, w10, w8
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_xor_i8_unaligned_seq_cst:
; -O1:    ldaxrb w8, [x0]
; -O1:    eor w9, w8, w1
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_monotonic:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_monotonic:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_acquire:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_acquire:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_release:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_release:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_acq_rel:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_acq_rel:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_seq_cst:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_seq_cst:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_monotonic:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_monotonic:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_acquire:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_acquire:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_release:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_release:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_acq_rel:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_acq_rel:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_seq_cst:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_seq_cst:
; -O1:    eor w8, w0, w19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_monotonic:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_monotonic:
; -O1:    eor x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_acquire:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_acquire:
; -O1:    eor x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_release:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_release:
; -O1:    eor x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_acq_rel:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_acq_rel:
; -O1:    eor x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_seq_cst:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_seq_cst:
; -O1:    eor x8, x0, x19
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_monotonic:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_acquire:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_release:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_acq_rel:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_seq_cst:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_aligned_monotonic:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_aligned_monotonic:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_aligned_acquire:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_aligned_acquire:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_aligned_release:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_aligned_release:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_aligned_acq_rel:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_aligned_acq_rel:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_aligned_seq_cst:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_aligned_seq_cst:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_aligned_monotonic:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_max_i16_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, gt
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_aligned_acquire:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_max_i16_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, gt
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_aligned_release:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_max_i16_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_aligned_acq_rel:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_max_i16_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_aligned_seq_cst:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_max_i16_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_aligned_monotonic:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_max_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, gt
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_aligned_acquire:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_max_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, gt
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_aligned_release:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_max_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, gt
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_aligned_acq_rel:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_max_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, gt
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_aligned_seq_cst:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_max_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, gt
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_aligned_monotonic:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_max_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, gt
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_aligned_acquire:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_max_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, gt
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_aligned_release:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_max_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, gt
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_aligned_acq_rel:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_max_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, gt
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_aligned_seq_cst:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_max_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, gt
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lt
; -O1:    csel x10, x0, x2, lt
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lt
; -O1:    csel x10, x0, x2, lt
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lt
; -O1:    csel x10, x0, x2, lt
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lt
; -O1:    csel x10, x0, x2, lt
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lt
; -O1:    csel x10, x0, x2, lt
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw max ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_unaligned_monotonic:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_unaligned_monotonic:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_unaligned_acquire:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_unaligned_acquire:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_unaligned_release:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_unaligned_release:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_unaligned_acq_rel:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_unaligned_acq_rel:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_max_i8_unaligned_seq_cst:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_max_i8_unaligned_seq_cst:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, gt
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_monotonic:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_monotonic:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_acquire:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_acquire:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_release:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_release:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_acq_rel:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_acq_rel:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_seq_cst:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_seq_cst:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_monotonic:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_acquire:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_release:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_acq_rel:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_seq_cst:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_monotonic:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_acquire:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_release:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_acq_rel:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_seq_cst:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x20, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_acquire:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x20, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_release:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x20, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x20, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x20, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_aligned_monotonic:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_aligned_monotonic:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_aligned_acquire:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_aligned_acquire:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_aligned_release:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_aligned_release:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_aligned_acq_rel:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_aligned_acq_rel:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_aligned_seq_cst:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_aligned_seq_cst:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_aligned_monotonic:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_min_i16_aligned_monotonic:
; -O1:    ldxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, le
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_aligned_acquire:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_min_i16_aligned_acquire:
; -O1:    ldaxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, le
; -O1:    stxrh w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_aligned_release:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_min_i16_aligned_release:
; -O1:    ldxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_aligned_acq_rel:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_min_i16_aligned_acq_rel:
; -O1:    ldaxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_aligned_seq_cst:
; -O0:    sxth w10, w8
; -O0:    subs w10, w10, w9, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_min_i16_aligned_seq_cst:
; -O1:    ldaxrh w9, [x0]
; -O1:    sxth w8, w9
; -O1:    cmp w8, w1, sxth
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrh w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_aligned_monotonic:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_min_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, le
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_aligned_acquire:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_min_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, le
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_aligned_release:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_min_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, le
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_aligned_acq_rel:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_min_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, le
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_aligned_seq_cst:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_min_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, le
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_aligned_monotonic:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_min_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, le
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_aligned_acquire:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_min_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, le
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_aligned_release:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_min_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, le
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_aligned_acq_rel:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_min_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, le
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_aligned_seq_cst:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_min_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, le
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, ge
; -O1:    csel x10, x0, x2, ge
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, ge
; -O1:    csel x10, x0, x2, ge
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, ge
; -O1:    csel x10, x0, x2, ge
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, ge
; -O1:    csel x10, x0, x2, ge
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, ge
; -O1:    csel x10, x0, x2, ge
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw min ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_unaligned_monotonic:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_unaligned_monotonic:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_unaligned_acquire:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_unaligned_acquire:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_unaligned_release:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_unaligned_release:
; -O1:    ldxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_unaligned_acq_rel:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_unaligned_acq_rel:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_min_i8_unaligned_seq_cst:
; -O0:    sxtb w9, w10
; -O0:    subs w9, w9, w8, sxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_min_i8_unaligned_seq_cst:
; -O1:    ldaxrb w9, [x0]
; -O1:    sxtb w8, w9
; -O1:    cmp w8, w1, sxtb
; -O1:    csel w9, w9, w1, le
; -O1:    stlxrb w10, w9, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_monotonic:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_monotonic:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_acquire:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_acquire:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_release:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_release:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_acq_rel:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_acq_rel:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_seq_cst:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_seq_cst:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w19, sxth
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_monotonic:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_acquire:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_release:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_acq_rel:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_seq_cst:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_monotonic:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_acquire:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_release:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_acq_rel:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_seq_cst:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x20, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_acquire:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x20, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_release:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x20, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x20, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x20, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_aligned_monotonic:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_aligned_monotonic:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_aligned_acquire:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_aligned_acquire:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_aligned_release:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_aligned_release:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_aligned_acq_rel:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_aligned_acq_rel:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_aligned_seq_cst:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_aligned_seq_cst:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_aligned_monotonic:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umax_i16_aligned_monotonic:
; -O1:    and w9, w1, #0xffff
; -O1:    ldxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stxrh w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_aligned_acquire:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umax_i16_aligned_acquire:
; -O1:    and w9, w1, #0xffff
; -O1:    ldaxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stxrh w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_aligned_release:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umax_i16_aligned_release:
; -O1:    and w9, w1, #0xffff
; -O1:    ldxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrh w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_aligned_acq_rel:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umax_i16_aligned_acq_rel:
; -O1:    and w9, w1, #0xffff
; -O1:    ldaxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrh w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_aligned_seq_cst:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umax_i16_aligned_seq_cst:
; -O1:    and w9, w1, #0xffff
; -O1:    ldaxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrh w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_aligned_monotonic:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umax_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, hi
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_aligned_acquire:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umax_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, hi
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_aligned_release:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umax_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, hi
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_aligned_acq_rel:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umax_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, hi
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_aligned_seq_cst:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umax_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, hi
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_aligned_monotonic:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umax_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, hi
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_aligned_acquire:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umax_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, hi
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_aligned_release:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umax_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, hi
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_aligned_acq_rel:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umax_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, hi
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_aligned_seq_cst:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umax_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, hi
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lo
; -O1:    csel x10, x0, x2, lo
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lo
; -O1:    csel x10, x0, x2, lo
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lo
; -O1:    csel x10, x0, x2, lo
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lo
; -O1:    csel x10, x0, x2, lo
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, lo
; -O1:    csel x10, x0, x2, lo
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw umax ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_unaligned_monotonic:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_unaligned_monotonic:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_unaligned_acquire:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_unaligned_acquire:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_unaligned_release:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_unaligned_release:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_unaligned_acq_rel:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_unaligned_acq_rel:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umax_i8_unaligned_seq_cst:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umax_i8_unaligned_seq_cst:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, hi
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_monotonic:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_monotonic:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_acquire:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_acquire:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_release:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_release:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_acq_rel:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_acq_rel:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_seq_cst:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_seq_cst:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_monotonic:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_acquire:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_release:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_acq_rel:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_seq_cst:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_monotonic:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_acquire:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_release:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_acq_rel:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_seq_cst:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x20, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_acquire:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x20, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_release:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x20, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x20, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x20, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_aligned_monotonic:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_aligned_monotonic:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_aligned_acquire:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_aligned_acquire:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_aligned_release:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_aligned_release:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_aligned_acq_rel:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_aligned_acq_rel:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_aligned_seq_cst:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_aligned_seq_cst:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_aligned_monotonic:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umin_i16_aligned_monotonic:
; -O1:    and w9, w1, #0xffff
; -O1:    ldxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stxrh w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_aligned_acquire:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umin_i16_aligned_acquire:
; -O1:    and w9, w1, #0xffff
; -O1:    ldaxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stxrh w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_aligned_release:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umin_i16_aligned_release:
; -O1:    and w9, w1, #0xffff
; -O1:    ldxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrh w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_aligned_acq_rel:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umin_i16_aligned_acq_rel:
; -O1:    and w9, w1, #0xffff
; -O1:    ldaxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrh w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_aligned_seq_cst:
; -O0:    subs w10, w10, w9, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxrh w9, [x11]
; -O0:    cmp w9, w8, uxth
; -O0:    stlxrh w10, w12, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_umin_i16_aligned_seq_cst:
; -O1:    and w9, w1, #0xffff
; -O1:    ldaxrh w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrh w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_aligned_monotonic:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umin_i32_aligned_monotonic:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, ls
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_aligned_acquire:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umin_i32_aligned_acquire:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, ls
; -O1:    stxr w10, w9, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_aligned_release:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umin_i32_aligned_release:
; -O1:    ldxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, ls
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_aligned_acq_rel:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umin_i32_aligned_acq_rel:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, ls
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_aligned_seq_cst:
; -O0:    subs w10, w8, w9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w12, w8, w9, ne
; -O0:    ldaxr w9, [x11]
; -O0:    cmp w9, w8
; -O0:    stlxr w10, w12, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_umin_i32_aligned_seq_cst:
; -O1:    ldaxr w8, [x0]
; -O1:    cmp w8, w1
; -O1:    csel w9, w8, w1, ls
; -O1:    stlxr w10, w9, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_aligned_monotonic:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umin_i64_aligned_monotonic:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, ls
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_aligned_acquire:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umin_i64_aligned_acquire:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, ls
; -O1:    stxr w10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_aligned_release:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umin_i64_aligned_release:
; -O1:    ldxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, ls
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_aligned_acq_rel:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umin_i64_aligned_acq_rel:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, ls
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_aligned_seq_cst:
; -O0:    subs x10, x8, x9
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x12, x8, x9, ne
; -O0:    ldaxr x9, [x11]
; -O0:    cmp x9, x8
; -O0:    stlxr w10, x12, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_umin_i64_aligned_seq_cst:
; -O1:    ldaxr x0, [x8]
; -O1:    cmp x0, x1
; -O1:    csel x9, x0, x1, ls
; -O1:    stlxr w10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_monotonic:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, hs
; -O1:    csel x10, x0, x2, hs
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stxp w8, x14, x15, [x11]
; -O0:    stxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_acquire:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, hs
; -O1:    csel x10, x0, x2, hs
; -O1:    stxp w11, x10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_release:
; -O1:    ldxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, hs
; -O1:    csel x10, x0, x2, hs
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_acq_rel:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, hs
; -O1:    csel x10, x0, x2, hs
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x9
; -O0:    subs x8, x8, x12
; -O0:    and w13, w13, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel w8, w8, w10, ne
; -O0:    and w13, w8, #0x1
; -O0:    ands w13, w13, #0x1
; -O0:    csel x14, x10, x12, ne
; -O0:    and w10, w8, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x15, x8, x9, ne
; -O0:    ldaxp x10, x9, [x11]
; -O0:    cmp x10, x12
; -O0:    cmp x9, x13
; -O0:    stlxp w8, x14, x15, [x11]
; -O0:    stlxp w8, x10, x9, [x11]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_seq_cst:
; -O1:    ldaxp x0, x1, [x8]
; -O1:    cmp x2, x0
; -O1:    csel x9, x1, x3, hs
; -O1:    csel x10, x0, x2, hs
; -O1:    stlxp w11, x10, x9, [x8]
    %r = atomicrmw umin ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_unaligned_monotonic:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_unaligned_monotonic:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_unaligned_acquire:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_unaligned_acquire:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_unaligned_release:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_unaligned_release:
; -O1:    and w9, w1, #0xff
; -O1:    ldxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_unaligned_acq_rel:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_unaligned_acq_rel:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_umin_i8_unaligned_seq_cst:
; -O0:    and w9, w10, #0xff
; -O0:    subs w9, w9, w8, uxtb
; -O0:    and w9, w9, #0x1
; -O0:    ands w9, w9, #0x1
; -O0:    csel w12, w10, w8, ne
; -O0:    ldaxrb w9, [x11]
; -O0:    cmp w9, w10, uxtb
; -O0:    stlxrb w8, w12, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_umin_i8_unaligned_seq_cst:
; -O1:    and w9, w1, #0xff
; -O1:    ldaxrb w8, [x0]
; -O1:    cmp w8, w9
; -O1:    csel w10, w8, w9, ls
; -O1:    stlxrb w11, w10, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_monotonic:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_monotonic:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_acquire:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_acquire:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_release:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_release:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_acq_rel:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_acq_rel:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_seq_cst:
; -O0:    subs w10, w10, w8, uxth
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_seq_cst:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w19, uxth
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_monotonic:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_acquire:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_release:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_acq_rel:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel w8, w9, w8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_seq_cst:
; -O1:    cmp w0, w19
; -O1:    csel w8, w0, w19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_monotonic:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_acquire:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_release:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_acq_rel:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    and w10, w10, #0x1
; -O0:    ands w10, w10, #0x1
; -O0:    csel x8, x9, x8, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_seq_cst:
; -O1:    cmp x0, x19
; -O1:    csel x8, x0, x19, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x20, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_acquire:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x20, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_release:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x20, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x20, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x10
; -O0:    subs x8, x8, x11
; -O0:    and w12, w12, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel w8, w8, w9, ne
; -O0:    and w12, w8, #0x1
; -O0:    ands w12, w12, #0x1
; -O0:    csel x9, x9, x11, ne
; -O0:    and w11, w8, #0x1
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x20, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x20, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}
