; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr8 < %s \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=P8
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr9 < %s \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=P9

define zeroext i1 @abs_isinff(float %x) {
; P8-LABEL: abs_isinff:
; P8:       # %bb.0: # %entry
; P8-NEXT:    xsabsdp 0, 1
; P8-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; P8-NEXT:    li 4, 1
; P8-NEXT:    lfs 1, .LCPI0_0@toc@l(3)
; P8-NEXT:    li 3, 0
; P8-NEXT:    fcmpu 0, 0, 1
; P8-NEXT:    iseleq 3, 4, 3
; P8-NEXT:    blr
;
; P9-LABEL: abs_isinff:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; P9-NEXT:    xsabsdp 0, 1
; P9-NEXT:    li 4, 1
; P9-NEXT:    lfs 1, .LCPI0_0@toc@l(3)
; P9-NEXT:    li 3, 0
; P9-NEXT:    fcmpu 0, 0, 1
; P9-NEXT:    iseleq 3, 4, 3
; P9-NEXT:    blr
entry:
  %0 = tail call float @llvm.fabs.f32(float %x)
  %cmpinf = fcmp oeq float %0, 0x7FF0000000000000
  ret i1 %cmpinf
}

define zeroext i1 @abs_isinf(double %x) {
; P8-LABEL: abs_isinf:
; P8:       # %bb.0: # %entry
; P8-NEXT:    xsabsdp 0, 1
; P8-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; P8-NEXT:    li 4, 1
; P8-NEXT:    lfs 1, .LCPI1_0@toc@l(3)
; P8-NEXT:    li 3, 0
; P8-NEXT:    fcmpu 0, 0, 1
; P8-NEXT:    iseleq 3, 4, 3
; P8-NEXT:    blr
;
; P9-LABEL: abs_isinf:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; P9-NEXT:    xsabsdp 0, 1
; P9-NEXT:    li 4, 1
; P9-NEXT:    lfs 1, .LCPI1_0@toc@l(3)
; P9-NEXT:    li 3, 0
; P9-NEXT:    fcmpu 0, 0, 1
; P9-NEXT:    iseleq 3, 4, 3
; P9-NEXT:    blr
entry:
  %0 = tail call double @llvm.fabs.f64(double %x)
  %cmpinf = fcmp oeq double %0, 0x7FF0000000000000
  ret i1 %cmpinf
}

define zeroext i1 @abs_isinfq(fp128 %x) {
; P8-LABEL: abs_isinfq:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr 0
; P8-NEXT:    stdu 1, -48(1)
; P8-NEXT:    std 0, 64(1)
; P8-NEXT:    .cfi_def_cfa_offset 48
; P8-NEXT:    .cfi_offset lr, 16
; P8-NEXT:    xxswapd 0, 34
; P8-NEXT:    addi 3, 1, 32
; P8-NEXT:    stxvd2x 0, 0, 3
; P8-NEXT:    lbz 4, 47(1)
; P8-NEXT:    clrlwi 4, 4, 25
; P8-NEXT:    stb 4, 47(1)
; P8-NEXT:    lxvd2x 0, 0, 3
; P8-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; P8-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; P8-NEXT:    xxswapd 34, 0
; P8-NEXT:    lxvd2x 0, 0, 3
; P8-NEXT:    xxswapd 35, 0
; P8-NEXT:    bl __eqkf2
; P8-NEXT:    nop
; P8-NEXT:    cntlzw 3, 3
; P8-NEXT:    srwi 3, 3, 5
; P8-NEXT:    addi 1, 1, 48
; P8-NEXT:    ld 0, 16(1)
; P8-NEXT:    mtlr 0
; P8-NEXT:    blr
;
; P9-LABEL: abs_isinfq:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; P9-NEXT:    xsabsqp 2, 2
; P9-NEXT:    li 4, 1
; P9-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; P9-NEXT:    lxv 35, 0(3)
; P9-NEXT:    li 3, 0
; P9-NEXT:    xscmpuqp 0, 2, 3
; P9-NEXT:    iseleq 3, 4, 3
; P9-NEXT:    blr
entry:
  %0 = tail call fp128 @llvm.fabs.f128(fp128 %x)
  %cmpinf = fcmp oeq fp128 %0, 0xL00000000000000007FFF000000000000
  ret i1 %cmpinf
}

define <4 x i1> @abs_isinfv4f32(<4 x float> %x) {
; P8-LABEL: abs_isinfv4f32:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; P8-NEXT:    xvabssp 0, 34
; P8-NEXT:    addi 3, 3, .LCPI3_0@toc@l
; P8-NEXT:    lxvd2x 1, 0, 3
; P8-NEXT:    xxswapd 1, 1
; P8-NEXT:    xvcmpeqsp 34, 0, 1
; P8-NEXT:    blr
;
; P9-LABEL: abs_isinfv4f32:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; P9-NEXT:    xvabssp 0, 34
; P9-NEXT:    addi 3, 3, .LCPI3_0@toc@l
; P9-NEXT:    lxv 1, 0(3)
; P9-NEXT:    xvcmpeqsp 34, 0, 1
; P9-NEXT:    blr
entry:
  %0 = tail call <4 x float> @llvm.fabs.v4f32(<4 x float> %x)
  %cmpinf = fcmp oeq <4 x float> %0, <float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000>
  ret <4 x i1> %cmpinf
}

define <2 x i1> @abs_isinfv2f64(<2 x double> %x) {
; P8-LABEL: abs_isinfv2f64:
; P8:       # %bb.0: # %entry
; P8-NEXT:    addis 3, 2, .LCPI4_0@toc@ha
; P8-NEXT:    xvabsdp 0, 34
; P8-NEXT:    addi 3, 3, .LCPI4_0@toc@l
; P8-NEXT:    lxvd2x 1, 0, 3
; P8-NEXT:    xxswapd 1, 1
; P8-NEXT:    xvcmpeqdp 34, 0, 1
; P8-NEXT:    blr
;
; P9-LABEL: abs_isinfv2f64:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addis 3, 2, .LCPI4_0@toc@ha
; P9-NEXT:    xvabsdp 0, 34
; P9-NEXT:    addi 3, 3, .LCPI4_0@toc@l
; P9-NEXT:    lxv 1, 0(3)
; P9-NEXT:    xvcmpeqdp 34, 0, 1
; P9-NEXT:    blr
entry:
  %0 = tail call <2 x double> @llvm.fabs.v2f64(<2 x double> %x)
  %cmpinf = fcmp oeq <2 x double> %0, <double 0x7FF0000000000000, double 0x7FF0000000000000>
  ret <2 x i1> %cmpinf
}

define zeroext i1 @iszerof(float %x) {
; P8-LABEL: iszerof:
; P8:       # %bb.0: # %entry
; P8-NEXT:    xxlxor 0, 0, 0
; P8-NEXT:    li 3, 0
; P8-NEXT:    li 4, 1
; P8-NEXT:    fcmpu 0, 1, 0
; P8-NEXT:    iseleq 3, 4, 3
; P8-NEXT:    blr
;
; P9-LABEL: iszerof:
; P9:       # %bb.0: # %entry
; P9-NEXT:    xxlxor 0, 0, 0
; P9-NEXT:    li 3, 0
; P9-NEXT:    li 4, 1
; P9-NEXT:    fcmpu 0, 1, 0
; P9-NEXT:    iseleq 3, 4, 3
; P9-NEXT:    blr
entry:
  %cmp = fcmp oeq float %x, 0.000000e+00
  ret i1 %cmp
}

define zeroext i1 @iszero(double %x) {
; P8-LABEL: iszero:
; P8:       # %bb.0: # %entry
; P8-NEXT:    xxlxor 0, 0, 0
; P8-NEXT:    li 3, 0
; P8-NEXT:    li 4, 1
; P8-NEXT:    fcmpu 0, 1, 0
; P8-NEXT:    iseleq 3, 4, 3
; P8-NEXT:    blr
;
; P9-LABEL: iszero:
; P9:       # %bb.0: # %entry
; P9-NEXT:    xxlxor 0, 0, 0
; P9-NEXT:    li 3, 0
; P9-NEXT:    li 4, 1
; P9-NEXT:    fcmpu 0, 1, 0
; P9-NEXT:    iseleq 3, 4, 3
; P9-NEXT:    blr
entry:
  %cmp = fcmp oeq double %x, 0.000000e+00
  ret i1 %cmp
}

define zeroext i1 @iszeroq(fp128 %x) {
; P8-LABEL: iszeroq:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr 0
; P8-NEXT:    stdu 1, -32(1)
; P8-NEXT:    std 0, 48(1)
; P8-NEXT:    .cfi_def_cfa_offset 32
; P8-NEXT:    .cfi_offset lr, 16
; P8-NEXT:    addis 3, 2, .LCPI7_0@toc@ha
; P8-NEXT:    addi 3, 3, .LCPI7_0@toc@l
; P8-NEXT:    lxvd2x 0, 0, 3
; P8-NEXT:    xxswapd 35, 0
; P8-NEXT:    bl __eqkf2
; P8-NEXT:    nop
; P8-NEXT:    cntlzw 3, 3
; P8-NEXT:    srwi 3, 3, 5
; P8-NEXT:    addi 1, 1, 32
; P8-NEXT:    ld 0, 16(1)
; P8-NEXT:    mtlr 0
; P8-NEXT:    blr
;
; P9-LABEL: iszeroq:
; P9:       # %bb.0: # %entry
; P9-NEXT:    addis 3, 2, .LCPI7_0@toc@ha
; P9-NEXT:    li 4, 1
; P9-NEXT:    addi 3, 3, .LCPI7_0@toc@l
; P9-NEXT:    lxv 35, 0(3)
; P9-NEXT:    li 3, 0
; P9-NEXT:    xscmpuqp 0, 2, 3
; P9-NEXT:    iseleq 3, 4, 3
; P9-NEXT:    blr
entry:
  %cmp = fcmp oeq fp128 %x, 0xL00000000000000000000000000000000
  ret i1 %cmp
}

define <4 x i1> @iszerov4f32(<4 x float> %x) {
; P8-LABEL: iszerov4f32:
; P8:       # %bb.0: # %entry
; P8-NEXT:    xxlxor 0, 0, 0
; P8-NEXT:    xvcmpeqsp 34, 34, 0
; P8-NEXT:    blr
;
; P9-LABEL: iszerov4f32:
; P9:       # %bb.0: # %entry
; P9-NEXT:    xxlxor 0, 0, 0
; P9-NEXT:    xvcmpeqsp 34, 34, 0
; P9-NEXT:    blr
entry:
  %cmp = fcmp oeq <4 x float> %x, <float 0.000000e+00, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00>
  ret <4 x i1> %cmp
}

define <2 x i1> @iszerov2f64(<2 x double> %x) {
; P8-LABEL: iszerov2f64:
; P8:       # %bb.0: # %entry
; P8-NEXT:    xxlxor 0, 0, 0
; P8-NEXT:    xvcmpeqdp 34, 34, 0
; P8-NEXT:    blr
;
; P9-LABEL: iszerov2f64:
; P9:       # %bb.0: # %entry
; P9-NEXT:    xxlxor 0, 0, 0
; P9-NEXT:    xvcmpeqdp 34, 34, 0
; P9-NEXT:    blr
entry:
  %cmp = fcmp oeq <2 x double> %x, <double 0.000000e+00, double 0.000000e+00>
  ret <2 x i1> %cmp
}

declare float @llvm.fabs.f32(float)
declare double @llvm.fabs.f64(double)
declare fp128 @llvm.fabs.f128(fp128)
declare <4 x float> @llvm.fabs.v4f32(<4 x float>)
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)
