
#line 1 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
/**
 * \file
 * \brief parse SVG path specifications
 *
 * Copyright 2007 MenTaLguY <mental@rydia.net>
 * Copyright 2007 Aaron Spike <aaron@ekips.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it either under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * (the "LGPL") or, at your option, under the terms of the Mozilla
 * Public License Version 1.1 (the "MPL"). If you do not alter this
 * notice, a recipient may use your version of this file under either
 * the MPL or the LGPL.
 *
 * You should have received a copy of the LGPL along with this library
 * in the file COPYING-LGPL-2.1; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * You should have received a copy of the MPL along with this library
 * in the file COPYING-MPL-1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY
 * OF ANY KIND, either express or implied. See the LGPL or the MPL for
 * the specific language governing rights and limitations.
 *
 */

#include <cstdio>
#include <cmath>
#include <vector>
#include <glib.h>

#include <2geom/point.h>
#include <2geom/svg-path-parser.h>
#include <2geom/angle.h>

namespace Geom {


#line 48 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.cpp"
static const char _svg_path_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 15, 2, 
	1, 0, 2, 1, 6, 2, 1, 7, 
	2, 1, 8, 2, 1, 9, 2, 1, 
	10, 2, 1, 11, 2, 1, 12, 2, 
	1, 13, 2, 1, 14, 2, 2, 0, 
	2, 3, 0, 2, 4, 0, 2, 5, 
	0, 3, 1, 6, 0, 3, 1, 7, 
	0, 3, 1, 8, 0, 3, 1, 9, 
	0, 3, 1, 10, 0, 3, 1, 11, 
	0, 3, 1, 12, 0, 3, 1, 13, 
	0, 3, 1, 14, 0
};

static const short _svg_path_key_offsets[] = {
	0, 0, 9, 18, 21, 23, 35, 45, 
	48, 50, 53, 55, 67, 77, 80, 82, 
	91, 103, 112, 119, 126, 128, 138, 146, 
	153, 155, 167, 177, 180, 182, 191, 198, 
	204, 211, 218, 224, 234, 244, 247, 249, 
	261, 271, 274, 276, 286, 290, 292, 300, 
	309, 318, 321, 323, 335, 345, 348, 350, 
	362, 372, 375, 377, 389, 399, 402, 404, 
	416, 426, 429, 431, 443, 453, 456, 458, 
	470, 479, 491, 500, 512, 521, 533, 542, 
	554, 563, 567, 569, 578, 587, 590, 592, 
	596, 598, 607, 616, 625, 628, 630, 642, 
	652, 655, 657, 669, 679, 682, 684, 696, 
	706, 709, 711, 723, 732, 744, 753, 765, 
	774, 778, 780, 789, 798, 801, 803, 815, 
	825, 828, 830, 842, 852, 855, 857, 869, 
	879, 882, 884, 896, 905, 917, 926, 938, 
	947, 951, 953, 962, 971, 974, 976, 988, 
	998, 1001, 1003, 1015, 1024, 1028, 1030, 1039, 
	1048, 1051, 1053, 1057, 1059, 1066, 1075, 1084, 
	1093, 1102, 1114, 1123, 1127, 1129, 1138, 1147, 
	1156, 1165, 1169, 1171, 1181, 1185, 1187, 1197, 
	1201, 1203, 1213, 1217, 1219, 1229, 1233, 1235, 
	1245, 1249, 1251, 1261, 1265, 1267, 1277, 1281, 
	1283, 1293, 1297, 1299, 1309, 1313, 1315, 1325, 
	1329, 1331, 1341, 1345, 1347, 1357, 1361, 1363, 
	1373, 1377, 1379, 1388, 1392, 1394, 1404, 1416, 
	1425, 1435, 1442, 1446, 1448, 1455, 1465, 1474, 
	1478, 1480, 1490, 1502, 1506, 1508, 1512, 1514, 
	1524, 1530, 1562, 1592, 1624, 1656, 1686, 1714, 
	1746, 1776, 1808, 1838, 1870, 1900, 1932, 1962, 
	1994, 2024, 2056, 2086, 2118, 2148, 2180, 2210, 
	2242, 2272, 2304, 2334, 2366, 2396, 2428, 2458, 
	2482, 2506, 2538, 2568, 2596, 2626
};

static const char _svg_path_trans_keys[] = {
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	13, 32, 46, 9, 10, 48, 57, 13, 
	32, 46, 9, 10, 48, 57, 48, 57, 
	13, 32, 44, 46, 69, 101, 9, 10, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	48, 57, 13, 32, 46, 9, 10, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 44, 46, 9, 10, 43, 45, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 69, 101, 9, 10, 48, 57, 13, 
	32, 44, 48, 49, 9, 10, 13, 32, 
	48, 49, 9, 10, 13, 32, 44, 48, 
	49, 9, 10, 13, 32, 44, 48, 49, 
	9, 10, 13, 32, 48, 49, 9, 10, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 48, 57, 43, 45, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	9, 10, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 44, 46, 9, 10, 43, 45, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 46, 48, 57, 
	48, 57, 13, 32, 44, 46, 69, 101, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 43, 45, 48, 57, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 46, 48, 57, 48, 57, 
	43, 45, 48, 57, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 46, 48, 57, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 43, 
	45, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 43, 45, 
	48, 57, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 44, 46, 9, 10, 43, 45, 48, 
	57, 46, 48, 57, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 46, 48, 57, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 44, 
	46, 9, 10, 43, 45, 48, 57, 46, 
	48, 57, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 69, 101, 9, 
	10, 43, 45, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 43, 45, 48, 57, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 46, 48, 57, 48, 57, 
	13, 32, 44, 46, 69, 101, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	9, 10, 43, 45, 48, 57, 46, 48, 
	57, 48, 57, 13, 32, 44, 46, 69, 
	101, 9, 10, 43, 45, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	43, 45, 48, 57, 48, 57, 13, 32, 
	43, 45, 46, 9, 10, 48, 57, 13, 
	32, 43, 45, 46, 9, 10, 48, 57, 
	46, 48, 57, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 46, 9, 10, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 13, 32, 43, 
	45, 46, 9, 10, 48, 57, 13, 32, 
	44, 46, 69, 101, 9, 10, 43, 45, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 43, 45, 48, 57, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 13, 32, 43, 45, 46, 9, 
	10, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 13, 32, 43, 45, 
	46, 9, 10, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 44, 46, 9, 
	10, 43, 45, 48, 57, 43, 45, 48, 
	57, 48, 57, 13, 32, 43, 45, 46, 
	9, 10, 48, 57, 43, 45, 48, 57, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	69, 101, 9, 10, 43, 45, 48, 57, 
	13, 32, 43, 45, 46, 9, 10, 48, 
	57, 13, 32, 44, 46, 9, 10, 43, 
	45, 48, 57, 13, 32, 44, 48, 49, 
	9, 10, 43, 45, 48, 57, 48, 57, 
	13, 32, 44, 9, 10, 48, 57, 13, 
	32, 44, 46, 69, 101, 9, 10, 48, 
	57, 13, 32, 43, 45, 46, 9, 10, 
	48, 57, 43, 45, 48, 57, 48, 57, 
	13, 32, 44, 46, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 69, 101, 
	9, 10, 43, 45, 48, 57, 43, 45, 
	48, 57, 48, 57, 43, 45, 48, 57, 
	48, 57, 13, 32, 44, 46, 9, 10, 
	43, 45, 48, 57, 13, 32, 77, 109, 
	9, 10, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 69, 72, 
	76, 77, 81, 83, 84, 86, 90, 97, 
	99, 101, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 69, 72, 76, 77, 
	81, 83, 84, 86, 90, 97, 99, 101, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 43, 45, 48, 57, 13, 32, 
	44, 46, 65, 67, 72, 76, 77, 81, 
	83, 84, 86, 90, 97, 99, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	43, 45, 48, 57, 13, 32, 44, 46, 
	65, 67, 72, 76, 77, 81, 83, 84, 
	86, 90, 97, 99, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 13, 32, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 13, 32, 44, 46, 65, 67, 
	69, 72, 76, 77, 81, 83, 84, 86, 
	90, 97, 99, 101, 104, 108, 109, 113, 
	115, 116, 118, 122, 9, 10, 43, 45, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	13, 32, 44, 46, 65, 67, 72, 76, 
	77, 81, 83, 84, 86, 90, 97, 99, 
	104, 108, 109, 113, 115, 116, 118, 122, 
	9, 10, 48, 57, 13, 32, 44, 46, 
	65, 67, 69, 72, 76, 77, 81, 83, 
	84, 86, 90, 97, 99, 101, 104, 108, 
	109, 113, 115, 116, 118, 122, 9, 10, 
	48, 57, 13, 32, 44, 46, 65, 67, 
	72, 76, 77, 81, 83, 84, 86, 90, 
	97, 99, 104, 108, 109, 113, 115, 116, 
	118, 122, 9, 10, 43, 45, 48, 57, 
	0
};

static const char _svg_path_single_lengths[] = {
	0, 5, 5, 1, 0, 6, 4, 1, 
	0, 1, 0, 6, 4, 1, 0, 5, 
	6, 5, 3, 3, 0, 6, 4, 3, 
	0, 6, 4, 1, 0, 5, 5, 4, 
	5, 5, 4, 4, 4, 1, 0, 6, 
	4, 1, 0, 6, 2, 0, 4, 5, 
	5, 1, 0, 6, 4, 1, 0, 6, 
	4, 1, 0, 6, 4, 1, 0, 6, 
	4, 1, 0, 6, 4, 1, 0, 6, 
	5, 6, 5, 6, 5, 6, 5, 6, 
	5, 2, 0, 5, 5, 1, 0, 2, 
	0, 5, 5, 5, 1, 0, 6, 4, 
	1, 0, 6, 4, 1, 0, 6, 4, 
	1, 0, 6, 5, 6, 5, 6, 5, 
	2, 0, 5, 5, 1, 0, 6, 4, 
	1, 0, 6, 4, 1, 0, 6, 4, 
	1, 0, 6, 5, 6, 5, 6, 5, 
	2, 0, 5, 5, 1, 0, 6, 4, 
	1, 0, 6, 5, 2, 0, 5, 5, 
	1, 0, 2, 0, 3, 5, 5, 5, 
	5, 6, 5, 2, 0, 5, 5, 5, 
	5, 2, 0, 4, 2, 0, 4, 2, 
	0, 4, 2, 0, 4, 2, 0, 4, 
	2, 0, 4, 2, 0, 4, 2, 0, 
	4, 2, 0, 4, 2, 0, 4, 2, 
	0, 4, 2, 0, 4, 2, 0, 4, 
	2, 0, 5, 2, 0, 4, 6, 5, 
	4, 5, 2, 0, 3, 6, 5, 2, 
	0, 4, 6, 2, 0, 2, 0, 4, 
	4, 26, 24, 26, 26, 26, 24, 26, 
	24, 26, 24, 26, 24, 26, 24, 26, 
	24, 26, 24, 26, 24, 26, 24, 26, 
	24, 26, 24, 26, 24, 26, 24, 22, 
	22, 26, 24, 24, 26, 24
};

static const char _svg_path_range_lengths[] = {
	0, 2, 2, 1, 1, 3, 3, 1, 
	1, 1, 1, 3, 3, 1, 1, 2, 
	3, 2, 2, 2, 1, 2, 2, 2, 
	1, 3, 3, 1, 1, 2, 1, 1, 
	1, 1, 1, 3, 3, 1, 1, 3, 
	3, 1, 1, 2, 1, 1, 2, 2, 
	2, 1, 1, 3, 3, 1, 1, 3, 
	3, 1, 1, 3, 3, 1, 1, 3, 
	3, 1, 1, 3, 3, 1, 1, 3, 
	2, 3, 2, 3, 2, 3, 2, 3, 
	2, 1, 1, 2, 2, 1, 1, 1, 
	1, 2, 2, 2, 1, 1, 3, 3, 
	1, 1, 3, 3, 1, 1, 3, 3, 
	1, 1, 3, 2, 3, 2, 3, 2, 
	1, 1, 2, 2, 1, 1, 3, 3, 
	1, 1, 3, 3, 1, 1, 3, 3, 
	1, 1, 3, 2, 3, 2, 3, 2, 
	1, 1, 2, 2, 1, 1, 3, 3, 
	1, 1, 3, 2, 1, 1, 2, 2, 
	1, 1, 1, 1, 2, 2, 2, 2, 
	2, 3, 2, 1, 1, 2, 2, 2, 
	2, 1, 1, 3, 1, 1, 3, 1, 
	1, 3, 1, 1, 3, 1, 1, 3, 
	1, 1, 3, 1, 1, 3, 1, 1, 
	3, 1, 1, 3, 1, 1, 3, 1, 
	1, 3, 1, 1, 3, 1, 1, 3, 
	1, 1, 2, 1, 1, 3, 3, 2, 
	3, 1, 1, 1, 2, 2, 2, 1, 
	1, 3, 3, 1, 1, 1, 1, 3, 
	1, 3, 3, 3, 3, 2, 2, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 1, 
	1, 3, 3, 2, 2, 3
};

static const short _svg_path_index_offsets[] = {
	0, 0, 8, 16, 19, 21, 31, 39, 
	42, 44, 47, 49, 59, 67, 70, 72, 
	80, 90, 98, 104, 110, 112, 121, 128, 
	134, 136, 146, 154, 157, 159, 167, 174, 
	180, 187, 194, 200, 208, 216, 219, 221, 
	231, 239, 242, 244, 253, 257, 259, 266, 
	274, 282, 285, 287, 297, 305, 308, 310, 
	320, 328, 331, 333, 343, 351, 354, 356, 
	366, 374, 377, 379, 389, 397, 400, 402, 
	412, 420, 430, 438, 448, 456, 466, 474, 
	484, 492, 496, 498, 506, 514, 517, 519, 
	523, 525, 533, 541, 549, 552, 554, 564, 
	572, 575, 577, 587, 595, 598, 600, 610, 
	618, 621, 623, 633, 641, 651, 659, 669, 
	677, 681, 683, 691, 699, 702, 704, 714, 
	722, 725, 727, 737, 745, 748, 750, 760, 
	768, 771, 773, 783, 791, 801, 809, 819, 
	827, 831, 833, 841, 849, 852, 854, 864, 
	872, 875, 877, 887, 895, 899, 901, 909, 
	917, 920, 922, 926, 928, 934, 942, 950, 
	958, 966, 976, 984, 988, 990, 998, 1006, 
	1014, 1022, 1026, 1028, 1036, 1040, 1042, 1050, 
	1054, 1056, 1064, 1068, 1070, 1078, 1082, 1084, 
	1092, 1096, 1098, 1106, 1110, 1112, 1120, 1124, 
	1126, 1134, 1138, 1140, 1148, 1152, 1154, 1162, 
	1166, 1168, 1176, 1180, 1182, 1190, 1194, 1196, 
	1204, 1208, 1210, 1218, 1222, 1224, 1232, 1242, 
	1250, 1258, 1265, 1269, 1271, 1277, 1286, 1294, 
	1298, 1300, 1308, 1318, 1322, 1324, 1328, 1330, 
	1338, 1344, 1374, 1402, 1432, 1462, 1491, 1518, 
	1548, 1576, 1606, 1634, 1664, 1692, 1722, 1750, 
	1780, 1808, 1838, 1866, 1896, 1924, 1954, 1982, 
	2012, 2040, 2070, 2098, 2128, 2156, 2186, 2214, 
	2238, 2262, 2292, 2320, 2347, 2376
};

static const short _svg_path_indicies[] = {
	0, 0, 2, 2, 3, 0, 4, 1, 
	5, 5, 6, 6, 7, 5, 8, 1, 
	9, 10, 1, 11, 1, 12, 12, 14, 
	15, 16, 16, 12, 13, 11, 1, 17, 
	17, 19, 20, 17, 18, 21, 1, 22, 
	23, 1, 24, 1, 25, 26, 1, 27, 
	1, 28, 28, 30, 31, 32, 32, 28, 
	29, 27, 1, 33, 33, 35, 36, 33, 
	34, 37, 1, 38, 39, 1, 40, 1, 
	41, 41, 42, 42, 43, 41, 44, 1, 
	28, 28, 30, 27, 32, 32, 28, 29, 
	26, 1, 35, 35, 34, 34, 36, 35, 
	37, 1, 45, 45, 46, 45, 47, 1, 
	48, 48, 49, 48, 50, 1, 51, 1, 
	52, 52, 53, 54, 55, 55, 52, 51, 
	1, 56, 56, 57, 58, 56, 59, 1, 
	57, 57, 58, 57, 59, 1, 60, 1, 
	61, 61, 63, 64, 65, 65, 61, 62, 
	60, 1, 66, 66, 68, 69, 66, 67, 
	70, 1, 71, 72, 1, 73, 1, 74, 
	74, 75, 76, 76, 74, 73, 1, 77, 
	77, 78, 79, 80, 77, 1, 78, 78, 
	79, 80, 78, 1, 81, 81, 82, 83, 
	84, 81, 1, 85, 85, 86, 87, 88, 
	85, 1, 86, 86, 87, 88, 86, 1, 
	89, 89, 91, 92, 89, 90, 93, 1, 
	94, 94, 96, 97, 94, 95, 98, 1, 
	99, 100, 1, 101, 1, 102, 102, 104, 
	105, 106, 106, 102, 103, 101, 1, 107, 
	107, 109, 110, 107, 108, 111, 1, 112, 
	113, 1, 114, 1, 52, 52, 53, 51, 
	55, 55, 52, 115, 1, 116, 116, 117, 
	1, 117, 1, 52, 52, 53, 54, 52, 
	117, 1, 118, 118, 119, 119, 120, 118, 
	121, 1, 122, 122, 123, 123, 124, 122, 
	125, 1, 126, 127, 1, 128, 1, 129, 
	129, 131, 132, 133, 133, 129, 130, 128, 
	1, 134, 134, 136, 137, 134, 135, 138, 
	1, 139, 140, 1, 141, 1, 142, 142, 
	144, 145, 146, 146, 142, 143, 141, 1, 
	147, 147, 149, 150, 147, 148, 151, 1, 
	152, 153, 1, 154, 1, 155, 155, 157, 
	158, 159, 159, 155, 156, 154, 1, 160, 
	160, 162, 163, 160, 161, 164, 1, 165, 
	166, 1, 167, 1, 168, 168, 170, 171, 
	172, 172, 168, 169, 167, 1, 173, 173, 
	175, 176, 173, 174, 177, 1, 178, 179, 
	1, 180, 1, 181, 181, 183, 184, 185, 
	185, 181, 182, 180, 1, 186, 186, 188, 
	189, 186, 187, 190, 1, 191, 192, 1, 
	193, 1, 129, 129, 131, 128, 133, 133, 
	129, 130, 127, 1, 136, 136, 135, 135, 
	137, 136, 138, 1, 142, 142, 144, 141, 
	146, 146, 142, 143, 140, 1, 149, 149, 
	148, 148, 150, 149, 151, 1, 155, 155, 
	157, 154, 159, 159, 155, 156, 153, 1, 
	162, 162, 161, 161, 163, 162, 164, 1, 
	168, 168, 170, 167, 172, 172, 168, 169, 
	166, 1, 175, 175, 174, 174, 176, 175, 
	177, 1, 181, 181, 183, 180, 185, 185, 
	181, 182, 179, 1, 188, 188, 187, 187, 
	189, 188, 190, 1, 194, 194, 195, 1, 
	195, 1, 196, 196, 197, 197, 198, 196, 
	199, 1, 200, 200, 201, 201, 202, 200, 
	203, 1, 204, 205, 1, 206, 1, 207, 
	207, 208, 1, 208, 1, 209, 209, 210, 
	210, 211, 209, 212, 1, 213, 213, 214, 
	214, 215, 213, 216, 1, 217, 217, 218, 
	218, 219, 217, 220, 1, 221, 222, 1, 
	223, 1, 224, 224, 226, 227, 228, 228, 
	224, 225, 223, 1, 229, 229, 231, 232, 
	229, 230, 233, 1, 234, 235, 1, 236, 
	1, 237, 237, 239, 240, 241, 241, 237, 
	238, 236, 1, 242, 242, 244, 245, 242, 
	243, 246, 1, 247, 248, 1, 249, 1, 
	250, 250, 252, 253, 254, 254, 250, 251, 
	249, 1, 255, 255, 257, 258, 255, 256, 
	259, 1, 260, 261, 1, 262, 1, 224, 
	224, 226, 223, 228, 228, 224, 225, 222, 
	1, 231, 231, 230, 230, 232, 231, 233, 
	1, 237, 237, 239, 236, 241, 241, 237, 
	238, 235, 1, 244, 244, 243, 243, 245, 
	244, 246, 1, 250, 250, 252, 249, 254, 
	254, 250, 251, 248, 1, 257, 257, 256, 
	256, 258, 257, 259, 1, 263, 263, 264, 
	1, 264, 1, 265, 265, 266, 266, 267, 
	265, 268, 1, 269, 269, 270, 270, 271, 
	269, 272, 1, 273, 274, 1, 275, 1, 
	276, 276, 278, 279, 280, 280, 276, 277, 
	275, 1, 281, 281, 283, 284, 281, 282, 
	285, 1, 286, 287, 1, 288, 1, 289, 
	289, 291, 292, 293, 293, 289, 290, 288, 
	1, 294, 294, 296, 297, 294, 295, 298, 
	1, 299, 300, 1, 301, 1, 302, 302, 
	304, 305, 306, 306, 302, 303, 301, 1, 
	307, 307, 309, 310, 307, 308, 311, 1, 
	312, 313, 1, 314, 1, 276, 276, 278, 
	275, 280, 280, 276, 277, 274, 1, 283, 
	283, 282, 282, 284, 283, 285, 1, 289, 
	289, 291, 288, 293, 293, 289, 290, 287, 
	1, 296, 296, 295, 295, 297, 296, 298, 
	1, 302, 302, 304, 301, 306, 306, 302, 
	303, 300, 1, 309, 309, 308, 308, 310, 
	309, 311, 1, 315, 315, 316, 1, 316, 
	1, 317, 317, 318, 318, 319, 317, 320, 
	1, 321, 321, 322, 322, 323, 321, 324, 
	1, 325, 326, 1, 327, 1, 328, 328, 
	330, 331, 332, 332, 328, 329, 327, 1, 
	333, 333, 335, 336, 333, 334, 337, 1, 
	338, 339, 1, 340, 1, 328, 328, 330, 
	327, 332, 332, 328, 329, 326, 1, 335, 
	335, 334, 334, 336, 335, 337, 1, 341, 
	341, 342, 1, 342, 1, 343, 343, 344, 
	344, 345, 343, 346, 1, 347, 347, 348, 
	348, 349, 347, 350, 1, 351, 352, 1, 
	353, 1, 354, 354, 355, 1, 355, 1, 
	356, 356, 357, 356, 358, 1, 359, 359, 
	360, 360, 361, 359, 362, 1, 363, 363, 
	364, 364, 365, 363, 366, 1, 367, 367, 
	368, 368, 369, 367, 370, 1, 371, 371, 
	372, 372, 373, 371, 374, 1, 12, 12, 
	14, 11, 16, 16, 12, 13, 10, 1, 
	19, 19, 18, 18, 20, 19, 21, 1, 
	375, 375, 376, 1, 376, 1, 377, 377, 
	378, 378, 379, 377, 380, 1, 381, 381, 
	382, 382, 383, 381, 384, 1, 385, 385, 
	386, 386, 387, 385, 388, 1, 389, 389, 
	390, 390, 391, 389, 392, 1, 393, 393, 
	394, 1, 394, 1, 12, 12, 14, 15, 
	12, 13, 394, 1, 395, 395, 396, 1, 
	396, 1, 328, 328, 330, 331, 328, 329, 
	396, 1, 397, 397, 398, 1, 398, 1, 
	302, 302, 304, 305, 302, 303, 398, 1, 
	399, 399, 400, 1, 400, 1, 289, 289, 
	291, 292, 289, 290, 400, 1, 401, 401, 
	402, 1, 402, 1, 276, 276, 278, 279, 
	276, 277, 402, 1, 403, 403, 404, 1, 
	404, 1, 250, 250, 252, 253, 250, 251, 
	404, 1, 405, 405, 406, 1, 406, 1, 
	237, 237, 239, 240, 237, 238, 406, 1, 
	407, 407, 408, 1, 408, 1, 224, 224, 
	226, 227, 224, 225, 408, 1, 409, 409, 
	410, 1, 410, 1, 181, 181, 183, 184, 
	181, 182, 410, 1, 411, 411, 412, 1, 
	412, 1, 168, 168, 170, 171, 168, 169, 
	412, 1, 413, 413, 414, 1, 414, 1, 
	155, 155, 157, 158, 155, 156, 414, 1, 
	415, 415, 416, 1, 416, 1, 142, 142, 
	144, 145, 142, 143, 416, 1, 417, 417, 
	418, 1, 418, 1, 129, 129, 131, 132, 
	129, 130, 418, 1, 419, 419, 420, 1, 
	420, 1, 109, 109, 108, 108, 110, 109, 
	111, 1, 421, 421, 422, 1, 422, 1, 
	102, 102, 104, 105, 102, 103, 422, 1, 
	102, 102, 104, 101, 106, 106, 102, 103, 
	100, 1, 96, 96, 95, 95, 97, 96, 
	98, 1, 423, 423, 425, 426, 423, 424, 
	427, 1, 428, 428, 429, 430, 431, 428, 
	1, 432, 432, 433, 1, 433, 1, 74, 
	74, 75, 74, 433, 1, 74, 74, 75, 
	73, 76, 76, 74, 72, 1, 68, 68, 
	67, 67, 69, 68, 70, 1, 434, 434, 
	435, 1, 435, 1, 61, 61, 63, 64, 
	61, 62, 435, 1, 61, 61, 63, 60, 
	65, 65, 61, 62, 436, 1, 437, 437, 
	438, 1, 438, 1, 439, 439, 440, 1, 
	440, 1, 28, 28, 30, 31, 28, 29, 
	440, 1, 441, 441, 442, 443, 441, 1, 
	444, 444, 446, 447, 448, 449, 450, 451, 
	452, 453, 454, 455, 456, 457, 458, 459, 
	460, 450, 461, 462, 463, 464, 465, 466, 
	467, 458, 444, 445, 24, 1, 468, 468, 
	41, 43, 469, 470, 471, 472, 442, 473, 
	474, 475, 476, 477, 478, 479, 480, 481, 
	443, 482, 483, 484, 485, 477, 468, 42, 
	44, 1, 486, 486, 488, 489, 490, 491, 
	492, 493, 494, 495, 496, 497, 498, 499, 
	500, 501, 502, 492, 503, 504, 505, 506, 
	507, 508, 509, 500, 486, 487, 40, 1, 
	486, 486, 488, 40, 490, 491, 492, 493, 
	494, 495, 496, 497, 498, 499, 500, 501, 
	502, 492, 503, 504, 505, 506, 507, 508, 
	509, 500, 486, 487, 39, 1, 510, 510, 
	511, 512, 513, 514, 515, 516, 517, 518, 
	519, 520, 521, 522, 523, 524, 525, 515, 
	526, 527, 528, 529, 530, 531, 532, 523, 
	510, 114, 1, 533, 533, 48, 49, 469, 
	470, 471, 472, 442, 473, 474, 475, 476, 
	477, 478, 479, 480, 481, 443, 482, 483, 
	484, 485, 477, 533, 50, 1, 534, 534, 
	536, 537, 538, 539, 540, 541, 542, 543, 
	544, 545, 546, 547, 548, 549, 550, 540, 
	551, 552, 553, 554, 555, 556, 557, 548, 
	534, 535, 193, 1, 558, 558, 122, 124, 
	469, 470, 471, 472, 442, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 443, 482, 
	483, 484, 485, 477, 558, 123, 125, 1, 
	534, 534, 536, 193, 538, 539, 540, 541, 
	542, 543, 544, 545, 546, 547, 548, 549, 
	550, 540, 551, 552, 553, 554, 555, 556, 
	557, 548, 534, 535, 192, 1, 534, 534, 
	536, 537, 538, 539, 541, 542, 543, 544, 
	545, 546, 547, 548, 549, 550, 551, 552, 
	553, 554, 555, 556, 557, 548, 534, 535, 
	195, 1, 559, 559, 561, 562, 563, 564, 
	565, 566, 567, 568, 569, 570, 571, 572, 
	573, 574, 575, 565, 576, 577, 578, 579, 
	580, 581, 582, 573, 559, 560, 206, 1, 
	583, 583, 200, 202, 469, 470, 471, 472, 
	442, 473, 474, 475, 476, 477, 478, 479, 
	480, 481, 443, 482, 483, 484, 485, 477, 
	583, 201, 203, 1, 559, 559, 561, 206, 
	563, 564, 565, 566, 567, 568, 569, 570, 
	571, 572, 573, 574, 575, 565, 576, 577, 
	578, 579, 580, 581, 582, 573, 559, 560, 
	205, 1, 559, 559, 561, 562, 563, 564, 
	566, 567, 568, 569, 570, 571, 572, 573, 
	574, 575, 576, 577, 578, 579, 580, 581, 
	582, 573, 559, 560, 208, 1, 584, 584, 
	586, 587, 588, 589, 590, 591, 592, 593, 
	594, 595, 596, 597, 598, 599, 600, 590, 
	601, 602, 603, 604, 605, 606, 607, 598, 
	584, 585, 262, 1, 608, 608, 217, 219, 
	469, 470, 471, 472, 442, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 443, 482, 
	483, 484, 485, 477, 608, 218, 220, 1, 
	584, 584, 586, 262, 588, 589, 590, 591, 
	592, 593, 594, 595, 596, 597, 598, 599, 
	600, 590, 601, 602, 603, 604, 605, 606, 
	607, 598, 584, 585, 261, 1, 584, 584, 
	586, 587, 588, 589, 591, 592, 593, 594, 
	595, 596, 597, 598, 599, 600, 601, 602, 
	603, 604, 605, 606, 607, 598, 584, 585, 
	264, 1, 609, 609, 611, 612, 613, 614, 
	615, 616, 617, 618, 619, 620, 621, 622, 
	623, 624, 625, 615, 626, 627, 628, 629, 
	630, 631, 632, 623, 609, 610, 314, 1, 
	633, 633, 269, 271, 469, 470, 471, 472, 
	442, 473, 474, 475, 476, 477, 478, 479, 
	480, 481, 443, 482, 483, 484, 485, 477, 
	633, 270, 272, 1, 609, 609, 611, 314, 
	613, 614, 615, 616, 617, 618, 619, 620, 
	621, 622, 623, 624, 625, 615, 626, 627, 
	628, 629, 630, 631, 632, 623, 609, 610, 
	313, 1, 609, 609, 611, 612, 613, 614, 
	616, 617, 618, 619, 620, 621, 622, 623, 
	624, 625, 626, 627, 628, 629, 630, 631, 
	632, 623, 609, 610, 316, 1, 634, 634, 
	636, 637, 638, 639, 640, 641, 642, 643, 
	644, 645, 646, 647, 648, 649, 650, 640, 
	651, 652, 653, 654, 655, 656, 657, 648, 
	634, 635, 340, 1, 658, 658, 321, 323, 
	469, 470, 471, 472, 442, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 443, 482, 
	483, 484, 485, 477, 658, 322, 324, 1, 
	634, 634, 636, 340, 638, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 640, 651, 652, 653, 654, 655, 656, 
	657, 648, 634, 635, 339, 1, 634, 634, 
	636, 637, 638, 639, 641, 642, 643, 644, 
	645, 646, 647, 648, 649, 650, 651, 652, 
	653, 654, 655, 656, 657, 648, 634, 635, 
	342, 1, 659, 659, 661, 662, 663, 664, 
	665, 666, 667, 668, 669, 670, 671, 672, 
	673, 674, 675, 665, 676, 677, 678, 679, 
	680, 681, 682, 673, 659, 660, 353, 1, 
	683, 683, 347, 349, 469, 470, 471, 472, 
	442, 473, 474, 475, 476, 477, 478, 479, 
	480, 481, 443, 482, 483, 484, 485, 477, 
	683, 348, 350, 1, 659, 659, 661, 353, 
	663, 664, 665, 666, 667, 668, 669, 670, 
	671, 672, 673, 674, 675, 665, 676, 677, 
	678, 679, 680, 681, 682, 673, 659, 660, 
	352, 1, 659, 659, 661, 662, 663, 664, 
	666, 667, 668, 669, 670, 671, 672, 673, 
	674, 675, 676, 677, 678, 679, 680, 681, 
	682, 673, 659, 660, 355, 1, 684, 684, 
	685, 686, 687, 688, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 702, 703, 694, 684, 1, 704, 704, 
	469, 470, 471, 472, 442, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 443, 482, 
	483, 484, 485, 477, 704, 1, 444, 444, 
	446, 24, 448, 449, 450, 451, 452, 453, 
	454, 455, 456, 457, 458, 459, 460, 450, 
	461, 462, 463, 464, 465, 466, 467, 458, 
	444, 445, 23, 1, 444, 444, 446, 447, 
	448, 449, 451, 452, 453, 454, 455, 456, 
	457, 458, 459, 460, 461, 462, 463, 464, 
	465, 466, 467, 458, 444, 445, 376, 1, 
	510, 510, 511, 512, 513, 514, 516, 517, 
	518, 519, 520, 521, 522, 523, 524, 525, 
	526, 527, 528, 529, 530, 531, 532, 523, 
	510, 420, 1, 510, 510, 511, 114, 513, 
	514, 515, 516, 517, 518, 519, 520, 521, 
	522, 523, 524, 525, 515, 526, 527, 528, 
	529, 530, 531, 532, 523, 510, 113, 1, 
	486, 486, 488, 489, 490, 491, 493, 494, 
	495, 496, 497, 498, 499, 500, 501, 502, 
	503, 504, 505, 506, 507, 508, 509, 500, 
	486, 487, 438, 1, 0
};

static const short _svg_path_trans_targs[] = {
	2, 0, 3, 4, 161, 2, 3, 4, 
	161, 4, 161, 5, 6, 7, 162, 8, 
	169, 6, 7, 162, 8, 265, 8, 265, 
	233, 10, 16, 11, 12, 13, 17, 14, 
	229, 12, 13, 17, 14, 236, 14, 236, 
	235, 15, 9, 10, 16, 19, 20, 43, 
	19, 20, 43, 21, 22, 23, 24, 44, 
	22, 23, 24, 226, 25, 26, 27, 222, 
	28, 223, 26, 27, 222, 28, 221, 28, 
	221, 29, 30, 31, 218, 30, 31, 32, 
	217, 33, 34, 35, 216, 33, 34, 35, 
	216, 36, 37, 215, 38, 214, 36, 37, 
	215, 38, 214, 38, 214, 39, 40, 41, 
	210, 42, 211, 40, 41, 210, 42, 268, 
	42, 268, 237, 43, 45, 46, 48, 49, 
	50, 71, 48, 49, 50, 71, 50, 71, 
	51, 52, 53, 72, 54, 205, 52, 53, 
	72, 54, 73, 54, 73, 55, 56, 57, 
	74, 58, 202, 56, 57, 74, 58, 75, 
	58, 75, 59, 60, 61, 76, 62, 199, 
	60, 61, 76, 62, 77, 62, 77, 63, 
	64, 65, 78, 66, 196, 64, 65, 78, 
	66, 79, 66, 79, 67, 68, 69, 80, 
	70, 193, 68, 69, 80, 70, 241, 70, 
	241, 239, 82, 242, 84, 85, 86, 245, 
	84, 85, 86, 245, 86, 245, 243, 88, 
	246, 15, 9, 10, 16, 91, 92, 93, 
	106, 91, 92, 93, 106, 93, 106, 94, 
	95, 96, 107, 97, 190, 95, 96, 107, 
	97, 108, 97, 108, 98, 99, 100, 109, 
	101, 187, 99, 100, 109, 101, 110, 101, 
	110, 102, 103, 104, 111, 105, 184, 103, 
	104, 111, 105, 249, 105, 249, 247, 113, 
	250, 115, 116, 117, 130, 115, 116, 117, 
	130, 117, 130, 118, 119, 120, 131, 121, 
	181, 119, 120, 131, 121, 132, 121, 132, 
	122, 123, 124, 133, 125, 178, 123, 124, 
	133, 125, 134, 125, 134, 126, 127, 128, 
	135, 129, 175, 127, 128, 135, 129, 253, 
	129, 253, 251, 137, 254, 139, 140, 141, 
	146, 139, 140, 141, 146, 141, 146, 142, 
	143, 144, 147, 145, 172, 143, 144, 147, 
	145, 257, 145, 257, 255, 149, 258, 151, 
	152, 153, 261, 151, 152, 153, 261, 153, 
	261, 259, 155, 262, 19, 20, 43, 48, 
	49, 50, 71, 84, 85, 86, 245, 15, 
	9, 10, 16, 2, 3, 4, 161, 164, 
	266, 91, 92, 93, 106, 115, 116, 117, 
	130, 139, 140, 141, 146, 151, 152, 153, 
	261, 170, 171, 173, 174, 176, 177, 179, 
	180, 182, 183, 185, 186, 188, 189, 191, 
	192, 194, 195, 197, 198, 200, 201, 203, 
	204, 206, 207, 209, 267, 212, 213, 36, 
	37, 215, 38, 214, 33, 34, 35, 216, 
	219, 220, 224, 225, 226, 228, 269, 230, 
	231, 232, 1, 160, 234, 9, 15, 10, 
	18, 47, 163, 83, 89, 1, 90, 114, 
	138, 150, 263, 156, 157, 158, 159, 160, 
	165, 166, 167, 168, 234, 18, 47, 83, 
	89, 90, 114, 138, 150, 263, 156, 157, 
	158, 159, 165, 166, 167, 168, 234, 9, 
	15, 10, 18, 47, 227, 83, 89, 1, 
	90, 114, 138, 150, 263, 156, 157, 158, 
	159, 160, 165, 166, 167, 168, 238, 19, 
	20, 18, 47, 208, 83, 89, 1, 90, 
	114, 138, 150, 263, 156, 157, 158, 159, 
	160, 165, 166, 167, 168, 238, 240, 49, 
	48, 50, 18, 47, 81, 83, 89, 1, 
	90, 114, 138, 150, 263, 156, 157, 158, 
	159, 160, 165, 166, 167, 168, 240, 244, 
	85, 84, 86, 18, 47, 87, 83, 89, 
	1, 90, 114, 138, 150, 263, 156, 157, 
	158, 159, 160, 165, 166, 167, 168, 244, 
	248, 92, 91, 93, 18, 47, 112, 83, 
	89, 1, 90, 114, 138, 150, 263, 156, 
	157, 158, 159, 160, 165, 166, 167, 168, 
	248, 252, 116, 115, 117, 18, 47, 136, 
	83, 89, 1, 90, 114, 138, 150, 263, 
	156, 157, 158, 159, 160, 165, 166, 167, 
	168, 252, 256, 140, 139, 141, 18, 47, 
	148, 83, 89, 1, 90, 114, 138, 150, 
	263, 156, 157, 158, 159, 160, 165, 166, 
	167, 168, 256, 260, 152, 151, 153, 18, 
	47, 154, 83, 89, 1, 90, 114, 138, 
	150, 263, 156, 157, 158, 159, 160, 165, 
	166, 167, 168, 260, 264, 18, 47, 83, 
	89, 1, 90, 114, 138, 150, 263, 156, 
	157, 158, 159, 160, 165, 166, 167, 168, 
	264
};

static const char _svg_path_trans_actions[] = {
	9, 0, 51, 51, 51, 0, 1, 1, 
	1, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 0, 1, 1, 1, 9, 51, 51, 
	0, 1, 1, 0, 3, 3, 15, 0, 
	0, 0, 1, 1, 0, 3, 15, 3, 
	15, 0, 0, 1, 0, 1, 1, 0, 
	0, 0, 3, 3, 0, 0, 0, 0, 
	0, 7, 7, 7, 7, 0, 0, 0, 
	0, 7, 48, 7, 48, 48, 0, 1, 
	0, 1, 1, 0, 0, 0, 3, 15, 
	3, 15, 0, 0, 1, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 9, 51, 
	51, 51, 0, 1, 1, 1, 0, 0, 
	0, 3, 15, 3, 15, 0, 0, 1, 
	0, 1, 1, 0, 0, 0, 3, 15, 
	3, 15, 0, 0, 1, 0, 1, 1, 
	0, 0, 0, 3, 15, 3, 15, 0, 
	0, 1, 0, 1, 1, 0, 0, 0, 
	3, 15, 3, 15, 0, 0, 1, 0, 
	1, 1, 0, 0, 0, 3, 15, 3, 
	15, 0, 0, 1, 0, 1, 1, 0, 
	0, 0, 0, 0, 9, 51, 51, 51, 
	0, 1, 1, 1, 0, 0, 0, 0, 
	0, 9, 51, 51, 51, 9, 51, 51, 
	51, 0, 1, 1, 1, 0, 0, 0, 
	3, 15, 3, 15, 0, 0, 1, 0, 
	1, 1, 0, 0, 0, 3, 15, 3, 
	15, 0, 0, 1, 0, 1, 1, 0, 
	0, 0, 3, 15, 3, 15, 0, 0, 
	1, 0, 1, 1, 0, 0, 0, 0, 
	0, 9, 51, 51, 51, 0, 1, 1, 
	1, 0, 0, 0, 3, 15, 3, 15, 
	0, 0, 1, 0, 1, 1, 0, 0, 
	0, 3, 15, 3, 15, 0, 0, 1, 
	0, 1, 1, 0, 0, 0, 3, 15, 
	3, 15, 0, 0, 1, 0, 1, 1, 
	0, 0, 0, 0, 0, 9, 51, 51, 
	51, 0, 1, 1, 1, 0, 0, 0, 
	3, 15, 3, 15, 0, 0, 1, 0, 
	1, 1, 0, 0, 0, 0, 0, 9, 
	51, 51, 51, 0, 1, 1, 1, 0, 
	0, 0, 0, 0, 11, 54, 54, 11, 
	54, 54, 54, 11, 54, 54, 54, 11, 
	54, 54, 54, 11, 54, 54, 54, 0, 
	0, 11, 54, 54, 54, 11, 54, 54, 
	54, 11, 54, 54, 54, 11, 54, 54, 
	54, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 5, 
	45, 5, 45, 45, 5, 5, 5, 5, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 18, 57, 18, 57, 
	18, 18, 0, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 21, 61, 
	21, 61, 21, 21, 0, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 42, 42, 
	89, 42, 42, 0, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 0, 30, 73, 
	30, 73, 30, 30, 0, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 0, 24, 
	65, 24, 65, 24, 24, 0, 24, 24, 
	24, 24, 24, 24, 24, 24, 24, 24, 
	24, 24, 24, 24, 24, 24, 24, 0, 
	36, 81, 36, 81, 36, 36, 0, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	0, 33, 77, 33, 77, 33, 33, 0, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 0, 39, 85, 39, 85, 39, 39, 
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 0, 27, 69, 27, 69, 27, 
	27, 0, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 0, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	0
};

static const char _svg_path_eof_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 18, 0, 21, 21, 42, 0, 30, 
	0, 30, 30, 24, 0, 24, 24, 36, 
	0, 36, 36, 33, 0, 33, 33, 39, 
	0, 39, 39, 27, 0, 27, 27, 13, 
	0, 18, 18, 42, 42, 21
};

static const int svg_path_start = 232;
static const int svg_path_first_final = 232;

static const int svg_path_en_main = 232;


#line 47 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"


SVGPathParser::SVGPathParser(PathSink &sink)
    : _absolute(false)
    , _sink(sink)
    , _z_snap_threshold(0)
    , _curve(NULL)
{
    reset();
}

SVGPathParser::~SVGPathParser()
{
    delete _curve;
}

void SVGPathParser::reset() {
    _absolute = false;
    _current = _initial = Point(0, 0);
    _quad_tangent = _cubic_tangent = Point(0, 0);
    _params.clear();
    delete _curve;
    _curve = NULL;

    
#line 1105 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.cpp"
	{
	cs = svg_path_start;
	}

#line 73 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"

}

void SVGPathParser::parse(char const *str, int len)
{
    if (len < 0) {
        len = std::strlen(str);
    }
    _parse(str, str + len, true);
}

void SVGPathParser::parse(std::string const &s)
{
    _parse(s.c_str(), s.c_str() + s.size(), true);
}

void SVGPathParser::feed(char const *str, int len)
{
    if (len < 0) {
        len = std::strlen(str);
    }
    _parse(str, str + len, false);
}

void SVGPathParser::feed(std::string const &s)
{
    _parse(s.c_str(), s.c_str() + s.size(), false);
}

void SVGPathParser::finish()
{
    char const *empty = "";
    _parse(empty, empty, true);
}

void SVGPathParser::_push(Coord value)
{
    _params.push_back(value);
}

Coord SVGPathParser::_pop()
{
    Coord value = _params.back();
    _params.pop_back();
    return value;
}

bool SVGPathParser::_pop_flag()
{
    return _pop() != 0.0;
}

Coord SVGPathParser::_pop_coord(Dim2 axis)
{
    if (_absolute) {
        return _pop();
    } else {
        return _pop() + _current[axis];
    }
}

Point SVGPathParser::_pop_point()
{
    Coord y = _pop_coord(Y);
    Coord x = _pop_coord(X);
    return Point(x, y);
}

void SVGPathParser::_moveTo(Point const &p)
{
    _pushCurve(NULL); // flush
    _sink.moveTo(p);
    _quad_tangent = _cubic_tangent = _current = _initial = p;
}

void SVGPathParser::_lineTo(Point const &p)
{
    _pushCurve(new LineSegment(_current, p));
    _quad_tangent = _cubic_tangent = _current = p;
}

void SVGPathParser::_curveTo(Point const &c0, Point const &c1, Point const &p)
{
    _pushCurve(new CubicBezier(_current, c0, c1, p));
    _quad_tangent = _current = p;
    _cubic_tangent = p + ( p - c1 );
}

void SVGPathParser::_quadTo(Point const &c, Point const &p)
{
    _pushCurve(new QuadraticBezier(_current, c, p));
    _cubic_tangent = _current = p;
    _quad_tangent = p + ( p - c );
}

void SVGPathParser::_arcTo(Coord rx, Coord ry, Coord angle,
                           bool large_arc, bool sweep, Point const &p)
{
    if (_current == p) {
        return; // ignore invalid (ambiguous) arc segments where start and end point are the same (per SVG spec)
    }

    _pushCurve(new EllipticalArc(_current, rx, ry, angle, large_arc, sweep, p));
    _quad_tangent = _cubic_tangent = _current = p;
}

void SVGPathParser::_closePath()
{
    if (_curve && (!_absolute || !_moveto_was_absolute) &&
        are_near(_initial, _current, _z_snap_threshold))
    {
        _curve->setFinal(_initial);
    }

    _pushCurve(NULL); // flush
    _sink.closePath();
    _quad_tangent = _cubic_tangent = _current = _initial;
}

void SVGPathParser::_pushCurve(Curve *c)
{
    if (_curve) {
        _sink.feed(*_curve, false);
        delete _curve;
    }
    _curve = c;
}

void SVGPathParser::_parse(char const *str, char const *strend, bool finish)
{
    char const *p = str;
    char const *pe = strend;
    char const *eof = finish ? pe : NULL;
    char const *start = NULL;

    
#line 1247 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.cpp"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _svg_path_trans_keys + _svg_path_key_offsets[cs];
	_trans = _svg_path_index_offsets[cs];

	_klen = _svg_path_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _svg_path_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _svg_path_indicies[_trans];
	cs = _svg_path_trans_targs[_trans];

	if ( _svg_path_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _svg_path_actions + _svg_path_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 209 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            start = p;
        }
	break;
	case 1:
#line 213 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            if (start) {
                std::string buf(start, p);
                _push(g_ascii_strtod(buf.c_str(), NULL));
                start = NULL;
            } else {
                std::string buf(str, p);
                _push(g_ascii_strtod((_number_part + buf).c_str(), NULL));
                _number_part.clear();
            }
        }
	break;
	case 2:
#line 225 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _push(1.0);
        }
	break;
	case 3:
#line 229 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _push(0.0);
        }
	break;
	case 4:
#line 233 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _absolute = true;
        }
	break;
	case 5:
#line 237 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _absolute = false;
        }
	break;
	case 6:
#line 241 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _moveto_was_absolute = _absolute;
            _moveTo(_pop_point());
        }
	break;
	case 7:
#line 246 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _lineTo(_pop_point());
        }
	break;
	case 8:
#line 250 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_pop_coord(X), _current[Y]));
        }
	break;
	case 9:
#line 254 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_current[X], _pop_coord(Y)));
        }
	break;
	case 10:
#line 258 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            Point c0 = _pop_point();
            _curveTo(c0, c1, p);
        }
	break;
	case 11:
#line 265 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            _curveTo(_cubic_tangent, c1, p);
        }
	break;
	case 12:
#line 271 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c = _pop_point();
            _quadTo(c, p);
        }
	break;
	case 13:
#line 277 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            _quadTo(_quad_tangent, p);
        }
	break;
	case 14:
#line 282 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point point = _pop_point();
            bool sweep = _pop_flag();
            bool large_arc = _pop_flag();
            double angle = rad_from_deg(_pop());
            double ry = _pop();
            double rx = _pop();

            _arcTo(rx, ry, angle, large_arc, sweep, point);
        }
	break;
	case 15:
#line 293 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _closePath();
        }
	break;
#line 1441 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.cpp"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _svg_path_actions + _svg_path_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 1:
#line 213 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            if (start) {
                std::string buf(start, p);
                _push(g_ascii_strtod(buf.c_str(), NULL));
                start = NULL;
            } else {
                std::string buf(str, p);
                _push(g_ascii_strtod((_number_part + buf).c_str(), NULL));
                _number_part.clear();
            }
        }
	break;
	case 6:
#line 241 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _moveto_was_absolute = _absolute;
            _moveTo(_pop_point());
        }
	break;
	case 7:
#line 246 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _lineTo(_pop_point());
        }
	break;
	case 8:
#line 250 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_pop_coord(X), _current[Y]));
        }
	break;
	case 9:
#line 254 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _lineTo(Point(_current[X], _pop_coord(Y)));
        }
	break;
	case 10:
#line 258 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            Point c0 = _pop_point();
            _curveTo(c0, c1, p);
        }
	break;
	case 11:
#line 265 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c1 = _pop_point();
            _curveTo(_cubic_tangent, c1, p);
        }
	break;
	case 12:
#line 271 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            Point c = _pop_point();
            _quadTo(c, p);
        }
	break;
	case 13:
#line 277 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point p = _pop_point();
            _quadTo(_quad_tangent, p);
        }
	break;
	case 14:
#line 282 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            Point point = _pop_point();
            bool sweep = _pop_flag();
            bool large_arc = _pop_flag();
            double angle = rad_from_deg(_pop());
            double ry = _pop();
            double rx = _pop();

            _arcTo(rx, ry, angle, large_arc, sweep, point);
        }
	break;
	case 15:
#line 293 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"
	{
            _closePath();
        }
	break;
#line 1547 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.cpp"
		}
	}
	}

	_out: {}
	}

#line 435 "/home/tweenk/src/lib2geom/src/2geom/svg-path-parser.rl"


    if (finish) {
        if (cs < svg_path_first_final) {
            throw SVGPathParseError();
        }
    } else if (start != NULL) {
        _number_part = std::string(start, pe);
    }

    if (finish) {
        _pushCurve(NULL);
        _sink.flush();
        reset();
    }
}

void parse_svg_path(char const *str, PathSink &sink)
{
    SVGPathParser parser(sink);
    parser.parse(str);
}

void parse_svg_path_file(FILE *fi, PathSink &sink)
{
    static const size_t BUFFER_SIZE = 4096;
    char buffer[BUFFER_SIZE];
    size_t bytes_read;
    SVGPathParser parser(sink);

    while (true) {
        bytes_read = fread(buffer, 1, BUFFER_SIZE, fi);
        if (bytes_read < BUFFER_SIZE) {
            parser.parse(buffer, bytes_read);
            break;
        } else {
            parser.feed(buffer, bytes_read);
        }
    }
}

} // namespace Geom

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:encoding=utf-8:textwidth=99 :
