﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/gamelift/model/GetGameSessionLogUrlRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::GameLift::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

GetGameSessionLogUrlRequest::GetGameSessionLogUrlRequest() : 
    m_gameSessionIdHasBeenSet(false)
{
}

Aws::String GetGameSessionLogUrlRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_gameSessionIdHasBeenSet)
  {
   payload.WithString("GameSessionId", m_gameSessionId);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetGameSessionLogUrlRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "GameLift.GetGameSessionLogUrl"));
  return headers;

}




