// Generated by CoffeeScript 2.5.1
var AnsiPainter, styles, tags, tools,
  hasProp = {}.hasOwnProperty;

tools = require('./tools');

tags = require('./ansiPainter/tags');

styles = require('./ansiPainter/styles');

module.exports = AnsiPainter = (function() {
  var self;

  class AnsiPainter {
    paint(s) {
      return this._replaceSpecialStrings(this._renderDom(this._parse(s)));
    }

    _replaceSpecialStrings(str) {
      return str.replace(/&sp;/g, ' ').replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&quot;/g, '"').replace(/&amp;/g, '&');
    }

    _parse(string, injectFakeRoot = true) {
      if (injectFakeRoot) {
        string = '<none>' + string + '</none>';
      }
      return tools.toDom(string);
    }

    _renderDom(dom) {
      var parentStyles;
      parentStyles = {
        bg: 'none',
        color: 'none'
      };
      return this._renderChildren(dom, parentStyles);
    }

    _renderChildren(children, parentStyles) {
      var child, n, ret;
      ret = '';
      for (n in children) {
        if (!hasProp.call(children, n)) continue;
        child = children[n];
        ret += this._renderNode(child, parentStyles);
      }
      return ret;
    }

    _renderNode(node, parentStyles) {
      if (node.type === 'text') {
        return this._renderTextNode(node, parentStyles);
      } else {
        return this._renderTag(node, parentStyles);
      }
    }

    _renderTextNode(node, parentStyles) {
      return this._wrapInStyle(node.data, parentStyles);
    }

    _wrapInStyle(str, style) {
      return styles.color(style.color) + styles.bg(style.bg) + str + styles.none();
    }

    _renderTag(node, parentStyles) {
      var currentStyles, tagStyles;
      tagStyles = this._getStylesForTagName(node.name);
      currentStyles = this._mixStyles(parentStyles, tagStyles);
      return this._renderChildren(node.children, currentStyles);
    }

    _mixStyles(...styles) {
      var final, i, key, len, style, val;
      final = {};
      for (i = 0, len = styles.length; i < len; i++) {
        style = styles[i];
        for (key in style) {
          if (!hasProp.call(style, key)) continue;
          val = style[key];
          if ((final[key] == null) || val !== 'inherit') {
            final[key] = val;
          }
        }
      }
      return final;
    }

    _getStylesForTagName(name) {
      if (tags[name] == null) {
        throw Error(`Unknown tag name \`${name}\``);
      }
      return tags[name];
    }

    static getInstance() {
      if (self._instance == null) {
        self._instance = new self();
      }
      return self._instance;
    }

    static paint(str) {
      return self.getInstance().paint(str);
    }

    static strip(s) {
      return s.replace(/\x1b\[[0-9]+m/g, '');
    }

  };

  AnsiPainter.tags = tags;

  self = AnsiPainter;

  return AnsiPainter;

}).call(this);
