/**
 * Namespace for text-related utilities.
 * @namespace text
 * @memberof axe.commons
 */
export { default as accessibleTextVirtual } from './accessible-text-virtual';
export { default as accessibleText } from './accessible-text';
export {
	default as formControlValue,
	formControlValueMethods
} from './form-control-value';
export { default as hasUnicode } from './has-unicode';
export { default as isHumanInterpretable } from './is-human-interpretable';
export { default as isIconLigature } from './is-icon-ligature';
export {
	default as isValidAutocomplete,
	autocomplete
} from './is-valid-autocomplete';
export { default as labelText } from './label-text';
export { default as labelVirtual } from './label-virtual';
export { default as label } from './label';
export { default as nativeElementType } from './native-element-type';
export { default as nativeTextAlternative } from './native-text-alternative';
export { default as nativeTextMethods } from './native-text-methods';
export { default as removeUnicode } from './remove-unicode';
export { default as sanitize } from './sanitize';
export { default as subtreeText } from './subtree-text';
export { default as titleText } from './title-text';
export { default as unsupported } from './unsupported';
export { default as visibleTextNodes } from './visible-text-nodes';
export { default as visibleVirtual } from './visible-virtual';
export { default as visible } from './visible';
