; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -fast-isel=0 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ISEL
; RUN: llc -mtriple=aarch64-linux-gnu -fast-isel=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,FAST

define i32 @test1(i32 %x) {
; CHECK-LABEL: test1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #7
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    asr w0, w8, #3
; CHECK-NEXT:    ret
  %div = sdiv i32 %x, 8
  ret i32 %div
}

define i32 @test2(i32 %x) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #7
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    neg w0, w8, asr #3
; CHECK-NEXT:    ret
  %div = sdiv i32 %x, -8
  ret i32 %div
}

define i32 @test3(i32 %x) {
; CHECK-LABEL: test3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #31
; CHECK-NEXT:    cmp w0, #0
; CHECK-NEXT:    csel w8, w8, w0, lt
; CHECK-NEXT:    asr w0, w8, #5
; CHECK-NEXT:    ret
  %div = sdiv i32 %x, 32
  ret i32 %div
}

define i64 @test4(i64 %x) {
; CHECK-LABEL: test4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #7
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #3
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, 8
  ret i64 %div
}

define i64 @test5(i64 %x) {
; CHECK-LABEL: test5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #7
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    neg x0, x8, asr #3
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, -8
  ret i64 %div
}

define i64 @test6(i64 %x) {
; CHECK-LABEL: test6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, #63
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #6
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, 64
  ret i64 %div
}

define i64 @test7(i64 %x) {
; CHECK-LABEL: test7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #281474976710655
; CHECK-NEXT:    cmp x0, #0
; CHECK-NEXT:    add x8, x0, x8
; CHECK-NEXT:    csel x8, x8, x0, lt
; CHECK-NEXT:    asr x0, x8, #48
; CHECK-NEXT:    ret
  %div = sdiv i64 %x, 281474976710656
  ret i64 %div
}

define i64 @test8(i64 %x) {
; ISEL-LABEL: test8:
; ISEL:       // %bb.0:
; ISEL-NEXT:    cmp x0, #0
; ISEL-NEXT:    cinc x8, x0, lt
; ISEL-NEXT:    asr x0, x8, #1
; ISEL-NEXT:    ret
;
; FAST-LABEL: test8:
; FAST:       // %bb.0:
; FAST-NEXT:    add x8, x0, #1
; FAST-NEXT:    cmp x0, #0
; FAST-NEXT:    csel x8, x8, x0, lt
; FAST-NEXT:    asr x0, x8, #1
; FAST-NEXT:    ret
  %div = sdiv i64 %x, 2
  ret i64 %div
}

