; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple aarch64 -mattr=+fullfp16 -global-isel -global-isel-abort=1 -verify-machineinstrs %s -o - | FileCheck %s
define half @test_s16(half %a) #0 {
; CHECK-LABEL: test_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    fmax h0, h1, h0
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt half %a, 0.0
  %sel = select i1 %fcmp, half 0.0, half %a
  ret half %sel
}

define float @test_s32(float %a) #0 {
; CHECK-LABEL: test_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    fmax s0, s1, s0
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt float %a, 0.0
  %sel = select i1 %fcmp, float 0.0, float %a
  ret float %sel
}

define double @test_s64(double %a) #0 {
; CHECK-LABEL: test_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    fmax d0, d1, d0
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt double %a, 0.0
  %sel = select i1 %fcmp, double 0.0, double %a
  ret double %sel
}

define <4 x half> @test_v4s16(<4 x half> %a) #0 {
; CHECK-LABEL: test_v4s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    dup v1.4h, v1.h[0]
; CHECK-NEXT:    fmax v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt <4 x half> %a, zeroinitializer
  %sel = select <4 x i1> %fcmp, <4 x half> zeroinitializer, <4 x half> %a
  ret <4 x half> %sel
}

define <8 x half> @test_v8s16(<8 x half> %a) #0 {
; CHECK-LABEL: test_v8s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    dup v1.8h, v1.h[0]
; CHECK-NEXT:    fmax v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt <8 x half> %a, zeroinitializer
  %sel = select <8 x i1> %fcmp, <8 x half> zeroinitializer, <8 x half> %a
  ret <8 x half> %sel
}

define <2 x float> @test_v2s32(<2 x float> %a) #0 {
; CHECK-LABEL: test_v2s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    dup v1.2s, v1.s[0]
; CHECK-NEXT:    fmax v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt <2 x float> %a, zeroinitializer
  %sel = select <2 x i1> %fcmp, <2 x float> zeroinitializer, <2 x float> %a
  ret <2 x float> %sel
}

define <4 x float> @test_v4s32(<4 x float> %a) #0 {
; CHECK-LABEL: test_v4s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    dup v1.4s, v1.s[0]
; CHECK-NEXT:    fmax v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt <4 x float> %a, zeroinitializer
  %sel = select <4 x i1> %fcmp, <4 x float> zeroinitializer, <4 x float> %a
  ret <4 x float> %sel
}

define <2 x double> @test_v2s64(<2 x double> %a) #0 {
; CHECK-LABEL: test_v2s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    dup v1.2d, v1.d[0]
; CHECK-NEXT:    fmax v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %fcmp = fcmp olt <2 x double> %a, zeroinitializer
  %sel = select <2 x i1> %fcmp, <2 x double> zeroinitializer, <2 x double> %a
  ret <2 x double> %sel
}

