/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.beans.LDAPBasePropertySupport;

public class LDAPGetEntries
extends LDAPBasePropertySupport
implements Serializable {
    private String _attribute = "dn";
    private String[] _result;
    private String _sResult = null;
    private String _errorMsg = null;

    public LDAPGetEntries() {
    }

    public LDAPGetEntries(String theHost, int thePort, String theBase) {
        this.setHost(theHost);
        this.setPort(thePort);
        this.setBase(theBase);
    }

    public LDAPGetEntries(String theHost, int thePort, String theBase, int theScope) {
        this.setHost(theHost);
        this.setPort(thePort);
        this.setBase(theBase);
        this.setScope(theScope);
    }

    private void notifyResult(String error) {
        this.firePropertyChange("error", this._errorMsg, error);
        this._errorMsg = error;
    }

    private void notifyResult(String[] newResult) {
        String sNewResult = this.convertToString(newResult);
        this.firePropertyChange("result", this._result, newResult);
        this._sResult = sNewResult;
        this._result = newResult;
    }

    public String getAttribute() {
        return this._attribute;
    }

    public void setAttribute(String attr) {
        this._attribute = attr;
    }

    public void setResultString(String sNewValue) {
        this._sResult = sNewValue;
    }

    public String getResultString() {
        return this._sResult;
    }

    public String[] getEntries(String host, int port, String base, int scope, String filter) {
        this.setHost(host);
        this.setPort(port);
        this.setBase(base);
        this.setScope(scope);
        this.setFilter(filter);
        return this.getEntries();
    }

    public String[] getEntries(String host, int port, String base, int scope, String userid, String userName) {
        this.setHost(host);
        this.setPort(port);
        this.setBase(base);
        this.setScope(scope);
        if (userName == null) {
            userName = new String("");
        }
        this.setUserName(userName);
        if (userid == null) {
            userid = new String("");
        }
        this.setUserID(userid);
        return this.getEntries();
    }

    public void getEntries(ActionEvent x) {
        this.getEntries();
    }

    public String[] getEntries() {
        LDAPConnection m_ldc;
        Object[] res;
        block30: {
            boolean invalid = false;
            if (this.getUserName().length() < 1 && this.getUserID().length() < 1 && this.getFilter().length() < 1) {
                this.printDebug("No user name or user ID");
                invalid = true;
            } else if (this.getHost().length() < 1 || this.getBase().length() < 1) {
                this.printDebug("Invalid host name or search base");
                invalid = true;
            }
            if (invalid) {
                this.setErrorCode(1);
                this.notifyResult((String)null);
                return null;
            }
            if (this.getFilter().length() < 1) {
                Object filter = new String("");
                if (this.getUserName().length() > 1 && this.getUserID().length() > 1) {
                    filter = "(|(cn=" + this.getUserName() + ")(uid=" + this.getUserID() + "))";
                } else if (this.getUserName().length() > 1) {
                    filter = "cn=" + this.getUserName();
                } else if (this.getUserID().length() > 1) {
                    filter = "uid=" + this.getUserID();
                }
                this.setFilter((String)filter);
            }
            res = null;
            m_ldc = new LDAPConnection();
            try {
                try {
                    this.printDebug("Connecting to " + this.getHost() + " " + this.getPort());
                    this.connect(m_ldc, this.getHost(), this.getPort());
                }
                catch (Exception e) {
                    this.printDebug("Failed to connect to " + this.getHost() + ": " + e.toString());
                    this.setErrorCode(2);
                    this.notifyResult((String)null);
                    m_ldc = null;
                    throw new Exception();
                }
                if (!this.getAuthDN().equals("") && !this.getAuthPassword().equals("")) {
                    this.printDebug("Authenticating " + this.getAuthDN());
                    try {
                        m_ldc.authenticate(this.getAuthDN(), this.getAuthPassword());
                    }
                    catch (Exception e) {
                        this.printDebug("Failed to authenticate: " + e.toString());
                        this.setErrorCode(3);
                        this.notifyResult((String)null);
                        throw new Exception();
                    }
                }
                try {
                    this.printDebug("Searching " + this.getBase() + " for " + this.getFilter() + ", scope = " + this.getScope());
                    String[] attrs = new String[]{this._attribute};
                    LDAPSearchResults results = m_ldc.search(this.getBase(), this.getScope(), this.getFilter(), attrs, false);
                    Vector<String> v = new Vector<String>();
                    LDAPEntry entry = null;
                    while (results.hasMoreElements()) {
                        try {
                            entry = results.next();
                        }
                        catch (LDAPException e) {
                            if (!this.getDebug()) continue;
                            this.notifyResult(e.toString());
                            continue;
                        }
                        String value = "";
                        if (this._attribute.equals("dn")) {
                            value = entry.getDN();
                        } else {
                            Enumeration vals;
                            LDAPAttribute attr = entry.getAttribute(this._attribute);
                            if (attr != null && (vals = attr.getStringValues()) != null && vals.hasMoreElements()) {
                                value = (String)vals.nextElement();
                            }
                        }
                        v.addElement(value);
                        this.printDebug("... " + value);
                    }
                    if (v.size() > 0) {
                        res = new String[v.size()];
                        v.copyInto(res);
                        v.removeAllElements();
                        this.setErrorCode(0);
                        break block30;
                    }
                    this.printDebug("No entries found for " + this.getFilter());
                    this.setErrorCode(4);
                }
                catch (Exception e) {
                    if (this.getDebug()) {
                        this.printDebug("Failed to search for " + this.getFilter() + ": " + e.toString());
                    }
                    this.setErrorCode(4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (m_ldc != null && m_ldc.isConnected()) {
                m_ldc.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyResult((String[])res);
        return res;
    }

    public static void main(String[] args) {
        String[] scope = new String[]{"base", "one", "sub"};
        int scopeIndex = -1;
        for (int i = 0; i < scope.length && args.length == 5; ++i) {
            if (!args[3].equalsIgnoreCase(scope[i])) continue;
            scopeIndex = i;
            break;
        }
        if (scopeIndex < 0) {
            System.out.println("Usage: LDAPGetEntries host port base scope filter");
            System.exit(1);
        }
        LDAPGetEntries app = new LDAPGetEntries();
        app.setHost(args[0]);
        app.setPort(Integer.parseInt(args[1]));
        app.setBase(args[2]);
        app.setScope(scopeIndex);
        app.setFilter(args[4]);
        String[] response = app.getEntries();
        if (response != null) {
            for (int i = 0; i < response.length; ++i) {
                System.out.println("\t" + response[i]);
            }
        }
        System.exit(0);
    }
}

