/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;

public class LDAPVirtualListControl
extends LDAPControl {
    public static final String VIRTUALLIST = "2.16.840.1.113730.3.4.9";
    private static final int TAG_BYINDEX = 0;
    private static final int TAG_BYFILTER = 1;
    private int m_beforeCount = 0;
    private int m_afterCount = 0;
    private int m_listIndex = -1;
    private int m_listSize = 0;
    private String m_context = null;

    LDAPVirtualListControl() {
        super(VIRTUALLIST, true, null);
    }

    public LDAPVirtualListControl(String jumpTo, int beforeCount, int afterCount) {
        super(VIRTUALLIST, true, null);
        this.setRange(jumpTo, beforeCount, afterCount);
    }

    public LDAPVirtualListControl(String jumpTo, int beforeCount, int afterCount, String context) {
        this(jumpTo, beforeCount, afterCount);
        this.m_context = context;
    }

    public LDAPVirtualListControl(int startIndex, int beforeCount, int afterCount, int contentCount) {
        super(VIRTUALLIST, true, null);
        this.m_listSize = contentCount;
        this.setRange(startIndex, beforeCount, afterCount);
    }

    public LDAPVirtualListControl(int startIndex, int beforeCount, int afterCount, int contentCount, String context) {
        this(startIndex, beforeCount, afterCount, contentCount);
        this.m_context = context;
    }

    public void setRange(int startIndex, int beforeCount, int afterCount) {
        this.m_beforeCount = beforeCount;
        this.m_afterCount = afterCount;
        this.m_listIndex = startIndex;
        this.m_value = this.createPageSpecification(this.m_listIndex, this.m_listSize, this.m_beforeCount, this.m_afterCount);
    }

    public void setRange(String jumpTo, int beforeCount, int afterCount) {
        this.m_beforeCount = beforeCount;
        this.m_afterCount = afterCount;
        this.m_value = this.createPageSpecification(jumpTo, this.m_beforeCount, this.m_afterCount);
    }

    public int getIndex() {
        return this.m_listIndex;
    }

    public int getListSize() {
        return this.m_listSize;
    }

    public void setListSize(int listSize) {
        this.m_listSize = listSize;
    }

    public int getBeforeCount() {
        return this.m_beforeCount;
    }

    public int getAfterCount() {
        return this.m_afterCount;
    }

    public String getContext() {
        return this.m_context;
    }

    public void setContext(String context) {
        this.m_context = context;
    }

    private byte[] createPageSpecification(String subFilter, int beforeCount, int afterCount) {
        BERSequence seq = new BERSequence();
        seq.addElement(new BERInteger(beforeCount));
        seq.addElement(new BERInteger(afterCount));
        seq.addElement(new BERTag(129, new BEROctetString(subFilter), true));
        if (this.m_context != null) {
            seq.addElement(new BEROctetString(this.m_context));
        }
        return this.flattenBER(seq);
    }

    private byte[] createPageSpecification(int listIndex, int listSize, int beforeCount, int afterCount) {
        BERSequence seq = new BERSequence();
        seq.addElement(new BERInteger(beforeCount));
        seq.addElement(new BERInteger(afterCount));
        BERSequence indexSeq = new BERSequence();
        indexSeq.addElement(new BERInteger(listIndex));
        indexSeq.addElement(new BERInteger(listSize));
        seq.addElement(new BERTag(160, indexSeq, true));
        if (this.m_context != null) {
            seq.addElement(new BEROctetString(this.m_context));
        }
        return this.flattenBER(seq);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("{VirtListCtrl:");
        sb.append(" isCritical=");
        sb.append(this.isCritical());
        sb.append(" beforeCount=");
        sb.append(this.m_beforeCount);
        sb.append(" afterCount=");
        sb.append(this.m_afterCount);
        sb.append(" listIndex=");
        sb.append(this.m_listIndex);
        sb.append(" listSize=");
        sb.append(this.m_listSize);
        if (this.m_context != null) {
            sb.append(" conext=");
            sb.append(this.m_context);
        }
        sb.append("}");
        return sb.toString();
    }
}

