/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPasswordExpiredControl;
import netscape.ldap.controls.LDAPPasswordExpiringControl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.LDIF;

public class LDAPControl
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5149887553272603753L;
    public static final String MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    public static final String PWEXPIRED = "2.16.840.1.113730.3.4.4";
    public static final String PWEXPIRING = "2.16.840.1.113730.3.4.5";
    private String m_oid;
    protected boolean m_critical = false;
    protected byte[] m_value = null;
    private static Hashtable<String, Class<?>> m_controlClassHash = null;

    public LDAPControl() {
    }

    public LDAPControl(String id, boolean critical, byte[] vals) {
        this.m_oid = id;
        this.m_critical = critical;
        this.m_value = vals;
    }

    public String getID() {
        return this.m_oid;
    }

    public boolean isCritical() {
        return this.m_critical;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_oid));
        seq.addElement(new BERBoolean(this.m_critical));
        if (this.m_value == null || this.m_value.length < 1) {
            seq.addElement(new BEROctetString((byte[])null));
        } else {
            seq.addElement(new BEROctetString(this.m_value, 0, this.m_value.length));
        }
        return seq;
    }

    public static void register(String oid, Class<?> controlClass) throws LDAPException {
        Class<?> superClass;
        if (controlClass == null) {
            return;
        }
        for (superClass = controlClass; superClass != LDAPControl.class && superClass != null; superClass = superClass.getSuperclass()) {
        }
        if (superClass == null) {
            throw new LDAPException("controlClass must be a subclass of LDAPControl", 89);
        }
        Class[] cparams = new Class[]{String.class, Boolean.TYPE, byte[].class};
        try {
            controlClass.getConstructor(cparams);
        }
        catch (NoSuchMethodException e) {
            throw new LDAPException("controlClass does not implement the correct contstructor", 89);
        }
        if (m_controlClassHash == null) {
            m_controlClassHash = new Hashtable();
        }
        m_controlClassHash.put(oid, controlClass);
    }

    protected static Class<?> lookupControlClass(String oid) {
        if (m_controlClassHash == null) {
            return null;
        }
        return m_controlClassHash.get(oid);
    }

    protected static LDAPControl createControl(String oid, boolean critical, byte[] value) {
        Class<?> controlClass = LDAPControl.lookupControlClass(oid);
        if (controlClass == null) {
            return new LDAPControl(oid, critical, value);
        }
        Class[] cparams = new Class[]{String.class, Boolean.TYPE, byte[].class};
        Constructor<?> creator = null;
        try {
            creator = controlClass.getConstructor(cparams);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Caught java.lang.NoSuchMethodException while attempting to instantiate a control of type " + oid);
            return new LDAPControl(oid, critical, value);
        }
        Object[] oparams = new Object[]{oid, critical, value};
        LDAPControl returnControl = null;
        try {
            returnControl = (LDAPControl)creator.newInstance(oparams);
        }
        catch (Exception e) {
            String eString = null;
            eString = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().toString() : e.toString();
            System.err.println("Caught " + eString + " while attempting to instantiate a control of type " + oid);
            returnControl = new LDAPControl(oid, critical, value);
        }
        return returnControl;
    }

    static LDAPControl parseControl(BERElement el) {
        BERSequence s = (BERSequence)el;
        String oid = null;
        boolean critical = false;
        byte[] value = null;
        try {
            oid = new String(((BEROctetString)s.elementAt(0)).getValue(), "UTF8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BERElement obj = s.elementAt(1);
        if (obj instanceof BERBoolean) {
            critical = ((BERBoolean)obj).getValue();
        } else {
            value = ((BEROctetString)obj).getValue();
        }
        if (s.size() >= 3) {
            value = ((BEROctetString)s.elementAt(2)).getValue();
        }
        return LDAPControl.createControl(oid, critical, value);
    }

    public static LDAPControl[] newInstance(byte[] data) throws IOException {
        int[] bread = new int[]{0};
        BERElement el = BERElement.getElement(new JDAPBERTagDecoder(), new ByteArrayInputStream(data), bread);
        LDAPControl[] jc = null;
        try {
            LDAPMessage msg = LDAPMessage.parseMessage(el);
            return msg.getControls();
        }
        catch (IOException e) {
            BERTag tag = (BERTag)el;
            if (tag.getTag() == 160) {
                BERSequence controls = (BERSequence)tag.getValue();
                jc = new LDAPControl[controls.size()];
                for (int i = 0; i < controls.size(); ++i) {
                    jc[i] = LDAPControl.parseControl(controls.elementAt(i));
                }
            }
            return jc;
        }
    }

    public Object clone() {
        byte[] vals = null;
        if (this.m_value != null) {
            vals = new byte[this.m_value.length];
            for (int i = 0; i < this.m_value.length; ++i) {
                vals[i] = this.m_value[i];
            }
        }
        LDAPControl control = new LDAPControl(this.m_oid, this.m_critical, vals);
        return control;
    }

    protected byte[] flattenBER(BERSequence ber) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            ber.write(outStream);
        }
        catch (IOException e) {
            return null;
        }
        return outStream.toByteArray();
    }

    public String toString() {
        if (this.getID().equals(MANAGEDSAIT)) {
            return "{MANAGEDSITControl: isCritical=" + this.isCritical() + "}";
        }
        String s = this.getID() + " " + this.isCritical();
        if (this.m_value != null) {
            s = s + " " + LDIF.toPrintableString(this.m_value);
        }
        return "LDAPControl {" + s + "}";
    }

    static {
        try {
            LDAPControl.register(PWEXPIRING, LDAPPasswordExpiringControl.class);
            LDAPControl.register(PWEXPIRED, LDAPPasswordExpiredControl.class);
            LDAPControl.register("2.16.840.1.113730.3.4.7", LDAPEntryChangeControl.class);
            LDAPControl.register("1.2.840.113556.1.4.474", LDAPSortControl.class);
            LDAPControl.register("2.16.840.1.113730.3.4.10", LDAPVirtualListResponse.class);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }
}

