﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/inspector2/model/Vulnerability.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Inspector2
{
namespace Model
{

Vulnerability::Vulnerability() : 
    m_atigDataHasBeenSet(false),
    m_cisaDataHasBeenSet(false),
    m_cvss2HasBeenSet(false),
    m_cvss3HasBeenSet(false),
    m_cwesHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_detectionPlatformsHasBeenSet(false),
    m_epssHasBeenSet(false),
    m_exploitObservedHasBeenSet(false),
    m_idHasBeenSet(false),
    m_referenceUrlsHasBeenSet(false),
    m_relatedVulnerabilitiesHasBeenSet(false),
    m_source(VulnerabilitySource::NOT_SET),
    m_sourceHasBeenSet(false),
    m_sourceUrlHasBeenSet(false),
    m_vendorCreatedAtHasBeenSet(false),
    m_vendorSeverityHasBeenSet(false),
    m_vendorUpdatedAtHasBeenSet(false)
{
}

Vulnerability::Vulnerability(JsonView jsonValue) : 
    m_atigDataHasBeenSet(false),
    m_cisaDataHasBeenSet(false),
    m_cvss2HasBeenSet(false),
    m_cvss3HasBeenSet(false),
    m_cwesHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_detectionPlatformsHasBeenSet(false),
    m_epssHasBeenSet(false),
    m_exploitObservedHasBeenSet(false),
    m_idHasBeenSet(false),
    m_referenceUrlsHasBeenSet(false),
    m_relatedVulnerabilitiesHasBeenSet(false),
    m_source(VulnerabilitySource::NOT_SET),
    m_sourceHasBeenSet(false),
    m_sourceUrlHasBeenSet(false),
    m_vendorCreatedAtHasBeenSet(false),
    m_vendorSeverityHasBeenSet(false),
    m_vendorUpdatedAtHasBeenSet(false)
{
  *this = jsonValue;
}

Vulnerability& Vulnerability::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("atigData"))
  {
    m_atigData = jsonValue.GetObject("atigData");

    m_atigDataHasBeenSet = true;
  }

  if(jsonValue.ValueExists("cisaData"))
  {
    m_cisaData = jsonValue.GetObject("cisaData");

    m_cisaDataHasBeenSet = true;
  }

  if(jsonValue.ValueExists("cvss2"))
  {
    m_cvss2 = jsonValue.GetObject("cvss2");

    m_cvss2HasBeenSet = true;
  }

  if(jsonValue.ValueExists("cvss3"))
  {
    m_cvss3 = jsonValue.GetObject("cvss3");

    m_cvss3HasBeenSet = true;
  }

  if(jsonValue.ValueExists("cwes"))
  {
    Aws::Utils::Array<JsonView> cwesJsonList = jsonValue.GetArray("cwes");
    for(unsigned cwesIndex = 0; cwesIndex < cwesJsonList.GetLength(); ++cwesIndex)
    {
      m_cwes.push_back(cwesJsonList[cwesIndex].AsString());
    }
    m_cwesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("description"))
  {
    m_description = jsonValue.GetString("description");

    m_descriptionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("detectionPlatforms"))
  {
    Aws::Utils::Array<JsonView> detectionPlatformsJsonList = jsonValue.GetArray("detectionPlatforms");
    for(unsigned detectionPlatformsIndex = 0; detectionPlatformsIndex < detectionPlatformsJsonList.GetLength(); ++detectionPlatformsIndex)
    {
      m_detectionPlatforms.push_back(detectionPlatformsJsonList[detectionPlatformsIndex].AsString());
    }
    m_detectionPlatformsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("epss"))
  {
    m_epss = jsonValue.GetObject("epss");

    m_epssHasBeenSet = true;
  }

  if(jsonValue.ValueExists("exploitObserved"))
  {
    m_exploitObserved = jsonValue.GetObject("exploitObserved");

    m_exploitObservedHasBeenSet = true;
  }

  if(jsonValue.ValueExists("id"))
  {
    m_id = jsonValue.GetString("id");

    m_idHasBeenSet = true;
  }

  if(jsonValue.ValueExists("referenceUrls"))
  {
    Aws::Utils::Array<JsonView> referenceUrlsJsonList = jsonValue.GetArray("referenceUrls");
    for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
    {
      m_referenceUrls.push_back(referenceUrlsJsonList[referenceUrlsIndex].AsString());
    }
    m_referenceUrlsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("relatedVulnerabilities"))
  {
    Aws::Utils::Array<JsonView> relatedVulnerabilitiesJsonList = jsonValue.GetArray("relatedVulnerabilities");
    for(unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength(); ++relatedVulnerabilitiesIndex)
    {
      m_relatedVulnerabilities.push_back(relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString());
    }
    m_relatedVulnerabilitiesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("source"))
  {
    m_source = VulnerabilitySourceMapper::GetVulnerabilitySourceForName(jsonValue.GetString("source"));

    m_sourceHasBeenSet = true;
  }

  if(jsonValue.ValueExists("sourceUrl"))
  {
    m_sourceUrl = jsonValue.GetString("sourceUrl");

    m_sourceUrlHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vendorCreatedAt"))
  {
    m_vendorCreatedAt = jsonValue.GetDouble("vendorCreatedAt");

    m_vendorCreatedAtHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vendorSeverity"))
  {
    m_vendorSeverity = jsonValue.GetString("vendorSeverity");

    m_vendorSeverityHasBeenSet = true;
  }

  if(jsonValue.ValueExists("vendorUpdatedAt"))
  {
    m_vendorUpdatedAt = jsonValue.GetDouble("vendorUpdatedAt");

    m_vendorUpdatedAtHasBeenSet = true;
  }

  return *this;
}

JsonValue Vulnerability::Jsonize() const
{
  JsonValue payload;

  if(m_atigDataHasBeenSet)
  {
   payload.WithObject("atigData", m_atigData.Jsonize());

  }

  if(m_cisaDataHasBeenSet)
  {
   payload.WithObject("cisaData", m_cisaData.Jsonize());

  }

  if(m_cvss2HasBeenSet)
  {
   payload.WithObject("cvss2", m_cvss2.Jsonize());

  }

  if(m_cvss3HasBeenSet)
  {
   payload.WithObject("cvss3", m_cvss3.Jsonize());

  }

  if(m_cwesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> cwesJsonList(m_cwes.size());
   for(unsigned cwesIndex = 0; cwesIndex < cwesJsonList.GetLength(); ++cwesIndex)
   {
     cwesJsonList[cwesIndex].AsString(m_cwes[cwesIndex]);
   }
   payload.WithArray("cwes", std::move(cwesJsonList));

  }

  if(m_descriptionHasBeenSet)
  {
   payload.WithString("description", m_description);

  }

  if(m_detectionPlatformsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> detectionPlatformsJsonList(m_detectionPlatforms.size());
   for(unsigned detectionPlatformsIndex = 0; detectionPlatformsIndex < detectionPlatformsJsonList.GetLength(); ++detectionPlatformsIndex)
   {
     detectionPlatformsJsonList[detectionPlatformsIndex].AsString(m_detectionPlatforms[detectionPlatformsIndex]);
   }
   payload.WithArray("detectionPlatforms", std::move(detectionPlatformsJsonList));

  }

  if(m_epssHasBeenSet)
  {
   payload.WithObject("epss", m_epss.Jsonize());

  }

  if(m_exploitObservedHasBeenSet)
  {
   payload.WithObject("exploitObserved", m_exploitObserved.Jsonize());

  }

  if(m_idHasBeenSet)
  {
   payload.WithString("id", m_id);

  }

  if(m_referenceUrlsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> referenceUrlsJsonList(m_referenceUrls.size());
   for(unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex)
   {
     referenceUrlsJsonList[referenceUrlsIndex].AsString(m_referenceUrls[referenceUrlsIndex]);
   }
   payload.WithArray("referenceUrls", std::move(referenceUrlsJsonList));

  }

  if(m_relatedVulnerabilitiesHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> relatedVulnerabilitiesJsonList(m_relatedVulnerabilities.size());
   for(unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength(); ++relatedVulnerabilitiesIndex)
   {
     relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString(m_relatedVulnerabilities[relatedVulnerabilitiesIndex]);
   }
   payload.WithArray("relatedVulnerabilities", std::move(relatedVulnerabilitiesJsonList));

  }

  if(m_sourceHasBeenSet)
  {
   payload.WithString("source", VulnerabilitySourceMapper::GetNameForVulnerabilitySource(m_source));
  }

  if(m_sourceUrlHasBeenSet)
  {
   payload.WithString("sourceUrl", m_sourceUrl);

  }

  if(m_vendorCreatedAtHasBeenSet)
  {
   payload.WithDouble("vendorCreatedAt", m_vendorCreatedAt.SecondsWithMSPrecision());
  }

  if(m_vendorSeverityHasBeenSet)
  {
   payload.WithString("vendorSeverity", m_vendorSeverity);

  }

  if(m_vendorUpdatedAtHasBeenSet)
  {
   payload.WithDouble("vendorUpdatedAt", m_vendorUpdatedAt.SecondsWithMSPrecision());
  }

  return payload;
}

} // namespace Model
} // namespace Inspector2
} // namespace Aws
