﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/inspector2/model/ExploitabilityDetails.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Inspector2
{
namespace Model
{

ExploitabilityDetails::ExploitabilityDetails() : 
    m_lastKnownExploitAtHasBeenSet(false)
{
}

ExploitabilityDetails::ExploitabilityDetails(JsonView jsonValue) : 
    m_lastKnownExploitAtHasBeenSet(false)
{
  *this = jsonValue;
}

ExploitabilityDetails& ExploitabilityDetails::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("lastKnownExploitAt"))
  {
    m_lastKnownExploitAt = jsonValue.GetDouble("lastKnownExploitAt");

    m_lastKnownExploitAtHasBeenSet = true;
  }

  return *this;
}

JsonValue ExploitabilityDetails::Jsonize() const
{
  JsonValue payload;

  if(m_lastKnownExploitAtHasBeenSet)
  {
   payload.WithDouble("lastKnownExploitAt", m_lastKnownExploitAt.SecondsWithMSPrecision());
  }

  return payload;
}

} // namespace Model
} // namespace Inspector2
} // namespace Aws
