/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResultAccessLogMessage
extends SearchRequestAccessLogMessage
implements OperationResultAccessLogMessage {
    private static final long serialVersionUID = 7181644154168110011L;
    @Nullable
    private final Boolean isUnindexed;
    @Nullable
    private final Boolean uncachedDataAccessed;
    @Nullable
    private final Double processingTime;
    @Nullable
    private final Double queueTime;
    @NotNull
    private final List<String> indexesWithKeysAccessedNearEntryLimit;
    @NotNull
    private final List<String> indexesWithKeysAccessedOverEntryLimit;
    @NotNull
    private final List<String> missingPrivileges;
    @NotNull
    private final List<String> preAuthZUsedPrivileges;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final List<String> responseControlOIDs;
    @NotNull
    private final List<String> serversAccessed;
    @NotNull
    private final List<String> usedPrivileges;
    @Nullable
    private final Long entriesReturned;
    @Nullable
    private final Long intermediateResponsesReturned;
    @Nullable
    private final ResultCode resultCode;
    @Nullable
    private final String additionalInformation;
    @Nullable
    private final String authzDN;
    @Nullable
    private final String diagnosticMessage = this.getNamedValue("message");
    @Nullable
    private final String intermediateClientResult;
    @Nullable
    private final String matchedDN;
    @Nullable
    private final Integer targetPort;
    @Nullable
    private final String targetHost;
    @Nullable
    private final String targetProtocol;

    public SearchResultAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public SearchResultAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.additionalInformation = this.getNamedValue("additionalInfo");
        this.matchedDN = this.getNamedValue("matchedDN");
        this.processingTime = this.getNamedValueAsDouble("etime");
        this.queueTime = this.getNamedValueAsDouble("qtime");
        this.intermediateClientResult = this.getNamedValue("from");
        this.entriesReturned = this.getNamedValueAsLong("entriesReturned");
        this.isUnindexed = this.getNamedValueAsBoolean("unindexed");
        this.authzDN = this.getNamedValue("authzDN");
        this.targetHost = this.getNamedValue("targetHost");
        this.targetPort = this.getNamedValueAsInteger("targetPort");
        this.targetProtocol = this.getNamedValue("targetProtocol");
        this.intermediateResponsesReturned = this.getNamedValueAsLong("intermediateResponsesReturned");
        Integer rcInteger = this.getNamedValueAsInteger("resultCode");
        this.resultCode = rcInteger == null ? null : ResultCode.valueOf(rcInteger);
        String refStr = this.getNamedValue("referralURLs");
        if (refStr == null || refStr.isEmpty()) {
            this.referralURLs = Collections.emptyList();
        } else {
            LinkedList<String> refs = new LinkedList<String>();
            int startPos = 0;
            while (true) {
                int commaPos;
                if ((commaPos = refStr.indexOf(",ldap", startPos)) < 0) break;
                refs.add(refStr.substring(startPos, commaPos));
                startPos = commaPos + 1;
            }
            refs.add(refStr.substring(startPos));
            this.referralURLs = Collections.unmodifiableList(refs);
        }
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        String serversAccessedStr = this.getNamedValue("serversAccessed");
        if (serversAccessedStr == null || serversAccessedStr.isEmpty()) {
            this.serversAccessed = Collections.emptyList();
        } else {
            LinkedList<String> servers = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(serversAccessedStr, ",");
            while (tokenizer.hasMoreTokens()) {
                servers.add(tokenizer.nextToken());
            }
            this.serversAccessed = Collections.unmodifiableList(servers);
        }
        this.uncachedDataAccessed = this.getNamedValueAsBoolean("uncachedDataAccessed");
        String usedPrivilegesStr = this.getNamedValue("usedPrivileges");
        if (usedPrivilegesStr == null || usedPrivilegesStr.isEmpty()) {
            this.usedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(usedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.usedPrivileges = Collections.unmodifiableList(privileges);
        }
        String preAuthZUsedPrivilegesStr = this.getNamedValue("preAuthZUsedPrivileges");
        if (preAuthZUsedPrivilegesStr == null || preAuthZUsedPrivilegesStr.isEmpty()) {
            this.preAuthZUsedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(preAuthZUsedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.preAuthZUsedPrivileges = Collections.unmodifiableList(privileges);
        }
        String missingPrivilegesStr = this.getNamedValue("missingPrivileges");
        if (missingPrivilegesStr == null || missingPrivilegesStr.isEmpty()) {
            this.missingPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(missingPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.missingPrivileges = Collections.unmodifiableList(privileges);
        }
        String indexesNearLimitStr = this.getNamedValue("indexesWithKeysAccessedNearEntryLimit");
        if (indexesNearLimitStr == null || indexesNearLimitStr.isEmpty()) {
            this.indexesWithKeysAccessedNearEntryLimit = Collections.emptyList();
        } else {
            LinkedList<String> indexes = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(indexesNearLimitStr, ",");
            while (tokenizer.hasMoreTokens()) {
                indexes.add(tokenizer.nextToken());
            }
            this.indexesWithKeysAccessedNearEntryLimit = Collections.unmodifiableList(indexes);
        }
        String indexesOverLimitStr = this.getNamedValue("indexesWithKeysAccessedExceedingEntryLimit");
        if (indexesOverLimitStr == null || indexesOverLimitStr.isEmpty()) {
            this.indexesWithKeysAccessedOverEntryLimit = Collections.emptyList();
        } else {
            LinkedList<String> indexes = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(indexesOverLimitStr, ",");
            while (tokenizer.hasMoreTokens()) {
                indexes.add(tokenizer.nextToken());
            }
            this.indexesWithKeysAccessedOverEntryLimit = Collections.unmodifiableList(indexes);
        }
    }

    @Override
    @Nullable
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    @Nullable
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    @Nullable
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    @Nullable
    public String getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    @NotNull
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    @Nullable
    public Long getIntermediateResponsesReturned() {
        return this.intermediateResponsesReturned;
    }

    @Override
    @Nullable
    public Double getProcessingTimeMillis() {
        return this.processingTime;
    }

    @Override
    @Nullable
    public Double getQueueTimeMillis() {
        return this.queueTime;
    }

    @Override
    @NotNull
    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    @NotNull
    public List<String> getServersAccessed() {
        return this.serversAccessed;
    }

    @Nullable
    public Boolean getUncachedDataAccessed() {
        return this.uncachedDataAccessed;
    }

    @Override
    @Nullable
    public String getIntermediateClientResult() {
        return this.intermediateClientResult;
    }

    @Nullable
    public Long getEntriesReturned() {
        return this.entriesReturned;
    }

    @Nullable
    public Boolean isUnindexed() {
        return this.isUnindexed;
    }

    @Nullable
    public String getAlternateAuthorizationDN() {
        return this.authzDN;
    }

    @Nullable
    public String getTargetHost() {
        return this.targetHost;
    }

    @Nullable
    public Integer getTargetPort() {
        return this.targetPort;
    }

    @Nullable
    public String getTargetProtocol() {
        return this.targetProtocol;
    }

    @NotNull
    public List<String> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    @NotNull
    public List<String> getPreAuthorizationUsedPrivileges() {
        return this.preAuthZUsedPrivileges;
    }

    @NotNull
    public List<String> getMissingPrivileges() {
        return this.missingPrivileges;
    }

    @NotNull
    public List<String> getIndexesWithKeysAccessedNearEntryLimit() {
        return this.indexesWithKeysAccessedNearEntryLimit;
    }

    @NotNull
    public List<String> getIndexesWithKeysAccessedOverEntryLimit() {
        return this.indexesWithKeysAccessedOverEntryLimit;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }
}

