/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// RepositoriesRpmAPIService RepositoriesRpmAPI service
type RepositoriesRpmAPIService service

type RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmAddRoleExecute(r)
}

/*
RepositoriesRpmRpmAddRole Method for RepositoriesRpmRpmAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmAddRole(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmAddRoleExecute(r RepositoriesRpmAPIRepositoriesRpmRpmAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepository *RpmRpmRepository
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest) RpmRpmRepository(rpmRpmRepository RpmRpmRepository) RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest {
	r.rpmRpmRepository = &rpmRpmRepository
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest) Execute() (*RpmRpmRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmCreateExecute(r)
}

/*
RepositoriesRpmRpmCreate Create a rpm repository

A ViewSet for RpmRepository.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmCreate(ctx context.Context) RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return RpmRpmRepositoryResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmCreateExecute(r RepositoriesRpmAPIRepositoriesRpmRpmCreateRequest) (*RpmRpmRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmRpmRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmRepository == nil {
		return localVarReturnValue, nil, reportError("rpmRpmRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmDeleteExecute(r)
}

/*
RepositoriesRpmRpmDelete Delete a rpm repository

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmDeleteRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmDelete(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmDeleteRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmDeleteRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmDeleteExecute(r RepositoriesRpmAPIRepositoriesRpmRpmDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmListRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) LatestWithContent(latestWithContent string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Limit(limit int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Name(name string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) NameContains(nameContains string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) NameIcontains(nameIcontains string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) NameIn(nameIn []string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) NameStartswith(nameStartswith string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Offset(offset int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Ordering(ordering []string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) PulpIdIn(pulpIdIn []string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Remote(remote string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) WithContent(withContent string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Fields(fields []string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) ExcludeFields(excludeFields []string) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) Execute() (*PaginatedrpmRpmRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmListExecute(r)
}

/*
RepositoriesRpmRpmList List rpm repositorys

A ViewSet for RpmRepository.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesRpmAPIRepositoriesRpmRpmListRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmList(ctx context.Context) RepositoriesRpmAPIRepositoriesRpmRpmListRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedrpmRpmRepositoryResponseList
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmListExecute(r RepositoriesRpmAPIRepositoriesRpmRpmListRequest) (*PaginatedrpmRpmRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedrpmRpmRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/rpm/rpm/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest) Fields(fields []string) RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest) ExcludeFields(excludeFields []string) RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmListRolesExecute(r)
}

/*
RepositoriesRpmRpmListRoles Method for RepositoriesRpmRpmListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmListRoles(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmListRolesExecute(r RepositoriesRpmAPIRepositoriesRpmRpmListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	repositoryAddRemoveContent *RepositoryAddRemoveContent
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest) RepositoryAddRemoveContent(repositoryAddRemoveContent RepositoryAddRemoveContent) RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest {
	r.repositoryAddRemoveContent = &repositoryAddRemoveContent
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmModifyExecute(r)
}

/*
RepositoriesRpmRpmModify Modify Repository Content

Trigger an asynchronous task to create a new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmModify(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmModifyExecute(r RepositoriesRpmAPIRepositoriesRpmRpmModifyRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmModify")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}modify/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositoryAddRemoveContent == nil {
		return localVarReturnValue, nil, reportError("repositoryAddRemoveContent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositoryAddRemoveContent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest) Fields(fields []string) RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest) ExcludeFields(excludeFields []string) RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmMyPermissionsExecute(r)
}

/*
RepositoriesRpmRpmMyPermissions Method for RepositoriesRpmRpmMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmMyPermissions(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmMyPermissionsExecute(r RepositoriesRpmAPIRepositoriesRpmRpmMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	patchedrpmRpmRepository *PatchedrpmRpmRepository
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest) PatchedrpmRpmRepository(patchedrpmRpmRepository PatchedrpmRpmRepository) RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest {
	r.patchedrpmRpmRepository = &patchedrpmRpmRepository
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmPartialUpdateExecute(r)
}

/*
RepositoriesRpmRpmPartialUpdate Update a rpm repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmPartialUpdate(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmPartialUpdateExecute(r RepositoriesRpmAPIRepositoriesRpmRpmPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedrpmRpmRepository == nil {
		return localVarReturnValue, nil, reportError("patchedrpmRpmRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedrpmRpmRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmReadRequest) Fields(fields []string) RepositoriesRpmAPIRepositoriesRpmRpmReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesRpmAPIRepositoriesRpmRpmReadRequest) ExcludeFields(excludeFields []string) RepositoriesRpmAPIRepositoriesRpmRpmReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmReadRequest) Execute() (*RpmRpmRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmReadExecute(r)
}

/*
RepositoriesRpmRpmRead Inspect a rpm repository

A ViewSet for RpmRepository.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmReadRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmRead(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmReadRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmReadRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return RpmRpmRepositoryResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmReadExecute(r RepositoriesRpmAPIRepositoriesRpmRpmReadRequest) (*RpmRpmRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmRpmRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmRemoveRoleExecute(r)
}

/*
RepositoriesRpmRpmRemoveRole Method for RepositoriesRpmRpmRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmRemoveRole(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmRemoveRoleExecute(r RepositoriesRpmAPIRepositoriesRpmRpmRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	rpmRepositorySyncURL *RpmRepositorySyncURL
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest) RpmRepositorySyncURL(rpmRepositorySyncURL RpmRepositorySyncURL) RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest {
	r.rpmRepositorySyncURL = &rpmRepositorySyncURL
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmSyncExecute(r)
}

/*
RepositoriesRpmRpmSync Sync from remote

Trigger an asynchronous task to sync RPM content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmSync(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmSyncExecute(r RepositoriesRpmAPIRepositoriesRpmRpmSyncRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmSync")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}sync/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRepositorySyncURL == nil {
		return localVarReturnValue, nil, reportError("rpmRepositorySyncURL is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRepositorySyncURL
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesRpmAPIService
	rpmRpmRepositoryHref string
	rpmRpmRepository *RpmRpmRepository
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest) RpmRpmRepository(rpmRpmRepository RpmRpmRepository) RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest {
	r.rpmRpmRepository = &rpmRpmRepository
	return r
}

func (r RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesRpmRpmUpdateExecute(r)
}

/*
RepositoriesRpmRpmUpdate Update a rpm repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmRpmRepositoryHref
 @return RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest
*/
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmUpdate(ctx context.Context, rpmRpmRepositoryHref string) RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest {
	return RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmRpmRepositoryHref: rpmRpmRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesRpmAPIService) RepositoriesRpmRpmUpdateExecute(r RepositoriesRpmAPIRepositoriesRpmRpmUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesRpmAPIService.RepositoriesRpmRpmUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_rpm_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_rpm_repository_href"+"}", parameterValueToString(r.rpmRpmRepositoryHref, "rpmRpmRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmRpmRepository == nil {
		return localVarReturnValue, nil, reportError("rpmRpmRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmRpmRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
