/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RpmDistributionTreeResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmDistributionTreeResponse{}

// RpmDistributionTreeResponse DistributionTree serializer.
type RpmDistributionTreeResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Header Version.
	HeaderVersion string `json:"header_version"`
	// Release name.
	ReleaseName string `json:"release_name"`
	// Release short name.
	ReleaseShort string `json:"release_short"`
	// Release version.
	ReleaseVersion string `json:"release_version"`
	// Typically False for an operating system, True otherwise.
	ReleaseIsLayered bool `json:"release_is_layered"`
	// Base Product name.
	BaseProductName NullableString `json:"base_product_name"`
	// Base Product short name.
	BaseProductShort NullableString `json:"base_product_short"`
	// Base Product version.
	BaseProductVersion NullableString `json:"base_product_version"`
	// Tree architecturerch.
	Arch string `json:"arch"`
	// Tree build time timestamp.
	BuildTimestamp float64 `json:"build_timestamp"`
	// Relative path to Anaconda instimage.
	Instimage NullableString `json:"instimage"`
	// Relative path to Anaconda stage2 image.
	Mainimage NullableString `json:"mainimage"`
	// Disc number.
	Discnum NullableInt64 `json:"discnum"`
	// Number of discs in media set.
	Totaldiscs NullableInt64 `json:"totaldiscs"`
	Addons []AddonResponse `json:"addons"`
	Checksums []ChecksumResponse `json:"checksums"`
	Images []ImageResponse `json:"images"`
	Variants []VariantResponse `json:"variants"`
	AdditionalProperties map[string]interface{}
}

type _RpmDistributionTreeResponse RpmDistributionTreeResponse

// NewRpmDistributionTreeResponse instantiates a new RpmDistributionTreeResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmDistributionTreeResponse(headerVersion string, releaseName string, releaseShort string, releaseVersion string, releaseIsLayered bool, baseProductName NullableString, baseProductShort NullableString, baseProductVersion NullableString, arch string, buildTimestamp float64, instimage NullableString, mainimage NullableString, discnum NullableInt64, totaldiscs NullableInt64, addons []AddonResponse, checksums []ChecksumResponse, images []ImageResponse, variants []VariantResponse) *RpmDistributionTreeResponse {
	this := RpmDistributionTreeResponse{}
	this.HeaderVersion = headerVersion
	this.ReleaseName = releaseName
	this.ReleaseShort = releaseShort
	this.ReleaseVersion = releaseVersion
	this.ReleaseIsLayered = releaseIsLayered
	this.BaseProductName = baseProductName
	this.BaseProductShort = baseProductShort
	this.BaseProductVersion = baseProductVersion
	this.Arch = arch
	this.BuildTimestamp = buildTimestamp
	this.Instimage = instimage
	this.Mainimage = mainimage
	this.Discnum = discnum
	this.Totaldiscs = totaldiscs
	this.Addons = addons
	this.Checksums = checksums
	this.Images = images
	this.Variants = variants
	return &this
}

// NewRpmDistributionTreeResponseWithDefaults instantiates a new RpmDistributionTreeResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmDistributionTreeResponseWithDefaults() *RpmDistributionTreeResponse {
	this := RpmDistributionTreeResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *RpmDistributionTreeResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *RpmDistributionTreeResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *RpmDistributionTreeResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetHeaderVersion returns the HeaderVersion field value
func (o *RpmDistributionTreeResponse) GetHeaderVersion() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.HeaderVersion
}

// GetHeaderVersionOk returns a tuple with the HeaderVersion field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetHeaderVersionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.HeaderVersion, true
}

// SetHeaderVersion sets field value
func (o *RpmDistributionTreeResponse) SetHeaderVersion(v string) {
	o.HeaderVersion = v
}

// GetReleaseName returns the ReleaseName field value
func (o *RpmDistributionTreeResponse) GetReleaseName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ReleaseName
}

// GetReleaseNameOk returns a tuple with the ReleaseName field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetReleaseNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ReleaseName, true
}

// SetReleaseName sets field value
func (o *RpmDistributionTreeResponse) SetReleaseName(v string) {
	o.ReleaseName = v
}

// GetReleaseShort returns the ReleaseShort field value
func (o *RpmDistributionTreeResponse) GetReleaseShort() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ReleaseShort
}

// GetReleaseShortOk returns a tuple with the ReleaseShort field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetReleaseShortOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ReleaseShort, true
}

// SetReleaseShort sets field value
func (o *RpmDistributionTreeResponse) SetReleaseShort(v string) {
	o.ReleaseShort = v
}

// GetReleaseVersion returns the ReleaseVersion field value
func (o *RpmDistributionTreeResponse) GetReleaseVersion() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ReleaseVersion
}

// GetReleaseVersionOk returns a tuple with the ReleaseVersion field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetReleaseVersionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ReleaseVersion, true
}

// SetReleaseVersion sets field value
func (o *RpmDistributionTreeResponse) SetReleaseVersion(v string) {
	o.ReleaseVersion = v
}

// GetReleaseIsLayered returns the ReleaseIsLayered field value
func (o *RpmDistributionTreeResponse) GetReleaseIsLayered() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.ReleaseIsLayered
}

// GetReleaseIsLayeredOk returns a tuple with the ReleaseIsLayered field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetReleaseIsLayeredOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ReleaseIsLayered, true
}

// SetReleaseIsLayered sets field value
func (o *RpmDistributionTreeResponse) SetReleaseIsLayered(v bool) {
	o.ReleaseIsLayered = v
}

// GetBaseProductName returns the BaseProductName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmDistributionTreeResponse) GetBaseProductName() string {
	if o == nil || o.BaseProductName.Get() == nil {
		var ret string
		return ret
	}

	return *o.BaseProductName.Get()
}

// GetBaseProductNameOk returns a tuple with the BaseProductName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetBaseProductNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.BaseProductName.Get(), o.BaseProductName.IsSet()
}

// SetBaseProductName sets field value
func (o *RpmDistributionTreeResponse) SetBaseProductName(v string) {
	o.BaseProductName.Set(&v)
}

// GetBaseProductShort returns the BaseProductShort field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmDistributionTreeResponse) GetBaseProductShort() string {
	if o == nil || o.BaseProductShort.Get() == nil {
		var ret string
		return ret
	}

	return *o.BaseProductShort.Get()
}

// GetBaseProductShortOk returns a tuple with the BaseProductShort field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetBaseProductShortOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.BaseProductShort.Get(), o.BaseProductShort.IsSet()
}

// SetBaseProductShort sets field value
func (o *RpmDistributionTreeResponse) SetBaseProductShort(v string) {
	o.BaseProductShort.Set(&v)
}

// GetBaseProductVersion returns the BaseProductVersion field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmDistributionTreeResponse) GetBaseProductVersion() string {
	if o == nil || o.BaseProductVersion.Get() == nil {
		var ret string
		return ret
	}

	return *o.BaseProductVersion.Get()
}

// GetBaseProductVersionOk returns a tuple with the BaseProductVersion field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetBaseProductVersionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.BaseProductVersion.Get(), o.BaseProductVersion.IsSet()
}

// SetBaseProductVersion sets field value
func (o *RpmDistributionTreeResponse) SetBaseProductVersion(v string) {
	o.BaseProductVersion.Set(&v)
}

// GetArch returns the Arch field value
func (o *RpmDistributionTreeResponse) GetArch() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Arch
}

// GetArchOk returns a tuple with the Arch field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetArchOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Arch, true
}

// SetArch sets field value
func (o *RpmDistributionTreeResponse) SetArch(v string) {
	o.Arch = v
}

// GetBuildTimestamp returns the BuildTimestamp field value
func (o *RpmDistributionTreeResponse) GetBuildTimestamp() float64 {
	if o == nil {
		var ret float64
		return ret
	}

	return o.BuildTimestamp
}

// GetBuildTimestampOk returns a tuple with the BuildTimestamp field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetBuildTimestampOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BuildTimestamp, true
}

// SetBuildTimestamp sets field value
func (o *RpmDistributionTreeResponse) SetBuildTimestamp(v float64) {
	o.BuildTimestamp = v
}

// GetInstimage returns the Instimage field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmDistributionTreeResponse) GetInstimage() string {
	if o == nil || o.Instimage.Get() == nil {
		var ret string
		return ret
	}

	return *o.Instimage.Get()
}

// GetInstimageOk returns a tuple with the Instimage field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetInstimageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Instimage.Get(), o.Instimage.IsSet()
}

// SetInstimage sets field value
func (o *RpmDistributionTreeResponse) SetInstimage(v string) {
	o.Instimage.Set(&v)
}

// GetMainimage returns the Mainimage field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmDistributionTreeResponse) GetMainimage() string {
	if o == nil || o.Mainimage.Get() == nil {
		var ret string
		return ret
	}

	return *o.Mainimage.Get()
}

// GetMainimageOk returns a tuple with the Mainimage field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetMainimageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Mainimage.Get(), o.Mainimage.IsSet()
}

// SetMainimage sets field value
func (o *RpmDistributionTreeResponse) SetMainimage(v string) {
	o.Mainimage.Set(&v)
}

// GetDiscnum returns the Discnum field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *RpmDistributionTreeResponse) GetDiscnum() int64 {
	if o == nil || o.Discnum.Get() == nil {
		var ret int64
		return ret
	}

	return *o.Discnum.Get()
}

// GetDiscnumOk returns a tuple with the Discnum field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetDiscnumOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.Discnum.Get(), o.Discnum.IsSet()
}

// SetDiscnum sets field value
func (o *RpmDistributionTreeResponse) SetDiscnum(v int64) {
	o.Discnum.Set(&v)
}

// GetTotaldiscs returns the Totaldiscs field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *RpmDistributionTreeResponse) GetTotaldiscs() int64 {
	if o == nil || o.Totaldiscs.Get() == nil {
		var ret int64
		return ret
	}

	return *o.Totaldiscs.Get()
}

// GetTotaldiscsOk returns a tuple with the Totaldiscs field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmDistributionTreeResponse) GetTotaldiscsOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.Totaldiscs.Get(), o.Totaldiscs.IsSet()
}

// SetTotaldiscs sets field value
func (o *RpmDistributionTreeResponse) SetTotaldiscs(v int64) {
	o.Totaldiscs.Set(&v)
}

// GetAddons returns the Addons field value
func (o *RpmDistributionTreeResponse) GetAddons() []AddonResponse {
	if o == nil {
		var ret []AddonResponse
		return ret
	}

	return o.Addons
}

// GetAddonsOk returns a tuple with the Addons field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetAddonsOk() ([]AddonResponse, bool) {
	if o == nil {
		return nil, false
	}
	return o.Addons, true
}

// SetAddons sets field value
func (o *RpmDistributionTreeResponse) SetAddons(v []AddonResponse) {
	o.Addons = v
}

// GetChecksums returns the Checksums field value
func (o *RpmDistributionTreeResponse) GetChecksums() []ChecksumResponse {
	if o == nil {
		var ret []ChecksumResponse
		return ret
	}

	return o.Checksums
}

// GetChecksumsOk returns a tuple with the Checksums field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetChecksumsOk() ([]ChecksumResponse, bool) {
	if o == nil {
		return nil, false
	}
	return o.Checksums, true
}

// SetChecksums sets field value
func (o *RpmDistributionTreeResponse) SetChecksums(v []ChecksumResponse) {
	o.Checksums = v
}

// GetImages returns the Images field value
func (o *RpmDistributionTreeResponse) GetImages() []ImageResponse {
	if o == nil {
		var ret []ImageResponse
		return ret
	}

	return o.Images
}

// GetImagesOk returns a tuple with the Images field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetImagesOk() ([]ImageResponse, bool) {
	if o == nil {
		return nil, false
	}
	return o.Images, true
}

// SetImages sets field value
func (o *RpmDistributionTreeResponse) SetImages(v []ImageResponse) {
	o.Images = v
}

// GetVariants returns the Variants field value
func (o *RpmDistributionTreeResponse) GetVariants() []VariantResponse {
	if o == nil {
		var ret []VariantResponse
		return ret
	}

	return o.Variants
}

// GetVariantsOk returns a tuple with the Variants field value
// and a boolean to check if the value has been set.
func (o *RpmDistributionTreeResponse) GetVariantsOk() ([]VariantResponse, bool) {
	if o == nil {
		return nil, false
	}
	return o.Variants, true
}

// SetVariants sets field value
func (o *RpmDistributionTreeResponse) SetVariants(v []VariantResponse) {
	o.Variants = v
}

func (o RpmDistributionTreeResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmDistributionTreeResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	toSerialize["header_version"] = o.HeaderVersion
	toSerialize["release_name"] = o.ReleaseName
	toSerialize["release_short"] = o.ReleaseShort
	toSerialize["release_version"] = o.ReleaseVersion
	toSerialize["release_is_layered"] = o.ReleaseIsLayered
	toSerialize["base_product_name"] = o.BaseProductName.Get()
	toSerialize["base_product_short"] = o.BaseProductShort.Get()
	toSerialize["base_product_version"] = o.BaseProductVersion.Get()
	toSerialize["arch"] = o.Arch
	toSerialize["build_timestamp"] = o.BuildTimestamp
	toSerialize["instimage"] = o.Instimage.Get()
	toSerialize["mainimage"] = o.Mainimage.Get()
	toSerialize["discnum"] = o.Discnum.Get()
	toSerialize["totaldiscs"] = o.Totaldiscs.Get()
	toSerialize["addons"] = o.Addons
	toSerialize["checksums"] = o.Checksums
	toSerialize["images"] = o.Images
	toSerialize["variants"] = o.Variants

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmDistributionTreeResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRpmDistributionTreeResponse := _RpmDistributionTreeResponse{}

	if err = json.Unmarshal(bytes, &varRpmDistributionTreeResponse); err == nil {
		*o = RpmDistributionTreeResponse(varRpmDistributionTreeResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "header_version")
		delete(additionalProperties, "release_name")
		delete(additionalProperties, "release_short")
		delete(additionalProperties, "release_version")
		delete(additionalProperties, "release_is_layered")
		delete(additionalProperties, "base_product_name")
		delete(additionalProperties, "base_product_short")
		delete(additionalProperties, "base_product_version")
		delete(additionalProperties, "arch")
		delete(additionalProperties, "build_timestamp")
		delete(additionalProperties, "instimage")
		delete(additionalProperties, "mainimage")
		delete(additionalProperties, "discnum")
		delete(additionalProperties, "totaldiscs")
		delete(additionalProperties, "addons")
		delete(additionalProperties, "checksums")
		delete(additionalProperties, "images")
		delete(additionalProperties, "variants")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmDistributionTreeResponse struct {
	value *RpmDistributionTreeResponse
	isSet bool
}

func (v NullableRpmDistributionTreeResponse) Get() *RpmDistributionTreeResponse {
	return v.value
}

func (v *NullableRpmDistributionTreeResponse) Set(val *RpmDistributionTreeResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmDistributionTreeResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmDistributionTreeResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmDistributionTreeResponse(val *RpmDistributionTreeResponse) *NullableRpmDistributionTreeResponse {
	return &NullableRpmDistributionTreeResponse{value: val, isSet: true}
}

func (v NullableRpmDistributionTreeResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmDistributionTreeResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


