; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=x86_64-- -expand-large-fp-convert < %s | FileCheck %s
; RUN: opt -S -mtriple=x86_64-- -passes=expand-large-fp-convert < %s | FileCheck %s

define half @ui129tohalf(i129 %a) {
; CHECK-LABEL: @ui129tohalf(
; CHECK-NEXT:  itofp-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i129 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[ITOFP_RETURN:%.*]], label [[ITOFP_IF_END:%.*]]
; CHECK:       itofp-if-end:
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i129 [[A]], 128
; CHECK-NEXT:    [[TMP2:%.*]] = xor i129 [[TMP1]], [[A]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub i129 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = call i129 @llvm.ctlz.i129(i129 [[A]], i1 true)
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i129 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = sub i32 129, [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub i32 128, [[TMP5]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp sgt i32 [[TMP7]], 24
; CHECK-NEXT:    br i1 [[TMP8]], label [[ITOFP_IF_THEN4:%.*]], label [[ITOFP_IF_ELSE:%.*]]
; CHECK:       itofp-if-then4:
; CHECK-NEXT:    switch i32 [[TMP6]], label [[ITOFP_SW_DEFAULT:%.*]] [
; CHECK-NEXT:    i32 25, label [[ITOFP_SW_BB:%.*]]
; CHECK-NEXT:    i32 26, label [[ITOFP_SW_EPILOG:%.*]]
; CHECK-NEXT:    ]
; CHECK:       itofp-sw-bb:
; CHECK-NEXT:    [[TMP9:%.*]] = shl i129 [[A]], 1
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-default:
; CHECK-NEXT:    [[TMP10:%.*]] = sub i32 103, [[TMP5]]
; CHECK-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i129
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i129 [[A]], [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = add i32 [[TMP5]], 26
; CHECK-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i129
; CHECK-NEXT:    [[TMP15:%.*]] = lshr i129 -1, [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = and i129 [[TMP15]], [[A]]
; CHECK-NEXT:    [[TMP17:%.*]] = icmp ne i129 [[TMP16]], 0
; CHECK-NEXT:    [[TMP18:%.*]] = zext i1 [[TMP17]] to i129
; CHECK-NEXT:    [[TMP19:%.*]] = or i129 [[TMP12]], [[TMP18]]
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-epilog:
; CHECK-NEXT:    [[TMP20:%.*]] = phi i129 [ [[TMP19]], [[ITOFP_SW_DEFAULT]] ], [ [[A]], [[ITOFP_IF_THEN4]] ], [ [[TMP9]], [[ITOFP_SW_BB]] ]
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i129 [[TMP20]] to i32
; CHECK-NEXT:    [[TMP22:%.*]] = lshr i32 [[TMP21]], 2
; CHECK-NEXT:    [[TMP23:%.*]] = and i32 [[TMP22]], 1
; CHECK-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i129
; CHECK-NEXT:    [[TMP25:%.*]] = or i129 [[TMP20]], [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = add i129 [[TMP25]], 1
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i129 [[TMP26]], 2
; CHECK-NEXT:    [[A3:%.*]] = and i129 [[TMP26]], 67108864
; CHECK-NEXT:    [[TMP28:%.*]] = icmp eq i129 [[A3]], 0
; CHECK-NEXT:    [[TMP29:%.*]] = trunc i129 [[TMP27]] to i32
; CHECK-NEXT:    [[TMP30:%.*]] = lshr i129 [[TMP27]], 32
; CHECK-NEXT:    [[TMP31:%.*]] = trunc i129 [[TMP30]] to i32
; CHECK-NEXT:    br i1 [[TMP28]], label [[ITOFP_IF_END26:%.*]], label [[ITOFP_IF_THEN20:%.*]]
; CHECK:       itofp-if-then20:
; CHECK-NEXT:    [[TMP32:%.*]] = lshr i129 [[TMP26]], 3
; CHECK-NEXT:    [[TMP33:%.*]] = trunc i129 [[TMP32]] to i32
; CHECK-NEXT:    [[TMP34:%.*]] = lshr i129 [[TMP32]], 32
; CHECK-NEXT:    [[TMP35:%.*]] = trunc i129 [[TMP34]] to i32
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-else:
; CHECK-NEXT:    [[TMP36:%.*]] = add i32 [[TMP5]], -105
; CHECK-NEXT:    [[TMP37:%.*]] = zext i32 [[TMP36]] to i129
; CHECK-NEXT:    [[TMP38:%.*]] = shl i129 [[A]], [[TMP37]]
; CHECK-NEXT:    [[TMP39:%.*]] = trunc i129 [[TMP38]] to i32
; CHECK-NEXT:    [[TMP40:%.*]] = lshr i129 [[TMP38]], 32
; CHECK-NEXT:    [[TMP41:%.*]] = trunc i129 [[TMP40]] to i32
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-end26:
; CHECK-NEXT:    [[TMP42:%.*]] = phi i32 [ [[TMP33]], [[ITOFP_IF_THEN20]] ], [ [[TMP29]], [[ITOFP_SW_EPILOG]] ], [ [[TMP39]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP43:%.*]] = phi i32 [ [[TMP6]], [[ITOFP_IF_THEN20]] ], [ [[TMP7]], [[ITOFP_SW_EPILOG]] ], [ [[TMP7]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP44:%.*]] = trunc i129 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP45:%.*]] = and i32 [[TMP44]], -2147483648
; CHECK-NEXT:    [[TMP46:%.*]] = shl i32 [[TMP43]], 23
; CHECK-NEXT:    [[TMP47:%.*]] = add i32 [[TMP46]], 1065353216
; CHECK-NEXT:    [[TMP48:%.*]] = and i32 [[TMP42]], 8388607
; CHECK-NEXT:    [[TMP49:%.*]] = or i32 [[TMP48]], [[TMP45]]
; CHECK-NEXT:    [[TMP50:%.*]] = or i32 [[TMP48]], [[TMP47]]
; CHECK-NEXT:    [[TMP51:%.*]] = bitcast i32 [[TMP50]] to float
; CHECK-NEXT:    [[TMP52:%.*]] = fptrunc float [[TMP51]] to half
; CHECK-NEXT:    br label [[ITOFP_RETURN]]
; CHECK:       itofp-return:
; CHECK-NEXT:    [[TMP53:%.*]] = phi half [ [[TMP52]], [[ITOFP_IF_END26]] ], [ 0xH0000, [[ITOFP_ENTRY:%.*]] ]
; CHECK-NEXT:    ret half [[TMP53]]
;
  %conv = uitofp i129 %a to half
  ret half %conv
}

define float @ui129tofloat(i129 %a) {
; CHECK-LABEL: @ui129tofloat(
; CHECK-NEXT:  itofp-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i129 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[ITOFP_RETURN:%.*]], label [[ITOFP_IF_END:%.*]]
; CHECK:       itofp-if-end:
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i129 [[A]], 128
; CHECK-NEXT:    [[TMP2:%.*]] = xor i129 [[TMP1]], [[A]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub i129 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = call i129 @llvm.ctlz.i129(i129 [[A]], i1 true)
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i129 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = sub i32 129, [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub i32 128, [[TMP5]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp sgt i32 [[TMP7]], 24
; CHECK-NEXT:    br i1 [[TMP8]], label [[ITOFP_IF_THEN4:%.*]], label [[ITOFP_IF_ELSE:%.*]]
; CHECK:       itofp-if-then4:
; CHECK-NEXT:    switch i32 [[TMP6]], label [[ITOFP_SW_DEFAULT:%.*]] [
; CHECK-NEXT:    i32 25, label [[ITOFP_SW_BB:%.*]]
; CHECK-NEXT:    i32 26, label [[ITOFP_SW_EPILOG:%.*]]
; CHECK-NEXT:    ]
; CHECK:       itofp-sw-bb:
; CHECK-NEXT:    [[TMP9:%.*]] = shl i129 [[A]], 1
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-default:
; CHECK-NEXT:    [[TMP10:%.*]] = sub i32 103, [[TMP5]]
; CHECK-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i129
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i129 [[A]], [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = add i32 [[TMP5]], 26
; CHECK-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i129
; CHECK-NEXT:    [[TMP15:%.*]] = lshr i129 -1, [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = and i129 [[TMP15]], [[A]]
; CHECK-NEXT:    [[TMP17:%.*]] = icmp ne i129 [[TMP16]], 0
; CHECK-NEXT:    [[TMP18:%.*]] = zext i1 [[TMP17]] to i129
; CHECK-NEXT:    [[TMP19:%.*]] = or i129 [[TMP12]], [[TMP18]]
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-epilog:
; CHECK-NEXT:    [[TMP20:%.*]] = phi i129 [ [[TMP19]], [[ITOFP_SW_DEFAULT]] ], [ [[A]], [[ITOFP_IF_THEN4]] ], [ [[TMP9]], [[ITOFP_SW_BB]] ]
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i129 [[TMP20]] to i32
; CHECK-NEXT:    [[TMP22:%.*]] = lshr i32 [[TMP21]], 2
; CHECK-NEXT:    [[TMP23:%.*]] = and i32 [[TMP22]], 1
; CHECK-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i129
; CHECK-NEXT:    [[TMP25:%.*]] = or i129 [[TMP20]], [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = add i129 [[TMP25]], 1
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i129 [[TMP26]], 2
; CHECK-NEXT:    [[A3:%.*]] = and i129 [[TMP26]], 67108864
; CHECK-NEXT:    [[TMP28:%.*]] = icmp eq i129 [[A3]], 0
; CHECK-NEXT:    [[TMP29:%.*]] = trunc i129 [[TMP27]] to i32
; CHECK-NEXT:    [[TMP30:%.*]] = lshr i129 [[TMP27]], 32
; CHECK-NEXT:    [[TMP31:%.*]] = trunc i129 [[TMP30]] to i32
; CHECK-NEXT:    br i1 [[TMP28]], label [[ITOFP_IF_END26:%.*]], label [[ITOFP_IF_THEN20:%.*]]
; CHECK:       itofp-if-then20:
; CHECK-NEXT:    [[TMP32:%.*]] = lshr i129 [[TMP26]], 3
; CHECK-NEXT:    [[TMP33:%.*]] = trunc i129 [[TMP32]] to i32
; CHECK-NEXT:    [[TMP34:%.*]] = lshr i129 [[TMP32]], 32
; CHECK-NEXT:    [[TMP35:%.*]] = trunc i129 [[TMP34]] to i32
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-else:
; CHECK-NEXT:    [[TMP36:%.*]] = add i32 [[TMP5]], -105
; CHECK-NEXT:    [[TMP37:%.*]] = zext i32 [[TMP36]] to i129
; CHECK-NEXT:    [[TMP38:%.*]] = shl i129 [[A]], [[TMP37]]
; CHECK-NEXT:    [[TMP39:%.*]] = trunc i129 [[TMP38]] to i32
; CHECK-NEXT:    [[TMP40:%.*]] = lshr i129 [[TMP38]], 32
; CHECK-NEXT:    [[TMP41:%.*]] = trunc i129 [[TMP40]] to i32
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-end26:
; CHECK-NEXT:    [[TMP42:%.*]] = phi i32 [ [[TMP33]], [[ITOFP_IF_THEN20]] ], [ [[TMP29]], [[ITOFP_SW_EPILOG]] ], [ [[TMP39]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP43:%.*]] = phi i32 [ [[TMP6]], [[ITOFP_IF_THEN20]] ], [ [[TMP7]], [[ITOFP_SW_EPILOG]] ], [ [[TMP7]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP44:%.*]] = trunc i129 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP45:%.*]] = and i32 [[TMP44]], -2147483648
; CHECK-NEXT:    [[TMP46:%.*]] = shl i32 [[TMP43]], 23
; CHECK-NEXT:    [[TMP47:%.*]] = add i32 [[TMP46]], 1065353216
; CHECK-NEXT:    [[TMP48:%.*]] = and i32 [[TMP42]], 8388607
; CHECK-NEXT:    [[TMP49:%.*]] = or i32 [[TMP48]], [[TMP45]]
; CHECK-NEXT:    [[TMP50:%.*]] = or i32 [[TMP48]], [[TMP47]]
; CHECK-NEXT:    [[TMP51:%.*]] = bitcast i32 [[TMP50]] to float
; CHECK-NEXT:    br label [[ITOFP_RETURN]]
; CHECK:       itofp-return:
; CHECK-NEXT:    [[TMP52:%.*]] = phi float [ [[TMP51]], [[ITOFP_IF_END26]] ], [ 0.000000e+00, [[ITOFP_ENTRY:%.*]] ]
; CHECK-NEXT:    ret float [[TMP52]]
;
  %conv = uitofp i129 %a to float
  ret float %conv
}

define double @ui129todouble(i129 %a) {
; CHECK-LABEL: @ui129todouble(
; CHECK-NEXT:  itofp-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i129 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[ITOFP_RETURN:%.*]], label [[ITOFP_IF_END:%.*]]
; CHECK:       itofp-if-end:
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i129 [[A]], 128
; CHECK-NEXT:    [[TMP2:%.*]] = xor i129 [[TMP1]], [[A]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub i129 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = call i129 @llvm.ctlz.i129(i129 [[A]], i1 true)
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i129 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = sub i32 129, [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub i32 128, [[TMP5]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp sgt i32 [[TMP7]], 53
; CHECK-NEXT:    br i1 [[TMP8]], label [[ITOFP_IF_THEN4:%.*]], label [[ITOFP_IF_ELSE:%.*]]
; CHECK:       itofp-if-then4:
; CHECK-NEXT:    switch i32 [[TMP6]], label [[ITOFP_SW_DEFAULT:%.*]] [
; CHECK-NEXT:    i32 54, label [[ITOFP_SW_BB:%.*]]
; CHECK-NEXT:    i32 55, label [[ITOFP_SW_EPILOG:%.*]]
; CHECK-NEXT:    ]
; CHECK:       itofp-sw-bb:
; CHECK-NEXT:    [[TMP9:%.*]] = shl i129 [[A]], 1
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-default:
; CHECK-NEXT:    [[TMP10:%.*]] = sub i32 74, [[TMP5]]
; CHECK-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i129
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i129 [[A]], [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = add i32 [[TMP5]], 55
; CHECK-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i129
; CHECK-NEXT:    [[TMP15:%.*]] = lshr i129 -1, [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = and i129 [[TMP15]], [[A]]
; CHECK-NEXT:    [[TMP17:%.*]] = icmp ne i129 [[TMP16]], 0
; CHECK-NEXT:    [[TMP18:%.*]] = zext i1 [[TMP17]] to i129
; CHECK-NEXT:    [[TMP19:%.*]] = or i129 [[TMP12]], [[TMP18]]
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-epilog:
; CHECK-NEXT:    [[TMP20:%.*]] = phi i129 [ [[TMP19]], [[ITOFP_SW_DEFAULT]] ], [ [[A]], [[ITOFP_IF_THEN4]] ], [ [[TMP9]], [[ITOFP_SW_BB]] ]
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i129 [[TMP20]] to i32
; CHECK-NEXT:    [[TMP22:%.*]] = lshr i32 [[TMP21]], 2
; CHECK-NEXT:    [[TMP23:%.*]] = and i32 [[TMP22]], 1
; CHECK-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i129
; CHECK-NEXT:    [[TMP25:%.*]] = or i129 [[TMP20]], [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = add i129 [[TMP25]], 1
; CHECK-NEXT:    [[TMP27:%.*]] = lshr i129 [[TMP26]], 2
; CHECK-NEXT:    [[A3:%.*]] = and i129 [[TMP26]], 36028797018963968
; CHECK-NEXT:    [[TMP28:%.*]] = icmp eq i129 [[A3]], 0
; CHECK-NEXT:    [[TMP29:%.*]] = trunc i129 [[TMP27]] to i64
; CHECK-NEXT:    [[TMP30:%.*]] = lshr i129 [[TMP27]], 32
; CHECK-NEXT:    [[TMP31:%.*]] = trunc i129 [[TMP30]] to i32
; CHECK-NEXT:    br i1 [[TMP28]], label [[ITOFP_IF_END26:%.*]], label [[ITOFP_IF_THEN20:%.*]]
; CHECK:       itofp-if-then20:
; CHECK-NEXT:    [[TMP32:%.*]] = lshr i129 [[TMP26]], 3
; CHECK-NEXT:    [[TMP33:%.*]] = trunc i129 [[TMP32]] to i64
; CHECK-NEXT:    [[TMP34:%.*]] = lshr i129 [[TMP32]], 32
; CHECK-NEXT:    [[TMP35:%.*]] = trunc i129 [[TMP34]] to i32
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-else:
; CHECK-NEXT:    [[TMP36:%.*]] = add i32 [[TMP5]], -76
; CHECK-NEXT:    [[TMP37:%.*]] = zext i32 [[TMP36]] to i129
; CHECK-NEXT:    [[TMP38:%.*]] = shl i129 [[A]], [[TMP37]]
; CHECK-NEXT:    [[TMP39:%.*]] = trunc i129 [[TMP38]] to i64
; CHECK-NEXT:    [[TMP40:%.*]] = lshr i129 [[TMP38]], 32
; CHECK-NEXT:    [[TMP41:%.*]] = trunc i129 [[TMP40]] to i32
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-end26:
; CHECK-NEXT:    [[TMP42:%.*]] = phi i64 [ [[TMP33]], [[ITOFP_IF_THEN20]] ], [ [[TMP29]], [[ITOFP_SW_EPILOG]] ], [ [[TMP39]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP43:%.*]] = phi i32 [ [[TMP35]], [[ITOFP_IF_THEN20]] ], [ [[TMP31]], [[ITOFP_SW_EPILOG]] ], [ [[TMP41]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP44:%.*]] = phi i32 [ [[TMP6]], [[ITOFP_IF_THEN20]] ], [ [[TMP7]], [[ITOFP_SW_EPILOG]] ], [ [[TMP7]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP45:%.*]] = trunc i129 [[TMP1]] to i32
; CHECK-NEXT:    [[TMP46:%.*]] = and i32 [[TMP45]], -2147483648
; CHECK-NEXT:    [[TMP47:%.*]] = shl i32 [[TMP44]], 20
; CHECK-NEXT:    [[TMP48:%.*]] = add i32 [[TMP47]], 1072693248
; CHECK-NEXT:    [[TMP49:%.*]] = and i32 [[TMP43]], 1048575
; CHECK-NEXT:    [[TMP50:%.*]] = or i32 [[TMP49]], [[TMP46]]
; CHECK-NEXT:    [[TMP51:%.*]] = or i32 [[TMP49]], [[TMP48]]
; CHECK-NEXT:    [[TMP52:%.*]] = zext i32 [[TMP51]] to i64
; CHECK-NEXT:    [[TMP53:%.*]] = shl i64 [[TMP52]], 32
; CHECK-NEXT:    [[TMP54:%.*]] = and i64 [[TMP42]], 4294967295
; CHECK-NEXT:    [[TMP55:%.*]] = or i64 [[TMP53]], [[TMP54]]
; CHECK-NEXT:    [[TMP56:%.*]] = bitcast i64 [[TMP55]] to double
; CHECK-NEXT:    br label [[ITOFP_RETURN]]
; CHECK:       itofp-return:
; CHECK-NEXT:    [[TMP57:%.*]] = phi double [ [[TMP56]], [[ITOFP_IF_END26]] ], [ 0.000000e+00, [[ITOFP_ENTRY:%.*]] ]
; CHECK-NEXT:    ret double [[TMP57]]
;
  %conv = uitofp i129 %a to double
  ret double %conv
}

define x86_fp80 @ui129tox86_fp80(i129 %a) {
; CHECK-LABEL: @ui129tox86_fp80(
; CHECK-NEXT:  itofp-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i129 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[ITOFP_RETURN:%.*]], label [[ITOFP_IF_END:%.*]]
; CHECK:       itofp-if-end:
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i129 [[A]], 128
; CHECK-NEXT:    [[TMP2:%.*]] = xor i129 [[TMP1]], [[A]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub i129 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = call i129 @llvm.ctlz.i129(i129 [[A]], i1 true)
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i129 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = sub i129 129, [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub i129 128, [[TMP4]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp sgt i129 [[TMP7]], 113
; CHECK-NEXT:    br i1 [[TMP8]], label [[ITOFP_IF_THEN4:%.*]], label [[ITOFP_IF_ELSE:%.*]]
; CHECK:       itofp-if-then4:
; CHECK-NEXT:    switch i129 [[TMP6]], label [[ITOFP_SW_DEFAULT:%.*]] [
; CHECK-NEXT:    i129 114, label [[ITOFP_SW_BB:%.*]]
; CHECK-NEXT:    i129 115, label [[ITOFP_SW_EPILOG:%.*]]
; CHECK-NEXT:    ]
; CHECK:       itofp-sw-bb:
; CHECK-NEXT:    [[TMP9:%.*]] = shl i129 [[A]], 1
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-default:
; CHECK-NEXT:    [[TMP10:%.*]] = sub i129 14, [[TMP4]]
; CHECK-NEXT:    [[TMP11:%.*]] = lshr i129 [[A]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = add i129 [[TMP4]], 115
; CHECK-NEXT:    [[TMP13:%.*]] = lshr i129 -1, [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = and i129 [[TMP13]], [[A]]
; CHECK-NEXT:    [[TMP15:%.*]] = icmp ne i129 [[TMP14]], 0
; CHECK-NEXT:    [[TMP16:%.*]] = zext i1 [[TMP15]] to i129
; CHECK-NEXT:    [[TMP17:%.*]] = or i129 [[TMP11]], [[TMP16]]
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-epilog:
; CHECK-NEXT:    [[TMP18:%.*]] = phi i129 [ [[TMP17]], [[ITOFP_SW_DEFAULT]] ], [ [[A]], [[ITOFP_IF_THEN4]] ], [ [[TMP9]], [[ITOFP_SW_BB]] ]
; CHECK-NEXT:    [[TMP19:%.*]] = trunc i129 [[TMP18]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP19]], 2
; CHECK-NEXT:    [[TMP21:%.*]] = and i32 [[TMP20]], 1
; CHECK-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i129
; CHECK-NEXT:    [[TMP23:%.*]] = or i129 [[TMP18]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = add i129 [[TMP23]], 1
; CHECK-NEXT:    [[TMP25:%.*]] = lshr i129 [[TMP24]], 2
; CHECK-NEXT:    [[A3:%.*]] = and i129 [[TMP24]], 41538374868278621028243970633760768
; CHECK-NEXT:    [[TMP26:%.*]] = icmp eq i129 [[A3]], 0
; CHECK-NEXT:    [[TMP27:%.*]] = trunc i129 [[TMP25]] to i128
; CHECK-NEXT:    [[TMP28:%.*]] = lshr i129 [[TMP25]], 32
; CHECK-NEXT:    [[TMP29:%.*]] = trunc i129 [[TMP7]] to i64
; CHECK-NEXT:    br i1 [[TMP26]], label [[ITOFP_IF_END26:%.*]], label [[ITOFP_IF_THEN20:%.*]]
; CHECK:       itofp-if-then20:
; CHECK-NEXT:    [[TMP30:%.*]] = lshr i129 [[TMP24]], 3
; CHECK-NEXT:    [[TMP31:%.*]] = trunc i129 [[TMP30]] to i128
; CHECK-NEXT:    [[TMP32:%.*]] = lshr i129 [[TMP30]], 32
; CHECK-NEXT:    [[TMP33:%.*]] = trunc i129 [[TMP6]] to i64
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-else:
; CHECK-NEXT:    [[TMP34:%.*]] = add i129 [[TMP4]], 4294967280
; CHECK-NEXT:    [[TMP35:%.*]] = shl i129 [[A]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = trunc i129 [[TMP35]] to i128
; CHECK-NEXT:    [[TMP37:%.*]] = lshr i129 [[TMP35]], 32
; CHECK-NEXT:    [[TMP38:%.*]] = trunc i129 [[TMP7]] to i64
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-end26:
; CHECK-NEXT:    [[TMP39:%.*]] = phi i128 [ [[TMP31]], [[ITOFP_IF_THEN20]] ], [ [[TMP27]], [[ITOFP_SW_EPILOG]] ], [ [[TMP36]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP40:%.*]] = phi i64 [ [[TMP33]], [[ITOFP_IF_THEN20]] ], [ [[TMP29]], [[ITOFP_SW_EPILOG]] ], [ [[TMP38]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[AND29:%.*]] = and i129 [[TMP1]], 9223372036854775808
; CHECK-NEXT:    [[TMP41:%.*]] = shl i64 [[TMP40]], 48
; CHECK-NEXT:    [[TMP42:%.*]] = add i64 [[TMP41]], 4611404543450677248
; CHECK-NEXT:    [[TMP43:%.*]] = zext i64 [[TMP42]] to i128
; CHECK-NEXT:    [[TMP44:%.*]] = trunc i129 [[AND29]] to i128
; CHECK-NEXT:    [[TMP45:%.*]] = or i128 [[TMP44]], [[TMP43]]
; CHECK-NEXT:    [[TMP46:%.*]] = shl i128 [[TMP45]], 64
; CHECK-NEXT:    [[TMP47:%.*]] = and i128 [[TMP39]], 5192296858534827628530496329220095
; CHECK-NEXT:    [[TMP48:%.*]] = or i128 [[TMP46]], [[TMP47]]
; CHECK-NEXT:    [[TMP49:%.*]] = bitcast i128 [[TMP48]] to fp128
; CHECK-NEXT:    [[TMP50:%.*]] = fptrunc fp128 [[TMP49]] to x86_fp80
; CHECK-NEXT:    br label [[ITOFP_RETURN]]
; CHECK:       itofp-return:
; CHECK-NEXT:    [[TMP51:%.*]] = phi x86_fp80 [ [[TMP50]], [[ITOFP_IF_END26]] ], [ 0xK00000000000000000000, [[ITOFP_ENTRY:%.*]] ]
; CHECK-NEXT:    ret x86_fp80 [[TMP51]]
;
  %conv = uitofp i129 %a to x86_fp80
  ret x86_fp80 %conv
}

define fp128 @ui129tofp128(i129 %a) {
; CHECK-LABEL: @ui129tofp128(
; CHECK-NEXT:  itofp-entry:
; CHECK-NEXT:    [[TMP0:%.*]] = icmp eq i129 [[A:%.*]], 0
; CHECK-NEXT:    br i1 [[TMP0]], label [[ITOFP_RETURN:%.*]], label [[ITOFP_IF_END:%.*]]
; CHECK:       itofp-if-end:
; CHECK-NEXT:    [[TMP1:%.*]] = ashr i129 [[A]], 128
; CHECK-NEXT:    [[TMP2:%.*]] = xor i129 [[TMP1]], [[A]]
; CHECK-NEXT:    [[TMP3:%.*]] = sub i129 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = call i129 @llvm.ctlz.i129(i129 [[A]], i1 true)
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i129 [[TMP4]] to i32
; CHECK-NEXT:    [[TMP6:%.*]] = sub i129 129, [[TMP4]]
; CHECK-NEXT:    [[TMP7:%.*]] = sub i129 128, [[TMP4]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp sgt i129 [[TMP7]], 113
; CHECK-NEXT:    br i1 [[TMP8]], label [[ITOFP_IF_THEN4:%.*]], label [[ITOFP_IF_ELSE:%.*]]
; CHECK:       itofp-if-then4:
; CHECK-NEXT:    switch i129 [[TMP6]], label [[ITOFP_SW_DEFAULT:%.*]] [
; CHECK-NEXT:    i129 114, label [[ITOFP_SW_BB:%.*]]
; CHECK-NEXT:    i129 115, label [[ITOFP_SW_EPILOG:%.*]]
; CHECK-NEXT:    ]
; CHECK:       itofp-sw-bb:
; CHECK-NEXT:    [[TMP9:%.*]] = shl i129 [[A]], 1
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-default:
; CHECK-NEXT:    [[TMP10:%.*]] = sub i129 14, [[TMP4]]
; CHECK-NEXT:    [[TMP11:%.*]] = lshr i129 [[A]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = add i129 [[TMP4]], 115
; CHECK-NEXT:    [[TMP13:%.*]] = lshr i129 -1, [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = and i129 [[TMP13]], [[A]]
; CHECK-NEXT:    [[TMP15:%.*]] = icmp ne i129 [[TMP14]], 0
; CHECK-NEXT:    [[TMP16:%.*]] = zext i1 [[TMP15]] to i129
; CHECK-NEXT:    [[TMP17:%.*]] = or i129 [[TMP11]], [[TMP16]]
; CHECK-NEXT:    br label [[ITOFP_SW_EPILOG]]
; CHECK:       itofp-sw-epilog:
; CHECK-NEXT:    [[TMP18:%.*]] = phi i129 [ [[TMP17]], [[ITOFP_SW_DEFAULT]] ], [ [[A]], [[ITOFP_IF_THEN4]] ], [ [[TMP9]], [[ITOFP_SW_BB]] ]
; CHECK-NEXT:    [[TMP19:%.*]] = trunc i129 [[TMP18]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP19]], 2
; CHECK-NEXT:    [[TMP21:%.*]] = and i32 [[TMP20]], 1
; CHECK-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i129
; CHECK-NEXT:    [[TMP23:%.*]] = or i129 [[TMP18]], [[TMP22]]
; CHECK-NEXT:    [[TMP24:%.*]] = add i129 [[TMP23]], 1
; CHECK-NEXT:    [[TMP25:%.*]] = lshr i129 [[TMP24]], 2
; CHECK-NEXT:    [[A3:%.*]] = and i129 [[TMP24]], 41538374868278621028243970633760768
; CHECK-NEXT:    [[TMP26:%.*]] = icmp eq i129 [[A3]], 0
; CHECK-NEXT:    [[TMP27:%.*]] = trunc i129 [[TMP25]] to i128
; CHECK-NEXT:    [[TMP28:%.*]] = lshr i129 [[TMP25]], 32
; CHECK-NEXT:    [[TMP29:%.*]] = trunc i129 [[TMP7]] to i64
; CHECK-NEXT:    br i1 [[TMP26]], label [[ITOFP_IF_END26:%.*]], label [[ITOFP_IF_THEN20:%.*]]
; CHECK:       itofp-if-then20:
; CHECK-NEXT:    [[TMP30:%.*]] = lshr i129 [[TMP24]], 3
; CHECK-NEXT:    [[TMP31:%.*]] = trunc i129 [[TMP30]] to i128
; CHECK-NEXT:    [[TMP32:%.*]] = lshr i129 [[TMP30]], 32
; CHECK-NEXT:    [[TMP33:%.*]] = trunc i129 [[TMP6]] to i64
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-else:
; CHECK-NEXT:    [[TMP34:%.*]] = add i129 [[TMP4]], 4294967280
; CHECK-NEXT:    [[TMP35:%.*]] = shl i129 [[A]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = trunc i129 [[TMP35]] to i128
; CHECK-NEXT:    [[TMP37:%.*]] = lshr i129 [[TMP35]], 32
; CHECK-NEXT:    [[TMP38:%.*]] = trunc i129 [[TMP7]] to i64
; CHECK-NEXT:    br label [[ITOFP_IF_END26]]
; CHECK:       itofp-if-end26:
; CHECK-NEXT:    [[TMP39:%.*]] = phi i128 [ [[TMP31]], [[ITOFP_IF_THEN20]] ], [ [[TMP27]], [[ITOFP_SW_EPILOG]] ], [ [[TMP36]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[TMP40:%.*]] = phi i64 [ [[TMP33]], [[ITOFP_IF_THEN20]] ], [ [[TMP29]], [[ITOFP_SW_EPILOG]] ], [ [[TMP38]], [[ITOFP_IF_ELSE]] ]
; CHECK-NEXT:    [[AND29:%.*]] = and i129 [[TMP1]], 9223372036854775808
; CHECK-NEXT:    [[TMP41:%.*]] = shl i64 [[TMP40]], 48
; CHECK-NEXT:    [[TMP42:%.*]] = add i64 [[TMP41]], 4611404543450677248
; CHECK-NEXT:    [[TMP43:%.*]] = zext i64 [[TMP42]] to i128
; CHECK-NEXT:    [[TMP44:%.*]] = trunc i129 [[AND29]] to i128
; CHECK-NEXT:    [[TMP45:%.*]] = or i128 [[TMP44]], [[TMP43]]
; CHECK-NEXT:    [[TMP46:%.*]] = shl i128 [[TMP45]], 64
; CHECK-NEXT:    [[TMP47:%.*]] = and i128 [[TMP39]], 5192296858534827628530496329220095
; CHECK-NEXT:    [[TMP48:%.*]] = or i128 [[TMP46]], [[TMP47]]
; CHECK-NEXT:    [[TMP49:%.*]] = bitcast i128 [[TMP48]] to fp128
; CHECK-NEXT:    br label [[ITOFP_RETURN]]
; CHECK:       itofp-return:
; CHECK-NEXT:    [[TMP50:%.*]] = phi fp128 [ [[TMP49]], [[ITOFP_IF_END26]] ], [ 0xL00000000000000000000000000000000, [[ITOFP_ENTRY:%.*]] ]
; CHECK-NEXT:    ret fp128 [[TMP50]]
;
  %conv = uitofp i129 %a to fp128
  ret fp128 %conv
}
