/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.beans.LDAPBasePropertySupport;

public class LDAPSimpleAuth
extends LDAPBasePropertySupport
implements Serializable {
    private transient String result = new String("");

    public LDAPSimpleAuth() {
    }

    public LDAPSimpleAuth(String theHost, int thePort) {
        this.setHost(theHost);
        this.setPort(thePort);
    }

    public LDAPSimpleAuth(String theHost, int thePort, String dn, String password) {
        this.setHost(theHost);
        this.setPort(thePort);
        this.setAuthDN(dn);
        this.setAuthPassword(password);
    }

    private void notifyResult(String newResult) {
        this.firePropertyChange("result", this.result, newResult);
        this.result = newResult;
    }

    public String authenticate() {
        LDAPConnection m_ldc = null;
        String result = "N";
        try {
            m_ldc = new LDAPConnection();
            System.out.println("Connecting to " + this.getHost() + " " + this.getPort());
            this.connect(m_ldc, this.getHost(), this.getPort());
        }
        catch (Exception e) {
            System.out.println("Failed to connect to " + this.getHost() + ": " + e.toString());
        }
        if (m_ldc.isConnected()) {
            System.out.println("Authenticating " + this.getAuthDN());
            try {
                m_ldc.authenticate(this.getAuthDN(), this.getAuthPassword());
                result = "Y";
            }
            catch (Exception e) {
                System.out.println("Failed to authenticate to " + this.getHost() + ": " + e.toString());
            }
        }
        try {
            if (m_ldc != null && m_ldc.isConnected()) {
                m_ldc.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyResult(result);
        return result;
    }

    public String authenticate(String dn, String password) {
        this.setAuthDN(dn);
        this.setAuthPassword(password);
        return this.authenticate();
    }

    public void authenticate(ActionEvent x) {
        this.authenticate();
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("       LDAPSimpleAuth host port DN password");
            System.exit(1);
        }
        LDAPSimpleAuth app = new LDAPSimpleAuth();
        app.setHost(args[0]);
        app.setPort(Integer.parseInt(args[1]));
        app.setAuthDN(args[2]);
        app.setAuthPassword(args[3]);
        String response = app.authenticate();
        System.out.println("Response: " + response);
        System.exit(0);
    }
}

