/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RpmUpdateCollection type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmUpdateCollection{}

// RpmUpdateCollection A Serializer for UpdateCollection.
type RpmUpdateCollection struct {
	// Collection name.
	Name NullableString `json:"name"`
	// Collection short name.
	Shortname NullableString `json:"shortname"`
	// Collection modular NSVCA.
	Module map[string]interface{} `json:"module"`
	AdditionalProperties map[string]interface{}
}

type _RpmUpdateCollection RpmUpdateCollection

// NewRpmUpdateCollection instantiates a new RpmUpdateCollection object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmUpdateCollection(name NullableString, shortname NullableString, module map[string]interface{}) *RpmUpdateCollection {
	this := RpmUpdateCollection{}
	this.Name = name
	this.Shortname = shortname
	this.Module = module
	return &this
}

// NewRpmUpdateCollectionWithDefaults instantiates a new RpmUpdateCollection object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmUpdateCollectionWithDefaults() *RpmUpdateCollection {
	this := RpmUpdateCollection{}
	return &this
}

// GetName returns the Name field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmUpdateCollection) GetName() string {
	if o == nil || o.Name.Get() == nil {
		var ret string
		return ret
	}

	return *o.Name.Get()
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmUpdateCollection) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Name.Get(), o.Name.IsSet()
}

// SetName sets field value
func (o *RpmUpdateCollection) SetName(v string) {
	o.Name.Set(&v)
}

// GetShortname returns the Shortname field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmUpdateCollection) GetShortname() string {
	if o == nil || o.Shortname.Get() == nil {
		var ret string
		return ret
	}

	return *o.Shortname.Get()
}

// GetShortnameOk returns a tuple with the Shortname field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmUpdateCollection) GetShortnameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Shortname.Get(), o.Shortname.IsSet()
}

// SetShortname sets field value
func (o *RpmUpdateCollection) SetShortname(v string) {
	o.Shortname.Set(&v)
}

// GetModule returns the Module field value
// If the value is explicit nil, the zero value for map[string]interface{} will be returned
func (o *RpmUpdateCollection) GetModule() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.Module
}

// GetModuleOk returns a tuple with the Module field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmUpdateCollection) GetModuleOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Module) {
		return map[string]interface{}{}, false
	}
	return o.Module, true
}

// SetModule sets field value
func (o *RpmUpdateCollection) SetModule(v map[string]interface{}) {
	o.Module = v
}

func (o RpmUpdateCollection) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmUpdateCollection) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name.Get()
	toSerialize["shortname"] = o.Shortname.Get()
	if o.Module != nil {
		toSerialize["module"] = o.Module
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmUpdateCollection) UnmarshalJSON(bytes []byte) (err error) {
	varRpmUpdateCollection := _RpmUpdateCollection{}

	if err = json.Unmarshal(bytes, &varRpmUpdateCollection); err == nil {
		*o = RpmUpdateCollection(varRpmUpdateCollection)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "shortname")
		delete(additionalProperties, "module")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmUpdateCollection struct {
	value *RpmUpdateCollection
	isSet bool
}

func (v NullableRpmUpdateCollection) Get() *RpmUpdateCollection {
	return v.value
}

func (v *NullableRpmUpdateCollection) Set(val *RpmUpdateCollection) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmUpdateCollection) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmUpdateCollection) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmUpdateCollection(val *RpmUpdateCollection) *NullableRpmUpdateCollection {
	return &NullableRpmUpdateCollection{value: val, isSet: true}
}

func (v NullableRpmUpdateCollection) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmUpdateCollection) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


