/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the FileFileAlternateContentSource type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &FileFileAlternateContentSource{}

// FileFileAlternateContentSource Serializer for File alternate content source.
type FileFileAlternateContentSource struct {
	// Name of Alternate Content Source.
	Name string `json:"name"`
	// Date of last refresh of AlternateContentSource.
	LastRefreshed NullableTime `json:"last_refreshed,omitempty"`
	// List of paths that will be appended to the Remote url when searching for content.
	Paths []string `json:"paths,omitempty"`
	// The remote to provide alternate content source.
	Remote string `json:"remote"`
	AdditionalProperties map[string]interface{}
}

type _FileFileAlternateContentSource FileFileAlternateContentSource

// NewFileFileAlternateContentSource instantiates a new FileFileAlternateContentSource object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewFileFileAlternateContentSource(name string, remote string) *FileFileAlternateContentSource {
	this := FileFileAlternateContentSource{}
	this.Name = name
	this.Remote = remote
	return &this
}

// NewFileFileAlternateContentSourceWithDefaults instantiates a new FileFileAlternateContentSource object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewFileFileAlternateContentSourceWithDefaults() *FileFileAlternateContentSource {
	this := FileFileAlternateContentSource{}
	return &this
}

// GetName returns the Name field value
func (o *FileFileAlternateContentSource) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *FileFileAlternateContentSource) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *FileFileAlternateContentSource) SetName(v string) {
	o.Name = v
}

// GetLastRefreshed returns the LastRefreshed field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *FileFileAlternateContentSource) GetLastRefreshed() time.Time {
	if o == nil || IsNil(o.LastRefreshed.Get()) {
		var ret time.Time
		return ret
	}
	return *o.LastRefreshed.Get()
}

// GetLastRefreshedOk returns a tuple with the LastRefreshed field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FileFileAlternateContentSource) GetLastRefreshedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastRefreshed.Get(), o.LastRefreshed.IsSet()
}

// HasLastRefreshed returns a boolean if a field has been set.
func (o *FileFileAlternateContentSource) HasLastRefreshed() bool {
	if o != nil && o.LastRefreshed.IsSet() {
		return true
	}

	return false
}

// SetLastRefreshed gets a reference to the given NullableTime and assigns it to the LastRefreshed field.
func (o *FileFileAlternateContentSource) SetLastRefreshed(v time.Time) {
	o.LastRefreshed.Set(&v)
}
// SetLastRefreshedNil sets the value for LastRefreshed to be an explicit nil
func (o *FileFileAlternateContentSource) SetLastRefreshedNil() {
	o.LastRefreshed.Set(nil)
}

// UnsetLastRefreshed ensures that no value is present for LastRefreshed, not even an explicit nil
func (o *FileFileAlternateContentSource) UnsetLastRefreshed() {
	o.LastRefreshed.Unset()
}

// GetPaths returns the Paths field value if set, zero value otherwise.
func (o *FileFileAlternateContentSource) GetPaths() []string {
	if o == nil || IsNil(o.Paths) {
		var ret []string
		return ret
	}
	return o.Paths
}

// GetPathsOk returns a tuple with the Paths field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *FileFileAlternateContentSource) GetPathsOk() ([]string, bool) {
	if o == nil || IsNil(o.Paths) {
		return nil, false
	}
	return o.Paths, true
}

// HasPaths returns a boolean if a field has been set.
func (o *FileFileAlternateContentSource) HasPaths() bool {
	if o != nil && !IsNil(o.Paths) {
		return true
	}

	return false
}

// SetPaths gets a reference to the given []string and assigns it to the Paths field.
func (o *FileFileAlternateContentSource) SetPaths(v []string) {
	o.Paths = v
}

// GetRemote returns the Remote field value
func (o *FileFileAlternateContentSource) GetRemote() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Remote
}

// GetRemoteOk returns a tuple with the Remote field value
// and a boolean to check if the value has been set.
func (o *FileFileAlternateContentSource) GetRemoteOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Remote, true
}

// SetRemote sets field value
func (o *FileFileAlternateContentSource) SetRemote(v string) {
	o.Remote = v
}

func (o FileFileAlternateContentSource) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o FileFileAlternateContentSource) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	if o.LastRefreshed.IsSet() {
		toSerialize["last_refreshed"] = o.LastRefreshed.Get()
	}
	if !IsNil(o.Paths) {
		toSerialize["paths"] = o.Paths
	}
	toSerialize["remote"] = o.Remote

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *FileFileAlternateContentSource) UnmarshalJSON(bytes []byte) (err error) {
	varFileFileAlternateContentSource := _FileFileAlternateContentSource{}

	if err = json.Unmarshal(bytes, &varFileFileAlternateContentSource); err == nil {
		*o = FileFileAlternateContentSource(varFileFileAlternateContentSource)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "last_refreshed")
		delete(additionalProperties, "paths")
		delete(additionalProperties, "remote")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableFileFileAlternateContentSource struct {
	value *FileFileAlternateContentSource
	isSet bool
}

func (v NullableFileFileAlternateContentSource) Get() *FileFileAlternateContentSource {
	return v.value
}

func (v *NullableFileFileAlternateContentSource) Set(val *FileFileAlternateContentSource) {
	v.value = val
	v.isSet = true
}

func (v NullableFileFileAlternateContentSource) IsSet() bool {
	return v.isSet
}

func (v *NullableFileFileAlternateContentSource) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFileFileAlternateContentSource(val *FileFileAlternateContentSource) *NullableFileFileAlternateContentSource {
	return &NullableFileFileAlternateContentSource{value: val, isSet: true}
}

func (v NullableFileFileAlternateContentSource) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFileFileAlternateContentSource) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


