/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentReleaseFilesAPIService ContentReleaseFilesAPI service
type ContentReleaseFilesAPIService service

type ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest struct {
	ctx context.Context
	ApiService *ContentReleaseFilesAPIService
	debReleaseFile *DebReleaseFile
}

func (r ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest) DebReleaseFile(debReleaseFile DebReleaseFile) ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest {
	r.debReleaseFile = &debReleaseFile
	return r
}

func (r ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest) Execute() (*DebReleaseFileResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleaseFilesCreateExecute(r)
}

/*
ContentDebReleaseFilesCreate Create a release file

A ReleaseFile represents the Release file(s) from a single APT distribution.

Associated artifacts: At least one of 'Release' and 'InRelease' file. If the 'Release' file is
present, then there may also be a 'Release.gpg' detached signature file for it.

Note: The verbatim publisher will republish all associated artifacts, while the APT publisher
(both simple and structured mode) will generate any 'Release' files it needs when creating the
publication. It does not make use of ReleaseFile content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest
*/
func (a *ContentReleaseFilesAPIService) ContentDebReleaseFilesCreate(ctx context.Context) ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest {
	return ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return DebReleaseFileResponse
func (a *ContentReleaseFilesAPIService) ContentDebReleaseFilesCreateExecute(r ContentReleaseFilesAPIContentDebReleaseFilesCreateRequest) (*DebReleaseFileResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseFileResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseFilesAPIService.ContentDebReleaseFilesCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/release_files/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debReleaseFile == nil {
		return localVarReturnValue, nil, reportError("debReleaseFile is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debReleaseFile
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleaseFilesAPIContentDebReleaseFilesListRequest struct {
	ctx context.Context
	ApiService *ContentReleaseFilesAPIService
	codename *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	relativePath *string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	sha256 *string
	suite *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where codename matches value
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Codename(codename string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.codename = &codename
	return r
}

// Number of results to return per page.
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Limit(limit int32) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Offset(offset int32) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;codename&#x60; - Codename * &#x60;-codename&#x60; - Codename (descending) * &#x60;suite&#x60; - Suite * &#x60;-suite&#x60; - Suite (descending) * &#x60;distribution&#x60; - Distribution * &#x60;-distribution&#x60; - Distribution (descending) * &#x60;components&#x60; - Components * &#x60;-components&#x60; - Components (descending) * &#x60;architectures&#x60; - Architectures * &#x60;-architectures&#x60; - Architectures (descending) * &#x60;relative_path&#x60; - Relative path * &#x60;-relative_path&#x60; - Relative path (descending) * &#x60;sha256&#x60; - Sha256 * &#x60;-sha256&#x60; - Sha256 (descending) * &#x60;artifact_set_sha256&#x60; - Artifact set sha256 * &#x60;-artifact_set_sha256&#x60; - Artifact set sha256 (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Ordering(ordering []string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) PulpHrefIn(pulpHrefIn []string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) PulpIdIn(pulpIdIn []string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter results where relative_path matches value
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) RelativePath(relativePath string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.relativePath = &relativePath
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) RepositoryVersion(repositoryVersion string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where sha256 matches value
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Sha256(sha256 string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.sha256 = &sha256
	return r
}

// Filter results where suite matches value
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Suite(suite string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.suite = &suite
	return r
}

// A list of fields to include in the response.
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Fields(fields []string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) ExcludeFields(excludeFields []string) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) Execute() (*PaginateddebReleaseFileResponseList, *http.Response, error) {
	return r.ApiService.ContentDebReleaseFilesListExecute(r)
}

/*
ContentDebReleaseFilesList List release files

A ReleaseFile represents the Release file(s) from a single APT distribution.

Associated artifacts: At least one of 'Release' and 'InRelease' file. If the 'Release' file is
present, then there may also be a 'Release.gpg' detached signature file for it.

Note: The verbatim publisher will republish all associated artifacts, while the APT publisher
(both simple and structured mode) will generate any 'Release' files it needs when creating the
publication. It does not make use of ReleaseFile content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleaseFilesAPIContentDebReleaseFilesListRequest
*/
func (a *ContentReleaseFilesAPIService) ContentDebReleaseFilesList(ctx context.Context) ContentReleaseFilesAPIContentDebReleaseFilesListRequest {
	return ContentReleaseFilesAPIContentDebReleaseFilesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebReleaseFileResponseList
func (a *ContentReleaseFilesAPIService) ContentDebReleaseFilesListExecute(r ContentReleaseFilesAPIContentDebReleaseFilesListRequest) (*PaginateddebReleaseFileResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebReleaseFileResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseFilesAPIService.ContentDebReleaseFilesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/release_files/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.codename != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "codename", r.codename, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.relativePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "relative_path", r.relativePath, "")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.sha256 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "sha256", r.sha256, "")
	}
	if r.suite != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "suite", r.suite, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleaseFilesAPIContentDebReleaseFilesReadRequest struct {
	ctx context.Context
	ApiService *ContentReleaseFilesAPIService
	debReleaseFileHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentReleaseFilesAPIContentDebReleaseFilesReadRequest) Fields(fields []string) ContentReleaseFilesAPIContentDebReleaseFilesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleaseFilesAPIContentDebReleaseFilesReadRequest) ExcludeFields(excludeFields []string) ContentReleaseFilesAPIContentDebReleaseFilesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleaseFilesAPIContentDebReleaseFilesReadRequest) Execute() (*DebReleaseFileResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleaseFilesReadExecute(r)
}

/*
ContentDebReleaseFilesRead Inspect a release file

A ReleaseFile represents the Release file(s) from a single APT distribution.

Associated artifacts: At least one of 'Release' and 'InRelease' file. If the 'Release' file is
present, then there may also be a 'Release.gpg' detached signature file for it.

Note: The verbatim publisher will republish all associated artifacts, while the APT publisher
(both simple and structured mode) will generate any 'Release' files it needs when creating the
publication. It does not make use of ReleaseFile content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debReleaseFileHref
 @return ContentReleaseFilesAPIContentDebReleaseFilesReadRequest
*/
func (a *ContentReleaseFilesAPIService) ContentDebReleaseFilesRead(ctx context.Context, debReleaseFileHref string) ContentReleaseFilesAPIContentDebReleaseFilesReadRequest {
	return ContentReleaseFilesAPIContentDebReleaseFilesReadRequest{
		ApiService: a,
		ctx: ctx,
		debReleaseFileHref: debReleaseFileHref,
	}
}

// Execute executes the request
//  @return DebReleaseFileResponse
func (a *ContentReleaseFilesAPIService) ContentDebReleaseFilesReadExecute(r ContentReleaseFilesAPIContentDebReleaseFilesReadRequest) (*DebReleaseFileResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseFileResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseFilesAPIService.ContentDebReleaseFilesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_release_file_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_release_file_href"+"}", parameterValueToString(r.debReleaseFileHref, "debReleaseFileHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
