/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -8588488481097270056L;
    public static final String AUX = "AUX";
    public static final String MUST = "MUST";
    public static final String MAY = "MAY";
    public static final String NOT = "NOT";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private Vector<String> must = new Vector();
    private Vector<String> may = new Vector();
    private Vector<String> aux = new Vector();
    private Vector<String> not = new Vector();

    protected LDAPDITContentRuleSchema() {
    }

    public LDAPDITContentRuleSchema(String name, String oid, String description, boolean obsolete, String[] auxiliary, String[] required, String[] optional, String[] precluded) {
        super(name, oid, description, null);
        int i;
        if (required != null) {
            for (i = 0; i < required.length; ++i) {
                this.must.addElement(required[i]);
            }
        }
        if (optional != null) {
            for (i = 0; i < optional.length; ++i) {
                this.may.addElement(optional[i]);
            }
        }
        if (auxiliary != null) {
            for (i = 0; i < auxiliary.length; ++i) {
                this.aux.addElement(auxiliary[i]);
            }
        }
        if (precluded != null) {
            for (i = 0; i < precluded.length; ++i) {
                this.not.addElement(precluded[i]);
            }
        }
        if (obsolete) {
            this.setQualifier("OBSOLETE", "");
        }
    }

    public LDAPDITContentRuleSchema(String raw) {
        this.attrName = "ditContentRules";
        this.parseValue(raw);
        Object o = this.properties.get(MAY);
        if (o != null) {
            if (o instanceof Vector) {
                this.may = (Vector)o;
            } else {
                this.may.addElement((String)o);
            }
        }
        if ((o = this.properties.get(MUST)) != null) {
            if (o instanceof Vector) {
                this.must = (Vector)o;
            } else {
                this.must.addElement((String)o);
            }
        }
        if ((o = this.properties.get(NOT)) != null) {
            if (o instanceof Vector) {
                this.not = (Vector)o;
            } else {
                this.not.addElement((String)o);
            }
        }
        if ((o = this.properties.get(AUX)) != null) {
            if (o instanceof Vector) {
                this.aux = (Vector)o;
            } else {
                this.aux.addElement((String)o);
            }
        }
    }

    public String[] getRequiredAttributes() {
        Object[] vals = new String[this.must.size()];
        this.must.copyInto(vals);
        return vals;
    }

    public String[] getOptionalAttributes() {
        Object[] vals = new String[this.may.size()];
        this.may.copyInto(vals);
        return vals;
    }

    public String[] getPrecludedAttributes() {
        Object[] vals = new String[this.not.size()];
        this.not.copyInto(vals);
        return vals;
    }

    public String[] getAuxiliaryClasses() {
        Object[] vals = new String[this.aux.size()];
        this.aux.copyInto(vals);
        return vals;
    }

    @Override
    public String getValue() {
        Object s = this.getValuePrefix();
        String val = this.getOptionalValues(NOVALS);
        if (val.length() > 0) {
            s = (String)s + val + " ";
        }
        if (this.aux.size() > 0) {
            s = (String)s + "AUX " + this.vectorToList(this.aux);
            s = (String)s + " ";
        }
        if (this.must.size() > 0) {
            s = (String)s + "MUST " + this.vectorToList(this.must);
            s = (String)s + " ";
        }
        if (this.may.size() > 0) {
            s = (String)s + "MAY " + this.vectorToList(this.may);
            s = (String)s + " ";
        }
        if (this.not.size() > 0) {
            s = (String)s + "NOT " + this.vectorToList(this.not);
            s = (String)s + " ";
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = (String)s + val + " ";
        }
        s = (String)s + ")";
        return s;
    }

    protected String vectorToList(Vector<String> vals) {
        Object val = "( ";
        for (int i = 0; i < vals.size(); ++i) {
            val = (String)val + vals.elementAt(i) + " ";
            if (i >= vals.size() - 1) continue;
            val = (String)val + "$ ";
        }
        val = (String)val + ")";
        return val;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid;
        s = s + "; Description: " + this.description + "; Required: ";
        int i = 0;
        Enumeration<String> e = this.must.elements();
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = s + ", ";
            }
            ++i;
            s = s + e.nextElement();
        }
        s = s + "; Optional: ";
        e = this.may.elements();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = s + ", ";
            }
            ++i;
            s = s + e.nextElement();
        }
        s = s + "; Auxiliary: ";
        e = this.aux.elements();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = s + ", ";
            }
            ++i;
            s = s + e.nextElement();
        }
        s = s + "; Precluded: ";
        e = this.not.elements();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = s + ", ";
            }
            ++i;
            s = s + e.nextElement();
        }
        if (this.isObsolete()) {
            s = s + "; OBSOLETE";
        }
        s = s + this.getQualifierString(IGNOREVALS);
        return s;
    }

    static {
        for (int i = 0; i < NOVALS.length; ++i) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
        }
        IGNOREVALS = new String[]{"OBSOLETE", AUX, MUST, MAY, NOT};
    }
}

