/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.GeneralSubtree;

public class GeneralSubtrees
implements Serializable {
    private static final long serialVersionUID = 6308776640697100848L;
    private Vector<GeneralSubtree> trees;
    private transient PrettyPrintFormat pp = new PrettyPrintFormat(":");

    public GeneralSubtrees(Vector<GeneralSubtree> trees) {
        this.trees = trees;
    }

    public GeneralSubtrees(DerValue val) throws IOException {
        this.trees = new Vector(1, 1);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of GeneralSubtrees.");
        }
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            GeneralSubtree tree = new GeneralSubtree(opt);
            this.trees.addElement(tree);
        }
    }

    public String toString() {
        String s = "   GeneralSubtrees:\n" + this.trees.toString() + "\n";
        return s;
    }

    public String toPrint(int indent) {
        StringBuffer s = new StringBuffer();
        Enumeration<GeneralSubtree> e = this.trees.elements();
        while (e.hasMoreElements()) {
            GeneralSubtree element = e.nextElement();
            s.append(this.pp.indent(indent + 4) + element.toPrint(indent) + "\n");
        }
        return s.toString();
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream seq = new DerOutputStream();
        for (int i = 0; i < this.trees.size(); ++i) {
            this.trees.elementAt(i).encode(seq);
        }
        out.write((byte)48, seq);
    }

    public Vector<GeneralSubtree> getSubtrees() {
        return this.trees;
    }
}

