/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class CertificateIssuerName
implements CertAttrSet {
    public static final String IDENT = "x509.info.issuer";
    public static final String NAME = "issuer";
    public static final String DN_NAME = "dname";
    private X500Name dnName;

    public CertificateIssuerName(X500Name name) {
        this.dnName = name;
    }

    public CertificateIssuerName(DerInputStream in) throws IOException {
        this.dnName = new X500Name(in);
    }

    public CertificateIssuerName(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.dnName = new X500Name(derVal);
    }

    @Override
    public String toString() {
        if (this.dnName == null) {
            return "";
        }
        return this.dnName.toString();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.dnName.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.dnName = new X500Name(derVal);
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof X500Name)) {
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (!name.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
        }
        this.dnName = (X500Name)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
        }
        this.dnName = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(DN_NAME);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

