/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TimeBase;
import org.mozilla.jss.asn1.UTCTime;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;

public class CertTemplate
implements ASN1Value {
    private INTEGER version;
    private INTEGER serialNumber;
    private AlgorithmIdentifier signingAlg;
    private Name issuer;
    private Date notBefore;
    private Date notAfter;
    private Name subject;
    private SubjectPublicKeyInfo publicKey;
    private BIT_STRING issuerUID;
    private BIT_STRING subjectUID;
    private SEQUENCE extensions;
    public static final Tag TAG = SEQUENCE.TAG;
    static final int UTCTIME_CUTOFF_YEAR = 2049;
    private static Template templateInstance = new Template();

    public boolean hasVersion() {
        return this.version != null;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public void setVersion(INTEGER version) {
        this.version = version;
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(INTEGER serialNumber) {
        this.serialNumber = serialNumber;
    }

    public boolean hasSigningAlg() {
        return this.signingAlg != null;
    }

    public AlgorithmIdentifier getSigningAlg() {
        return this.signingAlg;
    }

    public void setSigningAlg(AlgorithmIdentifier signingAlg) {
        this.signingAlg = signingAlg;
    }

    public boolean hasIssuer() {
        return this.issuer != null;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Name issuer) {
        this.issuer = issuer;
    }

    public boolean hasNotBefore() {
        return this.notBefore != null;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date date) {
        this.notBefore = date;
    }

    public boolean hasNotAfter() {
        return this.notAfter != null;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date date) {
        this.notAfter = date;
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public Name getSubject() {
        return this.subject;
    }

    public void setSubject(Name subject) {
        this.subject = subject;
    }

    public boolean hasPublicKey() {
        return this.publicKey != null;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(SubjectPublicKeyInfo publicKey) {
        this.publicKey = publicKey;
    }

    public boolean hasIssuerUID() {
        return this.issuerUID != null;
    }

    public BIT_STRING getIssuerUID() {
        return this.issuerUID;
    }

    public void setIssuerUID(BIT_STRING issuerUID) {
        this.issuerUID = issuerUID;
    }

    public boolean hasSubjectUID() {
        return this.subjectUID != null;
    }

    public BIT_STRING getSubjectUID() {
        return this.subjectUID;
    }

    public void setSubjectUID(BIT_STRING subjectUID) {
        this.subjectUID = subjectUID;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public void setExtensions(SEQUENCE extensions) {
        this.extensions = extensions;
    }

    public int numExtensions() {
        return this.extensions == null ? 0 : this.extensions.size();
    }

    public Extension extensionAt(int idx) {
        if (this.extensions == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Extension)this.extensions.elementAt(idx);
    }

    public void print(PrintStream ps) throws InvalidBERException {
        if (this.version != null) {
            ps.println("Version: " + this.version.toString());
        }
        if (this.serialNumber != null) {
            ps.println("Serial Number: " + this.serialNumber.toString());
        }
        if (this.signingAlg != null) {
            ps.println("Signing Algorithm: " + this.signingAlg.getOID().toString());
        }
        if (this.issuer != null) {
            ps.println("Issuer: " + this.issuer.getRFC1485());
        }
        if (this.notBefore != null) {
            ps.println("Not Before: " + this.notBefore);
        }
        if (this.notAfter != null) {
            ps.println("Not After: " + this.notAfter);
        }
        if (this.subject != null) {
            ps.println("Subject: " + this.subject.getRFC1485());
        }
        if (this.publicKey != null) {
            ps.println("publicKey is present");
        }
        if (this.issuerUID != null) {
            ps.println("issuerUID is present");
        }
        if (this.subjectUID != null) {
            ps.println("subjectUID is present");
        }
        if (this.extensions != null) {
            ps.println("Extensions is present, with " + this.extensions.size() + " elements");
        }
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    private static TimeBase dateToASN1(Date d) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(d);
        return cal.get(1) <= 2049 ? new UTCTime(d) : new GeneralizedTime(d);
    }

    @Override
    public void encode(Tag t, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(Tag.get(0L), this.version);
        seq.addElement(Tag.get(1L), this.serialNumber);
        seq.addElement(Tag.get(2L), this.signingAlg);
        if (this.issuer != null) {
            seq.addElement(new EXPLICIT(Tag.get(3L), this.issuer));
        }
        if (this.notBefore != null || this.notAfter != null) {
            SEQUENCE optionalVal = new SEQUENCE();
            if (this.notBefore != null) {
                optionalVal.addElement(new EXPLICIT(Tag.get(0L), CertTemplate.dateToASN1(this.notBefore)));
            }
            if (this.notAfter != null) {
                optionalVal.addElement(new EXPLICIT(Tag.get(1L), CertTemplate.dateToASN1(this.notAfter)));
            }
            seq.addElement(Tag.get(4L), optionalVal);
        }
        if (this.subject != null) {
            seq.addElement(new EXPLICIT(Tag.get(5L), this.subject));
        }
        seq.addElement(Tag.get(6L), this.publicKey);
        seq.addElement(Tag.get(7L), this.issuerUID);
        seq.addElement(Tag.get(8L), this.subjectUID);
        seq.addElement(Tag.get(9L), this.extensions);
        seq.encode(t, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] args) {
        try {
            CertTemplate ct = new CertTemplate();
            ct.setVersion(new INTEGER(5L));
            ct.setSerialNumber(new INTEGER(13112L));
            Name name = new Name();
            name.addCommonName("You");
            name.addStateOrProvinceName("California");
            ct.setIssuer(name);
            ct.setNotBefore(new Date());
            name = new Name();
            name.addCommonName("Me");
            name.addCountryName("US");
            ct.setSubject(name);
            ct.setIssuerUID(new BIT_STRING(new byte[]{0, 1}, 0));
            System.out.println("Constructed CertTemplate:");
            byte[] encoded = ASN1Util.encode(ct);
            try (FileOutputStream fos = new FileOutputStream("certTemplate");){
                fos.write(encoded);
            }
            ct.print(System.out);
            CertTemplate newCt = (CertTemplate)ASN1Util.decode(CertTemplate.getTemplate(), encoded);
            System.out.println("\nDecoded CertTemplate:");
            newCt.print(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            CHOICE.Template timeChoice = new CHOICE.Template();
            timeChoice.addElement(new GeneralizedTime.Template());
            timeChoice.addElement(new UTCTime.Template());
            SEQUENCE.Template validity = new SEQUENCE.Template();
            validity.addOptionalElement(new EXPLICIT.Template(Tag.get(0L), timeChoice));
            validity.addOptionalElement(new EXPLICIT.Template(Tag.get(1L), timeChoice));
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addOptionalElement(Tag.get(0L), new INTEGER.Template());
            seqt.addOptionalElement(Tag.get(1L), new INTEGER.Template());
            seqt.addOptionalElement(Tag.get(2L), new AlgorithmIdentifier.Template());
            seqt.addOptionalElement(new EXPLICIT.Template(Tag.get(3L), new Name.Template()));
            seqt.addOptionalElement(Tag.get(4L), validity);
            seqt.addOptionalElement(new EXPLICIT.Template(Tag.get(5L), new Name.Template()));
            seqt.addOptionalElement(Tag.get(6L), new SubjectPublicKeyInfo.Template());
            seqt.addOptionalElement(Tag.get(7L), new BIT_STRING.Template());
            seqt.addOptionalElement(Tag.get(8L), new BIT_STRING.Template());
            seqt.addOptionalElement(Tag.get(9L), new SEQUENCE.OF_Template(new Extension.Template()));
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            CertTemplate ct = new CertTemplate();
            ct.setVersion((INTEGER)seq.elementAt(0));
            ct.setSerialNumber((INTEGER)seq.elementAt(1));
            ct.setSigningAlg((AlgorithmIdentifier)seq.elementAt(2));
            if (seq.elementAt(3) != null) {
                ct.setIssuer((Name)((EXPLICIT)seq.elementAt(3)).getContent());
            }
            if (seq.elementAt(4) != null) {
                TimeBase tb;
                CHOICE choice;
                ASN1Value val;
                EXPLICIT explicit = (EXPLICIT)((SEQUENCE)seq.elementAt(4)).elementAt(0);
                if (explicit != null && (val = (choice = (CHOICE)explicit.getContent()).getValue()) instanceof TimeBase) {
                    tb = (TimeBase)val;
                    ct.setNotBefore(tb.toDate());
                }
                if ((explicit = (EXPLICIT)((SEQUENCE)seq.elementAt(4)).elementAt(1)) != null && (val = (choice = (CHOICE)explicit.getContent()).getValue()) instanceof TimeBase) {
                    tb = (TimeBase)val;
                    ct.setNotAfter(tb.toDate());
                }
            }
            if (seq.elementAt(5) != null) {
                ct.setSubject((Name)((EXPLICIT)seq.elementAt(5)).getContent());
            }
            ct.setPublicKey((SubjectPublicKeyInfo)seq.elementAt(6));
            ct.setIssuerUID((BIT_STRING)seq.elementAt(7));
            ct.setSubjectUID((BIT_STRING)seq.elementAt(8));
            ct.setExtensions((SEQUENCE)seq.elementAt(9));
            return ct;
        }
    }
}

