/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.GeneralName;

public class CertificateScopeEntry {
    private GeneralName mGn = null;
    private BigInt mPort = null;

    public CertificateScopeEntry(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for PolicyQualifierInfo.");
        }
        DerValue gn = val.data.getDerValue();
        this.mGn = new GeneralName(gn);
        if (val.data.available() != 0) {
            this.mPort = val.data.getInteger();
        }
    }

    public CertificateScopeEntry(GeneralName gn, BigInt port) {
        this.mGn = gn;
        this.mPort = port;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.mGn.encode(tmp);
        if (this.mPort != null) {
            tmp.putInteger(this.mPort);
        }
        out.write((byte)48, tmp);
    }

    public GeneralName getGeneralName() {
        return this.mGn;
    }

    public BigInt getPort() {
        return this.mPort;
    }

    public String toString() {
        String s = super.toString() + "CertificateScopeEntry [\n";
        s = s + "GeneralName: " + this.mGn;
        if (this.mPort != null) {
            s = s + "PortNumber: " + this.mPort;
        }
        return s + "]\n";
    }
}

