/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.util.EventObject;
import javax.net.ssl.SSLException;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.ssl.SSLAlertDescription;
import org.mozilla.jss.ssl.SSLAlertLevel;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.javax.JSSEngine;

public class SSLAlertEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    int level;
    int description;
    transient JSSEngine engine;
    SSLAlertLevel levelEnum;
    SSLAlertDescription descriptionEnum;

    public SSLAlertEvent(SSLSocket socket) {
        super(socket);
    }

    public SSLAlertEvent(SSLSocket socket, int level, int description) {
        super(socket);
        this.setLevel(level);
        this.setDescription(description);
    }

    public SSLAlertEvent(SSLSocket socket, SSLAlertLevel level, SSLAlertDescription description) {
        super(socket);
        this.setLevel(level);
        this.setDescription(description);
    }

    public SSLAlertEvent(SSLFDProxy proxy) {
        super(proxy);
    }

    public SSLAlertEvent(SSLFDProxy proxy, int level, int description) {
        super(proxy);
        this.setLevel(level);
        this.setDescription(description);
    }

    public SSLAlertEvent(SSLFDProxy proxy, SSLAlertLevel level, SSLAlertDescription description) {
        super(proxy);
        this.setLevel(level);
        this.setDescription(description);
    }

    public SSLSocket getSocket() {
        Object obj = this.getSource();
        return obj instanceof SSLSocket ? (SSLSocket)obj : null;
    }

    public SSLFDProxy getFileDesc() {
        Object obj = this.getSource();
        return obj instanceof SSLFDProxy ? (SSLFDProxy)obj : null;
    }

    public int getLevel() {
        return this.level;
    }

    public SSLAlertLevel getLevelEnum() {
        return this.levelEnum;
    }

    public void setLevel(int level) {
        this.level = level;
        this.levelEnum = SSLAlertLevel.valueOf(level);
    }

    public void setLevel(SSLAlertLevel level) {
        this.levelEnum = level;
        this.level = level.getID();
    }

    public int getDescription() {
        return this.description;
    }

    public SSLAlertDescription getDescriptionEnum() {
        return this.descriptionEnum;
    }

    public void setDescription(int description) {
        this.description = description;
        this.descriptionEnum = SSLAlertDescription.valueOf(description);
    }

    public void setDescription(SSLAlertDescription description) {
        this.descriptionEnum = description;
        this.description = description.getID();
    }

    public JSSEngine getEngine() {
        return this.engine;
    }

    public void setEngine(JSSEngine new_engine) {
        this.engine = new_engine;
    }

    public SSLException toException() {
        if (this.levelEnum == SSLAlertLevel.FATAL) {
            SSLException exception;
            Class<? extends SSLException> exception_class = this.descriptionEnum.getExceptionClass();
            try {
                exception = exception_class.getConstructor(String.class).newInstance(this.toString());
            }
            catch (Exception e) {
                exception = new SSLException(this.toString());
            }
            return exception;
        }
        return null;
    }

    public void throwException() throws SSLException {
        throw this.toException();
    }

    @Override
    public String toString() {
        return this.levelEnum + ": " + this.descriptionEnum;
    }
}

