/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.security.MessageDigest;
import java.security.PublicKey;
import java.text.DateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.netscape.security.util.ExtPrettyPrint;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.PrettyPrintResources;
import org.mozilla.jss.netscape.security.util.PubKeyPrettyPrint;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.SignedData;
import org.mozilla.jss.pkix.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertPrettyPrint {
    private static final String CUSTOM_LOCALE = "Custom";
    private static final Logger logger = LoggerFactory.getLogger(CertPrettyPrint.class);
    private X509CertImpl mX509Cert = null;
    private PrettyPrintFormat pp = null;
    private byte[] mCert_b = null;

    public CertPrettyPrint(java.security.cert.Certificate cert) {
        if (cert instanceof X509CertImpl) {
            this.mX509Cert = (X509CertImpl)cert;
        }
        this.pp = new PrettyPrintFormat(":");
    }

    public CertPrettyPrint(byte[] certb) {
        this.mCert_b = certb;
        this.pp = new PrettyPrintFormat(":");
    }

    public String toString(Locale clientLocale) {
        if (this.mX509Cert != null) {
            return this.X509toString(clientLocale);
        }
        if (this.mCert_b != null) {
            return this.pkcs7toString(clientLocale);
        }
        return null;
    }

    public String pkcs7toString(Locale clientLocale) {
        StringBuffer content = new StringBuffer();
        try {
            this.mX509Cert = new X509CertImpl(this.mCert_b);
            return this.toString(clientLocale);
        }
        catch (Exception exception) {
            ContentInfo ci = null;
            try {
                ci = (ContentInfo)ASN1Util.decode(ContentInfo.getTemplate(), this.mCert_b);
            }
            catch (Exception e) {
                return "";
            }
            if (ci.getContentType().equals(ContentInfo.SIGNED_DATA)) {
                SignedData sd = null;
                try {
                    sd = (SignedData)ci.getInterpretedContent();
                }
                catch (Exception e) {
                    return "";
                }
                if (sd.hasCertificates()) {
                    SET certs = sd.getCertificates();
                    for (int i = 0; i < certs.size(); ++i) {
                        Certificate cert = (Certificate)certs.elementAt(i);
                        X509CertImpl certImpl = null;
                        try {
                            certImpl = new X509CertImpl(ASN1Util.encode(cert));
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        CertPrettyPrint print = new CertPrettyPrint(certImpl);
                        content.append(print.toString(Locale.getDefault()));
                        content.append("\n");
                    }
                    return content.toString();
                }
            }
            return content.toString();
        }
    }

    public String stripCertBrackets(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("-----BEGIN CERTIFICATE-----") && s.endsWith("-----END CERTIFICATE-----")) {
            return s.substring(27, s.length() - 25);
        }
        if (s.startsWith("-----BEGIN PKCS #7 SIGNED DATA-----") && s.endsWith("-----END PKCS #7 SIGNED DATA-----")) {
            return s.substring(35, s.length() - 33);
        }
        return s;
    }

    public String normalizeCertStr(String s) {
        StringBuffer val = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r' || s.charAt(i) == '\"' || s.charAt(i) == ' ') continue;
            val.append(s.charAt(i));
        }
        return val.toString();
    }

    public String X509toString(Locale clientLocale) {
        ResourceBundle resource = ResourceBundle.getBundle(PrettyPrintResources.class.getName());
        DateFormat dateFormater = DateFormat.getDateTimeInstance(0, 0, clientLocale);
        String tz = " ";
        String tzid = " ";
        StringBuffer sb = new StringBuffer();
        try {
            X509CertInfo info = (X509CertInfo)this.mX509Cert.get("x509.info");
            String serial2 = this.mX509Cert.getSerialNumber().toString(16).toUpperCase();
            PublicKey pKey = this.mX509Cert.getPublicKey();
            X509Key key = null;
            if (pKey instanceof CertificateX509Key) {
                CertificateX509Key certKey = (CertificateX509Key)((Object)pKey);
                key = (X509Key)certKey.get("value");
            }
            if (pKey instanceof X509Key) {
                key = (X509Key)pKey;
            }
            sb.append(this.pp.indent(4) + resource.getString("tokenCertificate") + "\n");
            sb.append(this.pp.indent(8) + resource.getString("tokenData") + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenVersion") + " v");
            sb.append(this.mX509Cert.getVersion() + 1 + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenSerial") + "0x" + serial2 + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenSignatureAlgorithm") + this.mX509Cert.getSigAlgName() + " - " + this.mX509Cert.getSigAlgOID() + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenIssuer") + this.mX509Cert.getIssuerX500Principal() + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenValidity") + "\n");
            String notBefore = dateFormater.format(this.mX509Cert.getNotBefore());
            String notAfter = dateFormater.format(this.mX509Cert.getNotAfter());
            if (TimeZone.getDefault() != null) {
                tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(this.mX509Cert.getNotBefore()), 0, clientLocale);
                tzid = TimeZone.getDefault().getID();
            }
            if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                sb.append(this.pp.indent(16) + resource.getString("tokenNotBefore") + notBefore + "\n");
            } else {
                sb.append(this.pp.indent(16) + resource.getString("tokenNotBefore") + notBefore + " " + tzid + "\n");
            }
            if (TimeZone.getDefault() != null) {
                tz = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(this.mX509Cert.getNotAfter()), 0, clientLocale);
            }
            if (tz.equals(tzid) || tzid.equals(CUSTOM_LOCALE)) {
                sb.append(this.pp.indent(16) + resource.getString("tokenNotAfter") + notAfter + "\n");
            } else {
                sb.append(this.pp.indent(16) + resource.getString("tokenNotAfter") + notAfter + " " + tzid + "\n");
            }
            sb.append(this.pp.indent(12) + resource.getString("tokenSubject") + this.mX509Cert.getSubjectX500Principal() + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenSPKI") + "\n");
            PubKeyPrettyPrint pkpp = new PubKeyPrettyPrint(key);
            sb.append(pkpp.toString(clientLocale, 16, 16));
            CertificateExtensions extensions = (CertificateExtensions)info.get("extensions");
            sb.append(this.pp.indent(12) + resource.getString("tokenExtensions") + "\n");
            if (extensions != null) {
                for (int i = 0; i < extensions.size(); ++i) {
                    Extension ext = (Extension)extensions.elementAt(i);
                    ExtPrettyPrint extpp = new ExtPrettyPrint(ext, 16);
                    sb.append(extpp.toString());
                }
            }
            sb.append(this.pp.indent(8) + resource.getString("tokenSignature") + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenAlgorithm") + this.mX509Cert.getSigAlgName() + " - " + this.mX509Cert.getSigAlgOID() + "\n");
            sb.append(this.pp.indent(12) + resource.getString("tokenSignature") + "\n");
            sb.append(this.pp.toHexString(this.mX509Cert.getSignature(), 16, 16));
            String[] hashes = new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-512"};
            StringBuffer certFingerprints = new StringBuffer();
            sb.append(this.pp.indent(8) + "FingerPrint\n");
            for (int i = 0; i < hashes.length; ++i) {
                MessageDigest md = MessageDigest.getInstance(hashes[i]);
                md.update(this.mX509Cert.getEncoded());
                certFingerprints.append(this.pp.indent(12) + hashes[i] + ":\n" + this.pp.toHexString(md.digest(), 16, 16));
            }
            sb.append(certFingerprints.toString());
        }
        catch (Exception e) {
            logger.error("Problem converting to string", (Throwable)e);
        }
        return sb.toString();
    }
}

