/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;

public class NSCertTypeExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 1856407688086284397L;
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    public static final ObjectIdentifier CertType_Id = new ObjectIdentifier(CertType_data);
    public static final String NAME = "NSCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String EMAIL = "email";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String EMAIL_CA = "email_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    public static final int SSL_CLIENT_BIT = 0;
    public static final int SSL_SERVER_BIT = 1;
    public static final int EMAIL_BIT = 2;
    public static final int OBJECT_SIGNING_BIT = 3;
    public static final int SSL_CA_BIT = 5;
    public static final int EMAIL_CA_BIT = 6;
    public static final int OBJECT_SIGNING_CA_BIT = 7;
    public static final int NBITS = 8;
    public static final String IDENT = "x509.info.extensions.NSCertType";
    private byte[] mBitString;
    private static MapEntry[] mMapData = new MapEntry[]{new MapEntry("ssl_client", 0), new MapEntry("ssl_server", 1), new MapEntry("email", 2), new MapEntry("object_signing", 3), new MapEntry("ssl_ca", 5), new MapEntry("email_ca", 6), new MapEntry("object_signing_ca", 7)};
    private static Vector<String> mAttributeNames = new Vector();

    private static int getPosition(String name) throws CertificateException {
        for (int i = 0; i < mMapData.length; ++i) {
            if (!name.equalsIgnoreCase(NSCertTypeExtension.mMapData[i].mName)) continue;
            return NSCertTypeExtension.mMapData[i].mPosition;
        }
        throw new CertificateException("Attribute name [" + name + "] not recognized by CertAttrSet:NSCertType.");
    }

    private void encodeThis() throws IOException {
        try (DerOutputStream os = new DerOutputStream();){
            os.putUnalignedBitString(this.mBitString);
            this.extensionValue = os.toByteArray();
        }
    }

    public boolean isSet(int position) {
        int index = position / 8;
        byte pos = (byte)(1 << 7 - position % 8);
        if (this.mBitString.length <= index) {
            return false;
        }
        return (this.mBitString[index] & pos) != 0;
    }

    public void set(int position, boolean val) {
        int index = position / 8;
        byte pos = (byte)(1 << 7 - position % 8);
        if (index >= this.mBitString.length) {
            byte[] tmp = new byte[index + 1];
            System.arraycopy(this.mBitString, 0, tmp, 0, this.mBitString.length);
            this.mBitString = tmp;
        }
        if (val) {
            int n = index;
            this.mBitString[n] = (byte)(this.mBitString[n] | pos);
        } else {
            int n = index;
            this.mBitString[n] = (byte)(this.mBitString[n] & ~pos);
        }
    }

    public NSCertTypeExtension(boolean critical, boolean[] bits) {
        this.extensionId = CertType_Id;
        this.critical = critical;
        this.mBitString = new byte[0];
        for (int i = 0; i < bits.length && i < 8; ++i) {
            this.set(i, bits[i]);
        }
    }

    public NSCertTypeExtension(boolean[] bits) {
        this.extensionId = CertType_Id;
        this.critical = false;
        this.mBitString = new byte[0];
        for (int i = 0; i < bits.length && i < 8; ++i) {
            this.set(i, bits[i]);
        }
    }

    public NSCertTypeExtension(boolean critical, byte[] bitString) throws IOException {
        this.mBitString = bitString;
        this.extensionId = CertType_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public NSCertTypeExtension(byte[] bitString) throws IOException {
        this.mBitString = bitString;
        this.extensionId = CertType_Id;
        this.critical = false;
        this.encodeThis();
    }

    public NSCertTypeExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = CertType_Id;
        this.critical = critical;
        byte[] extValue = (byte[])((byte[])value).clone();
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        BitArray bitArray = val.getUnalignedBitString();
        if (bitArray == null) {
            throw new IOException("Invalid Encoded DER Value");
        }
        this.mBitString = bitArray.toByteArray();
    }

    public NSCertTypeExtension() {
        this.extensionId = CertType_Id;
        this.critical = false;
        this.mBitString = new byte[0];
        try {
            this.encodeThis();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void set(String name, Object obj) throws CertificateException {
        if (!(obj instanceof Boolean)) {
            throw new CertificateException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        this.set(NSCertTypeExtension.getPosition(name), val);
    }

    @Override
    public Object get(String name) throws CertificateException {
        return this.isSet(NSCertTypeExtension.getPosition(name));
    }

    @Override
    public void delete(String name) throws CertificateException {
        this.set(NSCertTypeExtension.getPosition(name), false);
    }

    @Override
    public String toString() {
        String s = super.toString() + "NSCertType [\n";
        try {
            if (this.isSet(NSCertTypeExtension.getPosition(SSL_CLIENT))) {
                s = s + "   SSL client";
            }
            if (this.isSet(NSCertTypeExtension.getPosition(SSL_SERVER))) {
                s = s + "   SSL server";
            }
            if (this.isSet(NSCertTypeExtension.getPosition(EMAIL))) {
                s = s + "   Email";
            }
            if (this.isSet(NSCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                s = s + "   Object Signing";
            }
            if (this.isSet(NSCertTypeExtension.getPosition(SSL_CA))) {
                s = s + "   SSL CA";
            }
            if (this.isSet(NSCertTypeExtension.getPosition(EMAIL_CA))) {
                s = s + "   Email CA";
            }
            if (this.isSet(NSCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                s = s + "   Object Signing CA";
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        s = s + "]\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.encodeThis();
        if (this.extensionValue == null) {
            this.extensionId = CertType_Id;
            this.critical = true;
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return mAttributeNames.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void main(String[] argv) {
    }

    static {
        for (int i = 0; i < mMapData.length; ++i) {
            mAttributeNames.addElement(NSCertTypeExtension.mMapData[i].mName);
        }
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String name, int position) {
            this.mName = name;
            this.mPosition = position;
        }
    }
}

