/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentBlobsAPIService ContentBlobsAPI service
type ContentBlobsAPIService service

type ContentBlobsAPIContentContainerBlobsListRequest struct {
	ctx context.Context
	ApiService *ContentBlobsAPIService
	digest *string
	digestIn *[]string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where digest matches value
func (r ContentBlobsAPIContentContainerBlobsListRequest) Digest(digest string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.digest = &digest
	return r
}

// Filter results where digest is in a comma-separated list of values
func (r ContentBlobsAPIContentContainerBlobsListRequest) DigestIn(digestIn []string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.digestIn = &digestIn
	return r
}

// Number of results to return per page.
func (r ContentBlobsAPIContentContainerBlobsListRequest) Limit(limit int32) ContentBlobsAPIContentContainerBlobsListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentBlobsAPIContentContainerBlobsListRequest) Offset(offset int32) ContentBlobsAPIContentContainerBlobsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;digest&#x60; - Digest * &#x60;-digest&#x60; - Digest (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentBlobsAPIContentContainerBlobsListRequest) Ordering(ordering []string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentBlobsAPIContentContainerBlobsListRequest) PulpHrefIn(pulpHrefIn []string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentBlobsAPIContentContainerBlobsListRequest) PulpIdIn(pulpIdIn []string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentBlobsAPIContentContainerBlobsListRequest) RepositoryVersion(repositoryVersion string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentBlobsAPIContentContainerBlobsListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentBlobsAPIContentContainerBlobsListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// A list of fields to include in the response.
func (r ContentBlobsAPIContentContainerBlobsListRequest) Fields(fields []string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentBlobsAPIContentContainerBlobsListRequest) ExcludeFields(excludeFields []string) ContentBlobsAPIContentContainerBlobsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentBlobsAPIContentContainerBlobsListRequest) Execute() (*PaginatedcontainerBlobResponseList, *http.Response, error) {
	return r.ApiService.ContentContainerBlobsListExecute(r)
}

/*
ContentContainerBlobsList List blobs

ViewSet for Blobs.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentBlobsAPIContentContainerBlobsListRequest
*/
func (a *ContentBlobsAPIService) ContentContainerBlobsList(ctx context.Context) ContentBlobsAPIContentContainerBlobsListRequest {
	return ContentBlobsAPIContentContainerBlobsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedcontainerBlobResponseList
func (a *ContentBlobsAPIService) ContentContainerBlobsListExecute(r ContentBlobsAPIContentContainerBlobsListRequest) (*PaginatedcontainerBlobResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedcontainerBlobResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentBlobsAPIService.ContentContainerBlobsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/container/blobs/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.digest != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "digest", r.digest, "")
	}
	if r.digestIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "digest__in", r.digestIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentBlobsAPIContentContainerBlobsReadRequest struct {
	ctx context.Context
	ApiService *ContentBlobsAPIService
	containerBlobHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentBlobsAPIContentContainerBlobsReadRequest) Fields(fields []string) ContentBlobsAPIContentContainerBlobsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentBlobsAPIContentContainerBlobsReadRequest) ExcludeFields(excludeFields []string) ContentBlobsAPIContentContainerBlobsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentBlobsAPIContentContainerBlobsReadRequest) Execute() (*ContainerBlobResponse, *http.Response, error) {
	return r.ApiService.ContentContainerBlobsReadExecute(r)
}

/*
ContentContainerBlobsRead Inspect a blob

ViewSet for Blobs.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerBlobHref
 @return ContentBlobsAPIContentContainerBlobsReadRequest
*/
func (a *ContentBlobsAPIService) ContentContainerBlobsRead(ctx context.Context, containerBlobHref string) ContentBlobsAPIContentContainerBlobsReadRequest {
	return ContentBlobsAPIContentContainerBlobsReadRequest{
		ApiService: a,
		ctx: ctx,
		containerBlobHref: containerBlobHref,
	}
}

// Execute executes the request
//  @return ContainerBlobResponse
func (a *ContentBlobsAPIService) ContentContainerBlobsReadExecute(r ContentBlobsAPIContentContainerBlobsReadRequest) (*ContainerBlobResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerBlobResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentBlobsAPIService.ContentContainerBlobsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_blob_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_blob_href"+"}", parameterValueToString(r.containerBlobHref, "containerBlobHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
