; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=X64

define void @test_512(i512* %a, i512* %b, i512* %out) nounwind {
; X32-LABEL: test_512:
; X32:       # %bb.0:
; X32-NEXT:    pushl %ebp
; X32-NEXT:    pushl %ebx
; X32-NEXT:    pushl %edi
; X32-NEXT:    pushl %esi
; X32-NEXT:    subl $180, %esp
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl 28(%edx), %ecx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl 24(%edx), %ebp
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl (%eax), %edi
; X32-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %esi, %ebx
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 4(%eax), %ecx
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %ecx, %ebp
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %edi, %esi
; X32-NEXT:    setb %cl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebp
; X32-NEXT:    addl %esi, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl %cl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl 16(%ecx), %ebx
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl 20(%ecx), %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl %esi, %ecx
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    movl %ebp, %esi
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %edi, %ebp
; X32-NEXT:    setb %cl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    addl %ebp, %esi
; X32-NEXT:    movzbl %cl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 8(%eax), %ebp
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %ecx, %ebx
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 12(%eax), %ecx
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    adcl %ebp, %edi
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl %edi, %ecx
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    adcl %ebp, %esi
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    addl %esi, %eax
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X32-NEXT:    adcl %esi, %edx
; X32-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X32-NEXT:    adcl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl 8(%ecx), %ebx
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl 12(%ecx), %ecx
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %ebp, %edi
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ebp
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    mull %ebx
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl (%ecx), %esi
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl 4(%ecx), %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %ebx, %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %edi, %ecx
; X32-NEXT:    setb %bl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    addl %ecx, %esi
; X32-NEXT:    movzbl %bl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    adcl %ebp, %edi
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl %edi, %ebp
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %edi, %esi
; X32-NEXT:    setb %bl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    addl %esi, %eax
; X32-NEXT:    movzbl %bl, %ecx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    adcl %ecx, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    addl %ebp, %ecx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 1-byte Folded Reload
; X32-NEXT:    adcl %edi, %eax
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 16(%eax), %esi
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %ecx, %edi
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 20(%eax), %ecx
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %ecx, %ebx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ecx
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %ebx
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %ecx, %ebx
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ebp
; X32-NEXT:    setb %bl
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl %ebp, %ecx
; X32-NEXT:    movzbl %bl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 24(%eax), %ebx
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 28(%eax), %ebx
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    adcl %ebp, %esi
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %ebx, %ebp
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %esi, %ebx
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl %ebp, %ecx
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ebp
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X32-NEXT:    adcl %ecx, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    addl %ebx, %edi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    adcl (%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X32-NEXT:    adcl %ecx, %eax
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    addl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    adcl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    adcl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    adcl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl %edi, %edx
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %ebx, %ecx
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    adcl $0, %eax
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %ecx, %ebx
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ecx
; X32-NEXT:    setb %bl
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl %bl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %ecx, %ebx
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %edi
; X32-NEXT:    setb %bl
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    addl %edi, %esi
; X32-NEXT:    movzbl %bl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl (%esp), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    adcl %ebx, %ecx
; X32-NEXT:    setb (%esp) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edi, %ebx
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %ecx, %edi
; X32-NEXT:    movzbl (%esp), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl %ebx, %ecx
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    adcl %esi, %ebx
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X32-NEXT:    adcl %ecx, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    addl %edi, %ecx
; X32-NEXT:    adcl (%esp), %ebp # 4-byte Folded Reload
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X32-NEXT:    adcl %esi, %eax
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    addl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    adcl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %ecx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 32(%eax), %edi
; X32-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %ecx, %ebx
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 36(%eax), %ecx
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl %ecx, %esi
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %edi, %ecx
; X32-NEXT:    setb %bl
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl %bl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl %ecx, %ebp
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %edi, %esi
; X32-NEXT:    setb (%esp) # 1-byte Folded Spill
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %esi, %edi
; X32-NEXT:    movzbl (%esp), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 40(%eax), %esi
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl (%esp), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl 44(%eax), %esi
; X32-NEXT:    movl %esi, (%esp) # 4-byte Spill
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    adcl %ebp, %ecx
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    addl %ecx, %esi
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %ebp
; X32-NEXT:    addl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    adcl $0, %ebp
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    mull (%esp) # 4-byte Folded Reload
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    adcl %edi, %ecx
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl (%esp), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X32-NEXT:    adcl %ecx, %edx
; X32-NEXT:    addl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl %ebp, %ebx
; X32-NEXT:    movl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X32-NEXT:    adcl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl %edi, %esi
; X32-NEXT:    imull %eax, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X32-NEXT:    addl %esi, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    imull %ebx, %ecx
; X32-NEXT:    addl %edx, %ecx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    imull %edi, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl %esi, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    imull %ebp, %esi
; X32-NEXT:    addl %edx, %esi
; X32-NEXT:    addl (%esp), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, (%esp) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %ebp, %edi
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %ebx, %ebp
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ecx
; X32-NEXT:    setb %bl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebp
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movzbl %bl, %ecx
; X32-NEXT:    adcl %ecx, %edx
; X32-NEXT:    addl (%esp), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl 60(%edi), %ecx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    imull %eax, %ecx
; X32-NEXT:    movl 56(%edi), %esi
; X32-NEXT:    movl %edi, %ebx
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    addl %ecx, %edx
; X32-NEXT:    imull {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    addl %edx, %esi
; X32-NEXT:    movl 48(%edi), %edi
; X32-NEXT:    movl 52(%ebx), %ebp
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    imull %ebp, %ebx
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %edi
; X32-NEXT:    addl %ebx, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    imull %edi, %ecx
; X32-NEXT:    addl %edx, %ecx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %ecx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl %esi, %ebp
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %ebp, %edi
; X32-NEXT:    adcl %ebx, %ecx
; X32-NEXT:    setb %bl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movzbl %bl, %ecx
; X32-NEXT:    adcl %ecx, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X32-NEXT:    movl 40(%edi), %ebp
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl 44(%edi), %edi
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl %esi, %ecx
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X32-NEXT:    adcl %ebx, %esi
; X32-NEXT:    setb %cl
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %ebp
; X32-NEXT:    addl %esi, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl %cl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl 32(%ecx), %esi
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl 36(%ecx), %ebp
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    addl %ecx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %ebx, %edi
; X32-NEXT:    setb %cl
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %edi, %ebx
; X32-NEXT:    movzbl %cl, %eax
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    adcl (%esp), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, (%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    adcl %edi, %esi
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, %edi
; X32-NEXT:    addl %esi, %edi
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %ecx
; X32-NEXT:    addl %ebx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl (%esp), %ebp # 4-byte Folded Reload
; X32-NEXT:    movl %ebp, (%esp) # 4-byte Spill
; X32-NEXT:    adcl $0, %edi
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl $0, %ebx
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    mull {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    adcl %ebx, %esi
; X32-NEXT:    setb {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Folded Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    addl %esi, %eax
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %edx
; X32-NEXT:    addl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X32-NEXT:    adcl %ecx, %ebp
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X32-NEXT:    adcl %eax, %esi
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl $0, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl 48(%ecx), %edi
; X32-NEXT:    imull %edi, %ebx
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    addl %ebx, %edx
; X32-NEXT:    movl 52(%ecx), %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    imull %eax, %esi
; X32-NEXT:    addl %edx, %esi
; X32-NEXT:    movl %esi, %ebp
; X32-NEXT:    movl 56(%ecx), %eax
; X32-NEXT:    movl %eax, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    imull %ebx, %esi
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    addl %esi, %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    movl 60(%esi), %esi
; X32-NEXT:    imull %ecx, %esi
; X32-NEXT:    addl %edx, %esi
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %ebp, %esi
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ebp
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    mull %edi
; X32-NEXT:    movl %edx, %ecx
; X32-NEXT:    movl %eax, %ebx
; X32-NEXT:    addl %ebp, %ebx
; X32-NEXT:    adcl $0, %ecx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    mull %ebp
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    addl %ebx, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %ecx, %edi
; X32-NEXT:    setb %cl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebp
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movzbl %cl, %ecx
; X32-NEXT:    adcl %ecx, %edx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl %esi, %edx
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    imull %esi, %edi
; X32-NEXT:    movl %esi, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    mull %ecx
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl %edi, %edx
; X32-NEXT:    imull {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    addl %edx, %ecx
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Reload
; X32-NEXT:    imull %edi, %ecx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    addl %ecx, %edx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    imull %ebx, %ecx
; X32-NEXT:    addl %edx, %ecx
; X32-NEXT:    addl %ebp, %eax
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    movl %ebx, %ebp
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl %edi, %eax
; X32-NEXT:    mull %esi
; X32-NEXT:    movl %edx, %esi
; X32-NEXT:    movl %eax, %ecx
; X32-NEXT:    addl %ebx, %ecx
; X32-NEXT:    adcl $0, %esi
; X32-NEXT:    movl %ebp, %eax
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %edi
; X32-NEXT:    movl %eax, %ebp
; X32-NEXT:    addl %ecx, %ebp
; X32-NEXT:    adcl %esi, %edi
; X32-NEXT:    setb %cl
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X32-NEXT:    mull %ebx
; X32-NEXT:    movl %edx, %ebx
; X32-NEXT:    addl %edi, %eax
; X32-NEXT:    movzbl %cl, %ecx
; X32-NEXT:    adcl %ecx, %ebx
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl (%esp), %edi # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    movl %ebp, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Folded Reload
; X32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 4-byte Folded Reload
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X32-NEXT:    adcl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Folded Reload
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, (%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 4(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 8(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 12(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 16(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 20(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 24(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 28(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 32(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 36(%ecx)
; X32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; X32-NEXT:    movl %esi, 40(%ecx)
; X32-NEXT:    movl %edi, 44(%ecx)
; X32-NEXT:    movl %edx, 48(%ecx)
; X32-NEXT:    movl %ebp, 52(%ecx)
; X32-NEXT:    movl %eax, 56(%ecx)
; X32-NEXT:    movl %ebx, 60(%ecx)
; X32-NEXT:    addl $180, %esp
; X32-NEXT:    popl %esi
; X32-NEXT:    popl %edi
; X32-NEXT:    popl %ebx
; X32-NEXT:    popl %ebp
; X32-NEXT:    retl
;
; X64-LABEL: test_512:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    pushq %rax
; X64-NEXT:    movq %rdx, (%rsp) # 8-byte Spill
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq (%rdi), %r9
; X64-NEXT:    movq 8(%rdi), %r15
; X64-NEXT:    movq 24(%rdi), %r12
; X64-NEXT:    movq 16(%rdi), %rax
; X64-NEXT:    movq %rsi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq (%rsi), %rdi
; X64-NEXT:    movq 8(%rsi), %r14
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    movq %r12, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rcx, %rbx
; X64-NEXT:    adcq $0, %rbp
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %r10
; X64-NEXT:    addq %rbx, %r10
; X64-NEXT:    adcq %rbp, %rcx
; X64-NEXT:    setb %al
; X64-NEXT:    movzbl %al, %esi
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %r14, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rdx, %r8
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    addq %rcx, %r13
; X64-NEXT:    adcq %rsi, %r8
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    addq %rcx, %rbp
; X64-NEXT:    adcq $0, %rbx
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    movq %r9, %r12
; X64-NEXT:    movq %r9, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    addq %rbp, %rax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq %rbx, %rcx
; X64-NEXT:    setb %sil
; X64-NEXT:    movq %r15, %rdi
; X64-NEXT:    movq %r15, %rax
; X64-NEXT:    mulq %r14
; X64-NEXT:    movq %rdx, %r15
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rcx, %rbx
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    adcq %rax, %r15
; X64-NEXT:    addq %r11, %rbx
; X64-NEXT:    adcq %r10, %r15
; X64-NEXT:    adcq $0, %r13
; X64-NEXT:    movq %r8, %r14
; X64-NEXT:    adcq $0, %r14
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; X64-NEXT:    movq 16(%rsi), %r8
; X64-NEXT:    movq %r9, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %r10
; X64-NEXT:    movq %rax, %r9
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq %rdi, %r11
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    addq %r10, %rbp
; X64-NEXT:    adcq $0, %rcx
; X64-NEXT:    movq 24(%rsi), %rdi
; X64-NEXT:    movq %r12, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    addq %rbp, %rax
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    adcq %rcx, %rsi
; X64-NEXT:    setb %cl
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %r11
; X64-NEXT:    movq %rax, %r12
; X64-NEXT:    addq %rsi, %r12
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    adcq %rax, %r11
; X64-NEXT:    addq %rbx, %r9
; X64-NEXT:    movq %r9, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq %r15, %rbp
; X64-NEXT:    movq %rbp, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq $0, %r12
; X64-NEXT:    adcq $0, %r11
; X64-NEXT:    addq %r13, %r12
; X64-NEXT:    adcq %r14, %r11
; X64-NEXT:    setb %r9b
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbx # 8-byte Reload
; X64-NEXT:    movq %rbx, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    movq %rax, %r14
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r10 # 8-byte Reload
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    addq %rcx, %rbp
; X64-NEXT:    adcq $0, %rsi
; X64-NEXT:    movq %rbx, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    addq %rbp, %rax
; X64-NEXT:    movq %rax, %rbp
; X64-NEXT:    adcq %rsi, %rcx
; X64-NEXT:    setb %bl
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %rdi
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    movzbl %bl, %ecx
; X64-NEXT:    adcq %rcx, %rdx
; X64-NEXT:    addq %r12, %r14
; X64-NEXT:    movq %r14, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq %r11, %rbp
; X64-NEXT:    movq %rbp, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movzbl %r9b, %ecx
; X64-NEXT:    adcq %rcx, %rax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    adcq $0, %rdx
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq 32(%rcx), %r10
; X64-NEXT:    imulq %r10, %rdi
; X64-NEXT:    movq %r10, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    addq %rdi, %rdx
; X64-NEXT:    movq 40(%rcx), %r9
; X64-NEXT:    imulq %r9, %r8
; X64-NEXT:    addq %rdx, %r8
; X64-NEXT:    movq 48(%rcx), %rax
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbx # 8-byte Reload
; X64-NEXT:    imulq %rbx, %rdi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; X64-NEXT:    mulq %rsi
; X64-NEXT:    movq %rax, %r12
; X64-NEXT:    addq %rdi, %rdx
; X64-NEXT:    movq 56(%rcx), %rbp
; X64-NEXT:    imulq %rsi, %rbp
; X64-NEXT:    addq %rdx, %rbp
; X64-NEXT:    addq %r11, %r12
; X64-NEXT:    adcq %r8, %rbp
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    movq %rsi, %rcx
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %rdi
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rbx, %rax
; X64-NEXT:    movq %rbx, %r11
; X64-NEXT:    mulq %r10
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    movq %rax, %rbx
; X64-NEXT:    addq %rdi, %rbx
; X64-NEXT:    adcq $0, %rsi
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    mulq %r9
; X64-NEXT:    movq %rdx, %rdi
; X64-NEXT:    movq %rax, %r10
; X64-NEXT:    addq %rbx, %r10
; X64-NEXT:    adcq %rsi, %rdi
; X64-NEXT:    setb %bl
; X64-NEXT:    movq %r11, %rax
; X64-NEXT:    mulq %r9
; X64-NEXT:    movq %rdx, %r15
; X64-NEXT:    movq %rax, %r13
; X64-NEXT:    addq %rdi, %r13
; X64-NEXT:    movzbl %bl, %eax
; X64-NEXT:    adcq %rax, %r15
; X64-NEXT:    addq %r12, %r13
; X64-NEXT:    adcq %rbp, %r15
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Reload
; X64-NEXT:    movq 56(%rdx), %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    imulq %rax, %rcx
; X64-NEXT:    movq 48(%rdx), %rbp
; X64-NEXT:    movq %rdx, %rsi
; X64-NEXT:    movq %rax, %r11
; X64-NEXT:    mulq %rbp
; X64-NEXT:    movq %rax, %r12
; X64-NEXT:    addq %rcx, %rdx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r8 # 8-byte Reload
; X64-NEXT:    imulq %r8, %rbp
; X64-NEXT:    addq %rdx, %rbp
; X64-NEXT:    movq 32(%rsi), %rdi
; X64-NEXT:    movq 40(%rsi), %rbx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    imulq %rbx, %rsi
; X64-NEXT:    mulq %rdi
; X64-NEXT:    movq %rax, %rcx
; X64-NEXT:    addq %rsi, %rdx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %r14 # 8-byte Reload
; X64-NEXT:    imulq %rdi, %r14
; X64-NEXT:    addq %rdx, %r14
; X64-NEXT:    addq %r12, %rcx
; X64-NEXT:    adcq %rbp, %r14
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, %rsi
; X64-NEXT:    movq %rbx, %rax
; X64-NEXT:    mulq %r11
; X64-NEXT:    movq %rdx, %r11
; X64-NEXT:    movq %rax, %r12
; X64-NEXT:    addq %rbp, %r12
; X64-NEXT:    adcq $0, %r11
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    movq %rdx, %rbp
; X64-NEXT:    movq %rax, %rdi
; X64-NEXT:    addq %r12, %rdi
; X64-NEXT:    adcq %r11, %rbp
; X64-NEXT:    setb %r9b
; X64-NEXT:    movq %rbx, %rax
; X64-NEXT:    mulq %r8
; X64-NEXT:    addq %rbp, %rax
; X64-NEXT:    movzbl %r9b, %ebp
; X64-NEXT:    adcq %rbp, %rdx
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    adcq %r14, %rdx
; X64-NEXT:    addq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Folded Reload
; X64-NEXT:    adcq %r10, %rdi
; X64-NEXT:    adcq %r13, %rax
; X64-NEXT:    adcq %r15, %rdx
; X64-NEXT:    addq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Folded Reload
; X64-NEXT:    adcq {{[-0-9]+}}(%r{{[sb]}}p), %rdi # 8-byte Folded Reload
; X64-NEXT:    adcq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Folded Reload
; X64-NEXT:    adcq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Folded Reload
; X64-NEXT:    movq (%rsp), %rcx # 8-byte Reload
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbp # 8-byte Reload
; X64-NEXT:    movq %rbp, (%rcx)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbp # 8-byte Reload
; X64-NEXT:    movq %rbp, 8(%rcx)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbp # 8-byte Reload
; X64-NEXT:    movq %rbp, 16(%rcx)
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rbp # 8-byte Reload
; X64-NEXT:    movq %rbp, 24(%rcx)
; X64-NEXT:    movq %rsi, 32(%rcx)
; X64-NEXT:    movq %rdi, 40(%rcx)
; X64-NEXT:    movq %rax, 48(%rcx)
; X64-NEXT:    movq %rdx, 56(%rcx)
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
  %av = load i512, i512* %a
  %bv = load i512, i512* %b
  %r = mul i512 %av, %bv
  store i512 %r, i512* %out
  ret void
}
