package aQute.lib.properties;

import java.util.*;

public class PropertyAccess {
	Dictionary	dictionary;

	public PropertyAccess(Dictionary d) {
		this.dictionary = d;
	}

	public String getString(String key, String deflt) {
		return (String) get(key, deflt);
	}

	public int getInt(String key, int deflt) {
		try {
			return Integer.parseInt(getString(key, null));
		} catch (Exception e) {
			return deflt;
		}
	}
	public boolean getBoolean(String key, boolean deflt) {
		String v = getString(key, "" + deflt).toUpperCase();
		if (v.equals("TRUE"))
			return true;
		if (v.equals("FALSE"))
			return false;
		return deflt;
	}

	public Object get(String key, String deflt) {
		Object o = dictionary.get(key);
		if (o == null)
			return deflt;
		else
			return o;
	}

	public int getInt(String key, String[] strings, int[] values) {
		String s = getString(key, null);
		for (int i = 0; strings != null && i < strings.length; i++) {
			if (strings[i].equalsIgnoreCase(s))
				return values[i];
		}
		return values[0];
	}

}

