/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.ObjectTable;
import com.sun.jini.jeri.internal.runtime.WeakKey;
import com.sun.jini.thread.NewThreadAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.rmi.Remote;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.SecurityContext;

final class ImplRefManager {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
    private final ReferenceQueue reapQueue = new ReferenceQueue();
    private final Object lock = new Object();
    private final Map weakImplTable = new HashMap();
    private Thread reaper = null;
    private boolean interruptible = false;
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$runtime$ImplRefManager;

    ImplRefManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImplRef getImplRef(Remote impl, ObjectTable.Target target) {
        WeakKey lookupKey = new WeakKey(impl, this.reapQueue);
        Object object = this.lock;
        synchronized (object) {
            ImplRef implRef = (ImplRef)this.weakImplTable.get(lookupKey);
            if (implRef == null) {
                implRef = new ImplRef(lookupKey);
                this.weakImplTable.put(lookupKey, implRef);
                if (this.reaper == null) {
                    this.reaper = (Thread)AccessController.doPrivileged(new NewThreadAction(new Reaper(), "Reaper", true));
                    this.reaper.start();
                }
            } else {
                lookupKey.clear();
            }
            implRef.addTarget(target);
            return implRef;
        }
    }

    static /* synthetic */ boolean access$802(ImplRefManager x0, boolean x1) {
        x0.interruptible = x1;
        return x0.interruptible;
    }

    static /* synthetic */ ReferenceQueue access$1000(ImplRefManager x0) {
        return x0.reapQueue;
    }

    private class Reaper
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block14: while (true) {
                var1_1 = ImplRefManager.access$500(ImplRefManager.this);
                synchronized (var1_1) {
                    if (ImplRefManager.access$700(ImplRefManager.this) != Thread.currentThread()) {
                        break;
                    }
                    ImplRefManager.access$802(ImplRefManager.this, true);
                }
                try {
                    weakRef = ImplRefManager.access$1000(ImplRefManager.this).remove();
                }
                catch (InterruptedException e) {
                    var3_5 = ImplRefManager.access$500(ImplRefManager.this);
                    synchronized (var3_5) {
                        ImplRefManager.access$802(ImplRefManager.this, false);
                        break;
                    }
                }
                var3_5 = ImplRefManager.access$500(ImplRefManager.this);
                synchronized (var3_5) {
                    ImplRefManager.access$802(ImplRefManager.this, false);
                    Thread.interrupted();
                    implRef = (ImplRef)ImplRefManager.access$600(ImplRefManager.this).get(weakRef);
                    if (implRef == null) {
                        continue;
                    }
                    if (!Reaper.$assertionsDisabled && ImplRef.access$1100(implRef)) {
                        throw new AssertionError();
                    }
                    var5_8 = implRef;
                    synchronized (var5_8) {
                        if (!Reaper.$assertionsDisabled && ImplRef.access$1200(implRef)) {
                            throw new AssertionError();
                        }
                        collectedTargets = ImplRef.access$1300(implRef);
                        ImplRef.access$1400(implRef);
                        if (ImplRefManager.access$300().isLoggable(Level.FINEST)) {
                            ImplRefManager.access$300().log(Level.FINEST, "implRef={0}, targets={1}", new Object[]{implRef, collectedTargets});
                        }
                    }
                }
                i = collectedTargets.iterator();
                while (true) {
                    if (i.hasNext()) ** break;
                    continue block14;
                    ((ObjectTable.Target)i.next()).collect();
                }
                break;
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ImplRefManager == null ? (class$com$sun$jini$jeri$internal$runtime$ImplRefManager = ImplRefManager.class$("com.sun.jini.jeri.internal.runtime.ImplRefManager")) : class$com$sun$jini$jeri$internal$runtime$ImplRefManager).desiredAssertionStatus();
        }
    }

    final class ImplRef {
        private final Reference weakRef;
        private boolean removed = false;
        private final Set targets = new HashSet(1);
        private final Set pinningTargets = new HashSet(1);
        private Remote strongRef = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ImplRef(Reference weakRef) {
            this.weakRef = weakRef;
        }

        private synchronized void addTarget(ObjectTable.Target target) {
            if (!$assertionsDisabled && this.targets.contains(target)) {
                throw new AssertionError();
            }
            this.targets.add(target);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, target={1}", new Object[]{this, target});
            }
        }

        Remote getImpl() {
            return (Remote)this.weakRef.get();
        }

        synchronized void pin(ObjectTable.Target target) {
            if (!$assertionsDisabled && !target.getEnableDGC()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.targets.contains(target)) {
                throw new AssertionError();
            }
            if (this.pinningTargets.isEmpty()) {
                if (!$assertionsDisabled && this.strongRef != null) {
                    throw new AssertionError();
                }
                this.strongRef = (Remote)this.weakRef.get();
            }
            if (!$assertionsDisabled && this.strongRef == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.pinningTargets.contains(target)) {
                throw new AssertionError();
            }
            this.pinningTargets.add(target);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, target={1}, pin count now {2}", new Object[]{this, target, new Integer(this.pinningTargets.size())});
            }
        }

        synchronized void unpin(ObjectTable.Target target) {
            if (!$assertionsDisabled && !target.getEnableDGC()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.targets.contains(target)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.pinningTargets.contains(target)) {
                throw new AssertionError();
            }
            this.pinningTargets.remove(target);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "this={0}, target={1}, pin count now {2}", new Object[]{this, target, new Integer(this.pinningTargets.size())});
            }
            if (this.pinningTargets.isEmpty()) {
                if (!$assertionsDisabled && this.strongRef == null) {
                    throw new AssertionError();
                }
                this.invokeUnreferenced(target);
                this.strongRef = null;
            }
        }

        private void invokeUnreferenced(final ObjectTable.Target target) {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.strongRef == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !target.getEnableDGC()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.targets.contains(target)) {
                throw new AssertionError();
            }
            if (this.strongRef instanceof Unreferenced) {
                final Unreferenced obj = (Unreferenced)((Object)this.strongRef);
                final Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    public void run() {
                        SecurityContext securityContext = target.getSecurityContext();
                        AccessController.doPrivileged(securityContext.wrap(new PrivilegedAction(){

                            public Object run() {
                                obj.unreferenced();
                                return null;
                            }
                        }), securityContext.getAccessControlContext());
                    }
                }, "Unreferenced", false, true));
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        t.setContextClassLoader(target.getContextClassLoader());
                        return null;
                    }
                });
                t.start();
            }
        }

        private boolean isPinned() {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            return !this.pinningTargets.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(ObjectTable.Target target) {
            Object object = ImplRefManager.this.lock;
            synchronized (object) {
                if (this.removed) {
                    return;
                }
                ImplRef implRef = this;
                synchronized (implRef) {
                    boolean moreTargetsLeft;
                    if (!$assertionsDisabled && !this.targets.contains(target)) {
                        throw new AssertionError();
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, target={1}", new Object[]{this, target});
                    }
                    this.targets.remove(target);
                    boolean bl = moreTargetsLeft = !this.targets.isEmpty();
                    if (this.pinningTargets.remove(target) && this.pinningTargets.isEmpty()) {
                        if (!$assertionsDisabled && this.strongRef == null) {
                            throw new AssertionError();
                        }
                        if (moreTargetsLeft) {
                            Iterator i = this.targets.iterator();
                            while (i.hasNext()) {
                                ObjectTable.Target t = (ObjectTable.Target)i.next();
                                if (!t.getEnableDGC()) continue;
                                this.invokeUnreferenced(t);
                                break;
                            }
                        }
                        this.strongRef = null;
                    }
                    if (!moreTargetsLeft) {
                        this.remove();
                    }
                }
            }
        }

        private void remove() {
            if (!$assertionsDisabled && !Thread.holdsLock(ImplRefManager.this.lock)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.removed) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && ImplRefManager.this.weakImplTable.get(this.weakRef) != this) {
                throw new AssertionError();
            }
            ImplRefManager.this.weakImplTable.remove(this.weakRef);
            this.removed = true;
            if (ImplRefManager.this.weakImplTable.size() == 0) {
                if (!$assertionsDisabled && ImplRefManager.this.reaper == null) {
                    throw new AssertionError();
                }
                if (ImplRefManager.this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ImplRefManager.this.reaper.interrupt();
                            return null;
                        }
                    });
                }
                ImplRefManager.this.reaper = null;
            }
        }

        public String toString() {
            return "ImplRef@" + Integer.toHexString(this.hashCode()) + "[" + this.getImpl() + "]";
        }

        static /* synthetic */ boolean access$1100(ImplRef x0) {
            return x0.removed;
        }

        static /* synthetic */ boolean access$1200(ImplRef x0) {
            return x0.isPinned();
        }

        static /* synthetic */ Set access$1300(ImplRef x0) {
            return x0.targets;
        }

        static /* synthetic */ void access$1400(ImplRef x0) {
            x0.remove();
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ImplRefManager == null ? (class$com$sun$jini$jeri$internal$runtime$ImplRefManager = ImplRefManager.class$("com.sun.jini.jeri.internal.runtime.ImplRefManager")) : class$com$sun$jini$jeri$internal$runtime$ImplRefManager).desiredAssertionStatus();
        }
    }
}

