/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.felix.configurator.impl.json.BinUtil;
import org.apache.felix.configurator.impl.json.JSMin;
import org.apache.felix.configurator.impl.json.OrderedDictionary;
import org.apache.felix.configurator.impl.json.TypeConverter;
import org.apache.felix.configurator.impl.model.BundleState;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigPolicy;
import org.apache.felix.configurator.impl.model.ConfigurationFile;
import org.apache.johnzon.core.JsonProviderImpl;
import org.osgi.util.converter.Converting;

public class JSONUtil {
    private static final String INTERNAL_PREFIX = ":configurator:";
    private static final String PROP_RANKING = "ranking";
    private static final String PROP_POLICY = "policy";

    public static BundleState readConfigurationsFromBundle(BinUtil.ResourceProvider provider, Set<String> paths, Report report) {
        BundleState config = new BundleState();
        ArrayList<ConfigurationFile> allFiles = new ArrayList<ConfigurationFile>();
        for (String path : paths) {
            List<ConfigurationFile> files = JSONUtil.readJSON(provider, path, report);
            allFiles.addAll(files);
        }
        Collections.sort(allFiles);
        config.addFiles(allFiles);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConfigurationFile> readJSON(BinUtil.ResourceProvider provider, String path, Report report) {
        ArrayList<ConfigurationFile> result = new ArrayList<ConfigurationFile>();
        Enumeration<URL> urls = provider.findEntries(path, "*.json");
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String filePath = url.getPath();
                int pos = filePath.lastIndexOf(47);
                String name = path + filePath.substring(pos);
                try {
                    String contents = JSONUtil.getResource(name, url);
                    boolean done = false;
                    TypeConverter converter = new TypeConverter(provider);
                    try {
                        ConfigurationFile file = JSONUtil.readJSON(converter, name, url, provider.getBundleId(), contents, report);
                        if (file == null) continue;
                        result.add(file);
                        done = true;
                    }
                    finally {
                        if (done) continue;
                        converter.cleanupFiles();
                    }
                }
                catch (IOException ioe) {
                    report.errors.add("Unable to read " + name + " : " + ioe.getMessage());
                }
            }
            Collections.sort(result);
        } else {
            report.errors.add("No configurations found at path " + path);
        }
        return result;
    }

    public static ConfigurationFile readJSON(TypeConverter converter, String name, URL url, long bundleId, String contents, Report report) {
        List<Config> list;
        String identifier = url == null ? name : url.toString();
        JsonObject json = JSONUtil.parseJSON(name, contents, report);
        Map<String, ?> configs = JSONUtil.verifyJSON(name, json, url != null, report);
        if (configs != null && !(list = JSONUtil.readConfigurationsJSON(converter, bundleId, identifier, configs, report)).isEmpty()) {
            ConfigurationFile file = new ConfigurationFile(url, list);
            return file;
        }
        return null;
    }

    public static List<Config> readConfigurationsJSON(TypeConverter converter, long bundleId, String identifier, Map<String, ?> configs, Report report) {
        ArrayList<Config> configurations = new ArrayList<Config>();
        for (Map.Entry<String, ?> entry : configs.entrySet()) {
            if (!(entry.getValue() instanceof Map)) {
                if (entry.getKey().startsWith(INTERNAL_PREFIX)) continue;
                report.errors.add("Ignoring configuration in '" + identifier + "' (not a configuration) : " + entry.getKey());
                continue;
            }
            Map mainMap = (Map)entry.getValue();
            String pid = entry.getKey();
            int ranking = 0;
            ConfigPolicy policy = ConfigPolicy.DEFAULT;
            OrderedDictionary properties = new OrderedDictionary();
            boolean valid = true;
            for (String mapKey : mainMap.keySet()) {
                Object value = mainMap.get(mapKey);
                boolean internalKey = mapKey.startsWith(INTERNAL_PREFIX);
                String key = mapKey;
                if (internalKey) {
                    key = key.substring(INTERNAL_PREFIX.length());
                }
                int pos = key.indexOf(58);
                String typeInfo = null;
                if (pos != -1) {
                    typeInfo = key.substring(pos + 1);
                    key = key.substring(0, pos);
                }
                if (internalKey) {
                    if (key.equals(PROP_RANKING)) {
                        Integer intObj = (Integer)((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to(Integer.class);
                        if (intObj == null) {
                            report.warnings.add("Invalid ranking for configuration in '" + identifier + "' : " + pid + " - " + value);
                            continue;
                        }
                        ranking = intObj;
                        continue;
                    }
                    if (!key.equals(PROP_POLICY)) continue;
                    String stringVal = (String)((Converting)TypeConverter.getConverter().convert(value).defaultValue(null)).to(String.class);
                    if (stringVal == null) {
                        report.errors.add("Invalid policy for configuration in '" + identifier + "' : " + pid + " - " + value);
                        continue;
                    }
                    if (value.equals("default") || value.equals("force")) {
                        policy = ConfigPolicy.valueOf(stringVal.toUpperCase());
                        continue;
                    }
                    report.errors.add("Invalid policy for configuration in '" + identifier + "' : " + pid + " - " + value);
                    continue;
                }
                try {
                    Object convertedVal = JSONUtil.getTypedValue(converter, pid, value, typeInfo);
                    ((Dictionary)properties).put(key, convertedVal);
                }
                catch (IOException io) {
                    report.errors.add("Invalid value/type for configuration in '" + identifier + "' : " + pid + " - " + mapKey + " : " + io.getMessage());
                    valid = false;
                    break;
                }
            }
            if (!valid) continue;
            Config c = new Config(pid, properties, bundleId, ranking, policy);
            c.setFiles(converter.flushFiles());
            configurations.add(c);
        }
        return configurations;
    }

    public static JsonStructure build(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            JsonArrayBuilder builder = new JsonProviderImpl().createArrayBuilder();
            for (Object obj : list) {
                if (obj instanceof String) {
                    builder.add(obj.toString());
                    continue;
                }
                if (obj instanceof Long) {
                    builder.add(((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Double) {
                    builder.add(((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof Boolean) {
                    builder.add(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Map) {
                    builder.add((JsonValue)JSONUtil.build(obj));
                    continue;
                }
                if (!(obj instanceof List)) continue;
                builder.add((JsonValue)JSONUtil.build(obj));
            }
            return builder.build();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JsonObjectBuilder builder = new JsonProviderImpl().createObjectBuilder();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof String) {
                    builder.add((String)entry.getKey(), entry.getValue().toString());
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    builder.add((String)entry.getKey(), ((Long)entry.getValue()).longValue());
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    builder.add((String)entry.getKey(), ((Double)entry.getValue()).doubleValue());
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    builder.add((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    builder.add((String)entry.getKey(), (JsonValue)JSONUtil.build(entry.getValue()));
                    continue;
                }
                if (!(entry.getValue() instanceof List)) continue;
                builder.add((String)entry.getKey(), (JsonValue)JSONUtil.build(entry.getValue()));
            }
            return builder.build();
        }
        return null;
    }

    public static JsonObject parseJSON(String name, String contents, Report report) {
        Throwable throwable;
        Throwable throwable2;
        try {
            throwable2 = null;
            try (StringReader in = new StringReader(contents);){
                throwable = null;
                try (StringWriter out = new StringWriter();){
                    JSMin min = new JSMin(in, out);
                    min.jsmin();
                    contents = ((Object)out).toString();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable out) {
                throwable2 = out;
                throw out;
            }
        }
        catch (IOException ioe) {
            report.errors.add("Invalid JSON from " + name);
            return null;
        }
        throwable2 = null;
        try (JsonReader reader = new JsonProviderImpl().createReader((Reader)new StringReader(contents));){
            JsonStructure obj = reader.read();
            if (obj != null && obj.getValueType() == JsonValue.ValueType.OBJECT) {
                throwable = (JsonObject)obj;
                return throwable;
            }
            report.errors.add("Invalid JSON from " + name);
        }
        catch (Throwable throwable4) {
            throwable2 = throwable4;
            throw throwable4;
        }
        return null;
    }

    public static Object getValue(JsonObject root, String key) {
        if (!root.containsKey((Object)key)) {
            return null;
        }
        JsonValue value = (JsonValue)root.get((Object)key);
        return JSONUtil.getValue(value);
    }

    public static Object getValue(JsonValue value) {
        switch (value.getValueType()) {
            case NULL: {
                return null;
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                if (num.isIntegral()) {
                    return num.longValue();
                }
                return num.doubleValue();
            }
            case ARRAY: {
                ArrayList<Object> array = new ArrayList<Object>();
                for (JsonValue x : (JsonArray)value) {
                    array.add(JSONUtil.getValue(x));
                }
                return array;
            }
            case OBJECT: {
                LinkedHashMap map = new LinkedHashMap();
                JsonObject obj = (JsonObject)value;
                for (Map.Entry entry : obj.entrySet()) {
                    map.put(entry.getKey(), JSONUtil.getValue((JsonValue)entry.getValue()));
                }
                return map;
            }
        }
        return null;
    }

    public static Object getTypedValue(TypeConverter converter, String pid, Object value, String typeInfo) throws IOException {
        String[] convertedVal = converter.convert(pid, value, typeInfo);
        if (convertedVal == null) {
            if (typeInfo != null) {
                throw new IOException("Unable to convert to type " + typeInfo);
            }
            JsonStructure json = JSONUtil.build(value);
            if (json == null) {
                convertedVal = value.toString();
            } else if (json.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray arr = (JsonArray)json;
                String[] val = new String[arr.size()];
                for (int i = 0; i < val.length; ++i) {
                    val[i] = (String)TypeConverter.getConverter().convert(arr.get(i)).to(String.class);
                }
                convertedVal = val;
            } else {
                convertedVal = TypeConverter.getConverter().convert(value).to(String.class);
            }
        }
        return convertedVal;
    }

    public static Map<String, ?> verifyJSON(String name, JsonObject root, boolean bundleResource, Report report) {
        if (root == null) {
            return null;
        }
        Object version = JSONUtil.getValue(root, ":configurator:resource-version");
        if (version != null) {
            int v = (Integer)((Converting)TypeConverter.getConverter().convert(version).defaultValue((Object)-1)).to(Integer.class);
            if (v == -1) {
                report.errors.add("Invalid resource version information in " + name + " : " + version);
                return null;
            }
            if (v != 1) {
                report.errors.add("Invalid resource version number in " + name + " : " + version);
                return null;
            }
        }
        if (!bundleResource) {
            Object rsrcVersion = JSONUtil.getValue(root, ":configurator:version");
            if (rsrcVersion == null) {
                report.errors.add("Missing version information in " + name);
                return null;
            }
            if (!(rsrcVersion instanceof String)) {
                report.errors.add("Invalid version information in " + name + " : " + rsrcVersion);
                return null;
            }
            Object rsrcName = JSONUtil.getValue(root, ":configurator:symbolic-name");
            if (rsrcName == null) {
                report.errors.add("Missing symbolic name information in " + name);
                return null;
            }
            if (!(rsrcName instanceof String)) {
                report.errors.add("Invalid symbolic name information in " + name + " : " + rsrcName);
                return null;
            }
        }
        return (Map)JSONUtil.getValue((JsonValue)root);
    }

    public static String getResource(String name, URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
    }

    public static final class Report {
        public final List<String> warnings = new ArrayList<String>();
        public final List<String> errors = new ArrayList<String>();
    }
}

