/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitable;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public abstract class BlackVolTermStructure
extends TermStructure
implements TypedVisitable<TermStructure> {
    private static final double dT = 0.0027397260273972603;

    public abstract double minStrike();

    public abstract double maxStrike();

    protected abstract double blackVolImpl(double var1, double var3);

    protected abstract double blackVarianceImpl(double var1, double var3);

    public BlackVolTermStructure(DayCounter dc) {
        super(dc);
    }

    public BlackVolTermStructure(Date refDate, Calendar cal, DayCounter dc) {
        super(refDate, cal, dc);
    }

    public BlackVolTermStructure(int settlDays, Calendar cal, DayCounter dc) {
        super(settlDays, cal, dc);
    }

    public final double blackVol(Date maturity, double strike) {
        return this.blackVol(maturity, strike, false);
    }

    public final double blackVol(Date maturity, double strike, boolean extrapolate) {
        double t = super.timeFromReference(maturity);
        this.checkRange(t, strike, extrapolate);
        return this.blackVolImpl(t, strike);
    }

    public final double blackVol(double maturity, double strike) {
        return this.blackVol(maturity, strike, false);
    }

    public final double blackVol(double maturity, double strike, boolean extrapolate) {
        this.checkRange(maturity, strike, extrapolate);
        return this.blackVolImpl(maturity, strike);
    }

    public final double blackVariance(Date maturity, double strike) {
        return this.blackVariance(maturity, strike, false);
    }

    public final double blackVariance(Date maturity, double strike, boolean extrapolate) {
        double t = super.timeFromReference(maturity);
        this.checkRange(t, strike, extrapolate);
        return this.blackVarianceImpl(t, strike);
    }

    public final double blackVariance(double maturity, double strike) {
        return this.blackVariance(maturity, strike, false);
    }

    public final double blackVariance(double maturity, double strike, boolean extrapolate) {
        this.checkRange(maturity, strike, extrapolate);
        return this.blackVarianceImpl(maturity, strike);
    }

    private final void checkRange(double time, double strike, boolean extrapolate) {
        super.checkRange(time, extrapolate);
        if (!(extrapolate || this.allowsExtrapolation() || strike >= this.minStrike() && strike <= this.maxStrike())) {
            throw new ArithmeticException("strike (" + strike + ") is outside the curve domain [" + this.minStrike() + "," + this.maxStrike() + "]");
        }
    }

    public final double blackForwardVol(Date date1, Date date2, double strike, boolean extrapolate) {
        if (date1.gt(date2)) {
            throw new IllegalArgumentException(date1 + " later than " + date2);
        }
        double time1 = this.timeFromReference(date1);
        double time2 = this.timeFromReference(date2);
        return this.blackForwardVol(time1, time2, strike, extrapolate);
    }

    public final double blackForwardVol(double time1, double time2, double strike, boolean extrapolate) {
        double t1 = time1;
        double t2 = time2;
        if (t1 > t2) {
            throw new IllegalArgumentException(time1 + " later than " + time2);
        }
        this.checkRange(time2, strike, extrapolate);
        if (t1 == t2) {
            if (t1 == 0.0) {
                double epsilon = 1.0E-5;
                double var = this.blackVarianceImpl(epsilon, strike);
                return Math.sqrt(var / epsilon);
            }
            double epsilon = Math.min(1.0E-5, t1);
            double var1 = this.blackVarianceImpl(t1 - epsilon, strike);
            double var2 = this.blackVarianceImpl(t1 + epsilon, strike);
            if (var2 < var1) {
                throw new ArithmeticException("variances must be non-decreasing");
            }
            return Math.sqrt((var2 - var1) / (2.0 * epsilon));
        }
        double var1 = this.blackVarianceImpl(time1, strike);
        double var2 = this.blackVarianceImpl(time2, strike);
        if (var2 < var1) {
            throw new ArithmeticException("variances must be non-decreasing");
        }
        return Math.sqrt((var2 - var1) / (t2 - t1));
    }

    public final double blackForwardVariance(Date date1, Date date2, double strike, boolean extrapolate) {
        if (date1.gt(date2)) {
            throw new IllegalArgumentException(date1 + " later than " + date2);
        }
        double time1 = this.timeFromReference(date1);
        double time2 = this.timeFromReference(date2);
        return this.blackForwardVariance(time1, time2, strike, extrapolate);
    }

    public final double blackForwardVariance(double time1, double time2, double strike, boolean extrapolate) {
        double t1 = time1;
        double t2 = time2;
        if (t1 > t2) {
            throw new IllegalArgumentException(time1 + " later than " + time2);
        }
        this.checkRange(time2, strike, extrapolate);
        double v1 = this.blackVarianceImpl(time1, strike);
        double v2 = this.blackVarianceImpl(time2, strike);
        if (v2 < v1) {
            throw new ArithmeticException("variances must be non-decreasing");
        }
        return v2 - v1;
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 == null) {
            throw new UnsupportedOperationException("not a Black-volatility term structure visitor");
        }
        v1.visit(this);
    }
}

